/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.RoleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;

class SetRoleConstantAction
implements ConstantAction {
    private final String roleName;
    private final int type;

    SetRoleConstantAction(String roleName, int type) {
        this.roleName = roleName;
        this.type = type;
    }

    public String toString() {
        return "SET ROLE " + (this.type == 1 && this.roleName == null ? "?" : this.roleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        String thisRoleName = this.roleName;
        String currentAuthId = lcc.getAuthorizationId();
        String dbo = lcc.getDataDictionary().getAuthorizationDatabaseOwner();
        TransactionController tc = lcc.getTransactionExecute();
        if (!tc.isIdle()) {
            throw StandardException.newException("25001.S.1");
        }
        if (this.type == 1) {
            ParameterValueSet pvs = activation.getParameterValueSet();
            DataValueDescriptor dvs = pvs.getParameter(0);
            thisRoleName = dvs.getString();
        }
        RoleDescriptor rd = null;
        if (thisRoleName != null) {
            try {
                rd = dd.getRoleDefinitionDescriptor(thisRoleName);
                if (rd == null) {
                    throw StandardException.newException("0P000", thisRoleName);
                }
                if (!currentAuthId.equals(dbo) && (rd = dd.getRoleGrantDescriptor(thisRoleName, currentAuthId, dbo)) == null && (rd = dd.getRoleGrantDescriptor(thisRoleName, "PUBLIC", dbo)) == null) {
                    throw StandardException.newException("0P000.S.1", thisRoleName);
                }
            }
            finally {
                lcc.userCommit();
            }
        }
        lcc.setCurrentRole(activation, rd != null ? thisRoleName : null);
    }

    @Override
    public boolean isCancellable() {
        return false;
    }
}

