/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.HashJoinResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.HashTableResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.RowUtil;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class NcjPullJoinResultSet
extends HashJoinResultSet {
    public NcjPullJoinResultSet(NoPutResultSet leftResultSet, int leftNumCols, NoPutResultSet rightResultSet, int rightNumCols, Activation activation, GeneratedMethod restriction, int resultSetNumber, boolean oneRowRightSide, boolean notExistsRightSide, double optimizerEstimatedRowCount, double optimizerEstimatedCost, String userSuppliedOptimizerOverrides, int leftResultColumnNames, int rightResultColumnNames) {
        super(leftResultSet, leftNumCols, rightResultSet, rightNumCols, activation, restriction, resultSetNumber, oneRowRightSide, notExistsRightSide, optimizerEstimatedRowCount, optimizerEstimatedCost, userSuppliedOptimizerOverrides, leftResultColumnNames, rightResultColumnNames);
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        HashTableResultSet hashTab;
        ExecRow nextRow = super.getNextRowCore();
        if (nextRow == null && (hashTab = (HashTableResultSet)this.rightResultSet).moreRowsExpected()) {
            hashTab.purgeHashTable();
            if (hashTab.fillUpHashTable()) {
                this.leftResultSet.forceReOpenCore();
                this.reopenCore();
                nextRow = super.getNextRowCore();
            }
            if (GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("NcjPullJoinResultSet::getNextRowCore() moreRowsExpected. nextRow-not-null=" + (nextRow != null)));
            }
        }
        return nextRow;
    }

    @Override
    protected void closeRight() throws StandardException {
        SanityManager.ASSERT((boolean)this.isRightOpen, (String)"isRightOpen is expected to be true");
        HashTableResultSet hashTab = (HashTableResultSet)this.rightResultSet;
        if (hashTab.moreRowsExpected()) {
            if (GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)"NcjPullJoinResultSet::closeRight() moreRowsExpected.");
            }
        } else {
            super.closeRight();
        }
    }

    private void setKeysFromHashTable(DataValueDescriptor[] row, Object[] keysFromRight, int keysFromRightSize, HashTableResultSet hashTab) {
        SanityManager.ASSERT((row != null ? 1 : 0) != 0, (String)"Null row from hash table");
        if (GemFireXDUtils.TraceNCJIter) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJIter", (String)("NcjPullJoinResultSet#ncjOpen row=" + RowUtil.toString(row) + " ,first-key=" + row[hashTab.keyColumns[0]] + " ,key-column=" + Arrays.toString(hashTab.keyColumns)));
        }
        for (int index = 0; index < keysFromRightSize; ++index) {
            ArrayList keysArr = (ArrayList)keysFromRight[index];
            keysArr.add(row[hashTab.keyColumns[index]]);
        }
    }

    @Override
    public void ncjOpen() throws StandardException {
        SanityManager.ASSERT((boolean)(this.rightResultSet instanceof HashTableResultSet), (String)("HashTableResultSet expected, " + this.rightResultSet.getClass().getSimpleName()));
        super.openRight();
        HashTableResultSet hashTab = (HashTableResultSet)this.rightResultSet;
        Iterator hashIter = hashTab.hashTableIterator();
        SanityManager.ASSERT((hashIter != null ? 1 : 0) != 0, (String)"HashTableResultSet is not open");
        int keysFromRightSize = hashTab.keyColumns.length;
        Object[] keysFromRight = new Object[keysFromRightSize];
        for (int index = 0; index < keysFromRightSize; ++index) {
            keysFromRight[index] = new ArrayList();
        }
        int countKeys = 0;
        while (hashIter.hasNext()) {
            Object objHash = hashIter.next();
            SanityManager.ASSERT((objHash != null ? 1 : 0) != 0, (String)"Null row from hash table");
            if (objHash instanceof ArrayList) {
                for (Object objItem : (ArrayList)objHash) {
                    this.setKeysFromHashTable((DataValueDescriptor[])objItem, keysFromRight, keysFromRightSize, hashTab);
                }
            } else {
                this.setKeysFromHashTable((DataValueDescriptor[])objHash, keysFromRight, keysFromRightSize, hashTab);
            }
            ++countKeys;
        }
        for (int index = 0; index < keysFromRightSize; ++index) {
            ArrayList keysArr = (ArrayList)keysFromRight[index];
            this.leftResultSet.setGfKeysForNCJoin(keysArr);
        }
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("NcjPullJoinResultSet#ncjOpen node=" + this.resultSetNumber() + " ,leftResultSet=" + this.leftResultSet.resultSetNumber() + " ,rightResultSet=" + this.rightResultSet.resultSetNumber() + " ,rowCount=" + countKeys + " ,keysFromRight-size=" + keysFromRightSize + " ,hashtable-keys=" + Arrays.toString(hashTab.keyColumns)));
        }
        if (GemFireXDUtils.TraceNCJDump) {
            StringBuilder strKeysFromRight = new StringBuilder();
            for (int index = 0; index < keysFromRightSize; ++index) {
                ArrayList keysArr = (ArrayList)keysFromRight[index];
                strKeysFromRight.append(" <");
                strKeysFromRight.append(keysArr);
                strKeysFromRight.append("> ");
            }
            SanityManager.DEBUG_PRINT((String)"TraceNCJDump", (String)("NcjPullJoinResultSet#ncjOpen keysFromRight-size=" + keysFromRightSize + " ,rowCount=" + countKeys + " ,keysFromRight=" + strKeysFromRight));
        }
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        boolean isSuccess = context.setNested();
        super.buildQueryPlan(builder, context.pushContext());
        PlanUtils.xmlAttribute(builder, "is_noncolocated_join", true);
        if (isSuccess) {
            PlanUtils.xmlTermTag(builder, context, "NCJOIN");
        }
        return builder;
    }
}

