/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.DynamicCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.StaticCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.FKInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.IndexRow;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class GenericRIChecker {
    protected FKInfo fkInfo;
    protected DynamicCompiledOpenConglomInfo[] fkDcocis;
    protected StaticCompiledOpenConglomInfo[] fkScocis;
    protected DynamicCompiledOpenConglomInfo refDcoci;
    protected StaticCompiledOpenConglomInfo refScoci;
    protected TransactionController tc;
    private Hashtable scanControllers;
    private int numColumns;
    private IndexRow indexQualifierRow;

    GenericRIChecker(TransactionController tc, FKInfo fkinfo) throws StandardException {
        this.fkInfo = fkinfo;
        this.tc = tc;
        this.scanControllers = new Hashtable();
        this.numColumns = this.fkInfo.colArray.length;
        this.indexQualifierRow = new IndexRow(this.numColumns);
        this.fkDcocis = new DynamicCompiledOpenConglomInfo[this.fkInfo.fkConglomNumbers.length];
        this.fkScocis = new StaticCompiledOpenConglomInfo[this.fkInfo.fkConglomNumbers.length];
        for (int index = 0; index < this.fkInfo.fkConglomNumbers.length; ++index) {
            this.fkDcocis[index] = tc.getDynamicCompiledConglomInfo(this.fkInfo.fkConglomNumbers[index]);
            this.fkScocis[index] = tc.getStaticCompiledConglomInfo(this.fkInfo.fkConglomNumbers[index]);
        }
        this.refDcoci = tc.getDynamicCompiledConglomInfo(this.fkInfo.refConglomNumber);
        this.refScoci = tc.getStaticCompiledConglomInfo(this.fkInfo.refConglomNumber);
    }

    abstract void doCheck(ExecRow var1, boolean var2) throws StandardException;

    public void doCheck(ExecRow row) throws StandardException {
        this.doCheck(row, false);
    }

    protected ScanController getScanController(long conglomNumber, StaticCompiledOpenConglomInfo scoci, DynamicCompiledOpenConglomInfo dcoci, ExecRow searchRow) throws StandardException {
        int isoLevel = this.getRICheckIsolationLevel();
        Long hashKey = conglomNumber;
        ScanController scan = (ScanController)this.scanControllers.get(hashKey);
        if (scan == null) {
            this.setupQualifierRow(searchRow);
            scan = this.tc.openCompiledScan(false, 0, 6, isoLevel, null, this.indexQualifierRow.getRowArray(), 1, null, this.indexQualifierRow.getRowArray(), -1, scoci, dcoci);
            this.scanControllers.put(hashKey, scan);
        } else {
            this.setupQualifierRow(searchRow);
            scan.reopenScan(this.indexQualifierRow.getRowArray(), 1, null, this.indexQualifierRow.getRowArray(), -1, null);
        }
        return scan;
    }

    private void setupQualifierRow(ExecRow baseRow) {
        DataValueDescriptor[] indexColArray = this.indexQualifierRow.getRowArray();
        DataValueDescriptor[] baseColArray = baseRow.getRowArray();
        for (int i = 0; i < this.numColumns; ++i) {
            indexColArray[i] = baseColArray[this.fkInfo.colArray[i] - 1];
        }
    }

    boolean isAnyFieldNull(ExecRow baseRow) {
        DataValueDescriptor[] baseColArray = baseRow.getRowArray();
        for (int i = 0; i < this.numColumns; ++i) {
            DataValueDescriptor storable = baseColArray[this.fkInfo.colArray[i] - 1];
            if (!storable.isNull()) continue;
            return true;
        }
        return false;
    }

    void close() throws StandardException {
        Enumeration e = this.scanControllers.elements();
        while (e.hasMoreElements()) {
            ScanController scan = (ScanController)e.nextElement();
            scan.close();
        }
        this.scanControllers.clear();
    }

    int getRICheckIsolationLevel() {
        return 3;
    }
}

