/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.conn;

import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.Authorizer;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.StatementPermission;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import java.util.List;

final class GenericAuthorizer
implements Authorizer {
    private static final int NO_ACCESS = 0;
    private static final int READ_ACCESS = 1;
    private static final int FULL_ACCESS = 2;
    private int userAccessLevel;
    boolean readOnlyConnection;
    private final LanguageConnectionContext lcc;
    private final String authorizationId;

    GenericAuthorizer(String authorizationId, LanguageConnectionContext lcc) throws StandardException {
        this.lcc = lcc;
        this.authorizationId = authorizationId;
        this.refresh();
    }

    private boolean connectionMustRemainReadOnly() {
        return this.lcc.getDatabase().isReadOnly() || this.userAccessLevel == 1;
    }

    @Override
    public void authorize(int operation) throws StandardException {
        this.authorize(null, null, operation);
    }

    @Override
    public final void authorize(Activation activation, int operation) throws StandardException {
        this.authorize(activation, activation != null ? activation.getPreparedStatement() : null, operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void authorize(Activation activation, ExecPreparedStatement ps, int operation) throws StandardException {
        if (this.lcc.isConnectionForRemote()) {
            if (GemFireXDUtils.TraceAuthentication) {
                SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("skipping remote connection authorization for authorizationId=" + this.authorizationId));
            }
            return;
        }
        this.refresh();
        int sqlAllowed = 3;
        StatementContext ctx = this.lcc.getStatementContext();
        if (ctx != null) {
            sqlAllowed = ctx.getSQLAllowed();
        }
        block1 : switch (operation) {
            case 2: 
            case 3: {
                if (sqlAllowed != 3) break;
                throw GenericAuthorizer.externalRoutineException(operation, sqlAllowed);
            }
            case 1: {
                if (sqlAllowed <= 1) break;
                throw GenericAuthorizer.externalRoutineException(operation, sqlAllowed);
            }
            case 0: 
            case 5: {
                if (this.isReadOnlyConnection()) {
                    throw StandardException.newException("25502");
                }
                if (sqlAllowed <= 0) break;
                throw GenericAuthorizer.externalRoutineException(operation, sqlAllowed);
            }
            case 4: 
            case 6: {
                if (this.isReadOnlyConnection()) {
                    throw StandardException.newException("25503");
                }
                if (sqlAllowed <= 0) break;
                throw GenericAuthorizer.externalRoutineException(operation, sqlAllowed);
            }
            default: {
                if (operation >= 7) {
                    switch (operation - 7) {
                        case 1: {
                            break;
                        }
                        case 0: {
                            if (!this.isReadOnlyConnection()) break block1;
                            throw StandardException.newException("25502");
                        }
                        case 4: {
                            if (!this.isReadOnlyConnection()) break block1;
                            throw StandardException.newException("25503");
                        }
                        default: {
                            SanityManager.THROWASSERT((String)("Bad operation code " + operation));
                            break;
                        }
                    }
                    break;
                }
                SanityManager.THROWASSERT((String)("Bad operation code " + operation));
            }
        }
        if (activation != null && (ps != null || (ps = activation.getPreparedStatement()) != null)) {
            DataDictionary dd = this.lcc.getDataDictionary();
            int ddMode = dd.startReading(this.lcc);
            boolean nestedTX = false;
            try {
                activation.checkStatementValidity();
                List requiredPermissionsList = ps.getRequiredPermissionsList();
                if (GemFireXDUtils.TraceAuthentication) {
                    SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("authorizing for authorizationId=" + this.authorizationId + " activation " + activation + " distributed member owner = " + dd.getAuthorizationDatabaseOwner() + " requiredPermissionList=" + requiredPermissionsList));
                }
                if (requiredPermissionsList != null && !requiredPermissionsList.isEmpty() && !this.authorizationId.equals(dd.getAuthorizationDatabaseOwner())) {
                    this.lcc.beginNestedTransaction(true);
                    nestedTX = true;
                    for (StatementPermission perm : requiredPermissionsList) {
                        if (GemFireXDUtils.TraceAuthentication) {
                            SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("authorizationId=" + this.authorizationId + " StatementPermission=" + perm));
                        }
                        perm.check(this.lcc, this.authorizationId, false);
                    }
                }
            }
            finally {
                dd.doneReading(ddMode, this.lcc);
                if (nestedTX) {
                    this.lcc.commitNestedTransaction();
                }
            }
        }
    }

    private static StandardException externalRoutineException(int operation, int sqlAllowed) {
        String sqlState;
        if (sqlAllowed == 1) {
            sqlState = "38002";
        } else if (sqlAllowed == 2) {
            switch (operation) {
                case 0: 
                case 4: 
                case 5: 
                case 6: {
                    sqlState = "38002";
                    break;
                }
                default: {
                    sqlState = "38004";
                    break;
                }
            }
        } else {
            sqlState = "38001";
        }
        return StandardException.newException(sqlState);
    }

    @Override
    public String getAuthorizationId() {
        return this.authorizationId;
    }

    private void getUserAccessLevel() throws StandardException {
        this.userAccessLevel = 0;
        if (this.userOnAccessList("gemfirexd.authz-full-access-users") || this.userOnAccessList("authz-full-access-users")) {
            this.userAccessLevel = 2;
        }
        if (this.userAccessLevel == 0 && (this.userOnAccessList("gemfirexd.authz-read-only-access-users") || this.userOnAccessList("authz-read-only-access-users"))) {
            this.userAccessLevel = 1;
        }
        if (this.userAccessLevel == 0) {
            this.userAccessLevel = this.getDefaultAccessLevel();
        }
    }

    private int getDefaultAccessLevel() throws StandardException {
        TransactionController tc = this.lcc.getTransactionExecute();
        String modeS = PropertyUtil.getServiceProperty(tc, "gemfirexd.authz-default-connection-mode");
        if (modeS == null) {
            return 2;
        }
        if (StringUtil.SQLEqualsIgnoreCase(modeS, "NOACCESS")) {
            return 0;
        }
        if (StringUtil.SQLEqualsIgnoreCase(modeS, "READONLYACCESS")) {
            return 1;
        }
        if (StringUtil.SQLEqualsIgnoreCase(modeS, "FULLACCESS")) {
            return 2;
        }
        SanityManager.THROWASSERT((String)("Invalid value for property gemfirexd.authz-default-connection-mode " + modeS));
        return 2;
    }

    private boolean userOnAccessList(String listName) throws StandardException {
        TransactionController tc = this.lcc.getTransactionExecute();
        String listS = PropertyUtil.getServiceProperty(tc, listName);
        return IdUtil.idOnList(this.authorizationId, listS);
    }

    @Override
    public boolean isReadOnlyConnection() {
        return this.readOnlyConnection;
    }

    @Override
    public void setReadOnlyConnection(boolean on, boolean authorize) throws StandardException {
        if (authorize && !on && this.connectionMustRemainReadOnly()) {
            throw StandardException.newException("25505");
        }
        this.readOnlyConnection = on;
    }

    @Override
    public void refresh() throws StandardException {
        this.getUserAccessLevel();
        this.readOnlyConnection = this.connectionMustRemainReadOnly();
        if (this.userAccessLevel == 0) {
            throw StandardException.newException("08004.C.3");
        }
    }
}

