/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;

public class SavepointNode
extends DDLStatementNode {
    private String savepointName;
    private int savepointStatementType;

    @Override
    public void init(Object objectName, Object savepointStatementType) throws StandardException {
        this.initAndCheck(null);
        this.savepointName = (String)objectName;
        this.savepointStatementType = (Integer)savepointStatementType;
        if (this.savepointStatementType > 3 || this.savepointStatementType < 1) {
            SanityManager.THROWASSERT((String)("Unexpected value for savepointStatementType = " + this.savepointStatementType + ". Expected value between 1-3"));
        }
    }

    @Override
    public String toString() {
        String tempString = "savepointName: \n" + this.savepointName + "\n";
        tempString = tempString + "savepointStatementType: " + "\n" + this.savepointStatementType + "\n";
        return super.toString() + tempString;
    }

    @Override
    public String statementToString() {
        if (this.savepointStatementType == 1) {
            return "SAVEPOINT";
        }
        if (this.savepointStatementType == 2) {
            return "ROLLBACK WORK TO SAVEPOINT";
        }
        return "RELEASE TO SAVEPOINT";
    }

    @Override
    public boolean needsSavepoint() {
        return false;
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getSavepointConstantAction(this.savepointName, this.savepointStatementType);
    }
}

