/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.gemstone.gnu.trove.THashMap;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ValueQueryInfo;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class QueryTreeNodeVector
extends QueryTreeNode
implements Iterable<QueryTreeNode> {
    private ArrayList<QueryTreeNode> v = new ArrayList();
    private THashMap visitedMap;

    public final int size() {
        return this.v.size();
    }

    @Override
    public final Iterator<QueryTreeNode> iterator() {
        return this.v.iterator();
    }

    public final QueryTreeNode elementAt(int index) {
        return this.v.get(index);
    }

    public final void addElement(QueryTreeNode qt) {
        this.v.add(qt);
        if (this.visitedMap != null) {
            this.visitedMap.clear();
        }
    }

    final void removeElementAt(int index) {
        this.v.remove(index);
        if (this.visitedMap != null) {
            this.visitedMap.clear();
        }
    }

    final void removeElement(QueryTreeNode qt) {
        this.v.remove(qt);
        if (this.visitedMap != null) {
            this.visitedMap.clear();
        }
    }

    final Object remove(int index) {
        if (this.visitedMap != null) {
            this.visitedMap.clear();
        }
        return this.v.remove(index);
    }

    final int indexOf(QueryTreeNode qt) {
        return this.v.indexOf(qt);
    }

    final void setElementAt(QueryTreeNode qt, int index) {
        this.v.set(index, qt);
        if (this.visitedMap != null) {
            this.visitedMap.clear();
        }
    }

    final void destructiveAppend(QueryTreeNodeVector qtnv) {
        this.nondestructiveAppend(qtnv);
        qtnv.removeAllElements();
        if (this.visitedMap != null) {
            this.visitedMap.clear();
        }
    }

    final void nondestructiveAppend(QueryTreeNodeVector qtnv) {
        int qtnvSize = qtnv.size();
        for (int index = 0; index < qtnvSize; ++index) {
            this.v.add(qtnv.elementAt(index));
        }
        if (this.visitedMap != null) {
            this.visitedMap.clear();
        }
    }

    public final void removeAllElements() {
        this.v.clear();
        if (this.visitedMap != null) {
            this.visitedMap = null;
        }
    }

    public final void insertElementAt(QueryTreeNode qt, int index) {
        this.v.add(index, qt);
        if (this.visitedMap != null) {
            this.visitedMap.clear();
        }
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder("");
        for (int index = 0; index < this.size(); ++index) {
            buffer.append(this.elementAt(index).toString()).append("; ");
        }
        return buffer.toString();
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        boolean deltaRecord = false;
        if (v.supportsDeltaMerge()) {
            Object delta;
            if (this.visitedMap == null) {
                this.visitedMap = new THashMap();
            } else if (this.visitedMap.size() > 0 && (delta = this.visitedMap.get(v.getClass())) != null) {
                return v.mergeDeltaState(delta, this);
            }
            deltaRecord = v.initForDeltaState();
        }
        Visitable returnNode = v.visit(this);
        if (v.skipChildren(this)) {
            if (deltaRecord) {
                this.visitedMap.put(v.getClass(), v.getAndResetDeltaState());
            }
            return returnNode;
        }
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            QueryTreeNode qn0 = this.elementAt(index);
            QueryTreeNode qn = (QueryTreeNode)qn0.accept(v);
            if (qn == qn0) continue;
            this.setElementAt(qn, index);
        }
        if (deltaRecord) {
            this.visitedMap.put(v.getClass(), v.getAndResetDeltaState());
        }
        return returnNode;
    }

    public Boolean populateQueryInfoArray(QueryInfoContext qic, ValueQueryInfo[] qiArr) throws StandardException {
        int size = qiArr.length;
        boolean isDynamic = false;
        for (int i = 0; i < size; ++i) {
            QueryInfo temp = this.v.get(i).computeQueryInfo(qic);
            if (!(temp instanceof ValueQueryInfo)) {
                return null;
            }
            qiArr[i] = (ValueQueryInfo)temp;
            isDynamic = isDynamic || temp.isDynamic();
        }
        return isDynamic;
    }
}

