/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.OrderByQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrderByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SingleChildResultSetNode;

public class OrderByNode
extends SingleChildResultSetNode {
    OrderByList orderByList;

    @Override
    public void init(Object childResult, Object orderByList, Object tableProperties) throws StandardException {
        ResultSetNode child = (ResultSetNode)childResult;
        super.init(childResult, tableProperties);
        this.orderByList = (OrderByList)orderByList;
        ResultColumnList prRCList = child.getResultColumns().copyListAndObjects();
        this.resultColumns = child.getResultColumns();
        child.setResultColumns(prRCList);
        this.resultColumns.genVirtualColumnNodes(this, prRCList);
    }

    @Override
    public String toString() {
        return this.childResult.toString() + "\n" + "orderByList: " + (this.orderByList != null ? this.orderByList.toString() : "null") + "\n" + super.toString();
    }

    @Override
    ResultColumnDescriptor[] makeResultDescriptors() {
        return this.childResult.makeResultDescriptors();
    }

    @Override
    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.costEstimate == null) {
            this.costEstimate = this.childResult.getFinalCostEstimate();
        }
        this.orderByList.generate(acb, mb, this.childResult);
    }

    @Override
    public QueryInfo computeQueryInfo(QueryInfoContext qic) throws StandardException {
        return new OrderByQueryInfo(qic, this.orderByList, this.resultColumns, qic.getParentPRN() != null ? qic.getParentPRN().getResultColumns() : null);
    }

    @Override
    public ResultSetNode getInnerMostPRN() {
        return this.childResult.getInnerMostPRN();
    }

    @Override
    protected void optimizeForOffHeap(boolean shouldOptimize) {
        shouldOptimize = shouldOptimize && !this.orderByList.getSortNeeded();
        this.childResult.optimizeForOffHeap(shouldOptimize);
    }
}

