/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ComparisonQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.InsertQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.IndexLister;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.store.access.StaticCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.util.ReuseFactory;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.sql.GenericParameterValueSet;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DMLModStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromVTI;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ParameterNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SingleChildResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnionNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.VTIDeferModPolicy;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.VirtualColumnNode;
import com.pivotal.gemfirexd.internal.impl.sql.execute.FKInfo;
import com.pivotal.gemfirexd.internal.shared.common.ColumnRoutingObjectInfo;
import com.pivotal.gemfirexd.internal.shared.common.MultiColumnRoutingObjectInfo;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public final class InsertNode
extends DMLModStatementNode {
    public ResultColumnList targetColumnList;
    public boolean deferred;
    public ValueNode checkConstraints;
    public Properties targetProperties;
    public FKInfo fkInfo;
    protected boolean bulkInsert;
    private boolean bulkInsertReplace;
    protected RowLocation[] autoincRowLocation;
    private boolean resultSetInfoInitialized;
    private SelectQueryInfo resultSetInfo = null;
    private boolean isPutDML = false;

    @Override
    public void init(Object targetName, Object insertColumns, Object queryExpression, Object targetProperties, Object isPutDML) {
        super.init(queryExpression, ReuseFactory.getInteger(InsertNode.getStatementType((Properties)targetProperties)));
        this.setTarget((QueryTreeNode)targetName);
        this.targetColumnList = (ResultColumnList)insertColumns;
        this.targetProperties = (Properties)targetProperties;
        this.getResultSetNode().setInsertSource();
        this.isPutDML = (Boolean)isPutDML;
    }

    @Override
    public String toString() {
        try {
            return (this.targetTableName != null ? this.targetTableName : this.targetVTI.getTableName()).toString() + "\n" + this.targetProperties + "\n" + super.toString();
        }
        catch (StandardException e) {
            return "tableName: <not_known>\n" + this.targetProperties + "\n" + super.toString();
        }
    }

    @Override
    public String statementToString() {
        return this.isPutDML ? "PUT" : "INSERT";
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.targetTableName != null) {
            this.printLabel(depth, "targetTableName: ");
            this.targetTableName.treePrint(depth + 1);
        }
        if (this.targetColumnList != null) {
            this.printLabel(depth, "targetColumnList: ");
            this.targetColumnList.treePrint(depth + 1);
        }
    }

    @Override
    public void bindStatement() throws StandardException {
        this.getCompilerContext().pushCurrentPrivType(0);
        FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        DataDictionary dataDictionary = this.getDataDictionary();
        super.bindResultSetsWithTables(dataDictionary);
        this.verifyTargetTable();
        if (this.targetProperties != null) {
            this.verifyTargetProperties(dataDictionary);
        }
        this.getResultColumnList();
        if (this.targetColumnList != null) {
            if (this.synonymTableName != null) {
                this.normalizeSynonymColumns(this.targetColumnList, this.targetTableName);
            }
            this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
            if (this.targetTableDescriptor != null) {
                this.targetColumnList.bindResultColumnsByName(this.targetTableDescriptor, this);
            } else {
                this.targetColumnList.bindResultColumnsByName(this.targetVTI.getResultColumns(), this.targetVTI, this);
            }
            this.getCompilerContext().popCurrentPrivType();
        }
        SanityManager.ASSERT((fromList.size() == 0 ? 1 : 0) != 0, (String)("fromList.size() is expected to be 0, not " + fromList.size() + " on return from RS.bindExpressions()"));
        this.resultSet.replaceDefaults(this.targetTableDescriptor, this.targetColumnList);
        super.bindExpressions();
        if (this.targetColumnList != null) {
            if (this.resultSet.getResultColumns().visibleSize() > this.targetColumnList.size()) {
                throw StandardException.newException("42802");
            }
            this.resultSet.bindUntypedNullsToResultColumns(this.targetColumnList);
            this.resultSet.setTableConstructorTypes(this.targetColumnList);
        } else {
            if (this.resultSet.getResultColumns().visibleSize() > this.resultColumnList.size()) {
                throw StandardException.newException("42802");
            }
            this.resultSet.bindUntypedNullsToResultColumns(this.resultColumnList);
            this.resultSet.setTableConstructorTypes(this.resultColumnList);
        }
        this.resultSet.bindResultColumns(fromList);
        int resCols = this.resultSet.getResultColumns().visibleSize();
        DataDictionary dd = this.getDataDictionary();
        if (this.targetColumnList != null ? this.targetColumnList.size() != resCols : !Misc.getMemStore().isSnappyStore() && this.targetTableDescriptor != null && this.targetTableDescriptor.getNumberOfColumns() != resCols) {
            throw StandardException.newException("42802");
        }
        boolean inOrder = true;
        int numTableColumns = this.resultColumnList.size();
        int[] colMap = new int[numTableColumns];
        for (int i = 0; i < colMap.length; ++i) {
            colMap[i] = -1;
        }
        if (this.targetColumnList != null) {
            int targetSize = this.targetColumnList.size();
            int index = 0;
            while (index < targetSize) {
                int position = ((ResultColumn)this.targetColumnList.elementAt((int)index)).columnDescriptor.getPosition();
                if (index != position - 1) {
                    inOrder = false;
                }
                colMap[position - 1] = index++;
            }
        } else {
            for (int position = 0; position < this.resultSet.getResultColumns().visibleSize(); ++position) {
                colMap[position] = position;
            }
        }
        this.enhanceAndCheckForAutoincrement(this.resultSet, inOrder, numTableColumns, colMap, dataDictionary, this.targetTableDescriptor, this.targetVTI);
        this.resultColumnList.checkStorableExpressions(this.resultSet.getResultColumns());
        if (!this.resultColumnList.columnTypesAndLengthsMatch(this.resultSet.getResultColumns())) {
            this.resultSet = this.resultSet.genNormalizeResultSetNode(false);
            this.resultColumnList.copyTypesAndLengthsToSource(this.resultSet.getResultColumns());
        }
        if (this.targetTableDescriptor != null) {
            ResultColumnList sourceRCL = this.resultSet.getResultColumns();
            sourceRCL.copyResultColumnNames(this.resultColumnList);
            this.checkConstraints = this.bindConstraints(dataDictionary, this.getNodeFactory(), this.targetTableDescriptor, null, sourceRCL, null, null, false, true);
            if (this.resultSet.referencesTarget(this.targetTableDescriptor.getName(), true) || this.requiresDeferredProcessing()) {
                this.deferred = true;
                if (this.bulkInsertReplace && this.resultSet.referencesTarget(this.targetTableDescriptor.getName(), true)) {
                    throw StandardException.newException("42Y38", this.targetTableDescriptor.getQualifiedName());
                }
            }
            this.getAffectedIndexes(this.targetTableDescriptor);
            TransactionController tc = this.getLanguageConnectionContext().getTransactionCompile();
            this.autoincRowLocation = dd.computeAutoincRowLocations(tc, this.targetTableDescriptor);
            if (this.isPrivilegeCollectionRequired()) {
                this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
                this.getCompilerContext().addRequiredTablePriv(this.targetTableDescriptor);
                this.getCompilerContext().popCurrentPrivType();
            }
        } else {
            this.deferred = VTIDeferModPolicy.deferIt(1, this.targetVTI, null, this.resultSet);
        }
        this.getCompilerContext().popCurrentPrivType();
    }

    private void enhanceAndCheckForAutoincrement(ResultSetNode resultSet, boolean inOrder, int numTableColumns, int[] colMap, DataDictionary dataDictionary, TableDescriptor targetTableDescriptor, FromVTI targetVTI) throws StandardException {
        if (resultSet instanceof SingleChildResultSetNode) {
            this.enhanceAndCheckForAutoincrement(((SingleChildResultSetNode)resultSet).getChildResult(), inOrder, numTableColumns, colMap, dataDictionary, targetTableDescriptor, targetVTI);
            if (!inOrder || resultSet.resultColumns.size() < numTableColumns) {
                resultSet.enhanceRCLForInsert(numTableColumns, colMap, dataDictionary, targetTableDescriptor, targetVTI);
            }
        } else if (resultSet instanceof UnionNode) {
            this.enhanceAndCheckForAutoincrement(((TableOperatorNode)resultSet).getLeftResultSet(), inOrder, numTableColumns, colMap, dataDictionary, targetTableDescriptor, targetVTI);
            this.enhanceAndCheckForAutoincrement(((TableOperatorNode)resultSet).getRightResultSet(), inOrder, numTableColumns, colMap, dataDictionary, targetTableDescriptor, targetVTI);
            if (!inOrder || resultSet.resultColumns.size() < numTableColumns) {
                resultSet.enhanceRCLForInsert(numTableColumns, colMap, dataDictionary, targetTableDescriptor, targetVTI);
            }
        } else {
            if (!inOrder || resultSet.resultColumns.size() < numTableColumns) {
                resultSet.enhanceRCLForInsert(numTableColumns, colMap, dataDictionary, targetTableDescriptor, targetVTI);
            }
            this.resultColumnList.checkAutoincrement(resultSet.getResultColumns());
        }
    }

    @Override
    int getPrivType() {
        return 3;
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        boolean returnValue = false;
        if (this.targetTableDescriptor != null) {
            returnValue = this.isSessionSchema(this.targetTableDescriptor.getSchemaDescriptor());
        }
        if (!returnValue) {
            returnValue = this.resultSet.referencesSessionSchema();
        }
        return returnValue;
    }

    private void verifyTargetProperties(DataDictionary dd) throws StandardException {
        String insertMode = this.targetProperties.getProperty("insertMode");
        if (insertMode != null) {
            String upperValue = StringUtil.SQLToUpperCase(insertMode);
            if (!upperValue.equals("BULKINSERT") && !upperValue.equals("REPLACE")) {
                throw StandardException.newException("42X60", (Object)insertMode, (Object)this.targetTableName);
            }
            if (!this.verifyBulkInsert(dd, upperValue)) {
                this.targetProperties.remove("insertMode");
            } else {
                int bulkFetch;
                String bulkFetchStr;
                this.bulkInsert = true;
                if (upperValue.equals("REPLACE")) {
                    this.bulkInsertReplace = true;
                }
                if ((bulkFetchStr = this.targetProperties.getProperty("bulkFetch")) != null && (bulkFetch = this.getIntProperty(bulkFetchStr, "bulkFetch")) <= 0) {
                    throw StandardException.newException("42Y64", String.valueOf(bulkFetch));
                }
            }
        }
    }

    private boolean verifyBulkInsert(DataDictionary dd, String mode) throws StandardException {
        return true;
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        if (this.targetTableDescriptor != null) {
            long heapConglomId = this.targetTableDescriptor.getHeapConglomerateId();
            TransactionController tc = this.getLanguageConnectionContext().getTransactionCompile();
            int numIndexes = this.targetTableDescriptor != null ? this.indexConglomerateNumbers.length : 0;
            StaticCompiledOpenConglomInfo[] indexSCOCIs = new StaticCompiledOpenConglomInfo[numIndexes];
            for (int index = 0; index < numIndexes; ++index) {
                indexSCOCIs[index] = tc.getStaticCompiledConglomInfo(this.indexConglomerateNumbers[index]);
            }
            if (this.bulkInsert || this.targetTableDescriptor.getLockGranularity() == 'T') {
                this.lockMode = 7;
            }
            return this.getGenericConstantActionFactory().getInsertConstantAction(this.targetTableDescriptor, heapConglomId, tc.getStaticCompiledConglomInfo(heapConglomId), this.indicesToMaintain, this.indexConglomerateNumbers, indexSCOCIs, this.indexNames, this.deferred, false, this.targetTableDescriptor.getUUID(), this.lockMode, null, null, this.targetProperties, this.getFKInfo(), this.getTriggerInfo(), this.resultColumnList.getStreamStorableColIds(this.targetTableDescriptor.getNumberOfColumns()), this.getIndexedCols(), null, null, null, this.resultSet.isOneRowResultSet(), this.autoincRowLocation);
        }
        return this.getGenericConstantActionFactory().getUpdatableVTIConstantAction(1, this.deferred);
    }

    public boolean[] getIndexedCols() throws StandardException {
        boolean[] indexedCols = new boolean[this.targetTableDescriptor.getNumberOfColumns()];
        for (int index = 0; index < this.indicesToMaintain.length; ++index) {
            int[] colIds = this.indicesToMaintain[index].getIndexDescriptor().baseColumnPositions();
            for (int index2 = 0; index2 < colIds.length; ++index2) {
                indexedCols[colIds[index2] - 1] = true;
            }
        }
        return indexedCols;
    }

    @Override
    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateCodeForTemporaryTable(acb, acb.getExecuteMethod());
        this.generateParameterValueSet(acb);
        if (this.targetTableDescriptor != null) {
            acb.pushGetResultSetFactoryExpression(mb);
            this.optimizeForOffHeap(false);
            this.resultSet.generate(acb, mb);
            this.generateCheckConstraints(this.checkConstraints, acb, mb);
            mb.callMethod((short)185, null, "getGemFireInsertResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.ResultSet", 2);
        } else {
            this.targetVTI.assignCostEstimate(this.resultSet.getNewCostEstimate());
            acb.pushGetResultSetFactoryExpression(mb);
            this.resultSet.generate(acb, mb);
            this.targetVTI.generate(acb, mb);
            mb.callMethod((short)185, null, "getInsertVTIResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.ResultSet", 2);
        }
    }

    @Override
    public final int getStatementType() {
        return 1;
    }

    static final int getStatementType(Properties targetProperties) {
        String upperValue;
        String insertMode;
        int retval = 1;
        String string = insertMode = targetProperties == null ? null : targetProperties.getProperty("insertMode");
        if (insertMode != null && (upperValue = StringUtil.SQLToUpperCase(insertMode)).equals("REPLACE")) {
            retval = 2;
        }
        return retval;
    }

    private void getAffectedIndexes(TableDescriptor td) throws StandardException {
        IndexLister indexLister = td.getIndexLister();
        this.indicesToMaintain = indexLister.getDistinctIndexRowGenerators();
        this.indexConglomerateNumbers = indexLister.getDistinctIndexConglomerateNumbers();
        this.indexNames = indexLister.getDistinctIndexNames();
        ConglomerateDescriptor[] cds = td.getConglomerateDescriptors();
        CompilerContext cc = this.getCompilerContext();
        for (int index = 0; index < cds.length; ++index) {
            cc.createDependency(cds[index]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryInfo computeQueryInfo(QueryInfoContext qic) throws StandardException {
        try {
            SelectQueryInfo sInfo = (SelectQueryInfo)this.computeSubSelectQueryInfo(qic);
            InsertQueryInfo insInfo = new InsertQueryInfo(qic, sInfo);
            qic.setRootQueryInfo(insInfo);
            this.accept(insInfo);
            insInfo.init();
            InsertQueryInfo insertQueryInfo = insInfo;
            return insertQueryInfo;
        }
        finally {
            qic.cleanUp();
        }
    }

    @Override
    public QueryInfo computeSubSelectQueryInfo(QueryInfoContext qic) throws StandardException {
        if (!this.resultSetInfoInitialized && this.resultSet != null) {
            this.resultSetInfoInitialized = true;
            QueryInfo qInfo = this.resultSet.computeSubSelectQueryInfo(qic);
            if (qInfo.isSelect()) {
                SanityManager.ASSERT((boolean)(qInfo instanceof SelectQueryInfo));
                this.resultSetInfo = (SelectQueryInfo)qInfo;
            }
        }
        return this.resultSetInfo;
    }

    public String getNonVTITargetTableName() {
        if (this.targetVTI != null) {
            return null;
        }
        return this.targetTableName.getFullTableName();
    }

    public boolean isPutDML() {
        return this.isPutDML;
    }

    public Set<Object> getSingleHopInformation(GenericParameterValueSet parameterValueSet, GenericPreparedStatement preparedStmt, GfxdPartitionResolver resolver, TableDescriptor ttd) throws StandardException {
        ResultColumnList rcl = this.resultColumnList;
        return this.getSHOPInformation(rcl, resolver, ttd);
    }

    public Set<Object> getSHOPInformation(ResultColumnList topLevelRCL, GfxdPartitionResolver resolver, TableDescriptor ttd) throws StandardException {
        ResultSetNode rsn = this.resultSet;
        ResultColumnList rcl = rsn.getResultColumns();
        int numColumns = rcl.size();
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < numColumns; ++i) {
            String colName;
            boolean partOfPartitioningColumn;
            ResultColumn rc = (ResultColumn)rcl.elementAt(i);
            ColumnRoutingObjectInfo croi = this.getRoutingObjectInfo(rc, resolver, partOfPartitioningColumn = resolver.isUsedInPartitioning(colName = rc.getActualName()), colName, ttd);
            if (croi != null) {
                set.add(croi);
                continue;
            }
            if (!partOfPartitioningColumn) continue;
            return null;
        }
        if (set.size() > 1) {
            ColumnRoutingObjectInfo[] parCols = new ColumnRoutingObjectInfo[set.size()];
            int i = 0;
            for (Object o : set) {
                parCols[i++] = (ColumnRoutingObjectInfo)o;
            }
            MultiColumnRoutingObjectInfo mcroi = new MultiColumnRoutingObjectInfo(parCols);
            set.clear();
            set.add(mcroi);
        }
        return set;
    }

    private ColumnRoutingObjectInfo getRoutingObjectInfo(ResultColumn rc, GfxdPartitionResolver resolver, boolean partOfPartitioningColumn, String colName, TableDescriptor ttd) throws StandardException {
        if (partOfPartitioningColumn) {
            return this.getAppropriateRoutingObjectInfo(rc, resolver, colName, ttd);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ColumnRoutingObjectInfo getAppropriateRoutingObjectInfo(ResultColumn rc, GfxdPartitionResolver resolver, String colName, TableDescriptor ttd) throws StandardException {
        ResultColumn internalRC;
        boolean isParameter;
        DataTypeDescriptor dtd = rc.getTypeServices();
        int maxWidth = dtd.getMaximumWidth();
        int type = dtd.getDVDTypeFormatId();
        ValueNode vn = rc.getExpression();
        int paramNum = this.isParameterNode(vn);
        Object constantValue = null;
        if (vn instanceof ConstantNode) {
            constantValue = ((ConstantNode)vn).getValue().getObject();
        }
        boolean bl = isParameter = paramNum > 0;
        if (isParameter || (constantValue = rc.getConstantValueAsObject()) != null || vn == null || (internalRC = vn.getSourceResultColumn()) == null || (constantValue = internalRC.getConstantValueAsObject()) != null) return ComparisonQueryInfo.getAppropriateRoutingObjectInfo(vn, type, isParameter, paramNum, constantValue, resolver, maxWidth);
        vn = internalRC.getExpression();
        if (vn instanceof ConstantNode) {
            DataValueDescriptor dvd = ((ConstantNode)vn).getValue();
            if (dvd != null) {
                constantValue = dvd.getObject();
                return ComparisonQueryInfo.getAppropriateRoutingObjectInfo(vn, type, isParameter, paramNum, constantValue, resolver, maxWidth);
            } else {
                if (ttd == null) return null;
                ColumnDescriptor cd = ttd.getColumnDescriptor(colName);
                if (cd == null || (dvd = cd.getDefaultValue()) == null) return ComparisonQueryInfo.getAppropriateRoutingObjectInfo(vn, type, isParameter, paramNum, constantValue, resolver, maxWidth);
                constantValue = dvd.getObject();
            }
            return ComparisonQueryInfo.getAppropriateRoutingObjectInfo(vn, type, isParameter, paramNum, constantValue, resolver, maxWidth);
        } else {
            if (!(vn instanceof ParameterNode)) return null;
            isParameter = true;
            paramNum = ((ParameterNode)vn).getParameterNumber();
        }
        return ComparisonQueryInfo.getAppropriateRoutingObjectInfo(vn, type, isParameter, paramNum, constantValue, resolver, maxWidth);
    }

    private int isParameterNode(ValueNode vn) {
        if (vn instanceof ParameterNode) {
            return ((ParameterNode)vn).getParameterNumber();
        }
        if (vn instanceof VirtualColumnNode) {
            ResultColumn source = ((VirtualColumnNode)vn).getSourceColumn();
            vn = source.getExpression();
            return this.isParameterNode(vn);
        }
        return -1;
    }

    private void printColumnInformation(ResultColumn rc, int idx) {
        VirtualColumnNode vcn = (VirtualColumnNode)rc.getExpression();
        rc = vcn.getSourceColumn();
        System.out.println("rc=" + rc.getExpression().getClass().getName() + "---" + rc.getExpression());
        this.printColumnInformation2(rc, idx);
    }

    private void printColumnInformation2(ResultColumn rc, int idx) {
        System.out.println("Number: " + idx);
        System.out.println("Column name: " + rc.getActualName());
        System.out.println("col position: " + rc.getColumnPosition());
    }
}

