/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.catalog.AliasInfo;
import com.pivotal.gemfirexd.internal.catalog.TypeDescriptor;
import com.pivotal.gemfirexd.internal.catalog.types.RoutineAliasInfo;
import com.pivotal.gemfirexd.internal.catalog.types.SynonymAliasInfo;
import com.pivotal.gemfirexd.internal.catalog.types.UDTAliasInfo;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import java.util.Arrays;
import java.util.Vector;

public class CreateAliasNode
extends DDLStatementNode {
    private String javaClassName;
    private String methodName;
    private char aliasType;
    private boolean delimitedIdentifier;
    private AliasInfo aliasInfo;

    @Override
    public void init(Object aliasName, Object targetObject, Object methodName, Object aliasSpecificInfo, Object aliasType, Object delimitedIdentifier) throws StandardException {
        TableName qn = (TableName)aliasName;
        this.aliasType = ((Character)aliasType).charValue();
        this.initAndCheck(qn);
        switch (this.aliasType) {
            case 'A': {
                this.javaClassName = (String)targetObject;
                this.aliasInfo = new UDTAliasInfo();
                this.implicitCreateSchema = true;
                break;
            }
            case 'F': 
            case 'P': {
                Integer drso;
                this.javaClassName = (String)targetObject;
                this.methodName = (String)methodName;
                this.delimitedIdentifier = (Boolean)delimitedIdentifier;
                Object[] routineElements = (Object[])aliasSpecificInfo;
                Object[] parameters = (Object[])routineElements[0];
                int paramCount = ((Vector)parameters[0]).size();
                if (this.methodName.indexOf(40) != -1) {
                    this.getDataDictionary().checkVersion(130, "EXTERNAL NAME 'class.method(<signature>)'");
                }
                Object[] names = null;
                Object[] types = null;
                int[] modes = null;
                if (paramCount > 90) {
                    throw StandardException.newException("54023", (Object)String.valueOf(90), aliasName, (Object)String.valueOf(paramCount));
                }
                if (paramCount != 0) {
                    names = new String[paramCount];
                    ((Vector)parameters[0]).copyInto(names);
                    types = new TypeDescriptor[paramCount];
                    ((Vector)parameters[1]).copyInto(types);
                    modes = new int[paramCount];
                    for (int i = 0; i < paramCount; ++i) {
                        int currentMode;
                        modes[i] = currentMode = ((Integer)((Vector)parameters[2]).elementAt(i)).intValue();
                        if (types[i].isUserDefinedType() || !TypeId.getBuiltInTypeId(types[i].getJDBCTypeId()).isXMLTypeId()) continue;
                        throw StandardException.newException("42962", names[i]);
                    }
                    if (paramCount > 1) {
                        Object[] dupNameCheck = new String[paramCount];
                        System.arraycopy(names, 0, dupNameCheck, 0, paramCount);
                        Arrays.sort(dupNameCheck);
                        for (int dnc = 1; dnc < dupNameCheck.length; ++dnc) {
                            if (((String)dupNameCheck[dnc]).equals("") || !((String)dupNameCheck[dnc]).equals(dupNameCheck[dnc - 1])) continue;
                            throw StandardException.newException("42734", dupNameCheck[dnc], (Object)this.getFullName());
                        }
                    }
                }
                int drs = (drso = (Integer)routineElements[2]) == null ? 0 : drso;
                Short sqlAllowedObject = (Short)routineElements[6];
                short sqlAllowed = sqlAllowedObject != null ? sqlAllowedObject : (this.aliasType == 'P' ? (short)0 : 1);
                Boolean calledOnNullInputO = (Boolean)routineElements[7];
                boolean calledOnNullInput = calledOnNullInputO == null ? true : calledOnNullInputO;
                TypeDescriptor returnType = (TypeDescriptor)routineElements[8];
                if (returnType != null) {
                    DataTypeDescriptor dtd = DataTypeDescriptor.getType(returnType);
                    dtd = this.bindUserType(dtd);
                    returnType = dtd.getCatalogType();
                }
                this.aliasInfo = new RoutineAliasInfo(this.methodName, paramCount, (String[])names, (TypeDescriptor[])types, modes, drs, (Short)routineElements[5], sqlAllowed, calledOnNullInput, returnType);
                this.implicitCreateSchema = true;
                break;
            }
            case 'S': {
                this.implicitCreateSchema = true;
                TableName t = (TableName)targetObject;
                String targetSchema = t.getSchemaName() != null ? t.getSchemaName() : this.getSchemaDescriptor().getSchemaName();
                this.aliasInfo = new SynonymAliasInfo(targetSchema, t.getTableName());
                break;
            }
            case 'R': {
                String className = (String)targetObject;
                this.aliasInfo = new SynonymAliasInfo(null, className);
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("Unexpected value for aliasType (" + aliasType + ")"));
            }
        }
    }

    @Override
    public String statementToString() {
        switch (this.aliasType) {
            case 'A': {
                return "CREATE TYPE";
            }
            case 'P': {
                return "CREATE PROCEDURE";
            }
            case 'S': {
                return "CREATE SYNONYM";
            }
            case 'R': {
                return "CREATE PROCEDURE RESULT PROCESSOR";
            }
        }
        return "CREATE FUNCTION";
    }

    private boolean anyStringTypeDescriptor() {
        TypeId compTypeId;
        RoutineAliasInfo rai = (RoutineAliasInfo)this.aliasInfo;
        TypeDescriptor aType = rai.getReturnType();
        if (aType != null && (compTypeId = TypeId.getBuiltInTypeId(aType.getTypeName())) != null && compTypeId.isStringTypeId()) {
            return true;
        }
        if (rai.getParameterCount() != 0) {
            int paramCount = rai.getParameterCount();
            TypeDescriptor[] paramTypes = rai.getParameterTypes();
            for (int i = 0; i < paramCount; ++i) {
                compTypeId = TypeId.getBuiltInTypeId(paramTypes[i].getTypeName());
                if (compTypeId == null || !compTypeId.isStringTypeId()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void bindStatement() throws StandardException {
        if (this.aliasType == 'F' || this.aliasType == 'P') {
            ((RoutineAliasInfo)this.aliasInfo).setCollationTypeForAllStringTypes(this.getSchemaDescriptor().getCollationType());
            this.bindParameterTypes((RoutineAliasInfo)this.aliasInfo);
        }
        if (this.aliasType == 'A') {
            TypeId[] allSystemTypeIds = TypeId.getAllBuiltinTypeIds();
            int systemTypeCount = allSystemTypeIds.length;
            boolean foundConflict = this.javaClassName.startsWith("com.pivotal.gemfirexd.internal.");
            if (!foundConflict) {
                for (int i = 0; i < systemTypeCount; ++i) {
                    TypeId systemType = allSystemTypeIds[i];
                    String systemTypeName = systemType.getCorrespondingJavaTypeName();
                    if (!systemTypeName.equals(this.javaClassName)) continue;
                    foundConflict = true;
                    break;
                }
            }
            if (foundConflict) {
                throw StandardException.newException("42Z10", this.javaClassName);
            }
            return;
        }
        if (this.aliasType != 'S') {
            return;
        }
        if (this.isSessionSchema(this.getSchemaDescriptor().getSchemaName())) {
            throw StandardException.newException("XCL51.S");
        }
        String targetSchema = ((SynonymAliasInfo)this.aliasInfo).getSynonymSchema();
        String targetTable = ((SynonymAliasInfo)this.aliasInfo).getSynonymTable();
        if (this.getObjectName().equals(targetSchema, targetTable)) {
            throw StandardException.newException("42916", (Object)this.getFullName(), (Object)(targetSchema + "." + targetTable));
        }
        SchemaDescriptor targetSD = this.getSchemaDescriptor(targetSchema, false);
        if (targetSD != null && this.isSessionSchema(targetSD)) {
            throw StandardException.newException("XCL51.S");
        }
    }

    private void bindParameterTypes(RoutineAliasInfo aliasInfo) throws StandardException {
        TypeDescriptor[] parameterTypes = aliasInfo.getParameterTypes();
        if (parameterTypes == null) {
            return;
        }
        for (TypeDescriptor td : parameterTypes) {
            if (!td.isUserDefinedType()) continue;
            DataTypeDescriptor dtd = DataTypeDescriptor.getType(td);
            dtd = this.bindUserType(dtd);
            parameterTypes[i] = dtd.getCatalogType();
        }
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        String schemaName = this.getSchemaDescriptor().getSchemaName();
        return this.getGenericConstantActionFactory().getCreateAliasConstantAction(this.getRelativeName(), schemaName, this.javaClassName, this.aliasInfo, this.aliasType);
    }
}

