/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNodeList;
import java.util.Vector;

public abstract class BinaryListOperatorNode
extends ValueNode {
    String methodName;
    String operator;
    String leftInterfaceType;
    String rightInterfaceType;
    ValueNode receiver;
    ValueNode leftOperand;
    ValueNodeList rightOperandList;

    @Override
    public void init(Object leftOperand, Object rightOperandList, Object operator, Object methodName) {
        this.leftOperand = (ValueNode)leftOperand;
        this.rightOperandList = (ValueNodeList)rightOperandList;
        this.operator = (String)operator;
        this.methodName = (String)methodName;
    }

    @Override
    public String toString() {
        return "operator: " + this.operator + "\n" + "methodName: " + this.methodName + "\n" + super.toString();
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.leftOperand != null) {
            this.printLabel(depth, "leftOperand: ");
            this.leftOperand.treePrint(depth + 1);
        }
        if (this.rightOperandList != null) {
            this.printLabel(depth, "rightOperandList: ");
            this.rightOperandList.treePrint(depth + 1);
        }
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.leftOperand = this.leftOperand.bindExpression(fromList, subqueryList, aggregateVector);
        this.rightOperandList.bindExpression(fromList, subqueryList, aggregateVector);
        if (this.leftOperand.requiresTypeFromContext()) {
            if (this.rightOperandList.containsAllParameterNodes()) {
                throw StandardException.newException("42X35", this.operator);
            }
            this.leftOperand.setType(this.rightOperandList.getTypeServices());
        }
        if (this.rightOperandList.containsParameterNode()) {
            this.rightOperandList.setParameterDescriptor(this.leftOperand.getTypeServices());
        }
        this.handleUserDefinedTypes();
        this.bindComparisonOperator();
        return this;
    }

    protected void handleUserDefinedTypes() throws StandardException {
        if (this.leftOperand.getTypeId().userType()) {
            this.leftOperand = this.leftOperand.genSQLJavaSQLTree();
        }
        this.rightOperandList.genSQLJavaSQLTrees();
    }

    public void bindComparisonOperator() throws StandardException {
        this.rightOperandList.comparable(this.leftOperand);
        boolean nullableResult = this.leftOperand.getTypeServices().isNullable() || this.rightOperandList.isNullable();
        this.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, nullableResult));
    }

    @Override
    public ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        this.leftOperand = this.leftOperand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        this.rightOperandList.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        return this;
    }

    public void setLeftOperand(ValueNode newLeftOperand) {
        this.leftOperand = newLeftOperand;
    }

    public ValueNode getLeftOperand() {
        return this.leftOperand;
    }

    public void setRightOperandList(ValueNodeList newRightOperandList) {
        this.rightOperandList = newRightOperandList;
    }

    public ValueNodeList getRightOperandList() {
        return this.rightOperandList;
    }

    @Override
    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        boolean pushable = this.leftOperand.categorize(referencedTabs, simplePredsOnly);
        pushable = this.rightOperandList.categorize(referencedTabs, simplePredsOnly) && pushable;
        return pushable;
    }

    @Override
    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.leftOperand = this.leftOperand.remapColumnReferencesToExpressions();
        this.rightOperandList.remapColumnReferencesToExpressions();
        return this;
    }

    @Override
    public boolean isConstantExpression() {
        return this.leftOperand.isConstantExpression() && this.rightOperandList.isConstantExpression();
    }

    @Override
    public boolean constantExpression(PredicateList whereClause) {
        return this.leftOperand.constantExpression(whereClause) && this.rightOperandList.constantExpression(whereClause);
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        int leftType = this.leftOperand.getOrderableVariantType();
        int rightType = this.rightOperandList.getOrderableVariantType();
        return Math.min(leftType, rightType);
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = v.visit(this);
        if (v.skipChildren(this)) {
            return returnNode;
        }
        if (this.leftOperand != null && !v.stopTraversal()) {
            this.leftOperand = (ValueNode)this.leftOperand.accept(v);
        }
        if (this.rightOperandList != null && !v.stopTraversal()) {
            this.rightOperandList = (ValueNodeList)this.rightOperandList.accept(v);
        }
        return returnNode;
    }

    @Override
    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (!this.isSameNodeType(o)) {
            return false;
        }
        BinaryListOperatorNode other = (BinaryListOperatorNode)o;
        if (!this.operator.equals(other.operator) || !this.leftOperand.isEquivalent(other.getLeftOperand())) {
            return false;
        }
        int sz = this.getRightOperandList().size();
        if (sz != other.rightOperandList.size()) {
            return false;
        }
        for (int i = 0; i < sz; ++i) {
            ValueNode e = (ValueNode)this.rightOperandList.elementAt(i);
            if (e.isEquivalent((ValueNode)other.rightOperandList.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public ValueNode genExpressionOperands(ResultColumnList outerResultColumns, ResultColumn parentRC, boolean remapToNew) throws StandardException {
        if (parentRC != null) {
            outerResultColumns.addResultColumn(parentRC);
            return this;
        }
        this.leftOperand = this.leftOperand.genExpressionOperands(outerResultColumns, null, remapToNew);
        int sz = this.rightOperandList.size();
        for (int i = 0; i < sz; ++i) {
            ValueNode e = (ValueNode)this.rightOperandList.elementAt(i);
            e = e.genExpressionOperands(outerResultColumns, null, remapToNew);
        }
        return this;
    }

    @Override
    public String printExplainInfo() {
        String explainStr = this.leftOperand.printExplainInfo() + " " + this.operator + " ";
        for (int index = 0; index < this.rightOperandList.size(); ++index) {
            ValueNode valueNode = (ValueNode)this.rightOperandList.elementAt(index);
            explainStr = explainStr + valueNode.printExplainInfo() + " ";
        }
        return explainStr;
    }
}

