/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql;

import com.gemstone.gnu.trove.TObjectIntHashMap;
import com.pivotal.gemfirexd.internal.iapi.services.io.Formatable;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultDescription;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.sql.GenericColumnDescriptor;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.ResultSetMetaData;

public final class GenericResultDescription
implements ResultDescription,
Formatable {
    private ResultColumnDescriptor[] columns;
    private String statementType;
    private transient ResultSetMetaData metaData;
    private final transient TObjectIntHashMap columnNameMap;
    private transient boolean qualifiedNamesPopulated;

    public GenericResultDescription() {
        this.columnNameMap = null;
    }

    public GenericResultDescription(ResultColumnDescriptor[] columns, String statementType) {
        this.columns = columns;
        this.statementType = statementType;
        if (columns != null && columns.length > 0) {
            this.columnNameMap = new TObjectIntHashMap(columns.length);
            for (int index = 0; index < this.columns.length; ++index) {
                this.setColumnDescriptor(index, columns[index]);
            }
        } else {
            this.columnNameMap = null;
        }
    }

    @Override
    public String getStatementType() {
        return this.statementType;
    }

    @Override
    public int getColumnCount() {
        return this.columns == null ? 0 : this.columns.length;
    }

    @Override
    public ResultColumnDescriptor[] getColumnInfo() {
        return this.columns;
    }

    @Override
    public ResultColumnDescriptor getColumnDescriptor(int position) {
        return this.columns[position - 1];
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int len = this.columns == null ? 0 : this.columns.length;
        out.writeObject(this.statementType);
        out.writeInt(len);
        while (len-- > 0) {
            if (!(this.columns[len] instanceof GenericColumnDescriptor)) {
                this.columns[len] = new GenericColumnDescriptor(this.columns[len]);
            }
            out.writeObject(this.columns[len]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.columns = null;
        this.statementType = (String)in.readObject();
        int len = in.readInt();
        if (len > 0) {
            this.columns = new GenericColumnDescriptor[len];
            while (len-- > 0) {
                this.columns[len] = (ResultColumnDescriptor)in.readObject();
            }
        }
    }

    @Override
    public int getTypeFormatId() {
        return 228;
    }

    public String toString() {
        StringBuilder colStr = new StringBuilder();
        for (int i = 0; i < this.columns.length; ++i) {
            colStr.append("column[" + i + "]\n");
            colStr.append(this.columns[i].toString());
        }
        return "GenericResultDescription\n\tStatementType = " + this.statementType + "\n" + "\tCOLUMNS\n" + colStr.toString();
    }

    @Override
    public synchronized void setMetaData(ResultSetMetaData rsmd) {
        if (this.metaData == null) {
            this.metaData = rsmd;
        }
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public synchronized int findColumnInsensitive(String columnName) {
        int val = this.columnNameMap.get((Object)columnName);
        if (val > 0) {
            return val;
        }
        String ucolumnName = StringUtil.SQLToUpperCase(columnName);
        val = this.columnNameMap.get((Object)ucolumnName);
        if (val > 0) {
            return val;
        }
        if (this.populateQualifiedNames()) {
            val = this.columnNameMap.get((Object)columnName);
            if (val > 0) {
                return val;
            }
            val = this.columnNameMap.get((Object)ucolumnName);
            if (val > 0) {
                return val;
            }
        }
        return -1;
    }

    public void setColumnDescriptor(int index, ResultColumnDescriptor rcd) {
        if (rcd != null && rcd.getName() != null) {
            this.columns[index] = rcd;
            String columnName = rcd.getName();
            if (columnName != null) {
                this.columnNameMap.putIfAbsent((Object)columnName, index + 1, 0);
            }
        }
    }

    private boolean populateQualifiedNames() {
        if (this.columns != null && !this.qualifiedNamesPopulated) {
            int columnPos = 1;
            for (ResultColumnDescriptor rcd : this.columns) {
                String tableName;
                String columnName = rcd.getName();
                if (columnName != null && (tableName = rcd.getSourceTableName()) != null && tableName.length() > 0) {
                    this.columnNameMap.putIfAbsent((Object)(tableName + '.' + columnName), columnPos, 0);
                    String schemaName = rcd.getSourceSchemaName();
                    if (schemaName != null && schemaName.length() > 0) {
                        this.columnNameMap.putIfAbsent((Object)(schemaName + '.' + tableName + '.' + columnName), columnPos, 0);
                    }
                }
                ++columnPos;
            }
            this.qualifiedNamesPopulated = true;
            return true;
        }
        return false;
    }
}

