/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.load;

import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.concurrent.ConcurrentTLongObjectHashMap;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.load.CharsReader;
import com.pivotal.gemfirexd.internal.impl.load.ImportBase;
import com.pivotal.gemfirexd.internal.impl.load.LoadError;
import com.pivotal.gemfirexd.internal.vti.VTITemplate;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class MTImport
extends VTITemplate {
    private static final AtomicLong currentImportId = new AtomicLong(0L);
    private static final ConcurrentTLongObjectHashMap<ArrayBlockingQueue<QueueData>> queueMap = new ConcurrentTLongObjectHashMap(4);
    public static final QueueData QUEUE_EOF_TOKEN = new QueueData(null, 0);
    public static final long QUEUE_INVALID_ID = -1L;
    private final ArrayBlockingQueue<QueueData> queue;
    private final ImportBase importer;

    static long putNewQueue(ArrayBlockingQueue<QueueData> queue) {
        long id = currentImportId.incrementAndGet();
        if (id == -1L) {
            id = currentImportId.incrementAndGet();
        }
        queueMap.putPrimitive(id, queue);
        return id;
    }

    static ArrayBlockingQueue<QueueData> getQueue(long id) {
        ArrayBlockingQueue queue = (ArrayBlockingQueue)queueMap.getPrimitive(id);
        if (queue != null) {
            return queue;
        }
        throw new IllegalStateException("import ID=" + id + " not found!");
    }

    static void removeData(long id) {
        queueMap.removePrimitive(id);
    }

    public MTImport(long queueId, String importClassName, String inputFileName, String columnDelimiter, String characterDelimiter, String codeset, long offset, long endPosition, int noOfColumnsExpected, String columnTypes, boolean lobsInExtFile, int importCounter, String columnTypeNames, String udtClassNamesString) throws SQLException {
        this(queueId, importClassName, inputFileName, columnDelimiter, characterDelimiter, codeset, offset, endPosition, false, noOfColumnsExpected, columnTypes, lobsInExtFile, importCounter, columnTypeNames, udtClassNamesString);
    }

    public MTImport(long queueId, String importClassName, String inputFileName, String columnDelimiter, String characterDelimiter, String codeset, long offset, long endPosition, boolean hasColumnDefinition, int noOfColumnsExpected, String columnTypes, boolean lobsInExtFile, int importCounter, String columnTypeNames, String udtClassNamesString) throws SQLException {
        this.queue = MTImport.getQueue(queueId);
        if (ImportBase._importers.containsKeyPrimitive((long)importCounter)) {
            this.importer = (ImportBase)ImportBase._importers.getPrimitive((long)importCounter);
        } else {
            try {
                Class importClass = ClassPathLoader.getLatest().forName(importClassName);
                this.importer = hasColumnDefinition ? (ImportBase)importClass.getConstructor(String.class, String.class, String.class, String.class, Long.TYPE, Long.TYPE, Boolean.TYPE, Integer.TYPE, String.class, Boolean.TYPE, Integer.TYPE, String.class, String.class).newInstance(inputFileName, columnDelimiter, characterDelimiter, codeset, offset, endPosition, hasColumnDefinition, noOfColumnsExpected, columnTypes, lobsInExtFile, importCounter, columnTypeNames, udtClassNamesString) : (ImportBase)importClass.getConstructor(String.class, String.class, String.class, String.class, Long.TYPE, Long.TYPE, Integer.TYPE, String.class, Boolean.TYPE, Integer.TYPE, String.class, String.class).newInstance(inputFileName, columnDelimiter, characterDelimiter, codeset, offset, endPosition, noOfColumnsExpected, columnTypes, lobsInExtFile, importCounter, columnTypeNames, udtClassNamesString);
                this.importer.importReadData.setCharsReader(new CharsReader(null, 0, 0));
            }
            catch (RuntimeException re) {
                throw LoadError.unexpectedError(re);
            }
            catch (Exception e) {
                throw LoadError.unexpectedError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SQLException {
        if (this.importer.eofReceived) {
            return false;
        }
        while (true) {
            InterruptedException t;
            block13: {
                if (this.importer.currentRows != null) {
                    char[] line = this.importer.currentRows[this.importer.currentRowIndex];
                    if (line != null) {
                        try {
                            this.importer.importReadData.resetCharsReader(line, 0, line.length);
                            this.importer.next();
                            boolean bl = true;
                            return bl;
                        }
                        finally {
                            ++this.importer.currentRowIndex;
                        }
                    }
                    this.importer.currentRows = null;
                    this.importer.currentRowIndex = 0;
                }
                t = null;
                try {
                    QueueData qdata = this.queue.poll(1L, TimeUnit.SECONDS);
                    if (qdata != QUEUE_EOF_TOKEN) {
                        if (qdata != null) {
                            this.importer.currentRows = qdata.rows;
                            this.importer.lineNumber = this.importer.importReadData.lineNumber = qdata.startLineNumber;
                            this.importer.currentRowIndex = 0;
                            continue;
                        }
                        break block13;
                    }
                    this.importer.nextRow = null;
                    this.importer.eofReceived = true;
                    return false;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    t = ie;
                }
            }
            try {
                Misc.checkIfCacheClosing(t);
            }
            catch (RuntimeException re) {
                throw Util.generateCsSQLException(Misc.processRuntimeException(re, "MTImport", null));
            }
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.importer.getString(columnIndex);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return this.importer.getClob(columnIndex);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return this.importer.getBlob(columnIndex);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.importer.getBytes(columnIndex);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.importer.getObject(columnIndex);
    }

    @Override
    public boolean wasNull() {
        return this.importer.wasNull();
    }

    @Override
    public int getRow() throws SQLException {
        return this.importer.getRow();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.importer.getMetaData();
    }

    @Override
    public void close() throws SQLException {
        this.importer.close();
    }

    public static class QueueData {
        final char[][] rows;
        final int startLineNumber;

        public QueueData(char[][] rows, int lineNumber) {
            this.rows = rows;
            this.startLineNumber = lineNumber;
        }
    }
}

