/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.drda;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.pivotal.gemfirexd.NetworkInterface;
import com.pivotal.gemfirexd.internal.engine.diag.SessionsVTI;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.stats.ConnectionStats;
import com.pivotal.gemfirexd.internal.iapi.error.DerbySQLException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.AuthenticationService;
import com.pivotal.gemfirexd.internal.iapi.jdbc.DRDAServerStarter;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.info.ProductVersionHolder;
import com.pivotal.gemfirexd.internal.iapi.services.info.Version;
import com.pivotal.gemfirexd.internal.iapi.services.jmx.ManagementService;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedOutput;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedResource;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.drda.AppRequester;
import com.pivotal.gemfirexd.internal.impl.drda.CharacterEncodings;
import com.pivotal.gemfirexd.internal.impl.drda.ClientThread;
import com.pivotal.gemfirexd.internal.impl.drda.CodePoint;
import com.pivotal.gemfirexd.internal.impl.drda.DDMReader;
import com.pivotal.gemfirexd.internal.impl.drda.DDMWriter;
import com.pivotal.gemfirexd.internal.impl.drda.DRDAConnThread;
import com.pivotal.gemfirexd.internal.impl.drda.DRDAProtocolException;
import com.pivotal.gemfirexd.internal.impl.drda.DRDAStatement;
import com.pivotal.gemfirexd.internal.impl.drda.Database;
import com.pivotal.gemfirexd.internal.impl.drda.DecryptionManager;
import com.pivotal.gemfirexd.internal.impl.drda.NaiveTrustManager;
import com.pivotal.gemfirexd.internal.impl.drda.NetworkServerMBeanImpl;
import com.pivotal.gemfirexd.internal.impl.drda.Session;
import com.pivotal.gemfirexd.internal.impl.drda.memCheck;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.tools.sysinfo.Main;
import com.pivotal.gemfirexd.internal.jdbc.InternalDriver;
import com.pivotal.gemfirexd.internal.mbeans.VersionMBean;
import com.pivotal.gemfirexd.internal.mbeans.drda.NetworkServerMBean;
import com.pivotal.gemfirexd.internal.security.SystemPermission;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class NetworkServerControlImpl {
    private static final int NO_USAGE_MSGS = 12;
    private static final String[] COMMANDS = new String[]{"start", "shutdown", "trace", "tracedirectory", "ping", "logconnections", "sysinfo", "runtimeinfo", "maxthreads", "timeslice", ""};
    private static final int[] COMMAND_ARGS = new int[]{0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0};
    public static final int COMMAND_START = 0;
    public static final int COMMAND_SHUTDOWN = 1;
    public static final int COMMAND_TRACE = 2;
    public static final int COMMAND_TRACEDIRECTORY = 3;
    public static final int COMMAND_TESTCONNECTION = 4;
    public static final int COMMAND_LOGCONNECTIONS = 5;
    public static final int COMMAND_SYSINFO = 6;
    public static final int COMMAND_RUNTIME_INFO = 7;
    public static final int COMMAND_MAXTHREADS = 8;
    public static final int COMMAND_TIMESLICE = 9;
    public static final int COMMAND_PROPERTIES = 10;
    public static final int COMMAND_UNKNOWN = -1;
    public static final String[] DASHARGS = new String[]{"p", "d", "user", "password", "ld", "ea", "ep", "b", "h", "s", "noSecurityManager", "ssl"};
    public static final int DASHARG_PORT = 0;
    public static final int DASHARG_DATABASE = 1;
    public static final int DASHARG_USER = 2;
    public static final int DASHARG_PASSWORD = 3;
    public static final int DASHARG_LOADSYSIBM = 4;
    public static final int DASHARG_ENCALG = 5;
    public static final int DASHARG_ENCPRV = 6;
    public static final int DASHARG_BOOTPASSWORD = 7;
    public static final int DASHARG_HOST = 8;
    public static final int DASHARG_SESSION = 9;
    public static final int DASHARG_UNSECURE = 10;
    private static final int DASHARG_SSL = 11;
    private static final int PROTOCOL_VERSION = 2;
    private static final String COMMAND_HEADER = "CMD:";
    private static final String REPLY_HEADER = "RPY:";
    private static final int REPLY_HEADER_LENGTH = "RPY:".length();
    private static final int OK = 0;
    private static final int WARNING = 1;
    private static final int ERROR = 2;
    private static final int SQLERROR = 3;
    private static final int SQLWARNING = 4;
    private static final String DRDA_PROP_MESSAGES = "com.pivotal.gemfirexd.internal.loc.drda.messages";
    private static final String DRDA_PROP_DEBUG = "gemfirexd.drda.debug";
    private static final String CLOUDSCAPE_DRIVER = "com.pivotal.gemfirexd.jdbc.EmbeddedDriver";
    public static final String UNEXPECTED_ERR = "Unexpected exception";
    private static final int MIN_MAXTHREADS = -1;
    private static final int MIN_TIMESLICE = -1;
    private static final int USE_DEFAULT = -1;
    private static final int DEFAULT_MAXTHREADS = 0;
    private static final int DEFAULT_TIMESLICE = 0;
    private static final String DEFAULT_HOST = "localhost";
    private static final String DRDA_MSG_PREFIX = "DRDA_";
    private static final String DEFAULT_LOCALE = "en";
    private static final String DEFAULT_LOCALE_COUNTRY = "US";
    private static final int SHUTDOWN_CHECK_ATTEMPTS = 100;
    private static final int SHUTDOWN_CHECK_INTERVAL = 100;
    private static final int MAXREPLY = Short.MAX_VALUE;
    protected static String att_srvclsnm;
    protected static final String ATT_SRVNAM = "NetworkServerControl";
    protected static String att_extnam;
    protected static String att_srvrlslv;
    protected static String prdId;
    protected static byte[] prdIdBytes_;
    private static String buildNumber;
    private static String versionString;
    protected static final int CCSIDSBC = 1208;
    protected static final int CCSIDMBC = 1208;
    protected static final String DEFAULT_ENCODING = "UTF8";
    static final Charset DEFAULT_CHARSET;
    protected static final int DEFAULT_CCSID = 1208;
    protected static final byte SPACE_CHAR = 32;
    protected static final int[] MGR_LEVELS;
    protected PrintWriter logWriter;
    protected PrintWriter cloudscapeLogWriter;
    private static Driver cloudscapeDriver;
    private static final int ERRTYPE_SEVERE = 1;
    private static final int ERRTYPE_USER = 2;
    private static final int ERRTYPE_INFO = 3;
    private static final int ERRTYPE_UNKNOWN = -1;
    private Vector commandArgs = new Vector();
    private String databaseArg;
    private String userArg = null;
    private String passwordArg = null;
    private String bootPasswordArg;
    private String encAlgArg;
    private String encPrvArg;
    private String hostArg = "localhost";
    private InetAddress hostAddress;
    private int sessionArg;
    private boolean unsecureArg;
    private memCheck mc;
    private byte[] replyBuffer;
    private int replyBufferCount;
    private int replyBufferPos;
    private int portNumber = 1527;
    private String traceDirectory;
    private Object traceDirectorySync = new Object();
    private boolean traceAll;
    private Object traceAllSync = new Object();
    private Object serverStartSync = new Object();
    private boolean logConnections;
    private Object logConnectionsSync = new Object();
    private int minThreads;
    private int maxThreads;
    private Object threadsSync = new Object();
    private int timeSlice;
    private Object timeSliceSync = new Object();
    private boolean keepAlive = true;
    private int minPoolSize;
    private int maxPoolSize;
    private Object poolSync = new Object();
    protected boolean debugOutput = false;
    private boolean cleanupOnStart = false;
    private boolean restartFlag = false;
    protected static final int INVALID_OR_NOTSET_SECURITYMECHANISM = -1;
    private int allowOnlySecurityMechanism = -1;
    private Socket clientSocket = null;
    private InputStream clientIs = null;
    private OutputStream clientOs = null;
    private ByteArrayOutputStream byteArrayOs = new ByteArrayOutputStream();
    private DataOutputStream commandOs = new DataOutputStream(this.byteArrayOs);
    private Object shutdownSync = new Object();
    private boolean shutdown;
    private int connNum;
    private ServerSocket serverSocket;
    private NetworkServerControlImpl serverInstance;
    private LocalizedResource langUtil;
    public String clientLocale;
    ArrayList localAddresses;
    private Hashtable sessionTable = new Hashtable();
    private Session currentSession;
    private Vector threadList = new Vector();
    private Vector runQueue = new Vector();
    private int freeThreads;
    private Hashtable appRequesterTable = new Hashtable();
    private String propertyFileName;
    private NetworkServerControlImpl thisControl = this;
    private boolean shutdownDatabasesOnShutdown = false;
    private static final int SSL_OFF = 0;
    private static final int SSL_BASIC = 1;
    private static final int SSL_PEER_AUTHENTICATION = 2;
    private int sslMode = 0;
    private NetworkInterface.ConnectionListener connListener;
    protected static final int DEFAULT_RUNQUEUE_MAXWAIT = 30000;
    private int runQueueMaxWait = 30000;
    private static boolean SUPPORTS_EUSRIDPWD;

    public String getHost() {
        return this.hostArg;
    }

    public boolean runningUnsecure() {
        return this.unsecureArg;
    }

    public NetworkServerControlImpl() throws Exception {
        this.init();
        this.getPropertyInfo();
    }

    public NetworkServerControlImpl(InetAddress address, int portNumber) throws Exception {
        this();
        this.hostAddress = address;
        this.portNumber = portNumber <= 0 ? this.portNumber : portNumber;
        this.hostArg = address.getHostAddress();
    }

    public NetworkServerControlImpl(String userName, String password) throws Exception {
        this();
        this.userArg = userName;
        this.passwordArg = password;
    }

    public NetworkServerControlImpl(InetAddress address, int portNumber, String userName, String password) throws Exception {
        this(address, portNumber);
        this.userArg = userName;
        this.passwordArg = password;
    }

    private void init() throws Exception {
        this.langUtil = new LocalizedResource(null, null, DRDA_PROP_MESSAGES);
        this.serverInstance = this;
        ProductVersionHolder myPVH = this.getNetProductVersionHolder();
        att_extnam = "NetworkServerControl " + Thread.currentThread().getName();
        att_srvclsnm = myPVH.getProductName();
        versionString = myPVH.getVersionBuildString(true);
        String majorStr = String.valueOf(myPVH.getMajorVersion());
        String minorStr = String.valueOf(myPVH.getMinorVersion());
        String drdaMaintStr = String.valueOf(myPVH.getDrdaMaintVersion());
        prdId = "CSS";
        if (majorStr.length() == 1) {
            prdId = prdId + "0";
        }
        prdId = prdId + majorStr;
        if (minorStr.length() == 1) {
            prdId = prdId + "0";
        }
        prdId = prdId + minorStr;
        prdId = ResolverUtils.isUsingGFXD1302Hashing() ? prdId + drdaMaintStr : ("10".equals(majorStr) && "4".equals(minorStr) && "1".equals(drdaMaintStr) ? prdId + "0" : prdId + drdaMaintStr);
        att_srvrlslv = prdId + "/" + myPVH.getVersionBuildString(true);
        prdIdBytes_ = prdId.getBytes(DEFAULT_ENCODING);
        if (majorStr.length() > 2 || minorStr.length() > 2 || drdaMaintStr.length() > 1) {
            SanityManager.THROWASSERT((String)"version values out of expected range  for PRDID");
        }
        buildNumber = myPVH.getBuildNumber();
    }

    private PrintWriter makePrintWriter(OutputStream out) {
        if (out != null) {
            return new PrintWriter(out, true);
        }
        return null;
    }

    protected static Driver getDriver() {
        return cloudscapeDriver;
    }

    public void setLogWriter(PrintWriter outWriter) {
        this.logWriter = outWriter != null ? new PrintWriter((Writer)outWriter, true) : outWriter;
    }

    public void consoleError(String msg) throws Exception {
        this.consoleMessage(msg);
        throw new Exception(msg);
    }

    public void consoleExceptionPrint(Exception e) {
        if (this.debugOutput) {
            this.consoleExceptionPrintTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consoleExceptionPrintTrace(Throwable e) {
        PrintWriter printWriter;
        this.consoleMessage(e.getMessage());
        PrintWriter lw = this.logWriter;
        if (lw != null) {
            printWriter = lw;
            synchronized (printWriter) {
                e.printStackTrace(lw);
            }
        }
        if ((lw = this.cloudscapeLogWriter) != null) {
            printWriter = lw;
            synchronized (printWriter) {
                e.printStackTrace(lw);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consoleMessage(String msg) {
        PrintWriter printWriter;
        PrintWriter lw = this.logWriter;
        if (lw != null) {
            printWriter = lw;
            synchronized (printWriter) {
                lw.println(msg);
            }
        }
        if ((lw = this.cloudscapeLogWriter) != null) {
            printWriter = lw;
            synchronized (printWriter) {
                Monitor.logMessage(msg);
            }
        }
    }

    public void start(PrintWriter consoleWriter) throws Exception {
        DRDAServerStarter starter = new DRDAServerStarter();
        starter.setStartInfo(this.hostAddress, this.portNumber, consoleWriter);
        this.setLogWriter(consoleWriter);
        this.startNetworkServer();
        starter.boot(false, null);
    }

    private ServerSocket createServerSocket() throws IOException {
        if (this.hostAddress == null) {
            this.hostAddress = InetAddress.getByName(this.hostArg);
        }
        this.buildLocalAddressList(this.hostAddress);
        switch (this.getSSLMode()) {
            default: {
                ServerSocketFactory sf = ServerSocketFactory.getDefault();
                return sf.createServerSocket(this.portNumber, 0, this.hostAddress);
            }
            case 1: {
                SSLServerSocketFactory ssf = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
                return (SSLServerSocket)ssf.createServerSocket(this.portNumber, 0, this.hostAddress);
            }
            case 2: 
        }
        SSLServerSocketFactory ssf2 = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        SSLServerSocket sss2 = (SSLServerSocket)ssf2.createServerSocket(this.portNumber, 0, this.hostAddress);
        sss2.setNeedClientAuth(true);
        return sss2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockingStart(PrintWriter consoleWriter) throws Exception {
        block36: {
            this.startNetworkServer();
            this.setLogWriter(consoleWriter);
            this.cloudscapeLogWriter = Monitor.getStream().getPrintWriter();
            if (this.debugOutput) {
                memCheck.showmem();
                this.mc = new memCheck(200000);
                this.mc.start();
            }
            try {
                this.serverSocket = AccessController.doPrivileged(new PrivilegedExceptionAction<ServerSocket>(){

                    @Override
                    public ServerSocket run() throws IOException {
                        return NetworkServerControlImpl.this.createServerSocket();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception e1 = e.getException();
                if (e1 instanceof UnknownHostException) {
                    this.consolePropertyMessage("DRDA_UnknownHost.S", this.hostArg);
                }
                if (e1 instanceof IOException) {
                    this.consolePropertyMessage("DRDA_ListenPort.S", new String[]{Integer.toString(this.portNumber), this.hostArg, e1.toString()});
                }
                throw e1;
            }
            catch (Exception e) {
                this.throwUnexpectedException(e);
            }
            switch (this.getSSLMode()) {
                default: {
                    this.consolePropertyMessage("DRDA_Ready.I", new String[]{Integer.toString(this.portNumber), "SnappyData", versionString, this.getFormattedTimestamp()});
                    break;
                }
                case 1: {
                    this.consolePropertyMessage("DRDA_SSLReady.I", new String[]{Integer.toString(this.portNumber), "SnappyData", versionString, this.getFormattedTimestamp()});
                    break;
                }
                case 2: {
                    this.consolePropertyMessage("DRDA_SSLClientAuthReady.I", new String[]{Integer.toString(this.portNumber), "SnappyData", versionString, this.getFormattedTimestamp()});
                }
            }
            final ClientThread clientThread = (ClientThread)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new ClientThread(NetworkServerControlImpl.this.thisControl, NetworkServerControlImpl.this.serverSocket);
                }
            });
            clientThread.start();
            ManagementService mgmtService = (ManagementService)Monitor.getSystemModule("com.pivotal.gemfirexd.internal.iapi.services.jmx.ManagementService");
            Object versionMBean = mgmtService.registerMBean(new Version(this.getNetProductVersionHolder(), "server"), VersionMBean.class, "type=Version,jar=gemfirexd.jar");
            Object networkServerMBean = mgmtService.registerMBean(new NetworkServerMBeanImpl(this), NetworkServerMBean.class, "type=NetworkServer");
            Object object = this.shutdownSync;
            synchronized (object) {
                try {
                    this.shutdownSync.wait();
                }
                catch (InterruptedException e) {
                    this.shutdown = true;
                }
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (NetworkServerControlImpl.this.mc != null) {
                        NetworkServerControlImpl.this.mc.interrupt();
                    }
                    clientThread.interrupt();
                    return null;
                }
            });
            object = this.sessionTable;
            synchronized (object) {
                Enumeration e = this.sessionTable.elements();
                while (e.hasMoreElements()) {
                    Session session = (Session)e.nextElement();
                    try {
                        session.close();
                    }
                    catch (CancelException cancelException) {}
                }
            }
            object = this.threadsSync;
            synchronized (object) {
                for (int i = 0; i < this.threadList.size(); ++i) {
                    final DRDAConnThread threadi = (DRDAConnThread)this.threadList.get(i);
                    threadi.close();
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            threadi.interrupt();
                            return null;
                        }
                    });
                }
                this.threadList.clear();
            }
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                this.consolePropertyMessage("DRDA_ListenerClose.S");
            }
            Vector e = this.runQueue;
            synchronized (e) {
                this.runQueue.notifyAll();
            }
            mgmtService.unregisterMBean(versionMBean);
            mgmtService.unregisterMBean(networkServerMBean);
            if (this.shutdownDatabasesOnShutdown) {
                try {
                    if (cloudscapeDriver != null) {
                        Properties p = new Properties();
                        if (this.userArg != null) {
                            p.setProperty("user", this.userArg);
                        }
                        if (this.passwordArg != null) {
                            p.setProperty("password", this.passwordArg);
                        }
                        cloudscapeDriver.connect("jdbc:gemfirexd:;shutdown=true", p);
                    }
                }
                catch (SQLException sqle) {
                    String expectedState = StandardException.getSQLStateFromIdentifier("XJ015.M");
                    if (expectedState.equals(sqle.getSQLState())) break block36;
                    this.consolePropertyMessage("DRDA_ShutdownWarning.I", sqle.getMessage());
                }
            }
        }
        this.consolePropertyMessage("DRDA_ShutdownSuccess.I", new String[]{att_srvclsnm, versionString, this.getFormattedTimestamp()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"DM_GC"})
    protected void startNetworkServer() throws Exception {
        boolean restartCheck = this.restartFlag;
        Object object = this.serverStartSync;
        synchronized (object) {
            if (restartCheck == this.restartFlag) {
                try {
                    if (this.cleanupOnStart) {
                        Vector vector = this.runQueue;
                        synchronized (vector) {
                            for (int i = 0; i < this.runQueue.size(); ++i) {
                                Session s = (Session)this.runQueue.get(i);
                                s.close();
                                this.removeFromSessionTable(s.getConnNum());
                            }
                            this.runQueue.clear();
                        }
                        cloudscapeDriver = null;
                        System.gc();
                    }
                    Class.forName(CLOUDSCAPE_DRIVER).newInstance();
                    cloudscapeDriver = DriverManager.getDriver("jdbc:gemfirexd:");
                }
                catch (Exception e) {
                    this.consoleExceptionPrintTrace(e);
                    this.consolePropertyMessage("DRDA_LoadException.S", e.getMessage());
                }
                this.cleanupOnStart = true;
                this.restartFlag = !this.restartFlag;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Exception {
        int ntry;
        PrintWriter savWriter;
        try {
            this.setUpSocket();
            this.writeCommandHeader(1);
            this.writeLDString(this.userArg);
            this.writeLDString(this.passwordArg);
            this.send();
            this.readResult();
            savWriter = this.logWriter;
            FilterOutputStream silentStream = new FilterOutputStream(null){

                @Override
                public void write(int b) {
                }

                @Override
                public void flush() {
                }

                @Override
                public void close() {
                }
            };
            this.setLogWriter(new PrintWriter(silentStream));
            for (ntry = 0; ntry < 100; ++ntry) {
                Thread.sleep(100L);
                try {
                    this.pingWithNoOpen();
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
        }
        finally {
            this.closeSocket();
        }
        if (ntry == 100) {
            this.consolePropertyMessage("DRDA_ShutdownError.S", new String[]{Integer.toString(this.portNumber), this.hostArg});
        }
        this.logWriter = savWriter;
    }

    public void checkShutdownPrivileges() throws SQLException {
        Serializable finfo;
        AuthenticationService auth = (AuthenticationService)Monitor.findService("com.pivotal.gemfirexd.internal.iapi.jdbc.AuthenticationService", "authentication");
        if (auth != null) {
            String failure;
            finfo = new Properties();
            if (this.userArg != null) {
                ((Properties)finfo).setProperty("user", this.userArg);
            }
            if (this.passwordArg != null) {
                ((Properties)finfo).setProperty("password", this.passwordArg);
            }
            if ((failure = auth.authenticate(null, (Properties)finfo)) != null) {
                throw Util.generateCsSQLException("08004.C.1", MessageService.getTextMessage("A020", failure));
            }
        }
        if (System.getSecurityManager() == null) {
            return;
        }
        try {
            finfo = new SystemPermission("server", "shutdown");
        }
        catch (AccessControlException ace) {
            throw Util.generateCsSQLException("08004.C.9", (Object)this.userArg, (Object)ace);
        }
    }

    public void directShutdown() throws SQLException {
        this.checkShutdownPrivileges();
        this.directShutdownInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void directShutdownInternal() {
        this.shutdown = true;
        Object object = this.shutdownSync;
        synchronized (object) {
            this.shutdownSync.notifyAll();
        }
    }

    public boolean isServerStarted() throws Exception {
        try {
            this.ping();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping() throws Exception {
        try {
            this.setUpSocket();
            this.pingWithNoOpen();
        }
        finally {
            this.closeSocket();
        }
    }

    private void pingWithNoOpen() throws Exception {
        String database = null;
        String user = this.userArg;
        String password = this.passwordArg;
        this.writeCommandHeader(4);
        this.writeLDString(database);
        this.writeLDString(user);
        this.writeLDString(password);
        this.send();
        this.readResult();
    }

    public void trace(boolean on) throws Exception {
        this.trace(0, on);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(int connNum, boolean on) throws Exception {
        try {
            this.setUpSocket();
            this.writeCommandHeader(2);
            this.commandOs.writeInt(connNum);
            this.writeByte(on ? 1 : 0);
            this.send();
            this.readResult();
            this.consoleTraceMessage(connNum, on);
        }
        finally {
            this.closeSocket();
        }
    }

    private void consoleTraceMessage(int connNum, boolean on) throws Exception {
        if (connNum == 0) {
            this.consolePropertyMessage("DRDA_TraceChangeAll.I", on ? "DRDA_ON.I" : "DRDA_OFF.I");
        } else {
            String[] args = new String[]{on ? "DRDA_ON.I" : "DRDA_OFF.I", Integer.toString(connNum, 10)};
            this.consolePropertyMessage("DRDA_TraceChangeOne.I", args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logConnections(boolean on) throws Exception {
        try {
            this.setUpSocket();
            this.writeCommandHeader(5);
            this.writeByte(on ? 1 : 0);
            this.send();
            this.readResult();
        }
        finally {
            this.closeSocket();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSetTraceDirectory(String traceDirectory) throws Exception {
        try {
            this.setUpSocket();
            this.writeCommandHeader(3);
            this.writeLDString(traceDirectory);
            this.send();
            this.readResult();
        }
        finally {
            this.closeSocket();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sysinfo() throws Exception {
        try {
            this.setUpSocket();
            this.writeCommandHeader(6);
            this.send();
            String string = this.readStringReply("DRDA_SysInfoError.S");
            return string;
        }
        finally {
            this.closeSocket();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String runtimeInfo() throws Exception {
        try {
            this.setUpSocket();
            this.writeCommandHeader(7);
            this.send();
            String string = this.readStringReply("DRDA_RuntimeInfoError.S");
            return string;
        }
        finally {
            this.closeSocket();
        }
    }

    public void usage() {
        try {
            for (int i = 1; i <= 12; ++i) {
                this.consolePropertyMessage("DRDA_Usage" + i + ".I");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void netSetMaxThreads(int max) throws Exception {
        try {
            this.setUpSocket();
            this.writeCommandHeader(8);
            this.commandOs.writeInt(max);
            this.send();
            this.readResult();
            int newval = this.readInt();
            this.consolePropertyMessage("DRDA_MaxThreadsChange.I", Integer.toString(newval, 10));
        }
        finally {
            this.closeSocket();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void netSetTimeSlice(int timeslice) throws Exception {
        try {
            this.setUpSocket();
            this.writeCommandHeader(9);
            this.commandOs.writeInt(timeslice);
            this.send();
            this.readResult();
            int newval = this.readInt();
            this.consolePropertyMessage("DRDA_TimeSliceChange.I", Integer.toString(newval, 10));
        }
        finally {
            this.closeSocket();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getCurrentProperties() throws Exception {
        try {
            this.setUpSocket();
            this.writeCommandHeader(10);
            this.send();
            byte[] val = this.readBytesReply("DRDA_PropertyError.S");
            Properties p = new Properties();
            try {
                ByteArrayInputStream bs = new ByteArrayInputStream(val);
                p.load(bs);
            }
            catch (IOException io) {
                this.consolePropertyMessage("DRDA_IOException.S", io.getMessage());
            }
            Properties properties = p;
            return properties;
        }
        finally {
            this.closeSocket();
        }
    }

    public static void setUniqueThreadName(Thread thrd, String newName) {
        if (thrd.getName().indexOf("Thread-") == -1) {
            return;
        }
        String oldName = thrd.getName();
        thrd.setName(newName + "_" + oldName.substring(oldName.indexOf("-") + 1, oldName.length()));
    }

    protected void removeFromSessionTable(int sessionid) {
        Session session = (Session)this.sessionTable.remove(sessionid);
        if (this.connListener != null) {
            this.connListener.connectionClosed(session.clientSocket, sessionid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void processCommands(DDMReader reader, DDMWriter writer, Session session) throws Throwable {
        try {
            String protocolStr = reader.readCmdString(4);
            String locale = DEFAULT_LOCALE;
            String codeset = null;
            int version = reader.readNetworkShort();
            if (version <= 0) throw new Throwable(this.langUtil.getTextMessage("DRDA_UnknownProtocol.S", new Integer(version).toString()));
            if (version > 2) {
                throw new Throwable(this.langUtil.getTextMessage("DRDA_UnknownProtocol.S", new Integer(version).toString()));
            }
            byte localeLen = reader.readByte();
            if (localeLen > 0) {
                this.currentSession = session;
                locale = reader.readCmdString(localeLen);
                session.langUtil = new LocalizedResource(codeset, locale, DRDA_PROP_MESSAGES);
            }
            String notLocalMessage = null;
            byte codesetLen = reader.readByte();
            byte command = reader.readByte();
            if (command != 4) {
                try {
                    this.checkAddressIsLocal(session.clientSocket.getInetAddress());
                }
                catch (Exception e) {
                    notLocalMessage = e.getMessage();
                }
            }
            if (notLocalMessage != null) {
                this.sendMessage(writer, 2, notLocalMessage);
                session.langUtil = null;
                this.currentSession = null;
                return;
            }
            switch (command) {
                case 1: {
                    this.userArg = reader.readCmdString();
                    this.passwordArg = reader.readCmdString();
                    try {
                        this.checkShutdownPrivileges();
                        this.sendOK(writer);
                        this.directShutdownInternal();
                        return;
                    }
                    catch (SQLException sqle) {
                        this.sendSQLMessage(writer, sqle, 3);
                        this.consolePropertyMessage("DRDA_ShutdownWarning.I", sqle.getMessage());
                        return;
                    }
                }
                case 2: {
                    boolean on;
                    this.sessionArg = reader.readNetworkInt();
                    boolean bl = on = reader.readByte() == 1;
                    if (this.setTrace(on)) {
                        this.sendOK(writer);
                        return;
                    }
                    if (this.sessionArg == 0) {
                        this.sendMessage(writer, 2, this.localizeMessage("DRDA_ErrorStartingTracing.S", null));
                        return;
                    }
                    this.sendMessage(writer, 2, this.localizeMessage("DRDA_SessionNotFound.U", session.langUtil == null ? this.langUtil : session.langUtil, new String[]{Integer.toString(this.sessionArg, 10)}));
                    return;
                }
                case 3: {
                    this.setTraceDirectory(reader.readCmdString());
                    this.sendOK(writer);
                    this.consolePropertyMessage("DRDA_TraceDirectoryChange.I", this.traceDirectory);
                    return;
                }
                case 4: {
                    this.databaseArg = reader.readCmdString();
                    this.userArg = reader.readCmdString();
                    this.passwordArg = reader.readCmdString();
                    if (this.databaseArg != null) {
                        this.connectToDatabase(writer, this.databaseArg, this.userArg, this.passwordArg);
                        return;
                    }
                    this.sendOK(writer);
                    return;
                }
                case 5: {
                    boolean log = reader.readByte() == 1;
                    this.setLogConnections(log);
                    this.sendOK(writer);
                    this.consolePropertyMessage("DRDA_LogConnectionsChange.I", log ? "DRDA_ON.I" : "DRDA_OFF.I");
                    return;
                }
                case 6: {
                    this.sendSysInfo(writer);
                    return;
                }
                case 10: {
                    this.sendPropInfo(writer);
                    return;
                }
                case 7: {
                    this.sendRuntimeInfo(writer);
                    return;
                }
                case 8: {
                    int max = reader.readNetworkInt();
                    try {
                        this.setMaxThreads(max);
                    }
                    catch (Exception e) {
                        this.sendMessage(writer, 2, e.getMessage());
                        session.langUtil = null;
                        this.currentSession = null;
                        return;
                    }
                    int newval = this.getMaxThreads();
                    this.sendOKInt(writer, newval);
                    this.consolePropertyMessage("DRDA_MaxThreadsChange.I", Integer.toString(newval, 10));
                    return;
                }
                case 9: {
                    int timeslice = reader.readNetworkInt();
                    try {
                        this.setTimeSlice(timeslice);
                    }
                    catch (Exception e) {
                        this.sendMessage(writer, 2, e.getMessage());
                        session.langUtil = null;
                        this.currentSession = null;
                        return;
                    }
                    int newval = this.getTimeSlice();
                    this.sendOKInt(writer, newval);
                    this.consolePropertyMessage("DRDA_TimeSliceChange.I", Integer.toString(newval, 10));
                    return;
                }
            }
            return;
        }
        catch (DRDAProtocolException e) {
            this.consoleExceptionPrintTrace(e);
            return;
        }
        catch (Exception e) {
            this.consoleExceptionPrintTrace(e);
            return;
        }
        finally {
            session.langUtil = null;
            this.currentSession = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session getNextSession(Session currentSession) {
        Session retval = null;
        long start = -1L;
        if (this.shutdown) {
            return retval;
        }
        Vector vector = this.runQueue;
        synchronized (vector) {
            try {
                if (this.runQueue.size() == 0) {
                    if (currentSession == null) {
                        while (this.runQueue.size() == 0) {
                            if (start == -1L) {
                                start = System.currentTimeMillis();
                            } else if (System.currentTimeMillis() - start >= (long)this.runQueueMaxWait) {
                                return null;
                            }
                            ++this.freeThreads;
                            this.runQueue.wait(this.runQueueMaxWait);
                            if (this.shutdown) {
                                return null;
                            }
                            --this.freeThreads;
                        }
                    } else {
                        return currentSession;
                    }
                }
                retval = (Session)this.runQueue.elementAt(0);
                this.runQueue.removeElementAt(0);
                if (currentSession != null) {
                    this.runQueueAdd(currentSession);
                }
            }
            catch (InterruptedException e) {
                --this.freeThreads;
            }
        }
        return retval;
    }

    protected AppRequester getAppRequester(AppRequester appRequester) {
        AppRequester s = null;
        if (appRequester == null) {
            SanityManager.THROWASSERT((String)"null appRequester in getAppRequester");
        }
        if (!this.appRequesterTable.isEmpty()) {
            s = (AppRequester)this.appRequesterTable.get(appRequester.prdid);
        }
        if (s == null) {
            this.appRequesterTable.put(appRequester.prdid, appRequester);
            return appRequester;
        }
        if (s.equals(appRequester)) {
            return s;
        }
        return appRequester;
    }

    protected int getManagerLevel(int manager) {
        int mindex = CodePoint.getManagerIndex(manager);
        if (mindex == -1) {
            SanityManager.THROWASSERT((String)"manager out of bounds");
        }
        return MGR_LEVELS[mindex];
    }

    protected boolean supportsCCSID(int ccsid) {
        try {
            CharacterEncodings.getJavaEncoding(ccsid);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected void consolePropertyMessage(String msgProp) throws Exception {
        this.consolePropertyMessageWork(msgProp, null);
    }

    protected void consolePropertyMessage(String msgProp, String arg) throws Exception {
        this.consolePropertyMessageWork(msgProp, new String[]{arg});
    }

    protected void consolePropertyMessage(String msgProp, String[] args) throws Exception {
        this.consolePropertyMessageWork(msgProp, args);
    }

    protected static boolean isCmd(String val) {
        return val.equals(COMMAND_HEADER);
    }

    private void writeCommandReplyHeader(DDMWriter writer) throws Exception {
        writer.setCMDProtocol();
        writer.writeString(REPLY_HEADER);
    }

    private void sendOK(DDMWriter writer) throws Exception {
        this.writeCommandReplyHeader(writer);
        writer.writeByte(0);
        writer.flush();
    }

    private void sendOKInt(DDMWriter writer, int val) throws Exception {
        this.writeCommandReplyHeader(writer);
        writer.writeByte(0);
        writer.writeNetworkInt(val);
        writer.flush();
    }

    private void sendMessage(DDMWriter writer, int messageType, String message) throws Exception {
        this.writeCommandReplyHeader(writer);
        writer.writeByte(messageType);
        writer.writeLDString(message);
        writer.flush();
    }

    private void sendSQLMessage(DDMWriter writer, SQLException se, int type) throws Exception {
        StringBuilder locMsg = new StringBuilder();
        while (se != null) {
            if (this.currentSession != null && this.currentSession.langUtil != null && se instanceof DerbySQLException) {
                locMsg.append(se.getSQLState() + ":" + MessageService.getLocalizedMessage(this.currentSession.langUtil.getLocale(), ((DerbySQLException)((Object)se)).getMessageId(), ((DerbySQLException)((Object)se)).getArguments()));
            } else {
                locMsg.append(se.getSQLState() + ":" + se.getMessage());
            }
            if ((se = se.getNextException()) == null) continue;
            locMsg.append("\n");
        }
        this.sendMessage(writer, type, locMsg.toString());
    }

    private void sendSysInfo(DDMWriter writer) throws Exception {
        StringBuilder sysinfo2 = new StringBuilder();
        sysinfo2.append(this.getNetSysInfo());
        sysinfo2.append(this.getCLSSysInfo());
        try {
            this.writeCommandReplyHeader(writer);
            writer.writeByte(0);
            writer.writeLDString(sysinfo2.toString());
        }
        catch (DRDAProtocolException e) {
            this.consolePropertyMessage("DRDA_SysInfoWriteError.S", e.getMessage());
        }
        writer.flush();
    }

    private void sendRuntimeInfo(DDMWriter writer) throws Exception {
        try {
            this.writeCommandReplyHeader(writer);
            writer.writeByte(0);
            writer.writeLDString(this.getRuntimeInfo());
        }
        catch (DRDAProtocolException e) {
            this.consolePropertyMessage("DRDA_SysInfoWriteError.S", e.getMessage());
        }
        writer.flush();
    }

    private void sendPropInfo(DDMWriter writer) throws Exception {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Properties p = this.getPropertyValues();
            p.store(out, "NetworkServerControl properties");
            try {
                this.writeCommandReplyHeader(writer);
                writer.writeByte(0);
                writer.writeLDBytes(out.toByteArray());
            }
            catch (DRDAProtocolException e) {
                this.consolePropertyMessage("DRDA_PropInfoWriteError.S", e.getMessage());
            }
            writer.flush();
        }
        catch (Exception e) {
            this.consoleExceptionPrintTrace(e);
        }
    }

    private String getNetSysInfo() {
        StringBuilder sysinfo2 = new StringBuilder();
        LocalizedResource localLangUtil = this.langUtil;
        if (this.currentSession != null && this.currentSession.langUtil != null) {
            localLangUtil = this.currentSession.langUtil;
        }
        sysinfo2.append(localLangUtil.getTextMessage("DRDA_SysInfoBanner.I") + "\n");
        sysinfo2.append(localLangUtil.getTextMessage("DRDA_SysInfoVersion.I") + " " + att_srvrlslv);
        sysinfo2.append("  ");
        sysinfo2.append(localLangUtil.getTextMessage("DRDA_SysInfoBuild.I") + " " + buildNumber);
        sysinfo2.append("  ");
        sysinfo2.append(localLangUtil.getTextMessage("DRDA_SysInfoDrdaPRDID.I") + " " + prdId);
        sysinfo2.append("  ** SANE BUILD **");
        sysinfo2.append("\n");
        Properties p = this.getPropertyValues();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        p.list(ps);
        sysinfo2.append(bos.toString());
        return sysinfo2.toString();
    }

    private String getRuntimeInfo() {
        return this.buildRuntimeInfo(this.langUtil);
    }

    private String getCLSSysInfo() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        LocalizedResource localLangUtil = this.langUtil;
        if (this.currentSession != null && this.currentSession.langUtil != null) {
            localLangUtil = this.currentSession.langUtil;
        }
        LocalizedOutput aw = localLangUtil.getNewOutput(bos);
        Main.getMainInfo(aw, false);
        return bos.toString();
    }

    public int parseArgs(String[] args) throws Exception {
        this.logWriter = this.makePrintWriter(System.out);
        int command = this.findCommand(args);
        if (command == -1) {
            this.consolePropertyMessage("DRDA_NoCommand.U");
        }
        return command;
    }

    public void executeWork(int command) throws Exception {
        if (command == -1) {
            return;
        }
        if (this.commandArgs.size() != COMMAND_ARGS[command]) {
            this.consolePropertyMessage("DRDA_InvalidNoArgs.U", COMMANDS[command]);
        }
        switch (command) {
            case 0: {
                this.shutdownDatabasesOnShutdown = true;
                this.blockingStart(this.makePrintWriter(System.out));
                break;
            }
            case 1: {
                this.shutdown();
                this.consolePropertyMessage("DRDA_ShutdownSuccess.I", new String[]{att_srvclsnm, versionString, this.getFormattedTimestamp()});
                break;
            }
            case 2: {
                boolean on = this.isOn((String)this.commandArgs.elementAt(0));
                this.trace(this.sessionArg, on);
                this.consoleTraceMessage(this.sessionArg, on);
                break;
            }
            case 3: {
                String directory = (String)this.commandArgs.elementAt(0);
                this.sendSetTraceDirectory(directory);
                this.consolePropertyMessage("DRDA_TraceDirectoryChange.I", directory);
                break;
            }
            case 4: {
                this.ping();
                this.consolePropertyMessage("DRDA_ConnectionTested.I", new String[]{this.hostArg, Integer.toString(this.portNumber, 10)});
                break;
            }
            case 5: {
                boolean on = this.isOn((String)this.commandArgs.elementAt(0));
                this.logConnections(on);
                this.consolePropertyMessage("DRDA_LogConnectionsChange.I", on ? "DRDA_ON.I" : "DRDA_OFF.I");
                break;
            }
            case 6: {
                String info = this.sysinfo();
                this.consoleMessage(info);
                break;
            }
            case 8: {
                int max = 0;
                try {
                    max = Integer.parseInt((String)this.commandArgs.elementAt(0));
                }
                catch (NumberFormatException e) {
                    this.consolePropertyMessage("DRDA_InvalidValue.U", new String[]{(String)this.commandArgs.elementAt(0), "maxthreads"});
                }
                if (max < -1) {
                    this.consolePropertyMessage("DRDA_InvalidValue.U", new String[]{Integer.toString(max, 10), "maxthreads"});
                }
                this.netSetMaxThreads(max);
                break;
            }
            case 7: {
                String reply = this.runtimeInfo();
                this.consoleMessage(reply);
                break;
            }
            case 9: {
                int timeslice = 0;
                String timeSliceArg = (String)this.commandArgs.elementAt(0);
                try {
                    timeslice = Integer.parseInt(timeSliceArg);
                }
                catch (NumberFormatException e) {
                    this.consolePropertyMessage("DRDA_InvalidValue.U", new String[]{(String)this.commandArgs.elementAt(0), "timeslice"});
                }
                if (timeslice < -1) {
                    this.consolePropertyMessage("DRDA_InvalidValue.U", new String[]{Integer.toString(timeslice, 10), "timeslice"});
                }
                this.netSetTimeSlice(timeslice);
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("Invalid command in switch:" + command));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runQueueAdd(Session clientSession) {
        Vector vector = this.runQueue;
        synchronized (vector) {
            this.runQueue.addElement(clientSession);
            this.runQueue.notify();
        }
    }

    private int findCommand(String[] args) throws Exception {
        block7: {
            try {
                int i = 0;
                int newpos = 0;
                while (i < args.length) {
                    if (args[i].startsWith("-")) {
                        newpos = this.processDashArg(i, args);
                        if (newpos == i) {
                            this.commandArgs.addElement(args[i++]);
                            continue;
                        }
                        i = newpos;
                        continue;
                    }
                    this.commandArgs.addElement(args[i++]);
                }
                if (this.commandArgs.size() > 0) {
                    for (i = 0; i < COMMANDS.length; ++i) {
                        if (!StringUtil.SQLEqualsIgnoreCase(COMMANDS[i], (String)this.commandArgs.firstElement())) continue;
                        this.commandArgs.removeElementAt(0);
                        return i;
                    }
                    this.consolePropertyMessage("DRDA_UnknownCommand.U", (String)this.commandArgs.firstElement());
                }
            }
            catch (Exception e) {
                if (!e.getMessage().equals(UNEXPECTED_ERR)) break block7;
                throw e;
            }
        }
        return -1;
    }

    private int processDashArg(int pos, String[] args) throws Exception {
        char c = args[pos].charAt(1);
        if (c >= '0' && c <= '9') {
            return pos;
        }
        int dashArg = -1;
        for (int i = 0; i < DASHARGS.length; ++i) {
            if (!DASHARGS[i].equals(args[pos].substring(1))) continue;
            dashArg = i;
            if (dashArg == 10) break;
            ++pos;
            break;
        }
        if (dashArg == -1) {
            this.consolePropertyMessage("DRDA_UnknownArgument.U", args[pos]);
        }
        switch (dashArg) {
            case 0: {
                if (pos < args.length) {
                    try {
                        this.portNumber = Integer.parseInt(args[pos]);
                    }
                    catch (NumberFormatException e) {
                        this.consolePropertyMessage("DRDA_InvalidValue.U", new String[]{args[pos], "DRDA_PortNumber.I"});
                    }
                    break;
                }
                this.consolePropertyMessage("DRDA_MissingValue.U", "DRDA_PortNumber.I");
                break;
            }
            case 8: {
                if (pos < args.length) {
                    this.hostArg = args[pos];
                    break;
                }
                this.consolePropertyMessage("DRDA_MissingValue.U", "DRDA_Host.I");
                break;
            }
            case 1: {
                if (pos < args.length) {
                    this.databaseArg = args[pos];
                    break;
                }
                this.consolePropertyMessage("DRDA_MissingValue.U", "DRDA_DatabaseDirectory.I");
                break;
            }
            case 2: {
                if (pos < args.length) {
                    this.userArg = args[pos];
                    break;
                }
                this.consolePropertyMessage("DRDA_MissingValue.U", "DRDA_User.I");
                break;
            }
            case 3: {
                if (pos < args.length) {
                    this.passwordArg = args[pos];
                    break;
                }
                this.consolePropertyMessage("DRDA_MissingValue.U", "DRDA_Password.I");
                break;
            }
            case 5: {
                if (pos < args.length) {
                    this.encAlgArg = args[pos];
                    break;
                }
                this.consolePropertyMessage("DRDA_MissingValue.U", "DRDA_EncryptionAlgorithm.I");
                break;
            }
            case 6: {
                if (pos < args.length) {
                    this.encPrvArg = args[pos];
                    break;
                }
                this.consolePropertyMessage("DRDA_MissingValue.U", "DRDA_EncryptionProvider.I");
                break;
            }
            case 4: {
                break;
            }
            case 9: {
                if (pos < args.length) {
                    try {
                        this.sessionArg = Integer.parseInt(args[pos]);
                    }
                    catch (NumberFormatException e) {
                        this.consolePropertyMessage("DRDA_InvalidValue.U", new String[]{args[pos], "DRDA_Session.I"});
                    }
                    break;
                }
                this.consolePropertyMessage("DRDA_MissingValue.U", "DRDA_Session.I");
                break;
            }
            case 10: {
                this.unsecureArg = true;
                break;
            }
            case 11: {
                if (pos < args.length) {
                    this.setSSLMode(this.getSSLModeValue(args[pos]));
                    break;
                }
                this.setSSLMode(0);
                break;
            }
        }
        return pos + 1;
    }

    private boolean isOn(String arg) throws Exception {
        if (StringUtil.SQLEqualsIgnoreCase(arg, "on")) {
            return true;
        }
        if (!StringUtil.SQLEqualsIgnoreCase(arg, "off")) {
            this.consolePropertyMessage("DRDA_OnOffValue.U", arg);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocket() throws IOException {
        try {
            if (this.clientIs != null) {
                this.clientIs.close();
            }
            if (this.clientOs != null) {
                this.clientOs.close();
            }
            if (this.clientSocket != null) {
                this.clientSocket.close();
            }
        }
        finally {
            this.clientIs = null;
            this.clientOs = null;
            this.clientSocket = null;
        }
    }

    private void setUpSocket() throws Exception {
        try {
            this.clientSocket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException, IOException, NoSuchAlgorithmException, KeyManagementException, NoSuchProviderException, KeyStoreException, UnrecoverableKeyException, CertificateException {
                    if (NetworkServerControlImpl.this.hostAddress == null) {
                        NetworkServerControlImpl.this.hostAddress = InetAddress.getByName(NetworkServerControlImpl.this.hostArg);
                    }
                    switch (NetworkServerControlImpl.this.getSSLMode()) {
                        case 1: {
                            SSLSocket s1 = (SSLSocket)NaiveTrustManager.getSocketFactory().createSocket(NetworkServerControlImpl.this.hostAddress, NetworkServerControlImpl.this.portNumber);
                            s1.startHandshake();
                            return s1;
                        }
                        case 2: {
                            SSLSocket s2 = (SSLSocket)SSLSocketFactory.getDefault().createSocket(NetworkServerControlImpl.this.hostAddress, NetworkServerControlImpl.this.portNumber);
                            s2.startHandshake();
                            return s2;
                        }
                    }
                    return SocketFactory.getDefault().createSocket(NetworkServerControlImpl.this.hostAddress, NetworkServerControlImpl.this.portNumber);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e1 = pae.getException();
            if (e1 instanceof UnknownHostException) {
                this.consolePropertyMessage("DRDA_UnknownHost.S", this.hostArg);
            } else if (e1 instanceof IOException) {
                this.consolePropertyMessage("DRDA_NoIO.S", new String[]{this.hostArg, Integer.toString(this.portNumber, 10), e1.getMessage()});
            }
        }
        catch (Exception e) {
            this.throwUnexpectedException(e);
        }
        try {
            this.clientIs = this.clientSocket.getInputStream();
            this.clientOs = this.clientSocket.getOutputStream();
        }
        catch (IOException e) {
            this.consolePropertyMessage("DRDA_NoInputStream.I");
            throw e;
        }
    }

    private void checkAddressIsLocal(InetAddress inetAddr) throws UnknownHostException, Exception {
        for (int i = 0; i < this.localAddresses.size(); ++i) {
            if (!inetAddr.equals((InetAddress)this.localAddresses.get(i))) continue;
            return;
        }
        this.consolePropertyMessage("DRDA_NeedLocalHost.S", new String[]{inetAddr.getHostName(), this.serverSocket.getInetAddress().getHostName()});
    }

    private void buildLocalAddressList(InetAddress bindAddr) {
        this.localAddresses = new ArrayList(3);
        this.localAddresses.add(bindAddr);
        try {
            this.localAddresses.add(ClientSharedUtils.getLocalHost());
            this.localAddresses.add(InetAddress.getByName(DEFAULT_HOST));
        }
        catch (UnknownHostException uhe) {
            try {
                this.consolePropertyMessage("DRDA_UnknownHostWarning.I", uhe.getMessage());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void writeCommandHeader(int command) throws Exception {
        try {
            this.writeString(COMMAND_HEADER);
            this.commandOs.writeByte(0);
            this.commandOs.writeByte(2);
            if (this.clientLocale != null && this.clientLocale != DEFAULT_LOCALE) {
                this.commandOs.writeByte(this.clientLocale.length());
                this.commandOs.writeBytes(this.clientLocale);
            } else {
                this.commandOs.writeByte(0);
            }
            this.commandOs.writeByte(0);
            this.commandOs.writeByte((byte)command);
        }
        catch (IOException e) {
            this.clientSocketError(e);
        }
    }

    private void writeLDString(String msg) throws Exception {
        try {
            if (msg == null) {
                this.commandOs.writeShort(0);
            } else {
                this.commandOs.writeShort(msg.length());
                this.writeString(msg);
            }
        }
        catch (IOException e) {
            this.clientSocketError(e);
        }
    }

    protected void writeString(String msg) throws Exception {
        byte[] msgBytes = msg.getBytes(DEFAULT_ENCODING);
        this.commandOs.write(msgBytes, 0, msgBytes.length);
    }

    private void writeShort(int value) throws Exception {
        try {
            this.commandOs.writeByte((byte)((value & 0xF0) >> 8));
            this.commandOs.writeByte((byte)(value & 0xF));
        }
        catch (IOException e) {
            this.clientSocketError(e);
        }
    }

    private void writeByte(int value) throws Exception {
        try {
            this.commandOs.writeByte((byte)(value & 0xF));
        }
        catch (IOException e) {
            this.clientSocketError(e);
        }
    }

    private void send() throws Exception {
        try {
            this.byteArrayOs.writeTo(this.clientOs);
            this.commandOs.flush();
            this.byteArrayOs.reset();
        }
        catch (IOException e) {
            this.clientSocketError(e);
        }
    }

    private void clientSocketError(IOException e) throws IOException {
        try {
            this.consolePropertyMessage("DRDA_ClientSocketError.S", e.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.consoleExceptionPrintTrace(e);
        throw e;
    }

    private void readResult() throws Exception {
        int messageType;
        this.fillReplyBuffer();
        this.readCommandReplyHeader();
        if (this.replyBufferPos >= this.replyBufferCount) {
            this.consolePropertyMessage("DRDA_InvalidReplyTooShort.S");
        }
        if ((messageType = this.replyBuffer[this.replyBufferPos++] & 0xFF) == 0) {
            return;
        }
        String message = this.readLDString();
        if (messageType == 3) {
            this.wrapSQLError(message);
        } else if (messageType == 4) {
            this.wrapSQLWarning(message);
        } else {
            this.consolePropertyMessage(message);
        }
    }

    private void ensureDataInBuffer(int minimumBytesNeeded) throws Exception {
        while (this.replyBufferCount - this.replyBufferPos < minimumBytesNeeded) {
            try {
                int bytesRead = this.clientIs.read(this.replyBuffer, this.replyBufferCount, this.replyBuffer.length - this.replyBufferCount);
                this.replyBufferCount += bytesRead;
            }
            catch (IOException e) {
                this.clientSocketError(e);
            }
        }
    }

    private void fillReplyBuffer() throws Exception {
        if (this.replyBuffer == null) {
            this.replyBuffer = new byte[Short.MAX_VALUE];
        }
        try {
            this.replyBufferCount = this.clientIs.read(this.replyBuffer);
        }
        catch (IOException e) {
            this.clientSocketError(e);
        }
        if (this.replyBufferCount == -1) {
            this.consolePropertyMessage("DRDA_InvalidReplyTooShort.S");
        }
        this.replyBufferPos = 0;
    }

    private void readCommandReplyHeader() throws Exception {
        String header;
        this.ensureDataInBuffer(REPLY_HEADER_LENGTH);
        if (this.replyBufferCount < REPLY_HEADER_LENGTH) {
            this.consolePropertyMessage("DRDA_InvalidReplyHeader1.S", Integer.toString(this.replyBufferCount));
        }
        if (!(header = new String(this.replyBuffer, 0, REPLY_HEADER_LENGTH, DEFAULT_ENCODING)).equals(REPLY_HEADER)) {
            this.consolePropertyMessage("DRDA_InvalidReplyHeader2.S", header);
        }
        this.replyBufferPos += REPLY_HEADER_LENGTH;
    }

    private int readShort() throws Exception {
        this.ensureDataInBuffer(2);
        if (this.replyBufferPos + 2 > this.replyBufferCount) {
            this.consolePropertyMessage("DRDA_InvalidReplyTooShort.S");
        }
        return ((this.replyBuffer[this.replyBufferPos++] & 0xFF) << 8) + (this.replyBuffer[this.replyBufferPos++] & 0xFF);
    }

    private int readInt() throws Exception {
        this.ensureDataInBuffer(4);
        if (this.replyBufferPos + 4 > this.replyBufferCount) {
            this.consolePropertyMessage("DRDA_InvalidReplyTooShort.S");
        }
        return ((this.replyBuffer[this.replyBufferPos++] & 0xFF) << 24) + ((this.replyBuffer[this.replyBufferPos++] & 0xFF) << 16) + ((this.replyBuffer[this.replyBufferPos++] & 0xFF) << 8) + (this.replyBuffer[this.replyBufferPos++] & 0xFF);
    }

    private String readStringReply(String msgKey) throws Exception {
        this.fillReplyBuffer();
        this.readCommandReplyHeader();
        if (this.replyBuffer[this.replyBufferPos++] == 0) {
            return this.readLDString();
        }
        this.consolePropertyMessage(msgKey);
        return null;
    }

    private String readLDString() throws Exception {
        int strlen = this.readShort();
        this.ensureDataInBuffer(strlen);
        if (this.replyBufferPos + strlen > this.replyBufferCount) {
            this.consolePropertyMessage("DRDA_InvalidReplyTooShort.S");
        }
        String retval = new String(this.replyBuffer, this.replyBufferPos, strlen, DEFAULT_ENCODING);
        this.replyBufferPos += strlen;
        return retval;
    }

    private byte[] readBytesReply(String msgKey) throws Exception {
        this.fillReplyBuffer();
        this.readCommandReplyHeader();
        if (this.replyBuffer[this.replyBufferPos++] == 0) {
            return this.readLDBytes();
        }
        this.consolePropertyMessage(msgKey);
        return null;
    }

    private byte[] readLDBytes() throws Exception {
        int len = this.readShort();
        this.ensureDataInBuffer(len);
        if (this.replyBufferPos + len > this.replyBufferCount) {
            this.consolePropertyMessage("DRDA_InvalidReplyTooShort.S");
        }
        byte[] retval = new byte[len];
        for (int i = 0; i < len; ++i) {
            retval[i] = this.replyBuffer[this.replyBufferPos++];
        }
        return retval;
    }

    private void getPropertyInfo() throws Exception {
        String directory = PropertyUtil.getSystemProperty("gemfirexd.system.home");
        String propval = PropertyUtil.getSystemProperty("gemfirexd.drda.logConnections");
        if (propval != null && StringUtil.SQLEqualsIgnoreCase(propval, "true")) {
            this.setLogConnections(true);
        }
        if ((propval = PropertyUtil.getSystemProperty("gemfirexd.drda.traceAll")) != null && StringUtil.SQLEqualsIgnoreCase(propval, "true")) {
            this.setTraceAll(true);
        }
        if ((propval = PropertyUtil.getSystemProperty("gemfirexd.drda.traceDirectory", directory)) != null) {
            if (propval.equals("")) {
                propval = directory;
            }
            this.setTraceDirectory(propval);
        }
        if ((propval = PropertyUtil.getSystemProperty("gemfirexd.drda.minThreads")) != null) {
            if (propval.equals("")) {
                propval = "0";
            }
            this.setMinThreads(this.getIntPropVal("gemfirexd.drda.minThreads", propval));
        }
        if ((propval = PropertyUtil.getSystemProperty("gemfirexd.drda.maxThreads")) != null) {
            if (propval.equals("")) {
                propval = "0";
            }
            this.setMaxThreads(this.getIntPropVal("gemfirexd.drda.maxThreads", propval));
        }
        if ((propval = PropertyUtil.getSystemProperty("gemfirexd.drda.timeSlice")) != null) {
            if (propval.equals("")) {
                propval = "0";
            }
            this.setTimeSlice(this.getIntPropVal("gemfirexd.drda.timeSlice", propval));
        }
        if ((propval = PropertyUtil.getSystemProperty("gemfirexd.drda.maxIdleTime")) != null) {
            this.runQueueMaxWait = propval.length() == 0 ? 30000 : this.getIntPropVal("gemfirexd.drda.maxIdleTime", propval);
        }
        if ((propval = PropertyUtil.getSystemProperty("gemfirexd.drda.portNumber")) != null) {
            if (propval.equals("")) {
                propval = String.valueOf(1527);
            }
            this.portNumber = this.getIntPropVal("gemfirexd.drda.portNumber", propval);
        }
        propval = PropertyUtil.getSystemProperty("gemfirexd.drda.sslMode");
        this.setSSLMode(this.getSSLModeValue(propval));
        propval = PropertyUtil.getSystemProperty("gemfirexd.drda.keepAlive");
        if (propval != null && StringUtil.SQLEqualsIgnoreCase(propval, "false")) {
            this.keepAlive = false;
        }
        if ((propval = PropertyUtil.getSystemProperty("gemfirexd.drda.host")) != null) {
            this.hostArg = propval.equals("") ? DEFAULT_HOST : propval;
        }
        if ((propval = PropertyUtil.getSystemProperty(DRDA_PROP_DEBUG)) != null && StringUtil.SQLEqualsIgnoreCase(propval, "true")) {
            this.debugOutput = true;
        }
        if ((propval = PropertyUtil.getSystemProperty("gemfirexd.drda.securityMechanism")) != null) {
            this.setSecurityMechanism(propval);
        }
    }

    private int getSecMecValue(String s) {
        int secmec = -1;
        if (StringUtil.SQLEqualsIgnoreCase(s, "USER_ONLY_SECURITY")) {
            secmec = 4;
        } else if (StringUtil.SQLEqualsIgnoreCase(s, "CLEAR_TEXT_PASSWORD_SECURITY")) {
            secmec = 3;
        } else if (StringUtil.SQLEqualsIgnoreCase(s, "ENCRYPTED_USER_AND_PASSWORD_SECURITY")) {
            secmec = 9;
        } else if (StringUtil.SQLEqualsIgnoreCase(s, "STRONG_PASSWORD_SUBSTITUTE_SECURITY")) {
            secmec = 8;
        }
        return secmec;
    }

    private String getStringValueForSecMec(int secmecVal) {
        switch (secmecVal) {
            case 4: {
                return "USER_ONLY_SECURITY";
            }
            case 3: {
                return "CLEAR_TEXT_PASSWORD_SECURITY";
            }
            case 9: {
                return "ENCRYPTED_USER_AND_PASSWORD_SECURITY";
            }
            case 8: {
                return "STRONG_PASSWORD_SUBSTITUTE_SECURITY";
            }
        }
        return null;
    }

    boolean supportsEUSRIDPWD() {
        return SUPPORTS_EUSRIDPWD;
    }

    private int getSSLModeValue(String s) throws Exception {
        if (s != null) {
            if (StringUtil.SQLEqualsIgnoreCase(s, "off")) {
                return 0;
            }
            if (StringUtil.SQLEqualsIgnoreCase(s, "basic")) {
                return 1;
            }
            if (StringUtil.SQLEqualsIgnoreCase(s, "peerAuthentication")) {
                return 2;
            }
            this.consolePropertyMessage("DRDA_InvalidValue.U", new String[]{s, "gemfirexd.drda.sslMode"});
            return 0;
        }
        return 0;
    }

    private String getSSLModeString(int i) {
        switch (i) {
            case 0: {
                return "off";
            }
            case 1: {
                return "basic";
            }
            case 2: {
                return "peerAuthentication";
            }
        }
        return "off";
    }

    private int getIntPropVal(String propName, String propVal) throws Exception {
        int val = 0;
        try {
            val = Integer.parseInt(propVal, 10);
        }
        catch (Exception e) {
            this.consolePropertyMessage("DRDA_InvalidPropVal.S", new String[]{propName, propVal});
        }
        return val;
    }

    private void consolePropertyMessageWork(String messageKey, String[] args) throws Exception {
        String locMsg = null;
        int type = this.getMessageType(messageKey);
        locMsg = type == -1 ? messageKey : this.localizeMessage(messageKey, this.langUtil, args);
        this.consoleMessage(locMsg);
        if (type == 2) {
            this.usage();
        }
        if (this.currentSession != null && this.currentSession.langUtil != null && type != -1) {
            locMsg = this.localizeMessage(messageKey, this.currentSession.langUtil, args);
        }
        if (type == 1 || type == 2) {
            if (messageKey.equals("DRDA_SQLException.S")) {
                this.throwSQLException(args[0]);
            } else if (messageKey.equals("DRDA_SQLWarning.I")) {
                this.throwSQLWarning(args[0]);
            } else {
                throw new Exception(messageKey + ":" + locMsg);
            }
        }
        if (type == -1) {
            throw new Exception(locMsg);
        }
    }

    private void throwSQLException(String msg) throws SQLException {
        SQLException ne;
        SQLException se = null;
        SQLException ce = null;
        StringBuilder strbuf = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(msg, "\n");
        String sqlstate = null;
        while (tokenizer.hasMoreTokens()) {
            String str = tokenizer.nextToken();
            if (str.charAt(5) == ':') {
                if (strbuf.length() > 0) {
                    if (se == null) {
                        ce = se = new SQLException(strbuf.toString(), sqlstate);
                    } else {
                        ne = new SQLException(strbuf.toString(), sqlstate);
                        ce.setNextException(ne);
                        ce = ne;
                    }
                    strbuf = new StringBuilder();
                }
                strbuf.append(str.substring(6));
                sqlstate = str.substring(0, 5);
                continue;
            }
            strbuf.append(str);
        }
        if (strbuf.length() > 0) {
            if (se == null) {
                ce = se = new SQLException(strbuf.toString(), sqlstate);
            } else {
                ne = new SQLException(strbuf.toString(), sqlstate);
                ce.setNextException(ne);
                ce = ne;
            }
        }
        throw se;
    }

    private void throwSQLWarning(String msg) throws SQLWarning {
        SQLWarning ne;
        SQLWarning se = null;
        SQLWarning ce = null;
        StringBuilder strbuf = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(msg, "\n");
        String sqlstate = null;
        while (tokenizer.hasMoreTokens()) {
            String str = tokenizer.nextToken();
            if (str.charAt(5) == ':') {
                if (strbuf.length() > 0) {
                    if (se == null) {
                        ce = se = new SQLWarning(strbuf.toString(), sqlstate);
                    } else {
                        ne = new SQLWarning(strbuf.toString(), sqlstate);
                        ce.setNextException(ne);
                        ce = ne;
                    }
                    strbuf = new StringBuilder();
                }
                strbuf.append(str.substring(6));
                sqlstate = str.substring(0, 5);
                continue;
            }
            strbuf.append(str);
        }
        if (strbuf.length() > 0) {
            if (se == null) {
                ce = se = new SQLWarning(strbuf.toString(), sqlstate);
            } else {
                ne = new SQLWarning(strbuf.toString(), sqlstate);
                ce.setNextException(ne);
                ce = ne;
            }
        }
        throw se;
    }

    private void throwUnexpectedException(Exception e) throws Exception {
        this.consoleExceptionPrintTrace(e);
        throw new Exception(UNEXPECTED_ERR, e);
    }

    public String localizeMessage(String msgProp, String[] args) {
        return this.localizeMessage(msgProp, this.langUtil, args);
    }

    private String localizeMessage(String msgProp, LocalizedResource localLangUtil, String[] args) {
        String locMsg = null;
        if (args != null) {
            String[] argMsg = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                argMsg[i] = this.isMsgProperty(args[i]) ? localLangUtil.getTextMessage(args[i]) : args[i];
            }
            switch (args.length) {
                case 1: {
                    locMsg = localLangUtil.getTextMessage(msgProp, argMsg[0]);
                    break;
                }
                case 2: {
                    locMsg = localLangUtil.getTextMessage(msgProp, argMsg[0], argMsg[1]);
                    break;
                }
                case 3: {
                    locMsg = localLangUtil.getTextMessage(msgProp, argMsg[0], argMsg[1], argMsg[2]);
                    break;
                }
                case 4: {
                    locMsg = localLangUtil.getTextMessage(msgProp, argMsg[0], argMsg[1], argMsg[2], argMsg[3]);
                    break;
                }
            }
        } else {
            locMsg = localLangUtil.getTextMessage(msgProp);
        }
        return locMsg;
    }

    private int getMessageType(String msg) {
        if (!msg.startsWith(DRDA_MSG_PREFIX)) {
            return -1;
        }
        int startpos = msg.indexOf(46) + 1;
        if (startpos >= msg.length()) {
            return -1;
        }
        if (msg.length() > startpos + 1) {
            return -1;
        }
        char type = msg.charAt(startpos);
        if (type == 'S') {
            return 1;
        }
        if (type == 'U') {
            return 2;
        }
        if (type == 'I') {
            return 3;
        }
        return -1;
    }

    private boolean isMsgProperty(String msg) {
        return msg.startsWith(DRDA_MSG_PREFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getLogConnections() {
        Object object = this.logConnectionsSync;
        synchronized (object) {
            return this.logConnections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLogConnections(boolean value) {
        Object object = this.logConnectionsSync;
        synchronized (object) {
            this.logConnections = value;
        }
        object = this.threadsSync;
        synchronized (object) {
            Enumeration e = this.threadList.elements();
            while (e.hasMoreElements()) {
                DRDAConnThread thread = (DRDAConnThread)e.nextElement();
                thread.setLogConnections(value);
            }
        }
    }

    private void setSecurityMechanism(String s) throws Exception {
        this.allowOnlySecurityMechanism = this.getSecMecValue(s);
        if (this.allowOnlySecurityMechanism == -1 || this.allowOnlySecurityMechanism == 9 && !SUPPORTS_EUSRIDPWD) {
            this.consolePropertyMessage("DRDA_InvalidValue.U", new String[]{s, "gemfirexd.drda.securityMechanism"});
        }
    }

    protected int getSecurityMechanism() {
        return this.allowOnlySecurityMechanism;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setTrace(boolean on) {
        boolean setTraceSuccessful = true;
        if (this.sessionArg == 0) {
            Hashtable hashtable = this.sessionTable;
            synchronized (hashtable) {
                Enumeration e = this.sessionTable.elements();
                while (e.hasMoreElements()) {
                    Session session = (Session)e.nextElement();
                    if (on) {
                        try {
                            session.setTraceOn(this.traceDirectory, true);
                        }
                        catch (Exception te) {
                            this.consoleExceptionPrintTrace(te);
                            setTraceSuccessful = false;
                            session.setTraceOff();
                        }
                        continue;
                    }
                    session.setTraceOff();
                }
                if (setTraceSuccessful) {
                    this.setTraceAll(on);
                }
            }
        } else {
            Session session = (Session)this.sessionTable.get(this.sessionArg);
            if (session != null) {
                if (on) {
                    try {
                        session.setTraceOn(this.traceDirectory, true);
                    }
                    catch (Exception te) {
                        this.consoleExceptionPrintTrace(te);
                        setTraceSuccessful = false;
                        session.setTraceOff();
                    }
                } else {
                    session.setTraceOff();
                }
            } else {
                return false;
            }
        }
        return setTraceSuccessful;
    }

    protected int getTimeSlice() {
        return this.timeSlice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTimeSlice(int value) throws Exception {
        if (value < -1) {
            this.consolePropertyMessage("DRDA_InvalidValue.U", new String[]{Integer.toString(value, 10), "timeslice"});
        }
        if (value == -1) {
            value = 0;
        }
        Object object = this.timeSliceSync;
        synchronized (object) {
            this.timeSlice = value;
        }
    }

    protected boolean getKeepAlive() {
        return this.keepAlive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMinThreads() {
        Object object = this.threadsSync;
        synchronized (object) {
            return this.minThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMinThreads(int value) {
        Object object = this.threadsSync;
        synchronized (object) {
            this.minThreads = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMaxThreads() {
        Object object = this.threadsSync;
        synchronized (object) {
            return this.maxThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMaxThreads(int value) throws Exception {
        if (value < -1) {
            this.consolePropertyMessage("DRDA_InvalidValue.U", new String[]{Integer.toString(value, 10), "maxthreads"});
        }
        if (value == -1) {
            value = 0;
        }
        Object object = this.threadsSync;
        synchronized (object) {
            this.maxThreads = value;
        }
    }

    protected void setSSLMode(int mode) {
        this.sslMode = mode;
    }

    protected int getSSLMode() {
        return this.sslMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getTraceAll() {
        Object object = this.traceAllSync;
        synchronized (object) {
            return this.traceAll;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTraceAll(boolean value) {
        Object object = this.traceAllSync;
        synchronized (object) {
            this.traceAll = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getTraceDirectory() {
        Object object = this.traceDirectorySync;
        synchronized (object) {
            return this.traceDirectory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTraceDirectory(String value) {
        Object object = this.traceDirectorySync;
        synchronized (object) {
            this.traceDirectory = value;
        }
    }

    private void connectToDatabase(DDMWriter writer, String database, String user, String password) throws Exception {
        Properties p = new Properties();
        if (user != null) {
            p.put("user", user);
        }
        if (password != null) {
            p.put("password", password);
        }
        try {
            Class.forName(CLOUDSCAPE_DRIVER);
        }
        catch (Exception e) {
            this.sendMessage(writer, 2, e.getMessage());
            return;
        }
        try {
            Connection conn = DriverManager.getConnection("jdbc:gemfirexd:", p);
            SQLWarning warn = conn.getWarnings();
            if (warn != null) {
                this.sendSQLMessage(writer, warn, 4);
            } else {
                this.sendOK(writer);
            }
            conn.close();
            return;
        }
        catch (SQLException se) {
            this.sendSQLMessage(writer, se, 3);
            return;
        }
    }

    private void wrapSQLError(String messageKey) throws Exception {
        this.consolePropertyMessage("DRDA_SQLException.S", messageKey);
    }

    private void wrapSQLWarning(String messageKey) throws Exception {
        this.consolePropertyMessage("DRDA_SQLWarning.I", messageKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties getPropertyValues() {
        Properties retval = new Properties();
        retval.put("gemfirexd.drda.portNumber", Integer.toString(this.portNumber, 10));
        retval.put("gemfirexd.drda.host", this.hostArg);
        retval.put("gemfirexd.drda.keepAlive", Boolean.toString(this.keepAlive));
        String tracedir = this.getTraceDirectory();
        if (tracedir != null) {
            retval.put("gemfirexd.drda.traceDirectory", tracedir);
        }
        retval.put("gemfirexd.drda.traceAll", Boolean.toString(this.getTraceAll()));
        retval.put("gemfirexd.drda.minThreads", Integer.toString(this.getMinThreads(), 10));
        retval.put("gemfirexd.drda.maxThreads", Integer.toString(this.getMaxThreads(), 10));
        retval.put("gemfirexd.drda.timeSlice", Integer.toString(this.getTimeSlice(), 10));
        retval.put("gemfirexd.drda.timeSlice", Integer.toString(this.getTimeSlice(), 10));
        retval.put("gemfirexd.drda.logConnections", Boolean.toString(this.getLogConnections()));
        String startDRDA = PropertyUtil.getSystemProperty("gemfirexd.drda.startNetworkServer");
        if (startDRDA != null && startDRDA.equals("")) {
            startDRDA = "false";
        }
        retval.put("gemfirexd.drda.startNetworkServer", startDRDA == null ? "false" : startDRDA);
        retval.put("gemfirexd.drda.sslMode", this.getSSLModeString(this.getSSLMode()));
        if (this.getSecurityMechanism() != -1) {
            retval.put("gemfirexd.drda.securityMechanism", this.getStringValueForSecMec(this.getSecurityMechanism()));
        }
        if (!this.getTraceAll()) {
            Hashtable hashtable = this.sessionTable;
            synchronized (hashtable) {
                Enumeration e = this.sessionTable.elements();
                while (e.hasMoreElements()) {
                    Session session = (Session)e.nextElement();
                    if (!session.isTraceOn()) continue;
                    retval.put("gemfirexd.drda.trace." + session.getConnNum(), "true");
                }
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSession(Socket clientSocket) throws Exception {
        boolean enoughThreads;
        int connectionNumber = ++this.connNum;
        if (this.getLogConnections()) {
            this.consolePropertyMessage("DRDA_ConnNumber.I", Integer.toString(connectionNumber));
        }
        Session session = new Session(this, connectionNumber, clientSocket, this.getTraceDirectory(), this.getTraceAll());
        this.sessionTable.put(connectionNumber, session);
        if (this.connListener != null) {
            this.connListener.connectionOpened(clientSocket, connectionNumber);
        }
        Vector vector = this.runQueue;
        synchronized (vector) {
            enoughThreads = this.runQueue.size() < this.freeThreads;
        }
        DRDAConnThread thread = null;
        if (!enoughThreads) {
            Object object = this.threadsSync;
            synchronized (object) {
                if (this.maxThreads == 0 || this.threadList.size() < this.maxThreads) {
                    try {
                        thread = new DRDAConnThread(session, this, this.getTimeSlice(), this.getLogConnections());
                        this.threadList.add(thread);
                        thread.start();
                    }
                    catch (OutOfMemoryError oome) {
                        this.removeThread(thread);
                        thread = null;
                    }
                }
            }
        }
        if (thread == null) {
            this.runQueueAdd(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeThread(DRDAConnThread thread) {
        Object object = this.threadsSync;
        synchronized (object) {
            this.threadList.remove(thread);
        }
    }

    protected Object getShutdownSync() {
        return this.shutdownSync;
    }

    protected boolean getShutdown() {
        return this.shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"DM_GC"})
    public String buildRuntimeInfo(LocalizedResource locallangUtil) {
        int i;
        int numThreads;
        String s = locallangUtil.getTextMessage("DRDA_RuntimeInfoBanner.I") + "\n";
        int sessionCount = 0;
        s = s + locallangUtil.getTextMessage("DRDA_RuntimeInfoSessionBanner.I") + "\n";
        Object object = this.threadsSync;
        synchronized (object) {
            numThreads = this.threadList.size();
            for (i = 0; i < numThreads; ++i) {
                String sessionInfo = ((DRDAConnThread)this.threadList.get(i)).buildRuntimeInfo("", locallangUtil);
                if (sessionInfo.equals("")) continue;
                ++sessionCount;
                s = s + sessionInfo + "\n";
            }
        }
        int waitingSessions = 0;
        for (i = 0; i < this.runQueue.size(); ++i) {
            s = s + ((Session)this.runQueue.get(i)).buildRuntimeInfo("", locallangUtil);
            ++waitingSessions;
        }
        s = s + "-------------------------------------------------------------\n";
        s = s + locallangUtil.getTextMessage("DRDA_RuntimeInfoNumThreads.I") + numThreads + "\n";
        s = s + locallangUtil.getTextMessage("DRDA_RuntimeInfoNumActiveSessions.I") + sessionCount + "\n";
        s = s + locallangUtil.getTextMessage("DRDA_RuntimeInfoNumWaitingSessions.I") + waitingSessions + "\n\n";
        Runtime rt = Runtime.getRuntime();
        rt.gc();
        long totalmem = rt.totalMemory();
        long freemem = rt.freeMemory();
        s = s + locallangUtil.getTextMessage("DRDA_RuntimeInfoTotalMemory.I") + totalmem + "\t";
        s = s + locallangUtil.getTextMessage("DRDA_RuntimeInfoFreeMemory.I") + freemem + "\n\n";
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getBytesRead() {
        long count = 0L;
        Object object = this.threadsSync;
        synchronized (object) {
            for (int i = 0; i < this.threadList.size(); ++i) {
                count += ((DRDAConnThread)this.threadList.get(i)).getBytesRead();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getBytesWritten() {
        long count = 0L;
        Object object = this.threadsSync;
        synchronized (object) {
            for (int i = 0; i < this.threadList.size(); ++i) {
                count += ((DRDAConnThread)this.threadList.get(i)).getBytesWritten();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getActiveSessions() {
        int count = 0;
        Object object = this.threadsSync;
        synchronized (object) {
            for (int i = 0; i < this.threadList.size(); ++i) {
                if (!((DRDAConnThread)this.threadList.get(i)).hasSession()) continue;
                ++count;
            }
        }
        return count;
    }

    int getRunQueueSize() {
        return this.runQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getThreadListSize() {
        Object object = this.threadsSync;
        synchronized (object) {
            return this.threadList.size();
        }
    }

    int getConnectionNumber() {
        return this.connNum;
    }

    protected void setClientLocale(String locale) {
        this.clientLocale = locale;
    }

    private ProductVersionHolder getNetProductVersionHolder() throws Exception {
        ProductVersionHolder myPVH = null;
        try {
            myPVH = (ProductVersionHolder)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException, IOException {
                    InputStream versionStream = this.getClass().getResourceAsStream("/com/pivotal/gemfirexd/internal/info/net.properties");
                    return ProductVersionHolder.getProductVersionHolderFromMyEnv((InputStream)versionStream);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception e1 = e.getException();
            this.consolePropertyMessage("DRDA_ProductVersionReadError.S", e1.getMessage());
        }
        return myPVH;
    }

    private String getFormattedTimestamp() {
        StringBuilder sb = new StringBuilder();
        ClientSharedUtils.formatDate((long)System.currentTimeMillis(), (StringBuilder)sb);
        return sb.toString();
    }

    public void setConnectionListener(NetworkInterface.ConnectionListener listener) {
        this.connListener = listener;
    }

    public InetAddress getHostAddressAndPort(int[] outPort) {
        outPort[0] = this.portNumber;
        return this.hostAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectStatisticsSample() {
        long totalThreads;
        ConnectionStats stats = InternalDriver.activeDriver().getConnectionStats();
        int connOpen = 0;
        long bytesRead = 0L;
        long bytesWritten = 0L;
        long totNumTimesWaited = 0L;
        long totalDRDAThreadIdleTime = 0L;
        long totalNumCommandsProcessed = 0L;
        long totalProcessTime = 0L;
        long waitingThreads = 0L;
        int numClientConnectionsIdle = 0;
        Object object = this.threadsSync;
        synchronized (object) {
            totalThreads = this.threadList.size();
            long[] connThreadStats = new long[5];
            int i = 0;
            while ((long)i < totalThreads) {
                DRDAConnThread connThread = (DRDAConnThread)this.threadList.get(i);
                if (connThread.hasSession()) {
                    ++connOpen;
                }
                bytesRead += connThread.getAndResetBytesRead();
                bytesWritten += connThread.getAndResetBytesWritten();
                connThread.getAndResetConnActivityStats(connThreadStats);
                long beginWaitTimeMillis = connThreadStats[0];
                long numTimesCurrentThreadWaited = connThreadStats[1];
                if (numTimesCurrentThreadWaited > 0L) {
                    totNumTimesWaited += numTimesCurrentThreadWaited;
                    ++waitingThreads;
                }
                long currWaitingTime = beginWaitTimeMillis > 0L ? System.currentTimeMillis() - beginWaitTimeMillis : 0L;
                totalDRDAThreadIdleTime += connThreadStats[2];
                if (currWaitingTime > 0L) {
                    ++numClientConnectionsIdle;
                    totalDRDAThreadIdleTime += currWaitingTime * 1000000L;
                }
                totalNumCommandsProcessed += connThreadStats[3];
                totalProcessTime += connThreadStats[4];
                ++i;
            }
        }
        int queuedConn = this.runQueue.size();
        stats.setDRDAServerThreads(totalThreads);
        stats.setDRDAServerWaitingThreads(waitingThreads);
        stats.setClientConnectionsIdle(numClientConnectionsIdle);
        stats.setClientConnectionsOpen(connOpen);
        stats.setClientConnectionsQueued(queuedConn);
        stats.incTotalBytesRead(bytesRead);
        stats.incTotalBytesWritten(bytesWritten);
        stats.incDRDAThreadLongWaits(totNumTimesWaited);
        stats.incDRDAThreadIdleTime(totalDRDAThreadIdleTime / 1000000L);
        stats.incCommandsProcessed(totalNumCommandsProcessed);
        stats.incCommandsProcessTime(totalProcessTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSessionInfo(SessionsVTI.SessionInfo info) throws StandardException {
        int i;
        Object object = this.threadsSync;
        synchronized (object) {
            for (i = 0; i < this.threadList.size(); ++i) {
                DRDAConnThread connThread = (DRDAConnThread)this.threadList.get(i);
                Session session = connThread.getSession();
                if (session == null) continue;
                SessionsVTI.SessionInfo.ClientSession cs = new SessionsVTI.SessionInfo.ClientSession();
                cs.connNum = session.getConnNum();
                Socket soc = session.getClientSocket();
                cs.isActive = true;
                cs.clientBindAddress = soc.getInetAddress().toString();
                cs.clientBindPort = soc.getPort();
                cs.hadConnectedOnce = soc.isConnected();
                cs.isConnected = !soc.isClosed();
                Database db = session.database;
                if (db == null) continue;
                cs.userId = db.userId;
                cs.failover = db.failover;
                cs.disableStreaming = db.disableStreaming;
                cs.skipListeners = db.skipListeners;
                cs.queryHDFS = db.queryHDFS;
                cs.routeQuery = db.routeQuery;
                cs.skipConstraintChecks = db.skipConstraintChecks;
                cs.syncCommits = db.syncCommits;
                cs.disableTXBatching = db.disableTXBatching;
                cs.skipLocks = db.skipLocks;
                cs.connectionBeginTimeStamp = db.connectionBeginTimeStamp;
                DRDAStatement st = db.getCurrentStatement();
                if (st != null) {
                    cs.currentStatementUUID = st.getStatementUUID();
                    cs.currentStatement = st.toDebugString("");
                    cs.currentStatementStatus = st.getStatus();
                    if (st.getExecutionBeginTime() > 0L) {
                        cs.currentStatementElapsedTime = (System.currentTimeMillis() - st.getExecutionBeginTime()) / 1000L;
                    }
                    cs.currentStatementAccessFrequency = st.getAccessFrequency();
                    long estimatedUsage = st.getEstimatedMemoryUsage();
                    if (estimatedUsage > 0L) {
                        cs.currentStatementEstimatedMemUsage = estimatedUsage;
                    }
                }
                info.addClientSession(cs);
            }
        }
        object = this.runQueue;
        synchronized (object) {
            for (i = 0; i < this.runQueue.size(); ++i) {
                Session session = (Session)this.runQueue.get(i);
                SessionsVTI.SessionInfo.ClientSession cs = new SessionsVTI.SessionInfo.ClientSession();
                cs.connNum = session.getConnNum();
                Socket soc = session.getClientSocket();
                cs.isActive = false;
                cs.clientBindAddress = soc.getInetAddress().toString();
                cs.clientBindPort = soc.getPort();
                cs.hadConnectedOnce = soc.isConnected();
                cs.isConnected = !soc.isClosed();
                Database db = session.database;
                if (db == null) continue;
                cs.userId = db.userId;
                cs.failover = db.failover;
                cs.disableStreaming = db.disableStreaming;
                cs.skipListeners = db.skipListeners;
                cs.queryHDFS = db.queryHDFS;
                cs.routeQuery = db.routeQuery;
                cs.skipConstraintChecks = db.skipConstraintChecks;
                cs.syncCommits = db.syncCommits;
                cs.disableTXBatching = db.disableTXBatching;
                cs.skipLocks = db.skipLocks;
                cs.connectionBeginTimeStamp = db.connectionBeginTimeStamp;
                DRDAStatement st = db.getCurrentStatement();
                if (st != null) {
                    long accessFrequency;
                    long estimatedUsage;
                    cs.currentStatementUUID = st.getStatementUUID();
                    cs.currentStatement = st.toDebugString("");
                    cs.currentStatementStatus = st.getStatus();
                    if (st.getExecutionBeginTime() > 0L) {
                        cs.currentStatementElapsedTime = (System.currentTimeMillis() - st.getExecutionBeginTime()) / 1000L;
                    }
                    if ((estimatedUsage = st.getEstimatedMemoryUsage()) > 0L) {
                        cs.currentStatementEstimatedMemUsage = estimatedUsage;
                    }
                    if ((accessFrequency = st.getAccessFrequency()) > 0L) {
                        cs.currentStatementEstimatedMemUsage = accessFrequency;
                    }
                }
                info.addClientSession(cs);
            }
        }
    }

    static {
        DEFAULT_CHARSET = Charset.forName(DEFAULT_ENCODING);
        MGR_LEVELS = new int[]{7, 4, 0, 0, 5, 0, 7, 0, 7, 7, 0, 0, 7};
        SUPPORTS_EUSRIDPWD = false;
        try {
            new DecryptionManager();
            SUPPORTS_EUSRIDPWD = true;
        }
        catch (Exception e) {
            if (GemFireXDUtils.TraceAuthentication) {
                SanityManager.DEBUG_PRINT((String)"warning:", (String)("DecryptionManager implementation raised exception " + e.getMessage()), (Throwable)e);
            }
            SUPPORTS_EUSRIDPWD = false;
        }
    }
}

