/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.drda;

import com.pivotal.gemfirexd.internal.impl.drda.CodePointNameTable;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Calendar;

public class DssTrace {
    private static final String LIST_SEPARATOR = " # ";
    private static final String NULL_VALUE = "null";
    private static final char[] asciiChar = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
    private static CodePointNameTable codePointNameTable = null;
    private static final String colPosHeader = "       0 1 2 3 4 5 6 7   8 9 A B C D E F   0123456789ABCDEF  0123456789ABCDEF";
    private static final char[] ebcdicChar = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '<', '(', '+', '|', '&', '.', '.', '.', '.', '.', '.', '.', '.', '.', '!', '$', '*', ')', ';', '.', '-', '/', '.', '.', '.', '.', '.', '.', '.', '.', '|', ',', '%', '_', '>', '?', '.', '.', '.', '.', '.', '.', '.', '.', '.', '`', ':', '#', '@', '\'', '=', '\"', '.', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '.', '.', '.', '.', '.', '.', '.', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '.', '.', '.', '.', '.', '.', '.', '~', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '.', '.', '.', '.', '.', '.', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '.', '.', '.', '.', '.', '.', '\\', '.', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '.', '.', '.', '.', '.', '.', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.', '.', '.', '.', '.', '.'};
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private PrintWriter comBufferWriter = null;
    private static final String receiveHeader = "       RECEIVE BUFFER:                     (ASCII)           (EBCDIC)";
    private static final String sendHeader = "       SEND BUFFER:                        (ASCII)           (EBCDIC)";
    private static final char spaceChar = ' ';
    private boolean comBufferTraceOn = false;
    private final Object comBufferSync = new Object();
    private static final char zeroChar = '0';
    protected static final int TYPE_TRACE_RECEIVE = 2;
    protected static final int TYPE_TRACE_SEND = 1;

    protected boolean isComBufferTraceOn() {
        return this.comBufferTraceOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startComBufferTrace(final String fileName) throws Exception {
        Object object = this.comBufferSync;
        synchronized (object) {
            if (!this.comBufferTraceOn) {
                try {
                    this.comBufferWriter = (PrintWriter)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws SecurityException, IOException {
                            return new PrintWriter(new BufferedWriter(new FileWriter(fileName), 4096));
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
                this.comBufferTraceOn = true;
                if (codePointNameTable == null) {
                    codePointNameTable = new CodePointNameTable();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopComBufferTrace() {
        Object object = this.comBufferSync;
        synchronized (object) {
            if (this.comBufferTraceOn) {
                this.comBufferTraceOn = false;
                if (this.comBufferWriter != null) {
                    this.comBufferWriter.flush();
                    this.comBufferWriter.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeComBufferData(byte[] buff, int offset, int len, int type, String className, String methodName, int trcPt) {
        Object object = this.comBufferSync;
        synchronized (object) {
            if (this.comBufferTraceOn) {
                Calendar time = Calendar.getInstance();
                this.comBufferWriter.println("       (" + time.get(1) + "." + (time.get(2) + 1) + "." + time.get(5) + " " + time.get(11) + ":" + time.get(12) + ":" + time.get(13) + ") " + className + " " + methodName + " " + Thread.currentThread().getName() + " " + trcPt);
                this.comBufferWriter.println();
                if (len != 0) {
                    String codePointName = null;
                    if (len >= 10) {
                        int codePoint = DssTrace.getCodePoint(buff, offset + 8);
                        codePointName = codePointNameTable.lookup(codePoint);
                    }
                    if (codePointName == null) {
                        this.comBufferWriter.println(DssTrace.getHeader(type));
                    } else {
                        this.printHeaderWithCodePointName(codePointName, type);
                    }
                    this.comBufferWriter.println(colPosHeader);
                    char[] trcDump = new char[77];
                    int bCounter = 7;
                    int aCounter = 43;
                    int eCounter = 61;
                    trcDump[0] = 48;
                    trcDump[1] = 48;
                    trcDump[2] = 48;
                    trcDump[3] = 48;
                    int lineCounter = 16;
                    for (int j = 4; j < 77; ++j) {
                        trcDump[j] = 32;
                    }
                    int i = 0;
                    do {
                        int num = buff[offset] < 0 ? buff[offset] + 256 : buff[offset];
                        ++offset;
                        ++i;
                        int n = bCounter;
                        bCounter = (short)(bCounter + 1);
                        trcDump[n] = hexDigit[num >>> 4 & 0xF];
                        int n2 = bCounter;
                        bCounter = (short)(bCounter + 1);
                        trcDump[n2] = hexDigit[num & 0xF];
                        int n3 = aCounter;
                        aCounter = (short)(aCounter + 1);
                        trcDump[n3] = asciiChar[num];
                        int n4 = eCounter;
                        eCounter = (short)(eCounter + 1);
                        trcDump[n4] = ebcdicChar[num];
                        if (i % 8 != 0) continue;
                        if (i % 16 == 0) {
                            this.comBufferWriter.println(trcDump);
                            if (i == len) continue;
                            if (len - i < 16) {
                                for (int j = 0; j < trcDump.length; ++j) {
                                    trcDump[j] = 32;
                                }
                            }
                            bCounter = 0;
                            aCounter = 43;
                            eCounter = 61;
                            if (lineCounter == 65520) {
                                lineCounter = 0;
                            }
                            int n5 = bCounter;
                            bCounter = (short)(bCounter + 1);
                            trcDump[n5] = hexDigit[lineCounter >>> 12 & 0xF];
                            int n6 = bCounter;
                            bCounter = (short)(bCounter + 1);
                            trcDump[n6] = hexDigit[lineCounter >>> 8 & 0xF];
                            int n7 = bCounter;
                            bCounter = (short)(bCounter + 1);
                            trcDump[n7] = hexDigit[lineCounter >>> 4 & 0xF];
                            int n8 = bCounter;
                            bCounter = (short)(bCounter + 1);
                            trcDump[n8] = hexDigit[lineCounter & 0xF];
                            bCounter = (short)(bCounter + 3);
                            lineCounter += 16;
                            continue;
                        }
                        bCounter = (short)(bCounter + 2);
                    } while (i < len);
                    if (len % 16 != 0) {
                        this.comBufferWriter.println(trcDump);
                    }
                    this.comBufferWriter.println();
                    this.comBufferWriter.println();
                }
                this.comBufferWriter.flush();
            }
        }
    }

    private static int getCodePoint(byte[] buff, int offset) {
        return ((buff[offset++] & 0xFF) << 8) + ((buff[offset] & 0xFF) << 0);
    }

    private static String getHeader(int type) {
        switch (type) {
            case 1: {
                return sendHeader;
            }
            case 2: {
                return receiveHeader;
            }
        }
        return null;
    }

    private static int getStartPosition(int type) {
        switch (type) {
            case 1: {
                return 20;
            }
            case 2: {
                return 23;
            }
        }
        return 0;
    }

    private void printHeaderWithCodePointName(String codePointName, int type) {
        char[] headerArray = DssTrace.getHeader(type).toCharArray();
        int replaceLen = codePointName.length() < 17 ? codePointName.length() : 16;
        int offset = DssTrace.getStartPosition(type);
        for (int i = 0; i < replaceLen; ++i) {
            headerArray[offset++] = codePointName.charAt(i);
        }
        this.comBufferWriter.println(headerArray);
    }
}

