/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.gemstone.gemfire.internal.offheap.ByteSource;
import com.gemstone.gemfire.internal.shared.ClientSharedData;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.ByteArrayDataOutput;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.LocaleFinder;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DateTimeDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.DateTimeParser;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDate;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDouble;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTime;
import com.pivotal.gemfirexd.internal.iapi.util.ReuseFactory;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;

public final class SQLTimestamp
extends DataType
implements DateTimeDataValue {
    static final int MAX_FRACTION_DIGITS = 6;
    static final int FRACTION_TO_NANO = 1000;
    static final int ONE_BILLION = 1000000000;
    private int encodedDate;
    private int encodedTime;
    private int nanos;
    private String valueString;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLTimestamp.class);
    static final char DATE_SEPARATOR = '-';
    private static final char[] DATE_SEPARATORS = new char[]{'-'};
    private static final char IBM_DATE_TIME_SEPARATOR = '-';
    private static final char ODBC_DATE_TIME_SEPARATOR = ' ';
    private static final char[] DATE_TIME_SEPARATORS = new char[]{'-', ' '};
    private static final char[] DATE_TIME_SEPARATORS_OR_END = new char[]{'-', ' ', '\u0000'};
    private static final char IBM_TIME_SEPARATOR = '.';
    private static final char ODBC_TIME_SEPARATOR = ':';
    private static final char[] TIME_SEPARATORS = new char[]{'.', ':'};
    private static final char[] TIME_SEPARATORS_OR_END = new char[]{'.', ':', '\u0000'};
    private static final char[] END_OF_STRING = new char[]{'\u0000'};
    public static final int TIMESTAMP_CHARS_NANOS = 29;
    public static final int TIMESTAMP_CHARS_MICROS = 26;

    @Override
    public int estimateMemoryUsage() {
        int sz = BASE_MEMORY_USAGE + ClassSize.estimateMemoryUsage(this.valueString);
        return sz;
    }

    @Override
    public String getString() {
        if (!this.isNull()) {
            if (this.valueString == null) {
                this.valueString = this.getTimestamp(null).toString();
                int separatorIdx = this.valueString.indexOf(45);
                if (separatorIdx >= 0 && separatorIdx < 4) {
                    StringBuilder sb = new StringBuilder();
                    while (separatorIdx < 4) {
                        sb.append('0');
                        ++separatorIdx;
                    }
                    sb.append(this.valueString);
                    this.valueString = sb.toString();
                }
            }
            return this.valueString;
        }
        if (this.valueString != null) {
            SanityManager.THROWASSERT((String)("valueString expected to be null, not " + this.valueString));
        }
        return null;
    }

    @Override
    public Date getDate(Calendar cal) throws StandardException {
        if (this.isNull()) {
            return null;
        }
        if (cal == null) {
            cal = ClientSharedData.getDefaultCalendar();
        }
        cal.clear();
        SQLDate.setDateInCalendar(cal, this.encodedDate);
        return new Date(cal.getTimeInMillis());
    }

    @Override
    public Time getTime(Calendar cal) throws StandardException {
        if (this.isNull()) {
            return null;
        }
        return SQLTime.getTime(cal, this.encodedTime, this.nanos);
    }

    @Override
    public Object getObject() {
        return this.getTimestamp(null);
    }

    @Override
    public int getLength() {
        return 12;
    }

    @Override
    public String getTypeName() {
        return "TIMESTAMP";
    }

    @Override
    public int getTypeFormatId() {
        return 31;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT((!this.isNull() ? 1 : 0) != 0, (String)"writeExternal() is not supposed to be called for null values.");
        out.writeInt(this.encodedDate);
        out.writeInt(this.encodedTime);
        out.writeInt(this.nanos);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.encodedDate = in.readInt();
        this.encodedTime = in.readInt();
        this.nanos = in.readInt();
        this.valueString = null;
    }

    @Override
    public void readExternalFromArray(ArrayInputStream in) throws IOException {
        this.encodedDate = in.readInt();
        this.encodedTime = in.readInt();
        this.nanos = in.readInt();
        this.valueString = null;
    }

    @Override
    public DataValueDescriptor getClone() {
        return new SQLTimestamp(this.encodedDate, this.encodedTime, this.nanos);
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLTimestamp();
    }

    @Override
    public void restoreToNull() {
        this.encodedDate = 0;
        this.encodedTime = 0;
        this.nanos = 0;
        this.valueString = null;
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException, StandardException {
        this.setValue(resultSet.getTimestamp(colNumber), (Calendar)null);
    }

    @Override
    public int compare(DataValueDescriptor other) throws StandardException {
        if (this.typePrecedence() < other.typePrecedence()) {
            return -Integer.signum(other.compare(this));
        }
        boolean thisNull = this.isNull();
        boolean otherNull = other.isNull();
        if (thisNull || otherNull) {
            if (!thisNull) {
                return -1;
            }
            if (!otherNull) {
                return 1;
            }
            return 0;
        }
        int otherEncodedDate = 0;
        int otherEncodedTime = 0;
        int otherNanos = 0;
        if (other instanceof SQLTimestamp) {
            SQLTimestamp st = (SQLTimestamp)other;
            otherEncodedDate = st.encodedDate;
            otherEncodedTime = st.encodedTime;
            otherNanos = st.nanos;
        } else {
            GregorianCalendar cal = ClientSharedData.getDefaultCleanCalendar();
            Timestamp otherts = other.getTimestamp(cal);
            otherEncodedDate = SQLTimestamp.computeEncodedDate(otherts, cal);
            otherEncodedTime = SQLTimestamp.computeEncodedTime(otherts, cal);
            otherNanos = otherts.getNanos();
        }
        int comparison = this.encodedDate < otherEncodedDate ? -1 : (this.encodedDate > otherEncodedDate ? 1 : (this.encodedTime < otherEncodedTime ? -1 : (this.encodedTime > otherEncodedTime ? 1 : (this.nanos < otherNanos ? -1 : (this.nanos > otherNanos ? 1 : 0)))));
        return comparison;
    }

    @Override
    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        if (!orderedNulls && (this.isNull() || other.isNull())) {
            return unknownRV;
        }
        return super.compare(op, other, orderedNulls, unknownRV);
    }

    public SQLTimestamp() {
    }

    public SQLTimestamp(Timestamp value) throws StandardException {
        this.setValue(value, (Calendar)null);
    }

    SQLTimestamp(int encodedDate, int encodedTime, int nanos) {
        this.encodedDate = encodedDate;
        this.encodedTime = encodedTime;
        this.nanos = nanos;
    }

    public SQLTimestamp(DataValueDescriptor date, DataValueDescriptor time) throws StandardException {
        GregorianCalendar cal = null;
        if (date == null || date.isNull() || time == null || time.isNull()) {
            return;
        }
        if (date instanceof SQLDate) {
            SQLDate sqlDate = (SQLDate)date;
            this.encodedDate = sqlDate.getEncodedDate();
        } else {
            cal = ClientSharedData.getDefaultCleanCalendar();
            this.encodedDate = SQLTimestamp.computeEncodedDate(date.getDate(cal), cal);
        }
        if (time instanceof SQLTime) {
            SQLTime sqlTime = (SQLTime)time;
            this.encodedTime = sqlTime.getEncodedTime();
        } else {
            if (cal == null) {
                cal = ClientSharedData.getDefaultCleanCalendar();
            }
            this.encodedTime = SQLTimestamp.computeEncodedTime(time.getTime(cal), cal);
        }
    }

    public SQLTimestamp(String timestampStr, boolean isJDBCEscape, LocaleFinder localeFinder) throws StandardException {
        this.parseTimestamp(timestampStr, isJDBCEscape, localeFinder, null);
    }

    public SQLTimestamp(String timestampStr, boolean isJDBCEscape, LocaleFinder localeFinder, Calendar cal) throws StandardException {
        this.parseTimestamp(timestampStr, isJDBCEscape, localeFinder, cal);
    }

    private void parseTimestamp(String timestampStr, boolean isJDBCEscape, LocaleFinder localeFinder, Calendar cal) throws StandardException {
        StandardException thrownSE = null;
        DateTimeParser parser = new DateTimeParser(timestampStr);
        try {
            int[] dateTimeNano = SQLTimestamp.parseDateOrTimestamp(parser, true);
            this.encodedDate = dateTimeNano[0];
            this.encodedTime = dateTimeNano[1];
            this.nanos = dateTimeNano[2];
            this.valueString = parser.getTrimmedString();
            return;
        }
        catch (StandardException se) {
            thrownSE = se;
            try {
                timestampStr = StringUtil.trimTrailing(timestampStr);
                int[] dateAndTime = SQLTimestamp.parseLocalTimestamp(timestampStr, localeFinder, cal);
                this.encodedDate = dateAndTime[0];
                this.encodedTime = dateAndTime[1];
                this.valueString = timestampStr;
                return;
            }
            catch (ParseException parseException) {
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            if (thrownSE != null) {
                throw thrownSE;
            }
            throw StandardException.newException("22007.S.181", timestampStr);
        }
    }

    static int[] parseLocalTimestamp(String str, LocaleFinder localeFinder, Calendar cal) throws StandardException, ParseException {
        DateFormat timestampFormat = null;
        timestampFormat = localeFinder == null ? DateFormat.getDateTimeInstance() : (cal == null ? localeFinder.getTimestampFormat() : (DateFormat)localeFinder.getTimestampFormat().clone());
        if (cal == null) {
            cal = ClientSharedData.getDefaultCleanCalendar();
        } else {
            timestampFormat.setCalendar(cal);
        }
        java.util.Date date = timestampFormat.parse(str);
        return new int[]{SQLTimestamp.computeEncodedDate(date, cal), SQLTimestamp.computeEncodedTime(date, cal)};
    }

    static int[] parseDateOrTimestamp(DateTimeParser parser, boolean timeRequired) throws StandardException {
        int year = parser.parseInt(4, false, DATE_SEPARATORS, false);
        int month = parser.parseInt(2, true, DATE_SEPARATORS, false);
        int day = parser.parseInt(2, true, timeRequired ? DATE_TIME_SEPARATORS : DATE_TIME_SEPARATORS_OR_END, false);
        int hour = 0;
        int minute = 0;
        int second = 0;
        int nano = 0;
        if (parser.getCurrentSeparator() != '\u0000') {
            char timeSeparator = parser.getCurrentSeparator() == ' ' ? (char)':' : '.';
            hour = parser.parseInt(2, true, TIME_SEPARATORS, false);
            if (timeSeparator == parser.getCurrentSeparator()) {
                minute = parser.parseInt(2, false, TIME_SEPARATORS, false);
                if (timeSeparator == parser.getCurrentSeparator()) {
                    second = parser.parseInt(2, false, TIME_SEPARATORS_OR_END, false);
                    if (parser.getCurrentSeparator() == '.') {
                        nano = parser.parseInt(6, true, END_OF_STRING, true) * 1000;
                    }
                }
            }
        }
        parser.checkEnd();
        return new int[]{SQLDate.computeEncodedDate(year, month, day), SQLTime.computeEncodedTime(hour, minute, second), nano};
    }

    @Override
    void setObject(Object theValue) throws StandardException {
        this.setValue((Timestamp)theValue);
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        if (theValue instanceof SQLTimestamp) {
            this.restoreToNull();
            SQLTimestamp tvst = (SQLTimestamp)theValue;
            this.encodedDate = tvst.encodedDate;
            this.encodedTime = tvst.encodedTime;
            this.nanos = tvst.nanos;
        } else {
            GregorianCalendar cal = ClientSharedData.getDefaultCleanCalendar();
            this.setValue(theValue.getTimestamp(cal), (Calendar)cal);
        }
    }

    @Override
    public void setValue(Date value, Calendar cal) throws StandardException {
        this.restoreToNull();
        if (value != null) {
            if (cal == null) {
                cal = ClientSharedData.getDefaultCleanCalendar();
            }
            this.encodedDate = SQLTimestamp.computeEncodedDate(value, cal);
        }
    }

    @Override
    public void setValue(Timestamp value, Calendar cal) throws StandardException {
        this.restoreToNull();
        this.setNumericTimestamp(value, cal);
    }

    @Override
    public void setValue(String theValue) throws StandardException {
        this.restoreToNull();
        if (theValue != null) {
            this.parseTimestamp(theValue, false, Misc.getMemStore().getDatabase(), null);
        }
    }

    NumberDataValue nullValueInt() {
        return new SQLInteger();
    }

    NumberDataValue nullValueDouble() {
        return new SQLDouble();
    }

    @Override
    public NumberDataValue getYear(NumberDataValue result) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLDate.getYear(this.encodedDate), result);
    }

    @Override
    public NumberDataValue getMonth(NumberDataValue result) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLDate.getMonth(this.encodedDate), result);
    }

    @Override
    public NumberDataValue getDate(NumberDataValue result) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLDate.getDay(this.encodedDate), result);
    }

    @Override
    public NumberDataValue getHours(NumberDataValue result) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLTime.getHour(this.encodedTime), result);
    }

    @Override
    public NumberDataValue getMinutes(NumberDataValue result) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLTime.getMinute(this.encodedTime), result);
    }

    @Override
    public NumberDataValue getSeconds(NumberDataValue source) throws StandardException {
        SanityManager.ASSERT((source == null || source instanceof SQLDouble ? 1 : 0) != 0, (String)"getSeconds for a timestamp was given a source other than a SQLDouble");
        if (this.isNull()) {
            return this.nullValueDouble();
        }
        NumberDataValue result = source != null ? source : new SQLDouble();
        result.setValue((double)SQLTime.getSecond(this.encodedTime) + (double)this.nanos / 1.0E9);
        return result;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.getTimestamp(null).toString();
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        return this.encodedDate + this.encodedTime + this.nanos;
    }

    @Override
    public int typePrecedence() {
        return 110;
    }

    @Override
    public final boolean isNull() {
        return this.encodedDate == 0;
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) {
        if (this.isNull()) {
            return null;
        }
        if (cal == null) {
            cal = ClientSharedData.getDefaultCalendar();
        }
        this.setCalendar(cal);
        Timestamp t = new Timestamp(cal.getTimeInMillis());
        t.setNanos(this.nanos);
        return t;
    }

    public long getEpochTime(Calendar cal) {
        if (cal == null) {
            cal = ClientSharedData.getDefaultCalendar();
        }
        this.setCalendar(cal);
        return cal.getTimeInMillis();
    }

    private void setCalendar(Calendar cal) {
        cal.clear();
        SQLDate.setDateInCalendar(cal, this.encodedDate);
        SQLTime.setTimeInCalendar(cal, this.encodedTime);
        cal.set(14, 0);
    }

    private void setNumericTimestamp(Timestamp value, Calendar cal) throws StandardException {
        SanityManager.ASSERT((boolean)this.isNull(), (String)"setNumericTimestamp called when already set");
        if (value != null) {
            if (cal == null) {
                cal = ClientSharedData.getDefaultCleanCalendar();
            }
            this.encodedDate = SQLTimestamp.computeEncodedDate(value, cal);
            this.encodedTime = SQLTimestamp.computeEncodedTime(value, cal);
            this.nanos = value.getNanos();
        }
    }

    @Override
    protected String getNationalString(LocaleFinder localeFinder) throws StandardException {
        if (this.isNull()) {
            return this.getString();
        }
        return localeFinder.getTimestampFormat().format(this.getTimestamp(null));
    }

    private static int computeEncodedDate(java.util.Date value, Calendar currentCal) throws StandardException {
        if (value == null) {
            return 0;
        }
        currentCal.setTime(value);
        return SQLDate.computeEncodedDate(currentCal);
    }

    private static int computeEncodedTime(java.util.Date value, Calendar currentCal) throws StandardException {
        currentCal.setTime(value);
        return SQLTime.computeEncodedTime(currentCal);
    }

    @Override
    public void setInto(PreparedStatement ps, int position) throws SQLException, StandardException {
        ps.setTimestamp(position, this.getTimestamp(null));
    }

    public static DateTimeDataValue computeTimestampFunction(DataValueDescriptor operand, DataValueFactory dvf) throws StandardException {
        try {
            if (operand.isNull()) {
                return new SQLTimestamp();
            }
            if (operand instanceof SQLTimestamp) {
                return (SQLTimestamp)operand.getClone();
            }
            String str = operand.getString();
            if (str.length() == 14) {
                int year = SQLTimestamp.parseDateTimeInteger(str, 0, 4);
                int month = SQLTimestamp.parseDateTimeInteger(str, 4, 2);
                int day = SQLTimestamp.parseDateTimeInteger(str, 6, 2);
                int hour = SQLTimestamp.parseDateTimeInteger(str, 8, 2);
                int minute = SQLTimestamp.parseDateTimeInteger(str, 10, 2);
                int second = SQLTimestamp.parseDateTimeInteger(str, 12, 2);
                return new SQLTimestamp(SQLDate.computeEncodedDate(year, month, day), SQLTime.computeEncodedTime(hour, minute, second), 0);
            }
            return dvf.getTimestampValue(str, false);
        }
        catch (StandardException se) {
            if ("22007.S.181".startsWith(se.getSQLState())) {
                throw StandardException.newException("22008.S", (Object)operand.getString(), (Object)"timestamp");
            }
            throw se;
        }
    }

    static int parseDateTimeInteger(String str, int start, int ndigits) throws StandardException {
        int end = start + ndigits;
        int retVal = 0;
        for (int i = start; i < end; ++i) {
            char c = str.charAt(i);
            if (!Character.isDigit(c)) {
                throw StandardException.newException("22007.S.181", str);
            }
            retVal = 10 * retVal + Character.digit(c, 10);
        }
        return retVal;
    }

    @Override
    public DateTimeDataValue timestampAdd(int intervalType, NumberDataValue count, Date currentDate, DateTimeDataValue resultHolder) throws StandardException {
        if (resultHolder == null) {
            resultHolder = new SQLTimestamp();
        }
        SQLTimestamp tsResult = (SQLTimestamp)resultHolder;
        if (this.isNull() || count.isNull()) {
            tsResult.restoreToNull();
            return resultHolder;
        }
        tsResult.setFrom(this);
        int intervalCount = count.getInt();
        switch (intervalType) {
            case 0: {
                long nanos = this.nanos + intervalCount;
                if (nanos >= 0L && nanos < 1000000000L) {
                    tsResult.nanos = (int)nanos;
                    break;
                }
                int secondsInc = (int)(nanos / 1000000000L);
                tsResult.nanos = nanos >= 0L ? (int)(nanos % 1000000000L) : (int)(nanos -= (long)(--secondsInc) * 1000000000L);
                this.addInternal(13, secondsInc, tsResult);
                break;
            }
            case 1: {
                this.addInternal(13, intervalCount, tsResult);
                break;
            }
            case 2: {
                this.addInternal(12, intervalCount, tsResult);
                break;
            }
            case 3: {
                this.addInternal(10, intervalCount, tsResult);
                break;
            }
            case 4: {
                this.addInternal(5, intervalCount, tsResult);
                break;
            }
            case 5: {
                this.addInternal(5, intervalCount * 7, tsResult);
                break;
            }
            case 6: {
                this.addInternal(2, intervalCount, tsResult);
                break;
            }
            case 7: {
                this.addInternal(2, intervalCount * 3, tsResult);
                break;
            }
            case 8: {
                this.addInternal(1, intervalCount, tsResult);
                break;
            }
            default: {
                throw StandardException.newException("22008.S", (Object)ReuseFactory.getInteger(intervalType), (Object)"TIMESTAMPADD");
            }
        }
        return tsResult;
    }

    private void addInternal(int calIntervalType, int count, SQLTimestamp tsResult) throws StandardException {
        GregorianCalendar cal = ClientSharedData.getDefaultCalendar();
        this.setCalendar(cal);
        try {
            cal.add(calIntervalType, count);
            tsResult.encodedTime = SQLTime.computeEncodedTime(cal);
            tsResult.encodedDate = SQLDate.computeEncodedDate(cal);
        }
        catch (StandardException se) {
            String state = se.getSQLState();
            if (state != null && state.length() > 0 && "22007.S.180".startsWith(state)) {
                throw StandardException.newException("22003", (Object)"TIMESTAMP", (Object)null);
            }
            throw se;
        }
    }

    @Override
    public NumberDataValue timestampDiff(int intervalType, DateTimeDataValue time1, Date currentDate, NumberDataValue resultHolder) throws StandardException {
        if (resultHolder == null) {
            resultHolder = new SQLLongint();
        }
        if (this.isNull() || time1.isNull()) {
            resultHolder.setToNull();
            return resultHolder;
        }
        SQLTimestamp ts1 = SQLTimestamp.promote(time1, currentDate);
        GregorianCalendar cal = ClientSharedData.getDefaultCalendar();
        this.setCalendar(cal);
        long thisInSeconds = cal.getTime().getTime() / 1000L;
        ts1.setCalendar(cal);
        long ts1InSeconds = cal.getTime().getTime() / 1000L;
        long secondsDiff = thisInSeconds - ts1InSeconds;
        int nanosDiff = this.nanos - ts1.nanos;
        if (nanosDiff < 0 && secondsDiff > 0L) {
            --secondsDiff;
            nanosDiff += 1000000000;
        } else if (nanosDiff > 0 && secondsDiff < 0L) {
            ++secondsDiff;
            nanosDiff -= 1000000000;
        }
        long ldiff = 0L;
        switch (intervalType) {
            case 0: {
                ldiff = secondsDiff * 1000000000L + (long)nanosDiff;
                break;
            }
            case 1: {
                ldiff = secondsDiff;
                break;
            }
            case 2: {
                ldiff = secondsDiff / 60L;
                break;
            }
            case 3: {
                ldiff = secondsDiff / 3600L;
                break;
            }
            case 4: {
                ldiff = secondsDiff / 86400L;
                break;
            }
            case 5: {
                ldiff = secondsDiff / 604800L;
                break;
            }
            case 6: 
            case 7: {
                ldiff = Math.abs(secondsDiff) > 31622400L ? 12L * (secondsDiff / 31622400L) : secondsDiff / 2678400L;
                if (secondsDiff >= 0L) {
                    if (ldiff >= Integer.MAX_VALUE) {
                        throw StandardException.newException("22003", (Object)"INTEGER", (Object)null);
                    }
                    ((Calendar)cal).add(2, (int)(ldiff + 1L));
                    while (cal.getTime().getTime() / 1000L <= thisInSeconds) {
                        ((Calendar)cal).add(2, 1);
                        ++ldiff;
                    }
                } else {
                    if (ldiff <= Integer.MIN_VALUE) {
                        throw StandardException.newException("22003", (Object)"INTEGER", (Object)null);
                    }
                    ((Calendar)cal).add(2, (int)(ldiff - 1L));
                    while (cal.getTime().getTime() / 1000L >= thisInSeconds) {
                        ((Calendar)cal).add(2, -1);
                        --ldiff;
                    }
                }
                if (intervalType != 7) break;
                ldiff /= 3L;
                break;
            }
            case 8: {
                ldiff = secondsDiff / 31622400L;
                if (secondsDiff >= 0L) {
                    if (ldiff >= Integer.MAX_VALUE) {
                        throw StandardException.newException("22003", (Object)"INTEGER", (Object)null);
                    }
                    ((Calendar)cal).add(1, (int)(ldiff + 1L));
                    while (cal.getTime().getTime() / 1000L <= thisInSeconds) {
                        ((Calendar)cal).add(1, 1);
                        ++ldiff;
                    }
                } else {
                    if (ldiff <= Integer.MIN_VALUE) {
                        throw StandardException.newException("22003", (Object)"INTEGER", (Object)null);
                    }
                    ((Calendar)cal).add(1, (int)(ldiff - 1L));
                    while (cal.getTime().getTime() / 1000L >= thisInSeconds) {
                        ((Calendar)cal).add(1, -1);
                        --ldiff;
                    }
                }
                break;
            }
            default: {
                throw StandardException.newException("22008.S", (Object)ReuseFactory.getInteger(intervalType), (Object)"TIMESTAMPDIFF");
            }
        }
        resultHolder.setValue(ldiff);
        return resultHolder;
    }

    static SQLTimestamp promote(DateTimeDataValue dateTime, Date currentDate) throws StandardException {
        if (dateTime instanceof SQLTimestamp) {
            return (SQLTimestamp)dateTime;
        }
        if (dateTime instanceof SQLTime) {
            return new SQLTimestamp(SQLDate.computeEncodedDate(currentDate, null), ((SQLTime)dateTime).getEncodedTime(), 0);
        }
        if (dateTime instanceof SQLDate) {
            return new SQLTimestamp(((SQLDate)dateTime).getEncodedDate(), 0, 0);
        }
        return new SQLTimestamp(dateTime.getTimestamp(ClientSharedData.getDefaultCleanCalendar()));
    }

    @Override
    public final int getEncodedDate() {
        return this.encodedDate;
    }

    @Override
    public final int getEncodedTime() {
        return this.encodedTime;
    }

    @Override
    public final int getNanos() {
        return this.nanos;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        if (!this.isNull()) {
            out.writeByte(21);
            this.toDataForOptimizedResultHolder(out);
            return;
        }
        this.writeNullDVD(out);
    }

    @Override
    public final void fromDataForOptimizedResultHolder(DataInput dis) throws IOException, ClassNotFoundException {
        this.encodedDate = dis.readInt();
        this.encodedTime = dis.readInt();
        this.nanos = dis.readInt();
        this.valueString = null;
    }

    @Override
    public final void toDataForOptimizedResultHolder(DataOutput dos) throws IOException {
        assert (!this.isNull());
        dos.writeInt(this.encodedDate);
        dos.writeInt(this.encodedTime);
        dos.writeInt(this.nanos);
    }

    @Override
    public int writeBytes(byte[] outBytes, int offset, DataTypeDescriptor dtd) {
        assert (!this.isNull());
        int n = RowFormatter.writeInt(outBytes, this.encodedDate, offset);
        n += RowFormatter.writeInt(outBytes, this.encodedTime, offset + n);
        n += RowFormatter.writeInt(outBytes, this.nanos, offset + n);
        return n;
    }

    @Override
    public int readBytes(byte[] inBytes, int offset, int columnWidth) {
        this.valueString = null;
        this.encodedDate = RowFormatter.readInt(inBytes, offset);
        this.encodedTime = RowFormatter.readInt(inBytes, offset += 4);
        this.nanos = RowFormatter.readInt(inBytes, offset += 4);
        assert (columnWidth == 12);
        return 12;
    }

    @Override
    public int readBytes(UnsafeWrapper unsafe, long memOffset, int columnWidth, ByteSource bs) {
        this.valueString = null;
        this.encodedDate = RowFormatter.readInt(unsafe, memOffset);
        this.encodedTime = RowFormatter.readInt(unsafe, memOffset += 4L);
        this.nanos = RowFormatter.readInt(unsafe, memOffset += 4L);
        assert (columnWidth == 12);
        return 12;
    }

    @Override
    public int computeHashCode(int maxWidth, int hash) {
        assert (!this.isNull());
        int typeId = this.getTypeFormatId();
        hash = ResolverUtils.addIntToBucketHash((int)this.encodedDate, (int)hash, (int)typeId);
        hash = ResolverUtils.addIntToBucketHash((int)this.encodedTime, (int)hash, (int)typeId);
        return ResolverUtils.addIntToBucketHash((int)this.nanos, (int)hash, (int)typeId);
    }

    static final Timestamp getAsTimeStamp(byte[] bytes, int offset, Calendar cal) {
        int encodedDate = RowFormatter.readInt(bytes, offset);
        if (encodedDate == 0) {
            return null;
        }
        int encodedTime = RowFormatter.readInt(bytes, offset += 4);
        int nanos = RowFormatter.readInt(bytes, offset += 4);
        cal.clear();
        SQLDate.setDateInCalendar(cal, encodedDate);
        SQLTime.setTimeInCalendar(cal, encodedTime);
        cal.set(14, 0);
        Timestamp t = new Timestamp(cal.getTimeInMillis());
        t.setNanos(nanos);
        return t;
    }

    static final Timestamp getAsTimeStamp(UnsafeWrapper unsafe, long memOffset, Calendar cal) {
        int encodedDate = RowFormatter.readInt(unsafe, memOffset);
        if (encodedDate == 0) {
            return null;
        }
        int encodedTime = RowFormatter.readInt(unsafe, memOffset += 4L);
        int nanos = RowFormatter.readInt(unsafe, memOffset += 4L);
        cal.clear();
        SQLDate.setDateInCalendar(cal, encodedDate);
        SQLTime.setTimeInCalendar(cal, encodedTime);
        cal.set(14, 0);
        Timestamp t = new Timestamp(cal.getTimeInMillis());
        t.setNanos(nanos);
        return t;
    }

    static String getAsString(byte[] inBytes, int offset) {
        int encodedDate = RowFormatter.readInt(inBytes, offset);
        if (encodedDate == 0) {
            return null;
        }
        int encodedTime = RowFormatter.readInt(inBytes, offset += 4);
        int nanos = RowFormatter.readInt(inBytes, offset += 4);
        char[] str = new char[29];
        int strlen = SharedUtils.dateTimeToString((char[])str, (int)0, (int)SQLDate.getYear(encodedDate), (int)SQLDate.getMonth(encodedDate), (int)SQLDate.getDay(encodedDate), (int)SQLTime.getHour(encodedTime), (int)SQLTime.getMinute(encodedTime), (int)SQLTime.getSecond(encodedTime), (int)-1, (int)nanos, (boolean)false);
        return ClientSharedUtils.getJdkHelper().newWrappedString(str, 0, strlen);
    }

    static String getAsString(UnsafeWrapper unsafe, long memOffset) {
        int encodedDate = RowFormatter.readInt(unsafe, memOffset);
        if (encodedDate == 0) {
            return null;
        }
        int encodedTime = RowFormatter.readInt(unsafe, memOffset += 4L);
        int nanos = RowFormatter.readInt(unsafe, memOffset += 4L);
        char[] str = new char[29];
        int strlen = SharedUtils.dateTimeToString((char[])str, (int)0, (int)SQLDate.getYear(encodedDate), (int)SQLDate.getMonth(encodedDate), (int)SQLDate.getDay(encodedDate), (int)SQLTime.getHour(encodedTime), (int)SQLTime.getMinute(encodedTime), (int)SQLTime.getSecond(encodedTime), (int)-1, (int)nanos, (boolean)false);
        return ClientSharedUtils.getJdkHelper().newWrappedString(str, 0, strlen);
    }

    static void writeAsString(byte[] inBytes, int offset, ByteArrayDataOutput buffer) {
        int encodedDate = RowFormatter.readInt(inBytes, offset);
        if (encodedDate == 0) {
            return;
        }
        int encodedTime = RowFormatter.readInt(inBytes, offset += 4);
        int nanos = RowFormatter.readInt(inBytes, offset += 4);
        int bufferPos = buffer.ensureCapacity(26, buffer.position());
        SharedUtils.dateTimeToChars((byte[])buffer.getData(), (int)bufferPos, (int)SQLDate.getYear(encodedDate), (int)SQLDate.getMonth(encodedDate), (int)SQLDate.getDay(encodedDate), (int)SQLTime.getHour(encodedTime), (int)SQLTime.getMinute(encodedTime), (int)SQLTime.getSecond(encodedTime), (int)(nanos / 1000), (int)-1, (boolean)false);
        buffer.advance(26);
    }

    static void writeAsString(UnsafeWrapper unsafe, long memOffset, ByteArrayDataOutput buffer) {
        int encodedDate = RowFormatter.readInt(unsafe, memOffset);
        if (encodedDate == 0) {
            return;
        }
        int encodedTime = RowFormatter.readInt(unsafe, memOffset += 4L);
        int nanos = RowFormatter.readInt(unsafe, memOffset += 4L);
        int bufferPos = buffer.ensureCapacity(26, buffer.position());
        SharedUtils.dateTimeToChars((byte[])buffer.getData(), (int)bufferPos, (int)SQLDate.getYear(encodedDate), (int)SQLDate.getMonth(encodedDate), (int)SQLDate.getDay(encodedDate), (int)SQLTime.getHour(encodedTime), (int)SQLTime.getMinute(encodedTime), (int)SQLTime.getSecond(encodedTime), (int)(nanos / 1000), (int)-1, (boolean)false);
        buffer.advance(26);
    }

    static final Date getAsDate(byte[] inBytes, int offset, Calendar cal) {
        int encodedDate = RowFormatter.readInt(inBytes, offset);
        if (encodedDate == 0) {
            return null;
        }
        cal.clear();
        SQLDate.setDateInCalendar(cal, encodedDate);
        return new Date(cal.getTimeInMillis());
    }

    static final Date getAsDate(UnsafeWrapper unsafe, long memOffset, Calendar cal) {
        int encodedDate = RowFormatter.readInt(unsafe, memOffset);
        if (encodedDate == 0) {
            return null;
        }
        cal.clear();
        SQLDate.setDateInCalendar(cal, encodedDate);
        return new Date(cal.getTimeInMillis());
    }

    static final Time getAsTime(byte[] inBytes, int offset, Calendar cal) {
        int encodedDate = RowFormatter.readInt(inBytes, offset);
        if (encodedDate == 0) {
            return null;
        }
        int encodedTime = RowFormatter.readInt(inBytes, offset += 4);
        int nanos = RowFormatter.readInt(inBytes, offset += 4);
        return SQLTime.getTime(cal, encodedTime, nanos);
    }

    static final Time getAsTime(UnsafeWrapper unsafe, long memOffset, Calendar cal) {
        int encodedDate = RowFormatter.readInt(unsafe, memOffset);
        if (encodedDate == 0) {
            return null;
        }
        int encodedTime = RowFormatter.readInt(unsafe, memOffset += 4L);
        int nanos = RowFormatter.readInt(unsafe, memOffset += 4L);
        return SQLTime.getTime(cal, encodedTime, nanos);
    }

    @Override
    public byte getTypeId() {
        return 21;
    }
}

