/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.pivotal.gemfirexd.internal.iapi.types.HarmonySerialBlob;
import com.pivotal.gemfirexd.internal.impl.jdbc.ReaderToAscii;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class HarmonySerialClob
implements Clob,
Serializable,
Cloneable {
    private static final long serialVersionUID = -1662519690087375313L;
    private char[] buf;
    private long len;
    private transient boolean makeCopy;

    private HarmonySerialClob(int len, char[] ch) {
        this.buf = ch;
        this.len = len;
    }

    public static HarmonySerialClob wrapChars(char[] ch) {
        return new HarmonySerialClob(ch.length, ch);
    }

    public HarmonySerialClob(String raw) {
        char[] chars = raw.toCharArray();
        int charsLen = chars.length;
        this.buf = chars;
        this.len = charsLen;
    }

    public HarmonySerialClob(char[] ch) {
        this.buf = new char[ch.length];
        this.len = ch.length;
        System.arraycopy(ch, 0, this.buf, 0, (int)this.len);
    }

    public HarmonySerialClob(char[] ch, int length) {
        int chLen = ch.length;
        if (chLen == length) {
            this.buf = ch;
            this.len = chLen;
        } else {
            this.buf = new char[length];
            this.len = length;
            System.arraycopy(ch, 0, this.buf, 0, length);
        }
    }

    @Override
    public long length() throws SQLException {
        this.checkValidation();
        return this.len;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return new ReaderToAscii(this.getCharacterStream());
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.checkValidation();
        return new CharArrayReader(this.buf);
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        this.checkValidation();
        if (length < 0) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", new Object[]{new Integer(length)});
        }
        if (pos < 1L || pos > this.len + 1L || pos + (long)length > this.len + 1L) {
            throw HarmonySerialBlob.makeSQLException("XJ070.S", new Object[]{new Long(pos)});
        }
        try {
            this.makeCopy = true;
            return ClientSharedUtils.getJdkHelper().newWrappedString(this.buf, (int)pos - 1, length);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new SQLException();
        }
    }

    @Override
    public long position(Clob searchClob, long start) throws SQLException {
        this.checkValidation();
        String searchString = searchClob.getSubString(1L, (int)searchClob.length());
        return this.position(searchString, start);
    }

    @Override
    public long position(String searchString, long start) throws SQLException, SQLException {
        this.checkValidation();
        if (start < 1L || this.len - (start - 1L) < (long)searchString.length()) {
            return -1L;
        }
        char[] pattern = searchString.toCharArray();
        int i = (int)start - 1;
        while ((long)i < this.len) {
            if (this.match(this.buf, i, pattern)) {
                return i + 1;
            }
            ++i;
        }
        return -1L;
    }

    private boolean match(char[] chars, int start, char[] pattern) {
        int i = 0;
        while (i < pattern.length) {
            if (chars[start++] == pattern[i++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        this.checkValidation();
        throw Util.generateCsSQLException("0A000.S", "SerialClob: setAsciiStream");
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        this.checkValidation();
        throw Util.generateCsSQLException("0A000.S", "SerialClob: setCharacterStream");
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        this.checkValidation();
        return this.setString(pos, str, 0, str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int length) throws SQLException {
        this.checkValidation();
        if (pos < 1L) {
            throw HarmonySerialBlob.makeSQLException("XJ070.S", new Object[]{new Long(pos)});
        }
        if (length < 0) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", null);
        }
        if (pos > this.len + 1L) {
            throw HarmonySerialBlob.makeSQLException("XJ076.S", null);
        }
        if (offset < 0 || offset > str.length() - length) {
            throw HarmonySerialBlob.makeSQLException("XJ078.S", null);
        }
        if (pos > this.len - (long)length + 1L) {
            long newLen = (long)length + pos - 1L;
            char[] newBuf = new char[(int)newLen];
            System.arraycopy(this.buf, 0, newBuf, 0, (int)this.len);
            this.buf = newBuf;
            this.len = newLen;
            this.makeCopy = false;
        } else if (this.makeCopy) {
            char[] newBuf = new char[(int)this.len];
            System.arraycopy(this.buf, 0, newBuf, 0, (int)this.len);
            this.buf = newBuf;
            this.makeCopy = false;
        }
        str.getChars(offset, offset + length, this.buf, (int)pos - 1);
        return length;
    }

    @Override
    public void truncate(long length) throws SQLException {
        this.checkValidation();
        if (length < 0L) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", new Object[]{new Long(length)});
        }
        if (length > this.len) {
            throw HarmonySerialBlob.makeSQLException("XJ079.S", new Object[]{new Long(length)});
        }
        char[] truncatedBuffer = new char[(int)length];
        System.arraycopy(this.buf, 0, truncatedBuffer, 0, (int)length);
        this.buf = truncatedBuffer;
        this.len = length;
        this.makeCopy = false;
    }

    @Override
    public void free() throws SQLException {
        if (this.len != -1L) {
            this.len = -1L;
            this.buf = null;
            this.makeCopy = false;
        }
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        this.checkValidation();
        return new CharArrayReader(this.buf, (int)pos, (int)length);
    }

    private void checkValidation() throws SQLException {
        if (this.len == -1L) {
            throw HarmonySerialBlob.makeSQLException("XJ215.S", null);
        }
    }
}

