/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.gemstone.gemfire.cache.DiskStore;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;

public class GfxdDiskStoreDescriptor
extends TupleDescriptor {
    private final String diskStoreName;
    private final long maxLogSize;
    private final String autoCompact;
    private final String allowForceCompaction;
    private final int compactionThreshold;
    private final long timeInterval;
    private final int writeBufferSize;
    private final int queueSize;
    private final String dirAndSize;
    private final UUID id;

    public GfxdDiskStoreDescriptor(DataDictionary dd, UUID id, DiskStore ds, String dirAndSize) {
        super(dd);
        this.id = id;
        this.diskStoreName = ds.getName();
        this.maxLogSize = ds.getMaxOplogSize();
        this.autoCompact = Boolean.toString(ds.getAutoCompact());
        this.allowForceCompaction = Boolean.toString(ds.getAllowForceCompaction());
        this.compactionThreshold = ds.getCompactionThreshold();
        this.timeInterval = ds.getTimeInterval();
        this.writeBufferSize = ds.getWriteBufferSize();
        this.queueSize = ds.getQueueSize();
        this.dirAndSize = dirAndSize;
    }

    public GfxdDiskStoreDescriptor(DataDictionary dd, UUID id, String diskStoreName, long maxLogSize, String autoCompact, String allowForceCompaction, int compactionThreshold, long timeInterval, int writeBufferSize, int queueSize, String dirAndSize) {
        super(dd);
        this.id = id;
        this.diskStoreName = diskStoreName;
        this.maxLogSize = maxLogSize;
        this.autoCompact = autoCompact;
        this.allowForceCompaction = allowForceCompaction;
        this.compactionThreshold = compactionThreshold;
        this.timeInterval = timeInterval;
        this.writeBufferSize = writeBufferSize;
        this.queueSize = queueSize;
        this.dirAndSize = dirAndSize;
    }

    public UUID getUUID() {
        return this.id;
    }

    public String getDiskStoreName() {
        return this.diskStoreName;
    }

    public long getMaxLogSize() {
        return this.maxLogSize;
    }

    public String getAutocompact() {
        return this.autoCompact;
    }

    public String getAllowForceCompaction() {
        return this.allowForceCompaction;
    }

    public int getCompactionThreshold() {
        return this.compactionThreshold;
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public String getDirPathAndSize() {
        return this.dirAndSize;
    }

    @Override
    public String getDescriptorType() {
        return "DiskStore";
    }

    @Override
    public String getDescriptorName() {
        return this.diskStoreName;
    }

    public String toString() {
        return "DiskStore: name=" + this.diskStoreName + ",maxLogSize=" + this.maxLogSize + ",autoCompact=" + this.autoCompact + ",allowForceCompaction=" + this.allowForceCompaction + ",compactionThreshold=" + this.compactionThreshold + ",timeInterval=" + this.timeInterval + ",writeBufferSize=" + this.writeBufferSize + ",queueSize=" + this.queueSize + ",dirPathAndSize=" + this.dirAndSize;
    }
}

