/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Scope;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import java.util.Properties;

public abstract class CatalogRowFactory {
    protected String[] indexNames;
    protected int[][] indexColumnPositions;
    protected boolean[] indexUniqueness;
    protected UUID tableUUID;
    protected UUID heapUUID;
    protected UUID[] indexUUID;
    protected DataValueFactory dvf;
    private final ExecutionFactory ef;
    private UUIDFactory uuidf;
    private int indexCount;
    private int columnCount;
    private String catalogName;

    public CatalogRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        this.uuidf = uuidf;
        this.dvf = dvf;
        this.ef = ef;
    }

    public ExecutionFactory getExecutionFactory() {
        return this.ef;
    }

    public UUIDFactory getUUIDFactory() {
        return this.uuidf;
    }

    public UUID getCanonicalTableUUID() {
        return this.tableUUID;
    }

    public UUID getCanonicalHeapUUID() {
        return this.heapUUID;
    }

    public UUID getCanonicalIndexUUID(int indexNumber) {
        return this.indexUUID[indexNumber];
    }

    public int getIndexColumnCount(int indexNum) {
        return this.indexColumnPositions[indexNum].length;
    }

    public String getCanonicalHeapName() {
        return this.catalogName + "_HEAP";
    }

    public String getIndexName(int indexNum) {
        return this.indexNames[indexNum];
    }

    public boolean isIndexUnique(int indexNumber) {
        return this.indexUniqueness != null ? this.indexUniqueness[indexNumber] : true;
    }

    public DataValueFactory getDataValueFactory() {
        return this.dvf;
    }

    public String generateIndexName(int indexNumber) {
        return this.catalogName + "_INDEX" + ++indexNumber;
    }

    public int getNumIndexes() {
        return this.indexCount;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void initInfo(int columnCount, String catalogName, int[][] indexColumnPositions, boolean[] indexUniqueness, String[] uuidStrings) {
        this.indexCount = indexColumnPositions != null ? indexColumnPositions.length : 0;
        this.catalogName = catalogName;
        this.columnCount = columnCount;
        UUIDFactory uf = this.getUUIDFactory();
        this.tableUUID = uf.recreateUUID(uuidStrings[0]);
        this.heapUUID = uf.recreateUUID(uuidStrings[1]);
        if (this.indexCount > 0) {
            this.indexNames = new String[this.indexCount];
            this.indexUUID = new UUID[this.indexCount];
            for (int ictr = 0; ictr < this.indexCount; ++ictr) {
                this.indexNames[ictr] = this.generateIndexName(ictr);
                this.indexUUID[ictr] = uf.recreateUUID(uuidStrings[ictr + 2]);
            }
            this.indexColumnPositions = indexColumnPositions;
            this.indexUniqueness = indexUniqueness;
        }
    }

    public Properties getCreateHeapProperties() {
        Properties properties = new Properties();
        properties.put("gemfirexd.storage.pageSize", "1024");
        properties.put("gemfirexd.storage.pageReservedSpace", "0");
        properties.put("gemfirexd.storage.minimumRecordSize", "1");
        AttributesFactory af = new AttributesFactory();
        af.setScope(Scope.LOCAL);
        af.setConcurrencyChecksEnabled(false);
        properties.put("GEMFIRE_REGION_ATTRIBUTES", af.create());
        return properties;
    }

    public Properties getCreateIndexProperties(int indexNumber) {
        Properties properties = new Properties();
        properties.put("gemfirexd.storage.pageSize", "1024");
        return properties;
    }

    public int getPrimaryKeyIndexNumber() {
        SanityManager.NOTREACHED();
        return 0;
    }

    public final int getHeapColumnCount() {
        return this.columnCount;
    }

    public ExecRow makeEmptyRow() throws StandardException {
        return this.makeRow(null, null);
    }

    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        SanityManager.THROWASSERT((String)"Should not get here.");
        return null;
    }

    public abstract TupleDescriptor buildDescriptor(ExecRow var1, TupleDescriptor var2, DataDictionary var3) throws StandardException;

    public abstract SystemColumn[] buildColumnList() throws StandardException;

    public int[] getIndexColumnPositions(int indexNumber) {
        return this.indexColumnPositions[indexNumber];
    }
}

