/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store.offheap;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.DataInputStreamBase;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.BytesAndBitsForCompactor;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.offheap.ByteSource;
import com.gemstone.gemfire.internal.offheap.OffHeapRegionEntryHelper;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.gemstone.gemfire.internal.offheap.UnsafeMemoryChunk;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.RegionEntryUtils;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRow;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRowWithLobs;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;

public abstract class OffHeapByteSource
extends SimpleMemoryAllocatorImpl.Chunk
implements ByteSource {
    protected OffHeapByteSource(long address, int chunkSize, SimpleMemoryAllocatorImpl.ChunkType chunkType) {
        super(address, chunkSize, chunkType);
    }

    protected OffHeapByteSource(long address) {
        super(address);
    }

    final byte[] getFullDataBytes() {
        int dataSize = this.getDataSize();
        byte[] result = new byte[dataSize];
        super.readBytes(0, result, 0, dataSize);
        SimpleMemoryAllocatorImpl.getAllocator().getStats().incReads();
        return result;
    }

    public long getUnsafeAddress(int offset, int size) {
        return super.getUnsafeBaseAddress(offset, size);
    }

    public long getUnsafeAddress() {
        return this.memoryAddress + 8L;
    }

    public final byte readByte(int offset) {
        return super.readByte(offset + this.getOffsetAdjustment());
    }

    public final void readBytes(int offset, byte[] bytes, int bytesOffset, int size) {
        super.readBytes(offset + this.getOffsetAdjustment(), bytes, bytesOffset, size);
    }

    public final byte[] getRowBytes() {
        return OffHeapByteSource.getBaseRowBytes(UnsafeMemoryChunk.getUnsafeWrapper(), this.getBaseDataAddress() + (long)this.getOffsetAdjustment(), this.getLength());
    }

    public static final boolean isOffHeapBytesClass(Class<?> c) {
        return c == OffHeapRow.class || c == OffHeapRowWithLobs.class;
    }

    public abstract Object getDeserializedValue(Region var1, RegionEntry var2);

    public void toData(DataOutput out) throws IOException {
        if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("OffHeapByteSource.toData: serializing offheap byte source=" + (Object)((Object)this)));
        }
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int offsetAdjustment = this.getOffsetAdjustment();
        int len = OffHeapByteSource.getDataSize((UnsafeWrapper)unsafe, (long)this.memoryAddress) - offsetAdjustment;
        OffHeapByteSource.serializeBaseRowBytes(unsafe, this.getBaseDataAddress() + (long)offsetAdjustment, len, out);
        SimpleMemoryAllocatorImpl.getAllocator().getStats().incReads();
    }

    public void sendTo(DataOutput out) throws IOException {
        out.writeByte(46);
        this.toData(out);
    }

    public final void fillSerializedValue(BytesAndBitsForCompactor wrapper, byte userBits) {
        byte[] value = this.getRawBytes();
        wrapper.setData(value, userBits, value.length, true);
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public int getLength() {
        return OffHeapByteSource.getDataSize((UnsafeWrapper)UnsafeMemoryChunk.getUnsafeWrapper(), (long)this.memoryAddress);
    }

    public final boolean isSerialized() {
        return this.isWithLobs();
    }

    public boolean isWithLobs() {
        return false;
    }

    public abstract int readNumLobsColumns(boolean var1);

    public long readAddressForLob(int index) {
        throw new UnsupportedOperationException("readAddressForLob only supported on OffHeapRowWithLobs but this is: " + ((Object)((Object)this)).getClass());
    }

    public long readAddressForLobIfPresent(int index) {
        return 0L;
    }

    public final Object getGfxdByteSource(int index) {
        if (index != 0) {
            long address = this.readAddressForLobIfPresent(index);
            if (address != 0L) {
                return RegionEntryUtils.convertLOBAddresstoByteSourceNoRetain(address);
            }
            return null;
        }
        return this;
    }

    public final byte[] getGfxdBytes(int index) {
        if (index != 0) {
            long address = this.readAddressForLobIfPresent(index);
            if (address != 0L) {
                return RegionEntryUtils.convertLOBAddresstoBytes(UnsafeMemoryChunk.getUnsafeWrapper(), address);
            }
            return null;
        }
        return this.getRowBytes();
    }

    public final void serializeGfxdBytes(int index, DataOutput out) throws IOException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        if (index != 0) {
            long address = this.readAddressForLobIfPresent(index);
            if (address != 0L) {
                RegionEntryUtils.serializeLOBAddresstoBytes(unsafe, address, out);
            } else {
                InternalDataSerializer.writeByteArray(null, (DataOutput)out);
            }
        } else {
            OffHeapByteSource.serializeBaseRowBytes(unsafe, this.getBaseDataAddress() + (long)this.getOffsetAdjustment(), this.getLength(), out);
        }
    }

    public final void serializeGfxdBytesWithStats(int index, DataOutput out) throws IOException {
        this.serializeGfxdBytes(index, out);
        SimpleMemoryAllocatorImpl.getAllocator().getStats().incReads();
    }

    public final byte[][] getRowByteArrays() {
        int numLobs = this.readNumLobsColumns(true);
        byte[][] value = new byte[numLobs + 1][];
        value[0] = this.getRowBytes();
        for (int i = 1; i <= numLobs; ++i) {
            value[i] = this.getGfxdBytes(i);
        }
        return value;
    }

    public int getOffsetAdjustment() {
        return 0;
    }

    public static byte[] getBaseRowBytes(UnsafeWrapper unsafe, long baseAddr, int bytesLen) {
        byte[] result = new byte[bytesLen];
        UnsafeMemoryChunk.readUnsafeBytes((UnsafeWrapper)unsafe, (long)baseAddr, (byte[])result, (int)bytesLen);
        SimpleMemoryAllocatorImpl.getAllocator().getStats().incReads();
        return result;
    }

    public static void serializeBaseRowBytes(UnsafeWrapper unsafe, long baseAddr, int bytesLen, DataOutput out) throws IOException {
        InternalDataSerializer.writeArrayLength((int)bytesLen, (DataOutput)out);
        OffHeapRegionEntryHelper.copyBytesToDataOutput((UnsafeWrapper)unsafe, (long)baseAddr, (int)bytesLen, (DataOutput)out);
        SimpleMemoryAllocatorImpl.getAllocator().getStats().incReads();
    }

    protected byte[] getRawBytes() {
        return this.getRowBytes();
    }

    public String toString() {
        return this.toStringForOffHeapByteSource();
    }

    public final DataInput getDataInputStreamWrapper(int startPos, final int streamSize) {
        SimpleMemoryAllocatorImpl.getAllocator().getStats().incReads();
        return new DataInputStreamBase(startPos){
            private final long baseAddr;
            {
                super(x0);
                this.baseAddr = OffHeapByteSource.this.getUnsafeAddress();
            }

            public final int read() throws IOException {
                if (this.pos < streamSize) {
                    long currAddr = this.baseAddr + (long)this.pos;
                    ++this.pos;
                    return UnsafeMemoryChunk.getUnsafeWrapper().getByte(currAddr) & 0xFF;
                }
                return -1;
            }

            public final int read(byte[] b, int off, int len) {
                if (b == null) {
                    throw new NullPointerException();
                }
                if (off < 0 || len < 0 || b.length < off + len) {
                    throw new IndexOutOfBoundsException();
                }
                int capacity = streamSize - this.pos;
                if (len > capacity) {
                    if (capacity == 0 && len > 0) {
                        return -1;
                    }
                    len = capacity;
                }
                if (len > 0) {
                    OffHeapByteSource.this.readBytes(this.pos, b, off, len);
                    this.pos += len;
                    return len;
                }
                return 0;
            }

            public final long skip(long n) {
                return this.skipOver(n, streamSize);
            }

            public final int available() {
                return streamSize - this.pos;
            }

            public int skipBytes(int n) throws IOException {
                return this.skipOver(n, streamSize);
            }

            public final int readUnsignedShort() throws IOException {
                long currentAddr = this.baseAddr + (long)this.pos;
                this.pos += 2;
                UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
                byte firstByte = unsafe.getByte(currentAddr);
                byte secondByte = unsafe.getByte(++currentAddr);
                return (firstByte & 0xFF) << 8 | secondByte & 0xFF;
            }

            public int readUnsignedByte() throws IOException {
                long currAddr = this.baseAddr + (long)this.pos;
                ++this.pos;
                return UnsafeMemoryChunk.getUnsafeWrapper().getByte(currAddr) & 0xFF;
            }

            public String readUTF() throws IOException {
                int utfLen = this.readUnsignedShort();
                if (this.pos + utfLen <= streamSize) {
                    int char1;
                    long memPos;
                    if (this.charBuf == null || this.charBuf.length < utfLen) {
                        int charBufLength = (utfLen / 2 + 1) * 3;
                        this.charBuf = new char[charBufLength];
                    }
                    char[] chars = this.charBuf;
                    UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
                    long currentAddr = memPos = this.baseAddr + (long)this.pos;
                    long addrLimit = currentAddr + (long)utfLen;
                    int nChars = 0;
                    while (currentAddr < addrLimit && (char1 = unsafe.getByte(currentAddr) & 0xFF) < 128) {
                        chars[nChars] = (char)char1;
                        ++currentAddr;
                        ++nChars;
                    }
                    while (currentAddr < addrLimit) {
                        char1 = unsafe.getByte(currentAddr) & 0xFF;
                        switch (char1 >> 5) {
                            case 6: {
                                byte char2;
                                if (currentAddr + 1L < addrLimit) {
                                    if (((char2 = unsafe.getByte(++currentAddr)) & 0xC0) == 128) {
                                        chars[nChars] = (char)((char1 & 0x1F) << 6 | char2 & 0x3F);
                                        break;
                                    }
                                    this.throwUTFEncodingError((int)(currentAddr - memPos), char1, char2, null, 2);
                                    break;
                                }
                                throw new UTFDataFormatException("partial 2-byte character at end (char1=" + char1 + ')');
                            }
                            case 7: {
                                byte char2;
                                if (currentAddr + 2L < addrLimit) {
                                    if (((char2 = unsafe.getByte(++currentAddr)) & 0xC0) == 128) {
                                        byte char3;
                                        if (((char3 = unsafe.getByte(++currentAddr)) & 0xC0) == 128) {
                                            chars[nChars] = (char)((char1 & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                                            break;
                                        }
                                        this.throwUTFEncodingError((int)(currentAddr - memPos), char1, char2, Integer.valueOf(char3), 3);
                                        break;
                                    }
                                    this.throwUTFEncodingError((int)(currentAddr - memPos), char1, char2, null, 3);
                                    break;
                                }
                                throw new UTFDataFormatException("partial 3-byte character at end (char1=" + char1 + ')');
                            }
                            default: {
                                chars[nChars] = (char)char1;
                            }
                        }
                        ++currentAddr;
                        ++nChars;
                    }
                    this.pos = (int)(addrLimit - memPos);
                    return new String(chars, 0, nChars);
                }
                throw new EOFException();
            }

            public final short readShort() throws IOException {
                long currentAddr = this.baseAddr + (long)this.pos;
                this.pos += 2;
                UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
                byte high = unsafe.getByte(currentAddr);
                byte low = unsafe.getByte(++currentAddr);
                return (short)(high << 8 | low & 0xFF);
            }

            public final long readLong() throws IOException {
                long currentAddr = this.baseAddr + (long)this.pos;
                this.pos += 8;
                UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
                return OffHeapRegionEntryHelper.NATIVE_BYTE_ORDER_IS_LITTLE_ENDIAN ? Long.reverseBytes(unsafe.getLong(currentAddr)) : unsafe.getLong(currentAddr);
            }

            public final int readInt() throws IOException {
                long currentAddr = this.baseAddr + (long)this.pos;
                this.pos += 4;
                UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
                return OffHeapRegionEntryHelper.NATIVE_BYTE_ORDER_IS_LITTLE_ENDIAN ? Integer.reverseBytes(unsafe.getInt(currentAddr)) : unsafe.getInt(currentAddr);
            }

            public void readFully(byte[] bytes, int offset, int length) throws IOException {
                OffHeapByteSource.this.readBytes(this.pos, bytes, offset, length);
                this.pos += length;
            }

            public void readFully(byte[] bytes) throws IOException {
                OffHeapByteSource.this.readBytes(this.pos, bytes);
                this.pos += bytes.length;
            }

            public float readFloat() throws IOException {
                int intbits = this.readInt();
                return Float.intBitsToFloat(intbits);
            }

            public double readDouble() throws IOException {
                long longbits = this.readLong();
                return Double.longBitsToDouble(longbits);
            }

            public char readChar() throws IOException {
                long currentAddr = this.baseAddr + (long)this.pos;
                this.pos += 2;
                UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
                byte first = unsafe.getByte(currentAddr);
                byte second = unsafe.getByte(++currentAddr);
                return (char)(first << 8 | second & 0xFF);
            }

            public byte readByte() throws IOException {
                long currentAddr = this.baseAddr + (long)this.pos;
                ++this.pos;
                return UnsafeMemoryChunk.getUnsafeWrapper().getByte(currentAddr);
            }

            public boolean readBoolean() throws IOException {
                long currentAddr = this.baseAddr + (long)this.pos;
                ++this.pos;
                return UnsafeMemoryChunk.getUnsafeWrapper().getByte(currentAddr) != 0;
            }
        };
    }

    public Object getValueAsDeserializedHeapObject() {
        return this.getDeserializedValue(null, null);
    }

    public byte[] getValueAsHeapByteArray() {
        return this.getRowBytes();
    }

    public static int getUnsignedCompactIntNumBytes(int data) {
        int numBytes = 1;
        while ((data & 0xFFFFFF80) != 0) {
            ++numBytes;
            data >>>= 7;
        }
        return numBytes;
    }
}

