/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gemfire.DataSerializer;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.RegionAndKey;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.ResultWasNull;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TreeSet;

public final class CompactExecRow
extends AbstractCompactExecRow {
    private static final long serialVersionUID = -8506169648261047433L;
    private byte[] source;

    public CompactExecRow() {
    }

    CompactExecRow(RowFormatter rf) {
        super(rf);
        this.source = null;
        assert (rf.isTableFormatter() || !rf.hasLobs()) : "use a CompactExecRowWithLobs instead";
    }

    CompactExecRow(DataValueDescriptor[] dvds, RowFormatter rf) throws StandardException {
        super(rf);
        assert (rf.isTableFormatter() || !rf.hasLobs()) : "use a CompactExecRowWithLobs instead";
        this.source = (byte[])(dvds != null ? rf.generateBytes(dvds) : null);
    }

    CompactExecRow(byte[] bytes, RowFormatter rf) {
        super(rf);
        this.source = bytes;
        assert (rf.isTableFormatter() || !rf.hasLobs()) : "use a CompactExecRowWithLobs instead";
    }

    CompactExecRow(byte[] bytes, RowFormatter rf, DataValueDescriptor[] row, int rowLen, boolean doClone) {
        super(rf, row, rowLen, doClone);
        this.source = bytes;
        assert (rf.isTableFormatter() || !rf.hasLobs()) : "use a CompactExecRowWithLobs instead";
    }

    @Override
    public final byte[] getRowBytes() {
        return this.source;
    }

    @Override
    public final byte[] getRowBytes(int logicalPosition) {
        return this.source;
    }

    @Override
    public final boolean hasByteArrays() {
        return false;
    }

    public final byte[] getRawRowValue(boolean doClone) {
        if (doClone) {
            byte[] source = this.source;
            if (source != null) {
                byte[] newBytes = new byte[source.length];
                System.arraycopy(source, 0, newBytes, 0, source.length);
                return newBytes;
            }
            return null;
        }
        return this.source;
    }

    @Override
    protected final DataValueDescriptor basicGetColumn(int position) throws StandardException {
        return this.formatter.getColumn(position, this.source);
    }

    @Override
    protected final void basicSetColumns(FormatableBitSet columns, DataValueDescriptor[] values) throws StandardException {
        if (values.length > 0) {
            this.source = this.formatter.setColumns(columns, values, this.source, this.formatter);
        } else assert (this.formatter.getNumColumns() == 0) : "if none of the values are set such a condition can happen when DTD is also nothing";
    }

    @Override
    protected void basicSetColumn(int columnIndex, DataValueDescriptor value) throws StandardException {
        this.source = this.formatter.setColumn(columnIndex, value, this.source, this.formatter);
    }

    @Override
    protected final void basicSetCompactColumns(FormatableBitSet columns, DataValueDescriptor[] values) throws StandardException {
        this.source = this.formatter.setByteCompactColumns(columns, values);
    }

    @Override
    protected final void basicSetColumns(int nCols, DataValueDescriptor[] values) throws StandardException {
        if (values.length > 0) {
            this.source = this.formatter.setColumns(nCols, values, this.source);
        } else assert (this.formatter.getNumColumns() == 0) : "if none of the values are set such a condition can happen when DTD is also nothing";
    }

    @Override
    protected final void basicSetColumns(FormatableBitSet columns, AbstractCompactExecRow srcRow, int[] baseColumnMap) throws StandardException {
        this.source = this.formatter.setColumns(columns, srcRow.getRowBytes(), srcRow.formatter, baseColumnMap);
    }

    @Override
    protected final void basicSetColumns(int[] columns, boolean zeroBased, AbstractCompactExecRow srcRow) throws StandardException {
        this.source = this.formatter.setColumns(columns, zeroBased, srcRow.getRowBytes(), srcRow.formatter);
    }

    @Override
    protected final void basicSetColumns(int nCols, AbstractCompactExecRow srcRow) throws StandardException {
        this.source = this.formatter.setColumns(nCols, srcRow.getRowBytes(), srcRow.formatter);
    }

    @Override
    protected final void basicResetRowArray() {
        this.source = null;
        if (this.setOfKeys != null) {
            this.setOfKeys.clear();
        }
    }

    @Override
    protected final DataValueDescriptor[] basicGetRowArray() {
        try {
            return this.formatter.getAllColumns(this.source);
        }
        catch (StandardException e) {
            throw GemFireXDRuntimeException.newRuntimeException("CompactExecRow#getRowArray: unexpected exception", e);
        }
    }

    @Override
    protected final void basicSetRowArray(ExecRow otherRow) {
        if (!(otherRow instanceof AbstractCompactExecRow)) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        this.basicSetRowArray((AbstractCompactExecRow)otherRow);
    }

    @Override
    protected final void basicSetRowArray(AbstractCompactExecRow otherRow) {
        if (this.formatter != otherRow.formatter) {
            this.formatter = otherRow.formatter;
        }
        assert (otherRow instanceof CompactExecRow) : "unexpected otherRow (" + otherRow.getClass() + "): " + otherRow;
        this.source = otherRow.getRowBytes();
    }

    @Override
    protected final void basicSetRowArray(byte[] rowArray, RowFormatter formatter) {
        this.source = rowArray;
        if (this.formatter != formatter) {
            this.formatter = formatter;
        }
    }

    @Override
    protected void basicSetRowArray(byte[][] rowArray, RowFormatter formatter) {
        if (this.formatter.container != formatter.container) {
            throw new UnsupportedOperationException("CompactExecRow does not support byte[][]");
        }
        this.basicSetRowArray(rowArray[0], formatter);
    }

    @Override
    protected void basicSetDVDValues(DataValueDescriptor[] dvds, int[] srcColumns, boolean zeroBased) throws StandardException {
        super.basicSetDVDValues(dvds, srcColumns, zeroBased, this.source);
    }

    @Override
    protected final byte[][] getRowByteArrays() {
        throw new UnsupportedOperationException("CompactExecRow does not support byte[][]");
    }

    @Override
    protected final byte[][] getRowByteArraysIfPresent() {
        return null;
    }

    @Override
    protected String getString(int position, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsString(position, this.source, wasNull);
    }

    @Override
    protected Object getObject(int position, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsObject(position, this.source, wasNull);
    }

    @Override
    protected boolean getBoolean(int position, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsBoolean(position, this.source, wasNull);
    }

    @Override
    protected byte getByte(int position, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsByte(position, this.source, wasNull);
    }

    @Override
    protected short getShort(int position, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsShort(position, this.source, wasNull);
    }

    @Override
    protected int getInt(int position, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsInt(position, this.source, wasNull);
    }

    @Override
    protected long getLong(int position, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsLong(position, this.source, wasNull);
    }

    @Override
    protected float getFloat(int position, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsFloat(position, this.source, wasNull);
    }

    @Override
    protected double getDouble(int position, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsDouble(position, this.source, wasNull);
    }

    @Override
    protected byte[] getBytes(int position, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsBytes(position, this.source, wasNull);
    }

    @Override
    protected BigDecimal getBigDecimal(int position, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsBigDecimal(position, this.source, wasNull);
    }

    @Override
    protected Date getDate(int position, Calendar cal, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsDate(position, this.source, cal, wasNull);
    }

    @Override
    protected Time getTime(int position, Calendar cal, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsTime(position, this.source, cal, wasNull);
    }

    @Override
    protected Timestamp getTimestamp(int position, Calendar cal, ResultWasNull wasNull) throws StandardException {
        return this.formatter.getAsTimestamp(position, this.source, cal, wasNull);
    }

    @Override
    public final void setRowArrayClone(ExecRow otherRow, TreeSet<RegionAndKey> allKeys) {
        if (otherRow instanceof AbstractCompactExecRow) {
            this.basicSetRowArray((AbstractCompactExecRow)otherRow);
            this.clearCachedRow();
        } else {
            this.setRowArray(otherRow.getRowArray());
        }
        this.setOfKeys = allKeys;
    }

    @Override
    public final CompactExecRow getClone() {
        CompactExecRow row = new CompactExecRow(this.source, this.formatter);
        row.setOfKeys = this.setOfKeys;
        return row;
    }

    @Override
    public final CompactExecRow getShallowClone() {
        return this.getClone();
    }

    @Override
    public final CompactExecRow getNewNullRow() {
        return new CompactExecRow(this.formatter);
    }

    @Override
    public final int compare(ExecRow row, int logicalPosition, long thisOffsetWidth, boolean nullsOrderedLow) throws StandardException {
        return this.compare(row, this.source, logicalPosition, thisOffsetWidth, nullsOrderedLow);
    }

    @Override
    public final int compare(ExecRow row, int logicalPosition, boolean nullsOrderedLow) throws StandardException {
        byte[] bytes = this.source;
        return super.compare(row, bytes, logicalPosition, this.formatter.getOffsetAndWidth(logicalPosition, bytes), nullsOrderedLow);
    }

    @Override
    public final int computeHashCode(int position, int hash) {
        return this.formatter.computeHashCode(position, this.source, hash);
    }

    @Override
    public long isNull(int logicalPosition) throws StandardException {
        return this.formatter.getOffsetAndWidth(logicalPosition, this.source);
    }

    @Override
    public byte getGfxdID() {
        return 86;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        throw new UnsupportedOperationException("CompactExecRow does not support toData()");
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.source = DataSerializer.readByteArray((DataInput)in);
    }

    public byte[] getByteSource() {
        return this.source;
    }

    public byte[] getByteSource(int offset) {
        return this.source;
    }

    @Override
    void basicSetByteSource(Object source) {
        throw new UnsupportedOperationException("CompactExecRow does not support setByteSource");
    }

    @Override
    public void releaseByteSource() {
        this.source = null;
    }

    public byte[] getBaseByteSource() {
        return this.source;
    }
}

