/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.AbstractRegionEntry;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.concurrent.AtomicUpdaterFactory;
import com.gemstone.gemfire.internal.offheap.OffHeapHelper;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.gemstone.gemfire.internal.offheap.UnsafeMemoryChunk;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraInfo;
import com.pivotal.gemfirexd.internal.engine.store.RegionEntryUtils;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRowWithLobs;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public abstract class CompactCompositeKey
extends AtomicReference<byte[]>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private volatile Object valueBytes;
    public transient ExtraInfo tableInfo;
    private static final AtomicReferenceFieldUpdater<CompactCompositeKey, Object> valBytesUpdater = AtomicUpdaterFactory.newReferenceFieldUpdater(CompactCompositeKey.class, Object.class, (String)"valueBytes");
    public static final int MAX_TRIES = 10000000;
    public static final int MAX_TRIES_YIELD = 1000;

    public CompactCompositeKey(Object value, ExtraInfo tabInfo) {
        this.valueBytes = value;
        this.tableInfo = tabInfo;
    }

    public CompactCompositeKey(ExtraInfo tabInfo, byte[] keyBytes) {
        super(keyBytes);
        this.tableInfo = tabInfo;
    }

    public CompactCompositeKey(DataValueDescriptor[] value, ExtraInfo tabInfo) throws StandardException {
        super(tabInfo.getPrimaryKeyFormatter().generateBytesWithIdenticalDVDTypes(value));
        this.tableInfo = tabInfo;
        assert (this.tableInfo != null);
    }

    public CompactCompositeKey(DataValueDescriptor value, ExtraInfo tabInfo) throws StandardException {
        super(tabInfo.getPrimaryKeyFormatter().generateBytesWithIdenticalDVDType(value));
        this.tableInfo = tabInfo;
        assert (this.tableInfo != null);
    }

    public CompactCompositeKey() {
    }

    public final int nCols() {
        ExtraInfo tabInfo = this.tableInfo;
        if (tabInfo != null) {
            return tabInfo.getPrimaryKeyColumns().length;
        }
        throw RegionEntryUtils.checkCacheForNullTableInfo("CompactCompositeKey#nCols()");
    }

    public final ExtraInfo getExtraInfo() {
        return this.tableInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DataValueDescriptor getKeyColumn(int index) {
        int tries = 1;
        do {
            DataValueDescriptor dvd;
            SimpleMemoryAllocatorImpl.skipRefCountTracking();
            Object vbs = this.getValueByteSource();
            SimpleMemoryAllocatorImpl.unskipRefCountTracking();
            try {
                dvd = RegionEntryUtils.entryKeyColumn(this.getKeyBytes(), vbs, this.tableInfo, index);
            }
            finally {
                SimpleMemoryAllocatorImpl.skipRefCountTracking();
                this.releaseValueByteSource(vbs);
                SimpleMemoryAllocatorImpl.unskipRefCountTracking();
            }
            if (dvd != null) {
                return dvd;
            }
            if (tries % 1000 != 0) continue;
            Thread.yield();
        } while (tries++ <= 10000000);
        throw RegionEntryUtils.checkCacheForNullKeyValue("CompactCompositeKey#getKeyColumn(int)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setKeyColumn(DataValueDescriptor dvd, int index) {
        int tries = 1;
        do {
            SimpleMemoryAllocatorImpl.skipRefCountTracking();
            Object vbs = this.getValueByteSource();
            SimpleMemoryAllocatorImpl.unskipRefCountTracking();
            try {
                if (RegionEntryUtils.entrySetKeyColumn(dvd, this.getKeyBytes(), vbs, this.tableInfo, index)) {
                    return;
                }
            }
            finally {
                SimpleMemoryAllocatorImpl.skipRefCountTracking();
                this.releaseValueByteSource(vbs);
                SimpleMemoryAllocatorImpl.unskipRefCountTracking();
            }
            if (tries % 1000 != 0) continue;
            Thread.yield();
        } while (tries++ <= 10000000);
        throw RegionEntryUtils.checkCacheForNullKeyValue("CompactCompositeKey#getKeyColumn(int)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void getKeyColumns(DataValueDescriptor[] keys) {
        int tries = 1;
        do {
            SimpleMemoryAllocatorImpl.skipRefCountTracking();
            Object vbs = this.getValueByteSource();
            SimpleMemoryAllocatorImpl.unskipRefCountTracking();
            try {
                if (RegionEntryUtils.entryKeyColumns(this.getKeyBytes(), vbs, this.tableInfo, keys)) {
                    return;
                }
            }
            finally {
                SimpleMemoryAllocatorImpl.skipRefCountTracking();
                this.releaseValueByteSource(vbs);
                SimpleMemoryAllocatorImpl.unskipRefCountTracking();
            }
            if (tries % 1000 != 0) continue;
            Thread.yield();
        } while (tries++ <= 10000000);
        throw RegionEntryUtils.checkCacheForNullKeyValue("CompactCompositeKey#getKeyColumns(DataValueDescriptor[])");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void getKeyColumns(Object[] keyObjects) throws StandardException {
        ExtraInfo tabInfo = this.tableInfo;
        if (tabInfo != null) {
            int tries = 1;
            do {
                SimpleMemoryAllocatorImpl.skipRefCountTracking();
                Object vbytes = this.getValueByteSource();
                SimpleMemoryAllocatorImpl.unskipRefCountTracking();
                if (vbytes != null) {
                    if (vbytes.getClass() == byte[].class) {
                        byte[] bytes = (byte[])vbytes;
                        RowFormatter rf = tabInfo.getRowFormatter(bytes);
                        int[] keyPositions = tabInfo.getPrimaryKeyColumns();
                        for (int index = 0; index < keyObjects.length; ++index) {
                            keyObjects[index] = rf.getAsObject(keyPositions[index], bytes, null);
                        }
                        return;
                    }
                    OffHeapByteSource ohbytes = (OffHeapByteSource)((Object)vbytes);
                    try {
                        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
                        int bytesLen = ohbytes.getLength();
                        long memAddr = ohbytes.getUnsafeAddress(0, bytesLen);
                        RowFormatter rf = tabInfo.getRowFormatter(ohbytes);
                        int[] keyPositions = tabInfo.getPrimaryKeyColumns();
                        for (int index = 0; index < keyObjects.length; ++index) {
                            int colIndex = keyPositions[index] - 1;
                            ColumnDescriptor cd = rf.columns[colIndex];
                            keyObjects[index] = !cd.isLob ? rf.getAsObject(colIndex, cd, unsafe, memAddr, bytesLen, ohbytes, null) : rf.getAsObject(colIndex + 1, (OffHeapRowWithLobs)ohbytes, null);
                        }
                    }
                    finally {
                        SimpleMemoryAllocatorImpl.skipRefCountTracking();
                        ohbytes.release();
                        SimpleMemoryAllocatorImpl.unskipRefCountTracking();
                    }
                    return;
                }
                byte[] kbytes = this.getKeyBytes();
                if (kbytes != null) {
                    RowFormatter rf = tabInfo.getPrimaryKeyFormatter();
                    for (int index = 0; index < keyObjects.length; ++index) {
                        keyObjects[index] = rf.getAsObject(index + 1, kbytes, null);
                    }
                    return;
                }
                if (tries % 1000 != 0) continue;
                Thread.yield();
            } while (tries++ <= 10000000);
            throw RegionEntryUtils.checkCacheForNullKeyValue("CompactCompositeKey#getKeyColumns(Object[])");
        }
        throw RegionEntryUtils.checkCacheForNullTableInfo("CompactCompositeKey#getKeyColumns(Object[])");
    }

    public final DataTypeDescriptor getKeyColumnType(int index) {
        ExtraInfo tabInfo = this.tableInfo;
        if (tabInfo != null) {
            return tabInfo.getPrimaryKeyFormatter().columns[index].columnType;
        }
        throw RegionEntryUtils.checkCacheForNullTableInfo("CompactCompositeKey#getKeyColumnType(int)");
    }

    public final byte[] snapshotKeyFromValue() {
        return this.snapshotKeyFromValue(true);
    }

    public final byte[] snapshotKeyFromValue(boolean storeInternally) {
        byte[] kbytes;
        int tries = 1;
        while ((kbytes = (byte[])super.get()) == null) {
            Object keyBytes;
            SimpleMemoryAllocatorImpl.skipRefCountTracking();
            Object vbytes = this.getValueByteSource();
            SimpleMemoryAllocatorImpl.unskipRefCountTracking();
            if (vbytes != null) {
                byte[] hvbytes = null;
                OffHeapByteSource ohvbytes = null;
                try {
                    if (vbytes.getClass() == byte[].class) {
                        hvbytes = (byte[])vbytes;
                    } else {
                        ohvbytes = (OffHeapByteSource)((Object)vbytes);
                    }
                    ExtraInfo tableInfo = this.tableInfo;
                    if (tableInfo != null) {
                        kbytes = ohvbytes == null ? tableInfo.getRowFormatter(hvbytes).generateColumns(hvbytes, tableInfo.getPrimaryKeyColumns(), tableInfo.getPrimaryKeyFormatter()) : tableInfo.getRowFormatter(ohvbytes).generateColumns(ohvbytes, tableInfo.getPrimaryKeyColumns(), tableInfo.getPrimaryKeyFormatter());
                        if (storeInternally) {
                            if (!this.compareAndSetKeyBytes(null, kbytes)) continue;
                            this.compareAndSetValueBytes(vbytes, null);
                            byte[] byArray = kbytes;
                            return byArray;
                        }
                        byte[] byArray = kbytes;
                        return byArray;
                    }
                    throw RegionEntryUtils.checkCacheForNullTableInfo("CompactCompositeKey#snapshotKeyBytes(Object)");
                }
                finally {
                    if (ohvbytes != null) {
                        SimpleMemoryAllocatorImpl.skipRefCountTracking();
                        ohvbytes.release();
                        SimpleMemoryAllocatorImpl.unskipRefCountTracking();
                    }
                    continue;
                }
            }
            if (tries % 1000 == 0) {
                Thread.yield();
                continue;
            }
            if (tries > 10000000) {
                throw RegionEntryUtils.checkCacheForNullKeyValue("RegionEntry#snapshotKeyFromValue");
            }
            Object vbs = valBytesUpdater.get(this);
            if (!(vbs instanceof OffHeapRegionEntry) || (keyBytes = ((AbstractRegionEntry)vbs).getRawKey()) == null) continue;
            if (storeInternally) {
                if (!this.compareAndSetKeyBytes(null, kbytes)) continue;
                return (byte[])keyBytes;
            }
            return (byte[])keyBytes;
        }
        return kbytes;
    }

    public final boolean update(Object vbytes, Object expectedBytes) {
        if (vbytes != null) {
            block2: {
                block3: {
                    byte[] kbytes;
                    do {
                        kbytes = (byte[])super.get();
                        if (!this.compareAndSetValueBytes(expectedBytes, vbytes)) break block2;
                        if (kbytes == null || this.getKeyColumns() == null) break block3;
                    } while (!this.compareAndSetKeyBytes(kbytes, null));
                    return true;
                }
                return true;
            }
            return false;
        }
        Assert.fail((Object)"CCIK.update(byte[], byte[]): unexpected null vbytes");
        return false;
    }

    public final void writeKeyBytes(DataOutput out) throws IOException {
        int tries = 1;
        do {
            byte[] kbytes;
            if ((kbytes = this.getKeyBytes()) != null) {
                DataSerializer.writeByteArray((byte[])kbytes, (DataOutput)out);
                return;
            }
            SimpleMemoryAllocatorImpl.skipRefCountTracking();
            Object vbytes = this.getValueByteSource();
            SimpleMemoryAllocatorImpl.unskipRefCountTracking();
            if (vbytes != null) {
                byte[] hvbytes = null;
                OffHeapByteSource ohvbytes = null;
                try {
                    if (vbytes.getClass() == byte[].class) {
                        hvbytes = (byte[])vbytes;
                    } else {
                        ohvbytes = (OffHeapByteSource)((Object)vbytes);
                    }
                    ExtraInfo tableInfo = this.tableInfo;
                    if (tableInfo != null) {
                        RowFormatter pkFormatter = tableInfo.getPrimaryKeyFormatter();
                        if (ohvbytes == null) {
                            tableInfo.getRowFormatter(hvbytes).serializeColumns(hvbytes, out, tableInfo.getPrimaryKeyFixedColumns(), tableInfo.getPrimaryKeyVarColumns(), pkFormatter.offsetBytes, pkFormatter.offsetIsDefault, pkFormatter);
                        } else {
                            tableInfo.getRowFormatter(ohvbytes).serializeColumns(ohvbytes, out, tableInfo.getPrimaryKeyFixedColumns(), tableInfo.getPrimaryKeyVarColumns(), pkFormatter.offsetBytes, pkFormatter.offsetIsDefault, pkFormatter);
                        }
                        return;
                    }
                    throw RegionEntryUtils.checkCacheForNullTableInfo("CompactCompositeKey#writeKeyBytes");
                }
                finally {
                    if (ohvbytes != null) {
                        SimpleMemoryAllocatorImpl.skipRefCountTracking();
                        ohvbytes.release();
                        SimpleMemoryAllocatorImpl.unskipRefCountTracking();
                    }
                }
            }
            if (this == this.getTokenKey()) {
                DataSerializer.writeByteArray(null, (DataOutput)out);
                return;
            }
            if (tries % 1000 != 0) continue;
            Thread.yield();
        } while (tries++ <= 10000000);
        throw RegionEntryUtils.checkCacheForNullKeyValue("CompactCompositeKey#writeKeyBytes");
    }

    protected Object getTokenKey() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        int tries = 1;
        do {
            byte[] kbytes = this.getKeyBytes();
            OffHeapByteSource vbs = null;
            try {
                if (kbytes != null) {
                    int n = RegionEntryUtils.entryHashCode(kbytes, null, null, this.tableInfo);
                    return n;
                }
                SimpleMemoryAllocatorImpl.skipRefCountTracking();
                Object vbytes = this.getValueByteSource();
                SimpleMemoryAllocatorImpl.unskipRefCountTracking();
                if (vbytes != null) {
                    if (vbytes.getClass() == byte[].class) {
                        int n = RegionEntryUtils.entryHashCode(null, (byte[])vbytes, null, this.tableInfo);
                        return n;
                    }
                    vbs = (OffHeapByteSource)((Object)vbytes);
                    int n = RegionEntryUtils.entryHashCode(null, null, vbs, this.tableInfo);
                    return n;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            finally {
                if (vbs != null) {
                    SimpleMemoryAllocatorImpl.skipRefCountTracking();
                    vbs.release();
                    SimpleMemoryAllocatorImpl.unskipRefCountTracking();
                }
            }
            if (tries % 1000 != 0) continue;
            Thread.yield();
        } while (tries++ <= 10000000);
        throw RegionEntryUtils.checkCacheForNullKeyValue("CompactCompositeKey#hashCode");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof CompactCompositeKey) {
            int tries = 1;
            do {
                byte[] kbytes = this.getKeyBytes();
                OffHeapByteSource vbs = null;
                try {
                    if (kbytes != null) {
                        boolean bl = RegionEntryUtils.entryEqualsKey(kbytes, null, null, null, this.tableInfo, (CompactCompositeKey)o);
                        return bl;
                    }
                    SimpleMemoryAllocatorImpl.skipRefCountTracking();
                    Object vbytes = this.getValueByteSource();
                    SimpleMemoryAllocatorImpl.unskipRefCountTracking();
                    if (vbytes != null) {
                        if (vbytes.getClass() == byte[].class) {
                            boolean bl = RegionEntryUtils.entryEqualsKey(null, null, (byte[])vbytes, null, this.tableInfo, (CompactCompositeKey)o);
                            return bl;
                        }
                        vbs = (OffHeapByteSource)((Object)vbytes);
                        boolean bl = RegionEntryUtils.entryEqualsKey(null, null, null, vbs, this.tableInfo, (CompactCompositeKey)o);
                        return bl;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                finally {
                    if (vbs != null) {
                        SimpleMemoryAllocatorImpl.skipRefCountTracking();
                        vbs.release();
                        SimpleMemoryAllocatorImpl.unskipRefCountTracking();
                    }
                }
                if (tries % 1000 != 0) continue;
                Thread.yield();
            } while (tries++ <= 10000000);
            throw RegionEntryUtils.checkCacheForNullKeyValue("CompactCompositeKey#equals");
        }
        if (o instanceof RowLocation) {
            return o.equals(this);
        }
        if (o instanceof RegionKey) {
            return false;
        }
        Assert.fail((Object)("other object is not a CompactCompositeKey or RowLocation or RegionKey but " + o.getClass().getName()));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("tableinfo(").append(this.tableInfo != null).append(").");
        sb.append(this.getClass().getSimpleName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append("=");
        SimpleMemoryAllocatorImpl.skipRefCountTracking();
        Object valBytes = this.getValueByteSource();
        SimpleMemoryAllocatorImpl.unskipRefCountTracking();
        try {
            RegionEntryUtils.entryKeyString(this.getKeyBytes(), valBytes, this.tableInfo, sb);
        }
        finally {
            SimpleMemoryAllocatorImpl.skipRefCountTracking();
            this.releaseValueByteSource(valBytes);
            SimpleMemoryAllocatorImpl.unskipRefCountTracking();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] getValueBytes() {
        SimpleMemoryAllocatorImpl.skipRefCountTracking();
        Object vbs = this.getValueByteSource();
        SimpleMemoryAllocatorImpl.unskipRefCountTracking();
        if (vbs != null) {
            if (vbs.getClass() == byte[].class) {
                return (byte[])vbs;
            }
            OffHeapByteSource ohbytes = (OffHeapByteSource)((Object)vbs);
            try {
                byte[] byArray = ohbytes.getRowBytes();
                return byArray;
            }
            finally {
                SimpleMemoryAllocatorImpl.skipRefCountTracking();
                ohbytes.release();
                SimpleMemoryAllocatorImpl.unskipRefCountTracking();
            }
        }
        return null;
    }

    public boolean isValueNull() {
        return this.getRawValueByteSource() == null;
    }

    public byte[] getKeyBytes() {
        return (byte[])super.get();
    }

    public final RowFormatter getKeyFormatter() {
        ExtraInfo tableInfo = this.tableInfo;
        if (tableInfo != null) {
            return tableInfo.getPrimaryKeyFormatter();
        }
        return null;
    }

    protected final void setKeyBytes(byte[] kbytes) {
        super.set(kbytes);
    }

    protected final boolean compareAndSetKeyBytes(byte[] expect, byte[] update) {
        return super.compareAndSet(expect, update);
    }

    protected final boolean compareAndSetValueBytes(Object expect, Object update) {
        boolean testOk = false;
        Object old = valBytesUpdater.get(this);
        if (old != null) {
            Class<?> oldClass = old.getClass();
            if (oldClass == byte[].class) {
                if (old == expect) {
                    testOk = true;
                } else if (expect instanceof byte[] && ((byte[])old).length < 8 && ((byte[])expect).length < 8) {
                    testOk = Arrays.equals((byte[])old, (byte[])expect);
                }
            } else if (OffHeapByteSource.isOffHeapBytesClass(oldClass)) {
                if (old == expect) {
                    testOk = true;
                } else if (expect instanceof OffHeapByteSource && ((OffHeapByteSource)((Object)old)).getMemoryAddress() == ((OffHeapByteSource)((Object)expect)).getMemoryAddress()) {
                    testOk = true;
                }
            } else {
                if (OffHeapRegionEntry.class.isAssignableFrom(oldClass)) {
                    return false;
                }
                testOk = old == expect;
            }
        } else if (expect == null) {
            testOk = true;
        } else {
            return false;
        }
        if (testOk) {
            return valBytesUpdater.compareAndSet(this, old, update);
        }
        return false;
    }

    protected final int[] getKeyColumns() {
        ExtraInfo containerInfo = this.tableInfo;
        if (containerInfo != null) {
            return containerInfo.getPrimaryKeyColumns();
        }
        return null;
    }

    public final void setValueBytes(Object valBytes) {
        valBytesUpdater.set(this, valBytes);
    }

    public final void releaseValueByteSource(Object vbs) {
        OffHeapHelper.release((Object)vbs);
    }

    public Object getValueByteSource() {
        return valBytesUpdater.get(this);
    }

    public final Object getRawValueByteSource() {
        return valBytesUpdater.get(this);
    }

    public abstract long estimateMemoryUsage();
}

