/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.stats;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.GemFireStatSampler;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;

public final class ConnectionStats {
    private static boolean enableClockStats = false;
    private final Statistics stats;
    private static boolean samplingEnabled;
    private static final StatisticsType type;
    private static final int peerConnectionsAttemptedId;
    private static final int peerConnectionsOpenId;
    private static final int peerConnectionsFailedId;
    private static final int peerConnectionsOpenedId;
    private static final int peerConnectionsOpenTimeId;
    public static final int peerConnectionsClosedId;
    private static final int peerConnectionsLifeTimeId;
    private static final int nestedConnectionsOpenId;
    private static final int nestedConnectionsOpenedId;
    public static final int nestedConnectionsClosedId;
    private static final int internalConnectionsOpenId;
    private static final int internalConnectionsOpenedId;
    public static final int internalConnectionsClosedId;
    private static final int drdaServerThreadsId;
    private static final int drdaServerWaitingThreadsId;
    private static final int clientConnectionsTotalBytesReadId;
    private static final int clientConnectionsTotalBytesWrittenId;
    private static final int clientConnectionsQueuedId;
    private static final int clientConnectionAttemptedId;
    private static final int clientConnectionsFailedId;
    private static final int clientConnectionsIdleId;
    private static final int clientConnectionsOpenId;
    private static final int clientConnectionsOpenedId;
    private static final int clientConnectionsOpenTimeId;
    private static final int clientConnectionsClosedId;
    private static final int clientConnectionsLifeTimeId;
    private static final int drdaThreadLongWaitsId;
    private static final int drdaThreadIdleTimeId;
    private static final int clientCommandsProcessedId;
    private static final int clientCommandsProcessTimeId;
    public static String name;

    public ConnectionStats(StatisticsFactory factory, String name) {
        this.stats = factory.createAtomicStatistics(type, name);
        InternalDistributedSystem sys = (InternalDistributedSystem)factory;
        GemFireStatSampler sampler = sys.getStatSampler();
        samplingEnabled = sampler != null && sampler.isSamplingEnabled();
        ConnectionStats.setClockStats(sys.getConfig().getEnableTimeStatistics(), false);
    }

    public static void setClockStats(boolean force, boolean booting) {
        if (force) {
            enableClockStats = true;
        } else {
            String enableTimeStats;
            boolean bl = enableClockStats = Boolean.getBoolean("gemfire.enable-time-statistics") || Boolean.getBoolean(GfxdConstants.GFXD_ENABLE_TIMESTATS);
            if (!enableClockStats && !booting && Monitor.getMonitor() != null && (enableTimeStats = PropertyUtil.findAndGetProperty(null, "enable-timestats", GfxdConstants.GFXD_ENABLE_TIMESTATS)) != null) {
                enableClockStats = Boolean.parseBoolean(enableTimeStats);
            }
        }
    }

    public static boolean clockStatsEnabled() {
        return enableClockStats;
    }

    public static boolean isSamplingEnabled() {
        return samplingEnabled;
    }

    public void incPeerConnectionsAttempt() {
        this.stats.incLong(peerConnectionsAttemptedId, 1L);
    }

    public void incPeerConnectionsOpen() {
        this.stats.incLong(peerConnectionsOpenId, 1L);
    }

    public void decPeerConnectionsOpen() {
        this.stats.incLong(peerConnectionsOpenId, -1L);
    }

    public void incpeerConnectionsOpened() {
        this.stats.incLong(peerConnectionsOpenedId, 1L);
    }

    public void incPeerConnectionsFailed() {
        this.stats.incLong(peerConnectionsFailedId, 1L);
    }

    public void incPeerConnectionsOpenTime(long begin) {
        long nanos;
        if (enableClockStats && (nanos = ConnectionStats.getStatTime() - begin) > 0L) {
            this.stats.incLong(peerConnectionsOpenTimeId, nanos);
        }
    }

    public void incPeerConnectionsClosed() {
        this.stats.incLong(peerConnectionsClosedId, 1L);
    }

    public void incPeerConnectionLifeTime(long begin) {
        long nanos;
        if (enableClockStats && (nanos = ConnectionStats.getStatTime() - begin) > 0L) {
            this.stats.incLong(peerConnectionsLifeTimeId, nanos);
        }
    }

    public void incNestedConnectionsOpen() {
        this.stats.incLong(nestedConnectionsOpenId, 1L);
    }

    public void decNestedConnectionsOpen() {
        this.stats.incLong(nestedConnectionsOpenId, -1L);
    }

    public void incNestedConnectionsOpened() {
        this.stats.incLong(nestedConnectionsOpenedId, 1L);
    }

    public void incNestedConnectionsClosed() {
        this.stats.incLong(nestedConnectionsClosedId, 1L);
    }

    public void incInternalConnectionsOpen() {
        this.stats.incLong(internalConnectionsOpenId, 1L);
    }

    public void decInternalConnectionsOpen() {
        this.stats.incLong(internalConnectionsOpenId, -1L);
    }

    public void incInternalConnectionsOpened() {
        this.stats.incLong(internalConnectionsOpenedId, 1L);
    }

    public void incInternalConnectionsClosed() {
        this.stats.incLong(internalConnectionsClosedId, 1L);
    }

    public void incClientConnectionsAttempt() {
        this.stats.incLong(clientConnectionAttemptedId, 1L);
    }

    public void setDRDAServerThreads(long newValue) {
        this.stats.setLong(drdaServerThreadsId, newValue);
    }

    public void setDRDAServerWaitingThreads(long newValue) {
        this.stats.setLong(drdaServerWaitingThreadsId, newValue);
    }

    public void setClientConnectionsQueued(long newValue) {
        this.stats.setLong(clientConnectionsQueuedId, newValue);
    }

    public void incTotalBytesRead(long inc) {
        this.stats.incLong(clientConnectionsTotalBytesReadId, inc);
    }

    public void incTotalBytesWritten(long inc) {
        this.stats.incLong(clientConnectionsTotalBytesWrittenId, inc);
    }

    public void incClientConnectionsFailed() {
        this.stats.incLong(clientConnectionsFailedId, 1L);
    }

    public void setClientConnectionsIdle(long newValue) {
        this.stats.setLong(clientConnectionsIdleId, newValue);
    }

    public void setClientConnectionsOpen(long newValue) {
        this.stats.setLong(clientConnectionsOpenId, newValue);
    }

    public void incClientConnectionsOpened() {
        this.stats.incLong(clientConnectionsOpenedId, 1L);
    }

    public void incClientConnectionsOpenTime(long begin) {
        long nanos;
        if (enableClockStats && (nanos = ConnectionStats.getStatTime() - begin) > 0L) {
            this.stats.incLong(clientConnectionsOpenTimeId, nanos);
        }
    }

    public void incClientConnectionsClosed() {
        this.stats.incLong(clientConnectionsClosedId, 1L);
    }

    public void incClientConnectionsLifeTime(long begin) {
        long nanos;
        if (enableClockStats && (nanos = ConnectionStats.getStatTime() - begin) > 0L) {
            this.stats.incLong(clientConnectionsLifeTimeId, nanos);
        }
    }

    public void incDRDAThreadLongWaits(long inc) {
        this.stats.incLong(drdaThreadLongWaitsId, inc);
    }

    public void incDRDAThreadIdleTime(long inc) {
        this.stats.incLong(drdaThreadIdleTimeId, inc);
    }

    public void incCommandsProcessed(long inc) {
        this.stats.incLong(clientCommandsProcessedId, inc);
    }

    public void incCommandsProcessTime(long inc) {
        this.stats.incLong(clientCommandsProcessTimeId, inc);
    }

    public static long getStatTime() {
        return enableClockStats ? XPLAINUtil.nanoTime() : 0L;
    }

    static {
        ConnectionStats.setClockStats(false, true);
        name = "ConnectionStats";
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        type = f.createType(name, "Statistics about embedded and client connections", new StatisticDescriptor[]{f.createLongCounter("peerConnectionsAttempted", "Number of peer connections attempted.", "operations"), f.createLongGauge("peerConnectionsOpen", "Number of peer connections open at this moment.", "operations"), f.createLongCounter("peerConnectionsFailed", "Number of peer connections creations failed due to exceptions.", "operations"), f.createLongCounter("peerConnectionsOpened", "Number of peer connections opened.", "operations"), f.createLongCounter("peerConnectionsOpenTime", "Time taken to open peer connections.", "nanoseconds"), f.createLongCounter("peerConnectionsClosed", "Number of peer connections closed.", "operations"), f.createLongCounter("peerConnectionsLifeTime", "Time for which peer connections were alive, i.e. time taken between open and close of connections.This divided by peerConnectionsOpened can yield average time a connection is retained on this server.", "nanoseconds"), f.createLongGauge("nestedConnectionsOpen", "Number of nested connections open at this moment.", "operations"), f.createLongCounter("nestedConnectionsOpened", "Number of nested connections opened.", "operations"), f.createLongCounter("nestedConnectionsClosed", "Number of nested connections closed.", "operations"), f.createLongGauge("internalConnectionsOpen", "Number of internal connections open at this moment.", "operations"), f.createLongCounter("internalConnectionsOpened", "Number of internal connections opened.", "operations"), f.createLongCounter("internalConnectionsClosed", "Number of internal connections closed.", "operations"), f.createLongCounter("clientConnectionsAttempted", "Number of client connections attempted", "operations"), f.createLongGauge("drdaServerThreads", "Number of DRDA server threads created for servicing client connections.", "operations"), f.createLongGauge("drdaServerWaitingThreads", "Number of DRDA server threads that waited > 1 millisecond for client requests.", "operations"), f.createLongGauge("clientConnectionsQueued", "Number of client connections active but in the wait queue and yet to be serviced by DRDAServer threads.", "operations"), f.createLongCounter("clientConnectionsTotalBytesRead", "Total bytes read across all client connections to receive commands from client.", "bytes"), f.createLongCounter("clientConnectionsTotalBytesWritten", "Total bytes written as a response to client requests across all connections.", "bytes"), f.createLongCounter("clientConnectionsFailed", "Number of client connections creation failed due to exceptions.", "operations"), f.createLongGauge("clientConnectionsIdle", "Number of client connections idle at this moment.", "operations"), f.createLongGauge("clientConnectionsOpen", "Number of client connections open at this moment.", "operations"), f.createLongCounter("clientConnectionsOpened", "Total number of client connections opened until now", "operations"), f.createLongCounter("clientConnectionsOpenTime", "Time taken to open client connections.", "nanoseconds"), f.createLongCounter("clientConnectionsClosed", "Number of client connections closed", "operations"), f.createLongCounter("clientConnectionsLifeTime", "Time for which client connections were held open by the client, i.e. time between open and close of client connections.This divided by clientConnectionsOpened will yield average time a connection is retained by the clients on this server.", "nanoseconds"), f.createLongCounter("drdaThreadLongWaits", "Number of times server DRDA threads waited > 5 millisecond for client requests.", "operations"), f.createLongCounter("drdaThreadIdleTime", "Time for which server DRDA threads were waiting for clients to submit requests. This divided by drdaThreadLongWaits gives average idle time across all receiving threads that waited beyond 5 millisecond. This divided by clientConnectionsIdle gives average per thread idle time.", "milliseconds"), f.createLongCounter("clientCommandsProcessed", "Number of commands processed by the server DRDA threads.", "operations"), f.createLongCounter("clientCommandsProcessTime", " Total time taken by server DRDA threads to process commands submitted.", "nanoseconds")});
        peerConnectionsAttemptedId = type.nameToId("peerConnectionsAttempted");
        peerConnectionsOpenId = type.nameToId("peerConnectionsOpen");
        peerConnectionsFailedId = type.nameToId("peerConnectionsFailed");
        peerConnectionsOpenedId = type.nameToId("peerConnectionsOpened");
        peerConnectionsOpenTimeId = type.nameToId("peerConnectionsOpenTime");
        peerConnectionsClosedId = type.nameToId("peerConnectionsClosed");
        peerConnectionsLifeTimeId = type.nameToId("peerConnectionsLifeTime");
        nestedConnectionsOpenId = type.nameToId("nestedConnectionsOpen");
        nestedConnectionsOpenedId = type.nameToId("nestedConnectionsOpened");
        nestedConnectionsClosedId = type.nameToId("nestedConnectionsClosed");
        internalConnectionsOpenId = type.nameToId("internalConnectionsOpen");
        internalConnectionsOpenedId = type.nameToId("internalConnectionsOpened");
        internalConnectionsClosedId = type.nameToId("internalConnectionsClosed");
        clientConnectionAttemptedId = type.nameToId("clientConnectionsAttempted");
        drdaServerThreadsId = type.nameToId("drdaServerThreads");
        drdaServerWaitingThreadsId = type.nameToId("drdaServerWaitingThreads");
        clientConnectionsQueuedId = type.nameToId("clientConnectionsQueued");
        clientConnectionsTotalBytesReadId = type.nameToId("clientConnectionsTotalBytesRead");
        clientConnectionsTotalBytesWrittenId = type.nameToId("clientConnectionsTotalBytesWritten");
        clientConnectionsFailedId = type.nameToId("clientConnectionsFailed");
        clientConnectionsIdleId = type.nameToId("clientConnectionsIdle");
        clientConnectionsOpenId = type.nameToId("clientConnectionsOpen");
        clientConnectionsOpenedId = type.nameToId("clientConnectionsOpened");
        clientConnectionsOpenTimeId = type.nameToId("clientConnectionsOpenTime");
        clientConnectionsClosedId = type.nameToId("clientConnectionsClosed");
        clientConnectionsLifeTimeId = type.nameToId("clientConnectionsLifeTime");
        drdaThreadLongWaitsId = type.nameToId("drdaThreadLongWaits");
        drdaThreadIdleTimeId = type.nameToId("drdaThreadIdleTime");
        clientCommandsProcessedId = type.nameToId("clientCommandsProcessed");
        clientCommandsProcessTimeId = type.nameToId("clientCommandsProcessTime");
    }
}

