/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.compile.types;

import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.shared.Version;
import com.gemstone.gnu.trove.THashSet;
import com.gemstone.gnu.trove.TObjectHashingStrategy;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.compile.types.DVDSetHashingStrategy;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.iapi.types.UserType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;

public final class DVDSet
extends UserType {
    private ArrayList<Object> values;
    private THashSet valueSet;
    public static final InternalDataSerializer.CollectionCreator<ArrayList<Object>> tListCreator = new InternalDataSerializer.CollectionCreator<ArrayList<Object>>(){

        public ArrayList<Object> newCollection(int initialCapacity) {
            return new ArrayList<Object>(initialCapacity);
        }
    };
    private DataTypeDescriptor resultDescriptor;
    public static final int DEFAULT_SIZE = 6;

    public DVDSet() {
    }

    public DVDSet(int size) {
        this.values = new ArrayList(size);
        this.valueSet = new THashSet(size);
    }

    public DVDSet(Object valueDescriptor) {
        assert (valueDescriptor == null || valueDescriptor instanceof DataTypeDescriptor) : "DataTypeDescriptor is expected but got " + valueDescriptor;
        this.values = new ArrayList(6);
        this.valueSet = new THashSet(6);
        this.resultDescriptor = (DataTypeDescriptor)valueDescriptor;
    }

    public DVDSet(DataTypeDescriptor valueDescriptor) {
        this.values = new ArrayList(6);
        this.valueSet = new THashSet(6);
        this.resultDescriptor = valueDescriptor;
    }

    public DVDSet(DataTypeDescriptor valueDescriptor, TObjectHashingStrategy hashStrategy) {
        this.values = new ArrayList(6);
        this.valueSet = new THashSet(6, hashStrategy);
        this.resultDescriptor = valueDescriptor;
    }

    private DVDSet(ArrayList<Object> values, DataTypeDescriptor resultDescriptor) {
        this.resultDescriptor = resultDescriptor;
        int numValues = values.size();
        if (numValues > 0) {
            this.values = new ArrayList<Object>(values);
            this.valueSet = new THashSet(values);
        } else {
            this.values = new ArrayList(6);
            this.valueSet = new THashSet(6);
        }
    }

    public void setResultDescriptor(DataTypeDescriptor valueDescriptor) {
        if (GemFireXDUtils.TraceAggreg) {
            SanityManager.DEBUG_PRINT((String)"TraceAggregation", (String)("DVDSet::setResultDescriptor(DataTypeDescriptor) is " + valueDescriptor + " for 0x" + System.identityHashCode(this)));
        }
        this.resultDescriptor = valueDescriptor;
    }

    public final DataTypeDescriptor getResultDescriptor() {
        return this.resultDescriptor;
    }

    public int resultTypePrecedence() {
        return this.resultDescriptor.getTypeId().typePrecedence();
    }

    public void addValue(Object value) {
        if (this.valueSet.add(value)) {
            this.values.add(value);
        }
    }

    public void addValueAndCheckType(DataValueDescriptor value) {
        if (value.getTypeFormatId() != this.resultDescriptor.getDVDTypeFormatId()) {
            Assert.fail((Object)("expected type=" + this.resultDescriptor.toString() + " incoming=" + value.getTypeName()));
        }
        this.values.add(value);
    }

    @Override
    public int compare(DataValueDescriptor other) throws StandardException {
        int argObjSize;
        if (this == other) {
            return 0;
        }
        DVDSet arg = (DVDSet)other;
        int thisObjSize = this.values.size();
        int size = thisObjSize < (argObjSize = arg.values.size()) ? thisObjSize : argObjSize;
        Iterator<Object> thisItr = this.values.iterator();
        Iterator<Object> argItr = arg.values.iterator();
        for (int index = 0; index < size; ++index) {
            DataValueDescriptor argDVD;
            DataValueDescriptor thisDVD = (DataValueDescriptor)thisItr.next();
            int cmp = thisDVD.compare(argDVD = (DataValueDescriptor)argItr.next());
            if (cmp == 0) continue;
            return cmp;
        }
        return thisObjSize - argObjSize;
    }

    @Override
    public DataValueDescriptor getClone() {
        return new DVDSet(this.values, this.resultDescriptor);
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new DVDSet(this.resultDescriptor);
    }

    @Override
    public void restoreToNull() {
        if (!this.valueSet.isEmpty()) {
            this.values.clear();
            this.valueSet.clear();
        }
    }

    @Override
    public void setValue(Object value) {
        if (value.getClass() != ArrayList.class) {
            SanityManager.THROWASSERT((String)("value (" + value + ") not an ArrayList but " + value.getClass()));
        }
        this.values = (ArrayList)value;
        if (!this.valueSet.isEmpty()) {
            this.valueSet.clear();
        }
        this.valueSet.addAll(this.values);
    }

    @Override
    public ArrayList<Object> getObject() {
        return this.values;
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        this.setValue(theValue.getObject());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT((!this.isNull() ? 1 : 0) != 0, (String)"writeExternal() is not supposed to be called for null values.");
        DVDSet.writeDVDCollection(this.values, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.values = DVDSet.readDVDCollection(in, tListCreator);
        if (!this.valueSet.isEmpty()) {
            this.valueSet.clear();
        }
        this.valueSet.addAll(this.values);
    }

    @Override
    public final boolean isNull() {
        return this.values.isEmpty();
    }

    @Override
    public String getTypeName() {
        return "DVDSET";
    }

    @Override
    public byte getTypeId() {
        return 66;
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.values.toString();
    }

    public DataValueDescriptor getNull() throws StandardException {
        return this.getNewNull();
    }

    public void merge(DVDSet input) {
        ArrayList<Object> ivals;
        int nvals;
        if (GemFireXDUtils.TraceAggreg) {
            SanityManager.DEBUG_PRINT((String)"TraceAggregation", (String)("DVDSet#merge (expected to be originating node) before merge valueSet.size=" + this.values.size() + " incoming merge data size=" + input.values.size()));
        }
        if ((nvals = (ivals = input.values).size()) > 0) {
            for (int index = 0; index < nvals; ++index) {
                this.addValue(ivals.get(index));
            }
        }
        if (GemFireXDUtils.TraceAggreg) {
            SanityManager.DEBUG_PRINT((String)"TraceAggregation", (String)("DVDSet#merge (expected to be originating node) post merge valueSet.size=" + this.values.size() + " valueSet merged data " + this.values));
        }
    }

    @Override
    public void toDataForOptimizedResultHolder(DataOutput dos) throws IOException {
        int numValues = this.values.size();
        InternalDataSerializer.writeArrayLength((int)numValues, (DataOutput)dos);
        if (numValues > 0) {
            Version v = InternalDataSerializer.getVersionForDataStream((DataOutput)dos);
            if (v.compareTo(Version.GFXD_13) >= 0) {
                InternalDataSerializer.writeByte((Byte)((DataValueDescriptor)this.values.iterator().next()).getTypeId(), (DataOutput)dos);
            }
            for (Object dvd : this.values) {
                ((DataValueDescriptor)dvd).toDataForOptimizedResultHolder(dos);
            }
        }
    }

    @Override
    public void fromDataForOptimizedResultHolder(DataInput dis) throws IOException, ClassNotFoundException {
        int len = InternalDataSerializer.readArrayLength((DataInput)dis);
        this.values = new ArrayList(len);
        this.valueSet = new THashSet(len, (TObjectHashingStrategy)DVDSetHashingStrategy.getInstance());
        if (len > 0) {
            byte typeId = -127;
            Version v = InternalDataSerializer.getVersionForDataStream((DataInput)dis);
            if (v.compareTo(Version.GFXD_13) >= 0) {
                typeId = InternalDataSerializer.readByte((DataInput)dis);
            }
            if (this.resultDescriptor != null) {
                try {
                    for (int i = 0; i < len; ++i) {
                        DataValueDescriptor dvd = this.resultDescriptor.getNull();
                        dvd.fromDataForOptimizedResultHolder(dis);
                        this.values.add(dvd);
                        this.valueSet.add((Object)dvd);
                    }
                }
                catch (StandardException se) {
                    throw new IOException(se.toString(), se);
                }
            } else if (typeId != -127) {
                for (int i = 0; i < len; ++i) {
                    DataValueDescriptor dvd = DataType.readNullDVD(typeId, dis);
                    dvd.fromDataForOptimizedResultHolder(dis);
                    this.values.add(dvd);
                    this.valueSet.add((Object)dvd);
                }
            } else {
                throw new IOException("Cannot de-serialize without resultDescriptor in DVDSet");
            }
        }
        this.valueSet.setHashingStrategy((TObjectHashingStrategy)this.valueSet);
        if (GemFireXDUtils.TraceAggreg) {
            SanityManager.DEBUG_PRINT((String)"TraceAggregation", (String)("De-serialized the value set of size " + this.values.size() + " to " + this.values + " for " + System.identityHashCode(this)));
        }
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return this.values.toString();
    }

    @Override
    public BooleanDataValue in(DataValueDescriptor left, DataValueDescriptor[] inList, boolean orderedList) throws StandardException {
        if (GemFireXDUtils.TraceNCJIter) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJIter", (String)("DVDSet#in " + this.getTypeName() + " of type " + (this.resultDescriptor == null ? "null" : this.resultDescriptor.getTypeName()) + " ,hash-set-size=" + this.values.size() + " ,hash-set-hashing-strategy=" + this.valueSet.getHashingStrategyName() + " ,left=" + left + " ,left-type=" + left.getClass().getSimpleName()));
        }
        if (GemFireXDUtils.TraceNCJDump) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJDump", (String)("DVDSet#in " + this.getTypeName() + " of size=" + this.values.size() + " ,hash-set" + this.values));
        }
        if (this.isNull() || left.isNull()) {
            return SQLBoolean.unknownTruthValue();
        }
        if (this.values.contains(left)) {
            if (GemFireXDUtils.TraceNCJIter) {
                SanityManager.DEBUG_PRINT((String)"TraceNCJIter", (String)("DVDSet#in return true for left=" + left));
            }
            return SQLBoolean.trueTruthValue();
        }
        if (GemFireXDUtils.TraceNCJIter) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJIter", (String)("DVDSet#in return false for left=" + left));
        }
        return SQLBoolean.falseTruthValue();
    }

    public DataValueDescriptor[] getValues() {
        SanityManager.ASSERT((!this.isNull() ? 1 : 0) != 0, (String)"Values missing");
        Object[] objArr = this.values.toArray();
        DataValueDescriptor[] newList = new DataValueDescriptor[objArr.length];
        for (int idx = 0; idx < objArr.length; ++idx) {
            newList[idx] = (DataValueDescriptor)objArr[idx];
        }
        return newList;
    }
}

