/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.procedure.coordinate;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.ServerGroupsTableAttribute;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.procedure.coordinate.ProcedureProcessorNode;
import com.pivotal.gemfirexd.internal.engine.procedure.coordinate.ProcedureProxy;
import com.pivotal.gemfirexd.internal.engine.procedure.coordinate.ReferencedColumnsVisitor;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.LocalField;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.IndexRowGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromSubquery;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromVTI;
import com.pivotal.gemfirexd.internal.impl.sql.compile.InListOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JavaValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.Predicate;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RelationalOperator;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SelectNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StaticMethodCallNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;

public class DistributedProcedureCallNode
extends StaticMethodCallNode
implements Serializable {
    private static final long serialVersionUID = -5431461816663110294L;
    private transient FromList onTable;
    private ValueNode whereClause;
    private boolean all;
    private ServerGroupsTableAttribute serverGroups;
    private transient ProcedureProxy procProxy;
    private LocalField procedureResultSetsHolder;
    transient PredicateList restrictionPredicates;
    private UUID tableId = null;
    private long indexId = -1L;
    private int numColumns = 0;
    transient FromBaseTable table = null;
    private transient ProcedureProcessorNode ppn = null;
    private boolean nowait;

    @Override
    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) throws StandardException {
        StaticMethodCallNode callNode = (StaticMethodCallNode)arg1;
        super.init(callNode.procedureName, callNode.javaClassName);
        this.methodParms = callNode.methodParms;
        this.ppn = (ProcedureProcessorNode)arg2;
        this.onTable = (FromList)arg3;
        this.whereClause = (ValueNode)arg4;
        this.all = (Boolean)arg5;
        this.serverGroups = (ServerGroupsTableAttribute)arg6;
        this.nowait = (Boolean)arg7;
    }

    @Override
    public JavaValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        this.ppn.bindExpression(dd);
        if (this.onTable.size() == 1) {
            this.bindExpressions(dd);
        }
        JavaValueNode node = super.bindExpression(fromList, subqueryList, aggregateVector);
        this.lcc = null;
        return node;
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        int predicateSize;
        int maxDynamicResults;
        this.generateParameters(acb, mb);
        if (this.routineInfo != null) {
            short sqlAllowed = this.routineInfo.getSQLAllowed();
            if (sqlAllowed != 3) {
                int sqlOperation = sqlAllowed == 1 ? 1 : (sqlAllowed == 0 ? 0 : 2);
                this.generateAuthorizeCheck(acb, mb, sqlOperation);
            }
            acb.pushThisAsActivation(mb);
            mb.callMethod((short)185, null, "getLanguageConnectionContext", "com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext", 0);
            mb.callMethod((short)185, null, "getStatementContext", "com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext", 0);
            mb.push(sqlAllowed);
            mb.push(false);
            mb.callMethod((short)185, null, "setSQLAllowed", "void", 2);
        }
        if (this.routineInfo != null && (maxDynamicResults = this.routineInfo.getMaxDynamicResultSets()) > 0) {
            MethodBuilder gdr = acb.getClassBuilder().newMethodBuilder(1, "int", "getMaxDynamicResults");
            gdr.push(maxDynamicResults);
            gdr.methodReturn();
            gdr.complete();
            MethodBuilder gdr1 = acb.getClassBuilder().newMethodBuilder(1, "java.sql.ResultSet[][]", "getDynamicResults");
            MethodBuilder cons = acb.getConstructor();
            this.procedureResultSetsHolder = acb.newFieldDeclaration(2, "java.sql.ResultSet[][]");
            cons.pushNewArray("java.sql.ResultSet[]", maxDynamicResults);
            cons.setField(this.procedureResultSetsHolder);
            for (int i = 0; i < maxDynamicResults; ++i) {
                mb.pushNewArray("java.sql.ResultSet", 1);
                mb.getField(this.procedureResultSetsHolder);
                mb.swap();
                mb.setArrayElement(i);
            }
            gdr1.getField(this.procedureResultSetsHolder);
            gdr1.methodReturn();
            gdr1.complete();
        }
        acb.pushGetExecutionFactoryExpression(mb);
        acb.pushThisAsActivation(mb);
        if (this.tableId != null) {
            mb.push(acb.addItem(this.tableId));
        } else {
            mb.push(-1);
        }
        mb.push(this.indexId);
        mb.push(this.numColumns);
        int n = predicateSize = this.restrictionPredicates == null ? 0 : this.restrictionPredicates.size();
        if (predicateSize > 0) {
            boolean multiProbing = false;
            for (int i = 0; i < predicateSize; ++i) {
                Predicate pred = (Predicate)this.restrictionPredicates.elementAt(i);
                if (!pred.isInListProbePredicate() || !pred.isStartKey()) continue;
                multiProbing = true;
                break;
            }
            this.restrictionPredicates.generateStartKey(acb, mb, this.table);
            mb.push(this.restrictionPredicates.startOperator(this.table));
            if (this.restrictionPredicates.sameStartStopPosition()) {
                mb.dup();
                mb.pushNull("com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod");
                mb.swap();
                mb.push(true);
            } else {
                this.restrictionPredicates.generateStopKey(acb, mb, this.table);
                mb.push(this.restrictionPredicates.stopOperator(this.table));
                mb.push(false);
            }
            if (multiProbing) {
                this.restrictionPredicates.generateInListValues(acb, mb);
            } else {
                mb.pushNull("com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor[]");
                mb.push(3);
            }
        } else {
            mb.pushNull("com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod");
            mb.push(0);
            mb.pushNull("com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod");
            mb.push(0);
            mb.push(false);
            mb.pushNull("com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor[]");
            mb.push(3);
        }
        mb.push(this.all);
        mb.push(acb.addItem(this.serverGroups));
        mb.push(acb.addItem(this));
        mb.push(this.nowait);
        this.ppn.generateExpression(acb, mb);
        if (this.procedureResultSetsHolder != null) {
            mb.getField(this.procedureResultSetsHolder);
        } else {
            mb.pushNull("java.sql.ResultSet[][]");
        }
        mb.callMethod((short)185, null, "getDistributedProcedureCallProxy", "com.pivotal.gemfirexd.internal.engine.procedure.coordinate.ProcedureProxy", 17);
        if (this.outParamArrays != null) {
            mb.dup();
        }
        mb.callMethod((short)182, null, "execute", "void", 0);
        if (this.outParamArrays != null) {
            MethodBuilder constructor = acb.getConstructor();
            acb.pushThisAsActivation(constructor);
            constructor.callMethod((short)185, null, "getParameterValueSet", "com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet", 0);
            int[] parameterModes = this.routineInfo.getParameterModes();
            for (int i = 0; i < this.outParamArrays.length; ++i) {
                int parameterMode = parameterModes[i];
                if (parameterMode == 1) continue;
                int applicationParameterNumber = this.applicationParameterNumbers[i];
                constructor.dup();
                constructor.push(applicationParameterNumber);
                constructor.push(parameterMode);
                constructor.callMethod((short)185, null, "setParameterMode", "void", 2);
            }
            mb.callMethod((short)182, null, "setProxyParameterValueSet", "void", 0);
            constructor.endStatement();
        }
        mb.endStatement();
    }

    @Override
    public int getStatementType() {
        return -1;
    }

    public ProcedureProxy getProcedureProxy() {
        return this.procProxy;
    }

    public void setProcedureProxy(ProcedureProxy proxy) {
        this.procProxy = proxy;
    }

    @Override
    public int generateParameters(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        for (int param = 0; param < this.methodParms.length; ++param) {
            this.generateOneParameter(acb, mb, param);
        }
        return this.methodParms.length;
    }

    @Override
    public void generateOneParameter(ExpressionClassBuilder acb, MethodBuilder mb, int parameterNumber) throws StandardException {
        assert (this.routineInfo != null) : "The routing info is supposed to not be null for a procedure!";
        int parameterMode = this.routineInfo.getParameterModes()[parameterNumber];
        switch (parameterMode) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 4: {
                String methodParameterType = this.methodParameterTypes[parameterNumber];
                String arrayType = methodParameterType.substring(0, methodParameterType.length() - 2);
                LocalField lf = acb.newFieldDeclaration(2, methodParameterType);
                if (this.outParamArrays == null) {
                    this.outParamArrays = new LocalField[this.methodParms.length];
                }
                this.outParamArrays[parameterNumber] = lf;
                mb.pushNewArray(arrayType, 1);
                mb.setField(lf);
                break;
            }
        }
    }

    private void bindExpressions(DataDictionary dd) throws StandardException {
        this.onTable.bindTables(dd, this.onTable);
        Vector whereAggregates = new Vector();
        SubqueryList whereSubquerys = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
        this.getCompilerContext().pushCurrentPrivType(0);
        if (this.whereClause != null) {
            this.whereClause = this.whereClause.bindExpression(this.onTable, whereSubquerys, whereAggregates);
        }
        if (this.whereClause != null && whereAggregates.size() > 0) {
            throw StandardException.newException("42903");
        }
        if (this.whereClause != null && whereSubquerys.size() > 0) {
            throw StandardException.newException("42904", "CALL PROCEDURE");
        }
        if (this.whereClause != null && this.whereClause.isParameterNode()) {
            throw StandardException.newException("42X19", "PARAMETER");
        }
        if (this.whereClause != null) {
            this.whereClause = this.whereClause.checkIsBoolean();
        }
        this.getCompilerContext().popCurrentPrivType();
        if (this.whereClause != null) {
            this.whereClause = SelectNode.normExpressions(this.whereClause);
            this.whereClause = this.whereClause.preprocess(1, null, null, null);
        }
        if (this.onTable.elementAt(0) instanceof FromSubquery || this.onTable.elementAt(0) instanceof FromVTI) {
            throw StandardException.newException("0A000.S", "CALL statement allowed on base table only");
        }
        this.table = (FromBaseTable)this.onTable.elementAt(0);
        this.table.initAccessPaths(null);
        JBitSet referencedTableMap = new JBitSet(1);
        referencedTableMap.set(this.table.getTableNumber());
        this.table.setReferencedTableMap(referencedTableMap);
        TableDescriptor td = this.table.getTableDescriptor();
        if (td.getSchemaDescriptor().isSystemSchema() || td.getSchemaDescriptor().getSchemaName().equals("SESSION")) {
            throw StandardException.newException("0A000.S", "CALL statement not allowed on SYS or temporary tables");
        }
        this.tableId = td.getUUID();
        int numColumns = td.getColumnDescriptorList().size();
        JBitSet referencedColumns = new JBitSet(numColumns + 1);
        ReferencedColumnsVisitor rcv = new ReferencedColumnsVisitor(referencedColumns);
        if (this.whereClause != null) {
            this.whereClause.accept(rcv);
        }
        PredicateList wherePredicates = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        wherePredicates.pullExpressions(1, this.whereClause);
        if (wherePredicates != null && wherePredicates.size() > 0) {
            this.printLabel(0, "wherePredicates: ");
            wherePredicates.treePrint(1);
        }
        PredicateList actionPredicates = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        this.searchUsefulStartKeyAndStopKey(td, referencedColumns, wherePredicates, actionPredicates);
    }

    private void searchUsefulStartKeyAndStopKey(TableDescriptor td, JBitSet referencedColumns, PredicateList where, PredicateList actionPredicates) throws StandardException {
        assert (td != null) : "The table descriptor cannot be null";
        Region region = Misc.getRegionForTableByPath(td.getSchemaName() + "." + td.getName(), true);
        assert (region != null) : "The region is supposed not to be null!";
        GfxdPartitionResolver resolver = null;
        if (!(region instanceof PartitionedRegion)) {
            return;
        }
        resolver = (GfxdPartitionResolver)((PartitionedRegion)region).getPartitionResolver();
        DistributionDescriptor dd = resolver.getDistributionDescriptor();
        int[] partitionColumnPositions = null;
        if (dd.getPolicy() <= 3 || (partitionColumnPositions = dd.getColumnPositionsSorted()) == null) {
            return;
        }
        int numColumns = td.getColumnDescriptorList().size();
        JBitSet partitionColumns = new JBitSet(numColumns + 1);
        for (int i = 0; i < partitionColumnPositions.length; ++i) {
            partitionColumns.set(partitionColumnPositions[i]);
        }
        ArrayList<ConglomerateDescriptor> candidateConglomerates = new ArrayList<ConglomerateDescriptor>();
        ConglomerateDescriptorList cdl = td.getConglomerateDescriptorList();
        int numCong = cdl.size();
        boolean hasIndexForPartitionColumns = false;
        for (int index = 0; index < numCong; ++index) {
            int[] columnPositions;
            IndexRowGenerator irg;
            String indexType;
            ConglomerateDescriptor cd = (ConglomerateDescriptor)cdl.get(index);
            if (!cd.isIndex() || (indexType = (irg = cd.getIndexDescriptor()).indexType()).equals("LOCALSORTEDMAP") || indexType.equals("LOCALHASH1") || !this.containColumns(referencedColumns, columnPositions = irg.baseColumnPositions())) continue;
            if (this.containColumns(partitionColumns, columnPositions)) {
                hasIndexForPartitionColumns = true;
                candidateConglomerates.add(0, cd);
                continue;
            }
            candidateConglomerates.add(cd);
        }
        if (!hasIndexForPartitionColumns) {
            candidateConglomerates.add(0, this.getFakeConglomerateDescriptor(partitionColumnPositions));
        }
        int candidateconglomeratesNum = candidateConglomerates.size();
        for (int index = 0; index < candidateconglomeratesNum; ++index) {
            ConglomerateDescriptor cd = (ConglomerateDescriptor)candidateConglomerates.get(index);
            int[] baseColumnPositions = cd.getIndexDescriptor().baseColumnPositions();
            actionPredicates.removeAllElements();
            this.getUsefulPredicates(where, baseColumnPositions, actionPredicates);
            if (!this.usefulPredicateList(actionPredicates, baseColumnPositions.length)) continue;
            this.restrictionPredicates = actionPredicates;
            this.indexId = cd.getConglomerateNumber();
            this.numColumns = baseColumnPositions.length + 1;
            this.table.getTrulyTheBestAccessPath().setConglomerateDescriptor(cd);
            break;
        }
    }

    boolean containColumns(JBitSet referencedColumns, int[] columnPositions) {
        int columnNum = columnPositions.length;
        for (int i = 0; i < columnNum; ++i) {
            if (referencedColumns.get(columnPositions[i])) continue;
            return false;
        }
        return true;
    }

    boolean usefulPredicateList(PredicateList predicates, int columnNum) {
        int stopPredicatesNum;
        int startPredicatesNum = predicates.getStartPredicatesNum();
        return startPredicatesNum == (stopPredicatesNum = predicates.getStopPredicatesNum()) && startPredicatesNum == columnNum;
    }

    ConglomerateDescriptor getFakeConglomerateDescriptor(int[] columnPositions) {
        boolean[] isAscending = new boolean[columnPositions.length];
        for (int i = 0; i < columnPositions.length; ++i) {
            isAscending[i] = true;
        }
        DataDescriptorGenerator ddg = this.getLanguageConnectionContext().getDataDictionary().getDataDescriptorGenerator();
        IndexRowGenerator indexRowGenerator = new IndexRowGenerator("LOCALHASH1", true, columnPositions, isAscending, columnPositions.length);
        ConglomerateDescriptor cd = ddg.newConglomerateDescriptor(-1L, "temp", true, indexRowGenerator, false, null, null, null);
        return cd;
    }

    private void getUsefulPredicates(PredicateList predList, int[] baseColumnPositions, PredicateList actionPredicates) throws StandardException {
        int size = predList.size();
        Object[] usefulPredicates = new Predicate[size];
        int usefulCount = 0;
        for (int index = 0; index < size; ++index) {
            int indexPosition;
            boolean isIn;
            Predicate pred = (Predicate)predList.elementAt(index);
            ColumnReference indexCol = null;
            RelationalOperator relop = pred.getRelop();
            InListOperatorNode inNode = pred.getSourceInList();
            boolean bl = isIn = inNode != null;
            if (!isIn && (relop == null || !relop.isQualifier(this.table, true))) continue;
            for (indexPosition = 0; indexPosition < baseColumnPositions.length; ++indexPosition) {
                if (isIn) {
                    if (inNode.getLeftOperand() instanceof ColumnReference) {
                        indexCol = (ColumnReference)inNode.getLeftOperand();
                        if (this.table.getTableNumber() != indexCol.getTableNumber() || indexCol.getColumnNumber() != baseColumnPositions[indexPosition] || inNode.selfReference(indexCol)) {
                            indexCol = null;
                        } else if (pred.isInListProbePredicate() && indexPosition > 0) {
                            indexCol = null;
                        }
                    }
                } else {
                    indexCol = relop.getColumnOperand(this.table, baseColumnPositions[indexPosition]);
                }
                if (indexCol != null) break;
            }
            if (indexCol == null) continue;
            pred.setIndexPosition(indexPosition);
            usefulPredicates[usefulCount++] = pred;
        }
        if (usefulCount == 0) {
            return;
        }
        if (usefulPredicates.length > usefulCount) {
            Predicate[] shrink = new Predicate[usefulCount];
            System.arraycopy(usefulPredicates, 0, shrink, 0, usefulCount);
            usefulPredicates = shrink;
        }
        Arrays.sort(usefulPredicates);
        int currentStartPosition = -1;
        boolean gapInStartPositions = false;
        int currentStopPosition = -1;
        boolean gapInStopPositions = false;
        boolean seenNonEquals = false;
        int firstNonEqualsPosition = -1;
        int lastStartEqualsPosition = -1;
        boolean seenGE = false;
        boolean seenGT = false;
        for (int i = 0; i < usefulCount; ++i) {
            boolean isIn;
            Object thisPred = usefulPredicates[i];
            int thisIndexPosition = ((Predicate)thisPred).getIndexPosition();
            boolean thisPredMarked = false;
            RelationalOperator relop = ((Predicate)thisPred).getRelop();
            int thisOperator = -1;
            boolean bl = isIn = ((Predicate)thisPred).getSourceInList() != null;
            if (relop != null) {
                thisOperator = relop.getOperator();
            }
            if (currentStartPosition != thisIndexPosition) {
                if (thisIndexPosition - currentStartPosition > 1) {
                    gapInStartPositions = true;
                } else if (thisOperator == 1 || thisOperator == 7) {
                    lastStartEqualsPosition = thisIndexPosition;
                }
                if (!gapInStartPositions && !seenGT && (isIn || relop.usefulStartKey(this.table))) {
                    ((Predicate)thisPred).markStartKey();
                    currentStartPosition = thisIndexPosition;
                    thisPredMarked = true;
                    boolean bl2 = seenGT = ((Predicate)thisPred).getStartOperator(this.table) == -1;
                }
            }
            if (currentStopPosition != thisIndexPosition) {
                if (thisIndexPosition - currentStopPosition > 1) {
                    gapInStopPositions = true;
                }
                if (!gapInStopPositions && !seenGE && (isIn || relop.usefulStopKey(this.table))) {
                    ((Predicate)thisPred).markStopKey();
                    currentStopPosition = thisIndexPosition;
                    thisPredMarked = true;
                    boolean bl3 = seenGE = ((Predicate)thisPred).getStopOperator(this.table) == 1;
                }
            }
            if (!isIn && (!thisPredMarked || seenNonEquals && thisIndexPosition != firstNonEqualsPosition)) {
                ((Predicate)thisPred).markQualifier();
            }
            if (lastStartEqualsPosition != thisIndexPosition && firstNonEqualsPosition == -1 && thisOperator != 1 && thisOperator != 7) {
                seenNonEquals = true;
                firstNonEqualsPosition = thisIndexPosition;
            }
            if (!thisPredMarked || ((Predicate)thisPred).isQualifier()) break;
            actionPredicates.addPredicate((Predicate)thisPred);
        }
    }
}

