/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.management.impl;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.management.GfxdMemberMXBean;
import com.pivotal.gemfirexd.internal.engine.management.NetworkServerConnectionStats;
import com.pivotal.gemfirexd.internal.engine.management.NetworkServerNestedConnectionStats;
import com.pivotal.gemfirexd.internal.engine.management.impl.InternalManagementService;
import com.pivotal.gemfirexd.internal.engine.management.impl.ManagementUtils;
import java.util.Iterator;
import java.util.Set;
import javax.management.ObjectName;

public class GfxdMemberClusterStatsMonitor {
    private long NETWORK_SERVER_CLIENT_CONNECTIONS_OPENED = 0L;
    private long NETWORK_SERVER_CLIENT_CONNECTIONS_CLOSED = 0L;
    private long NETWORK_SERVER_CLIENT_CONNECTIONS_ATTEMPTED = 0L;
    private long NETWORK_SERVER_CLIENT_CONNECTIONS_FAILED = 0L;
    private long NETWORK_SERVER_CLIENT_CONNECTIONS_LIFETIME = 0L;
    private long NETWORK_SERVER_CLIENT_CONNECTIONS_OPEN = 0L;
    private long NETWORK_SERVER_CLIENT_CONNECTIONS_IDLE = 0L;
    private long NETWORK_SERVER_PEER_CONNECTIONS_OPENED = 0L;
    private long NETWORK_SERVER_PEER_CONNECTIONS_CLOSED = 0L;
    private long NETWORK_SERVER_PEER_CONNECTIONS_ATTEMPTED = 0L;
    private long NETWORK_SERVER_PEER_CONNECTIONS_FAILED = 0L;
    private long NETWORK_SERVER_PEER_CONNECTIONS_LIFETIME = 0L;
    private long NETWORK_SERVER_PEER_CONNECTIONS_OPEN = 0L;
    private long NETWORK_SERVER_PEER_CONNECTIONS_IDLE = 0L;
    private long NETWORK_SERVER_NESTED_CONNECTIONS_OPEN = 0L;
    private long NETWORK_SERVER_NESTED_CONNECTIONS_CLOSED = 0L;
    private long NETWORK_SERVER_NESTED_CONNECTIONS_ACTIVE = 0L;
    private long NETWORK_SERVER_INTERNAL_CONNECTIONS_OPEN = 0L;
    private long NETWORK_SERVER_INTERNAL_CONNECTIONS_CLOSED = 0L;
    private long NETWORK_SERVER_INTERNAL_CONNECTIONS_ACTIVE = 0L;
    private int PROCEDURE_CALLS_COMPLETED = 0;
    private int PROCEDURE_CALLS_IN_PROGRESS = 0;
    private NetworkServerConnectionStats networkServerClientConnectionStats = null;
    private NetworkServerConnectionStats networkServerPeerConnectionStats = null;
    private NetworkServerNestedConnectionStats networkServerNestedConnectionStats = null;
    private NetworkServerNestedConnectionStats networkServerInternalConnectionStats = null;
    protected LogWriterI18n logger = InternalDistributedSystem.getLoggerI18n();

    public GfxdMemberClusterStatsMonitor() {
        this.networkServerClientConnectionStats = new NetworkServerConnectionStats("Client", this.NETWORK_SERVER_CLIENT_CONNECTIONS_OPENED, this.NETWORK_SERVER_CLIENT_CONNECTIONS_CLOSED, this.NETWORK_SERVER_CLIENT_CONNECTIONS_ATTEMPTED, this.NETWORK_SERVER_CLIENT_CONNECTIONS_FAILED, this.NETWORK_SERVER_CLIENT_CONNECTIONS_LIFETIME, this.NETWORK_SERVER_CLIENT_CONNECTIONS_OPEN, this.NETWORK_SERVER_CLIENT_CONNECTIONS_IDLE);
        this.networkServerPeerConnectionStats = new NetworkServerConnectionStats("Peer", this.NETWORK_SERVER_PEER_CONNECTIONS_OPENED, this.NETWORK_SERVER_PEER_CONNECTIONS_CLOSED, this.NETWORK_SERVER_PEER_CONNECTIONS_ATTEMPTED, this.NETWORK_SERVER_PEER_CONNECTIONS_FAILED, this.NETWORK_SERVER_PEER_CONNECTIONS_LIFETIME, this.NETWORK_SERVER_PEER_CONNECTIONS_OPEN, 0L);
        this.networkServerNestedConnectionStats = new NetworkServerNestedConnectionStats("Nested", this.NETWORK_SERVER_NESTED_CONNECTIONS_OPEN, this.NETWORK_SERVER_NESTED_CONNECTIONS_CLOSED, this.NETWORK_SERVER_NESTED_CONNECTIONS_ACTIVE);
        this.networkServerInternalConnectionStats = new NetworkServerNestedConnectionStats("Internal", this.NETWORK_SERVER_INTERNAL_CONNECTIONS_OPEN, this.NETWORK_SERVER_INTERNAL_CONNECTIONS_CLOSED, this.NETWORK_SERVER_INTERNAL_CONNECTIONS_ACTIVE);
    }

    public synchronized int getProcedureCallsCompleted() {
        this.update();
        return this.PROCEDURE_CALLS_COMPLETED;
    }

    public synchronized int getProcedureCallsInProgress() {
        this.update();
        return this.PROCEDURE_CALLS_IN_PROGRESS;
    }

    public synchronized NetworkServerConnectionStats getNetworkServerClientConnectionStats() {
        this.update();
        this.networkServerClientConnectionStats.updateNetworkServerConnectionStats(this.NETWORK_SERVER_CLIENT_CONNECTIONS_OPENED, this.NETWORK_SERVER_CLIENT_CONNECTIONS_CLOSED, this.NETWORK_SERVER_CLIENT_CONNECTIONS_ATTEMPTED, this.NETWORK_SERVER_CLIENT_CONNECTIONS_FAILED, this.NETWORK_SERVER_CLIENT_CONNECTIONS_LIFETIME, this.NETWORK_SERVER_CLIENT_CONNECTIONS_OPEN, this.NETWORK_SERVER_CLIENT_CONNECTIONS_IDLE);
        return this.networkServerClientConnectionStats;
    }

    public synchronized NetworkServerConnectionStats getNetworkServerPeerConnectionStats() {
        this.update();
        this.networkServerPeerConnectionStats.updateNetworkServerConnectionStats(this.NETWORK_SERVER_PEER_CONNECTIONS_OPENED, this.NETWORK_SERVER_PEER_CONNECTIONS_CLOSED, this.NETWORK_SERVER_PEER_CONNECTIONS_ATTEMPTED, this.NETWORK_SERVER_PEER_CONNECTIONS_FAILED, this.NETWORK_SERVER_PEER_CONNECTIONS_LIFETIME, this.NETWORK_SERVER_PEER_CONNECTIONS_OPEN, 0L);
        return this.networkServerPeerConnectionStats;
    }

    public synchronized NetworkServerNestedConnectionStats getNetworkServerNestedConnectionStats() {
        this.update();
        this.networkServerNestedConnectionStats.updateNetworkServerConnectionStats(this.NETWORK_SERVER_NESTED_CONNECTIONS_OPEN, this.NETWORK_SERVER_NESTED_CONNECTIONS_CLOSED, this.NETWORK_SERVER_NESTED_CONNECTIONS_ACTIVE);
        return this.networkServerNestedConnectionStats;
    }

    public synchronized NetworkServerNestedConnectionStats getNetworkServerInternalConnectionStats() {
        this.update();
        this.networkServerInternalConnectionStats.updateNetworkServerConnectionStats(this.NETWORK_SERVER_INTERNAL_CONNECTIONS_OPEN, this.NETWORK_SERVER_INTERNAL_CONNECTIONS_CLOSED, this.NETWORK_SERVER_INTERNAL_CONNECTIONS_ACTIVE);
        return this.networkServerInternalConnectionStats;
    }

    private void update() {
        assert (Thread.holdsLock(this));
        GemFireCacheImpl cache = Misc.getGemFireCacheNoThrow();
        if (cache != null) {
            Set dsMembers = CliUtil.getAllMembers((Cache)cache);
            Iterator it = dsMembers.iterator();
            this.reset();
            while (it.hasNext()) {
                try {
                    DistributedMember dsMember = (DistributedMember)it.next();
                    ObjectName memberMBeanName = ManagementUtils.getMemberMBeanName(MBeanJMXAdapter.getMemberNameOrId((DistributedMember)dsMember), "DEFAULT");
                    GfxdMemberMXBean mbean = InternalManagementService.getAnyInstance().getMBeanInstance(memberMBeanName, GfxdMemberMXBean.class);
                    if (mbean == null) continue;
                    this.PROCEDURE_CALLS_COMPLETED += mbean.getProcedureCallsCompleted();
                    this.PROCEDURE_CALLS_IN_PROGRESS += mbean.getProcedureCallsInProgress();
                    NetworkServerConnectionStats clientStats = mbean.getNetworkServerClientConnectionStats();
                    NetworkServerNestedConnectionStats internalStats = mbean.getNetworkServerInternalConnectionStats();
                    NetworkServerNestedConnectionStats nestedStats = mbean.getNetworkServerNestedConnectionStats();
                    NetworkServerConnectionStats peerStats = mbean.getNetworkServerPeerConnectionStats();
                    if (clientStats != null) {
                        this.NETWORK_SERVER_CLIENT_CONNECTIONS_OPENED += clientStats.getConnectionsOpened();
                        this.NETWORK_SERVER_CLIENT_CONNECTIONS_CLOSED += clientStats.getConnectionsClosed();
                        this.NETWORK_SERVER_CLIENT_CONNECTIONS_ATTEMPTED += clientStats.getConnectionsAttempted();
                        this.NETWORK_SERVER_CLIENT_CONNECTIONS_FAILED += clientStats.getConnectionsFailed();
                        this.NETWORK_SERVER_CLIENT_CONNECTIONS_LIFETIME += clientStats.getConnectionLifeTime();
                        this.NETWORK_SERVER_CLIENT_CONNECTIONS_OPEN += clientStats.getConnectionsOpen();
                        this.NETWORK_SERVER_CLIENT_CONNECTIONS_IDLE += clientStats.getConnectionsIdle();
                    }
                    if (peerStats != null) {
                        this.NETWORK_SERVER_PEER_CONNECTIONS_OPENED += peerStats.getConnectionsOpened();
                        this.NETWORK_SERVER_PEER_CONNECTIONS_CLOSED += peerStats.getConnectionsClosed();
                        this.NETWORK_SERVER_PEER_CONNECTIONS_ATTEMPTED += peerStats.getConnectionsAttempted();
                        this.NETWORK_SERVER_PEER_CONNECTIONS_FAILED += peerStats.getConnectionsFailed();
                        this.NETWORK_SERVER_PEER_CONNECTIONS_LIFETIME += peerStats.getConnectionLifeTime();
                        this.NETWORK_SERVER_PEER_CONNECTIONS_OPEN += peerStats.getConnectionsOpen();
                        this.NETWORK_SERVER_PEER_CONNECTIONS_IDLE += peerStats.getConnectionsIdle();
                    }
                    if (nestedStats != null) {
                        this.NETWORK_SERVER_NESTED_CONNECTIONS_OPEN += nestedStats.getConnectionsOpened();
                        this.NETWORK_SERVER_NESTED_CONNECTIONS_CLOSED += nestedStats.getConnectionsClosed();
                        this.NETWORK_SERVER_NESTED_CONNECTIONS_ACTIVE += nestedStats.getConnectionsActive();
                    }
                    if (internalStats == null) continue;
                    this.NETWORK_SERVER_INTERNAL_CONNECTIONS_OPEN += internalStats.getConnectionsOpened();
                    this.NETWORK_SERVER_INTERNAL_CONNECTIONS_CLOSED += internalStats.getConnectionsClosed();
                    this.NETWORK_SERVER_INTERNAL_CONNECTIONS_ACTIVE += internalStats.getConnectionsActive();
                }
                catch (Exception ex) {
                    if (!this.logger.fineEnabled()) continue;
                    this.logger.fine("Exception while aggregating member : " + ex.getMessage());
                    this.logger.fine("Cause : " + ex.getCause());
                }
            }
        }
    }

    void reset() {
        this.NETWORK_SERVER_CLIENT_CONNECTIONS_OPENED = 0L;
        this.NETWORK_SERVER_CLIENT_CONNECTIONS_CLOSED = 0L;
        this.NETWORK_SERVER_CLIENT_CONNECTIONS_ATTEMPTED = 0L;
        this.NETWORK_SERVER_CLIENT_CONNECTIONS_FAILED = 0L;
        this.NETWORK_SERVER_CLIENT_CONNECTIONS_LIFETIME = 0L;
        this.NETWORK_SERVER_CLIENT_CONNECTIONS_OPEN = 0L;
        this.NETWORK_SERVER_CLIENT_CONNECTIONS_IDLE = 0L;
        this.NETWORK_SERVER_PEER_CONNECTIONS_OPENED = 0L;
        this.NETWORK_SERVER_PEER_CONNECTIONS_CLOSED = 0L;
        this.NETWORK_SERVER_PEER_CONNECTIONS_ATTEMPTED = 0L;
        this.NETWORK_SERVER_PEER_CONNECTIONS_FAILED = 0L;
        this.NETWORK_SERVER_PEER_CONNECTIONS_LIFETIME = 0L;
        this.NETWORK_SERVER_PEER_CONNECTIONS_OPEN = 0L;
        this.NETWORK_SERVER_PEER_CONNECTIONS_IDLE = 0L;
        this.NETWORK_SERVER_NESTED_CONNECTIONS_OPEN = 0L;
        this.NETWORK_SERVER_NESTED_CONNECTIONS_CLOSED = 0L;
        this.NETWORK_SERVER_NESTED_CONNECTIONS_ACTIVE = 0L;
        this.NETWORK_SERVER_INTERNAL_CONNECTIONS_OPEN = 0L;
        this.NETWORK_SERVER_INTERNAL_CONNECTIONS_CLOSED = 0L;
        this.NETWORK_SERVER_INTERNAL_CONNECTIONS_ACTIVE = 0L;
        this.PROCEDURE_CALLS_COMPLETED = 0;
        this.PROCEDURE_CALLS_IN_PROGRESS = 0;
    }
}

