/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.fabricservice;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.cache.client.internal.BridgeServerLoadMessage;
import com.gemstone.gemfire.cache.server.ServerLoad;
import com.gemstone.gemfire.cache.server.ServerMetrics;
import com.gemstone.gemfire.cache.server.internal.ConnectionCountProbe;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisee;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.BridgeServerAdvisor;
import com.gemstone.gemfire.internal.cache.CacheServerLauncher;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberID;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.NetworkInterface;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.diag.SessionsVTI;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.SecurityUtils;
import com.pivotal.gemfirexd.internal.engine.fabricservice.FabricServiceUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.conn.ConnectionSignaller;
import com.pivotal.gemfirexd.internal.engine.sql.conn.ConnectionState;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.jdbc.AuthenticationService;
import com.pivotal.gemfirexd.internal.iapi.jdbc.DRDAServerStarter;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.services.monitor.FileMonitor;
import com.pivotal.gemfirexd.internal.jdbc.AutoloadedDriver;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.thrift.GFXDException;
import com.pivotal.gemfirexd.thrift.ServerType;
import com.pivotal.gemfirexd.thrift.common.SocketParameters;
import com.pivotal.gemfirexd.thrift.common.ThriftExceptionUtil;
import com.pivotal.gemfirexd.thrift.common.ThriftUtils;
import com.pivotal.gemfirexd.thrift.server.GfxdThriftServer;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.transport.TTransportException;

public abstract class FabricServiceImpl
implements FabricService {
    private static final String driver = "com.pivotal.gemfirexd.jdbc.EmbeddedDriver";
    protected static final String fabapi = "FabricServiceAPI";
    protected volatile FabricService.State serverstatus = FabricService.State.UNINITIALIZED;
    protected volatile FabricService.State previousServerStatus = FabricService.State.UNINITIALIZED;
    protected volatile FabricService.State networkserverstatus = FabricService.State.UNINITIALIZED;
    protected final HashMap<Object, Object> sysProps = new HashMap();
    protected String userName;
    protected String password;
    private String clientBindAddress = null;
    private int clientPort = -1;
    private Properties clientProperties = null;
    protected HashSet<NetworkInterface> allnetservers = new HashSet();
    protected FileMonitor monitorlite;
    private ServerRestarter restarter;
    private ForcedDisconnectListener forcedDisconnectListener;
    private static volatile FabricService theInstance;

    public static final FabricService getInstance() {
        return theInstance;
    }

    public static final void setInstance(FabricService instance) {
        theInstance = instance;
    }

    public Properties getSecurityPropertiesFromRestarter() {
        if (this.restarter != null) {
            return SecurityUtils.transformCredentialsForAutoReconnect(this.restarter.bootProperties);
        }
        return null;
    }

    public boolean isServer() {
        return false;
    }

    public String getProtocol() {
        return "jdbc:gemfirexd:";
    }

    public String getNetProtocol() {
        return "jdbc:gemfirexd://";
    }

    public String getDRDAProtocol() {
        return "jdbc:gemfirexd:drda://";
    }

    public String getThriftProtocol() {
        return "jdbc:gemfirexd:thrift://";
    }

    /*
     * Unable to fully structure code
     */
    protected void startImpl(Properties bootProperties, boolean ignoreIfStarted, boolean isLocator) throws SQLException {
        startTimeMillis = System.currentTimeMillis();
        Assert.assertHoldsLock((Object)this, (boolean)true);
        existingInstance = false;
        if (bootProperties == null) {
            bootProperties = new Properties();
        }
        this.monitorlite = FabricServiceUtils.initCachedMonitorLite(bootProperties, this.sysProps);
        oldcache = GemFireCacheImpl.getInstance();
        if (oldcache != null && !oldcache.isClosed() || (oldsys = InternalDistributedSystem.getConnectedInstance()) != null && oldsys.isConnected()) {
            try {
                if (ignoreIfStarted) {
                    existingInstance = true;
                }
                this.serverstatus = FabricService.State.RUNNING;
                stopProperties = new Properties();
                stopProperties.putAll((Map<?, ?>)bootProperties);
                this.stop(stopProperties);
                this.notifyStop(this.isReconnecting());
                if (!this.isReconnecting()) ** GOTO lbl38
                FabricServiceImpl.setInstance(this);
            }
            catch (Exception ex) {
                oldcache = GemFireCacheImpl.getInstance();
                if (oldcache != null && !oldcache.isClosed()) {
                    oldcache.close();
                    this.notifyStop(this.isReconnecting());
                }
                oldsys = InternalDistributedSystem.getConnectedInstance();
                if (oldsys != null && oldsys.isConnected()) {
                    oldsys.disconnect();
                    this.notifyStop(this.isReconnecting());
                }
                if (ex instanceof SQLException) {
                    throw (SQLException)ex;
                }
                throw (RuntimeException)ex;
            }
        } else if (this.serverstatus != FabricService.State.UNINITIALIZED && this.serverstatus != FabricService.State.STOPPED && this.serverstatus != FabricService.State.RECONNECTING) {
            this.notifyStop(this.isReconnecting());
        }
lbl38:
        // 8 sources

        if (!existingInstance && this.serverstatus != FabricService.State.UNINITIALIZED && this.serverstatus != FabricService.State.STOPPED && this.serverstatus != FabricService.State.RECONNECTING) {
            throw new IllegalStateException("unexpected server status = " + (Object)this.serverstatus);
        }
        this.serverstatus = FabricService.State.STARTING;
        jdbcConn = null;
        success = false;
        try {
            startupProps = FabricServiceUtils.preprocessProperties(bootProperties, this.monitorlite, this.sysProps, false);
            if (!existingInstance && SanityManager.TRACE_ON((String)"TraceFabricServiceBoot")) {
                this.monitorlite.dumpProperties((isLocator != false ? "GemFireXD locator" : "GemFireXD peer") + " boot properties ", bootProperties);
            }
            rebalance = (rebalanceObj = startupProps.remove("rebalance")) != null && "true".equalsIgnoreCase(rebalanceObj.toString()) != false;
            this.userName = startupProps.getProperty("user");
            this.userName = this.userName == null ? startupProps.getProperty("UserName") : this.userName;
            this.password = startupProps.getProperty("password");
            if (!startupProps.containsKey("gemfirexd.__rt.fabricapi")) {
                startupProps.setProperty("gemfirexd.__rt.fabricapi", GfxdConstants.BT_INDIC.FABRICAPI.toString());
            }
            FabricServiceImpl.registerDrivers();
            protocol = this.getProtocol();
            if (!startupProps.contains("route-query")) {
                startupProps.setProperty("route-query", "false");
            }
            DriverManager.getDriver(protocol);
            jdbcConn = new AutoloadedDriver().connect(protocol, startupProps);
            sys = InternalDistributedSystem.getConnectedInstance();
            if (sys == null || !sys.isConnected()) {
                throw new DistributedSystemDisconnectedException("Failed to connect to the distributed system.");
            }
            GemFireXDUtils.initFlags();
            if (rebalance && !isLocator && (cache = GemFireCacheImpl.getInstance()) != null) {
                SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)"Starting rebalance of buckets for the distributed system.");
                cache.getResourceManager().createRebalanceFactory().start();
            }
            if (existingInstance) {
                this.serverstatus = FabricService.State.RUNNING;
            }
            success = true;
            if (this.restarter == null && !sys.getConfig().getDisableAutoReconnect()) {
                this.registerServerRestarter(sys, bootProperties, ignoreIfStarted, isLocator);
            }
            this.registerForcedDisconnectListener(sys, bootProperties);
        }
        catch (SQLException sqle) {
            SanityManager.DEBUG_PRINT((String)"error:FabricServiceAPI", (String)(sqle.getSQLState() + " error occurred while starting server : " + sqle));
            throw sqle;
        }
        finally {
            try {
                if (jdbcConn != null && !jdbcConn.isClosed()) {
                    jdbcConn.close();
                }
            }
            catch (SQLException var18_20) {}
            if (this.serverstatus == FabricService.State.STARTING) {
                this.serverstatus = FabricService.State.UNINITIALIZED;
                jdbcConn = null;
            }
            if (!success) {
                FabricServiceImpl.theInstance = null;
            }
        }
        this.registerAutoStartedNetworkServer();
        memStore = Misc.getMemStore();
        if (memStore != null) {
            memStore.getIndexPersistenceStats().endNodeUp(startTimeMillis);
        }
    }

    private void registerAutoStartedNetworkServer() throws SQLException {
        Object sysServer = Monitor.getSystemModule(DRDAServerStarter.class.getName());
        if (sysServer != null) {
            this.networkserverstatus = FabricService.State.STARTING;
            try {
                DRDANetworkInterface netimpl = new DRDANetworkInterface((DRDAServerStarter)sysServer);
                netimpl.internalStart(null);
            }
            catch (SQLException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw Util.javaException(ex);
            }
        } else if (this.clientPort > 0 && this.networkserverstatus == FabricService.State.STOPPED && this.isReconnecting()) {
            this.startNetworkServer(this.clientBindAddress, this.clientPort, this.clientProperties);
        }
    }

    @Override
    public FabricService.State status() {
        return this.serverstatus;
    }

    public void setShutdownAllIdentifier() {
        Misc.getMemStoreBooting().setShutdownAllMode();
    }

    @Override
    public synchronized void stop(Properties shutdownCredentials) throws SQLException {
        this.stopNoSync(shutdownCredentials, InternalDistributedSystem.getConnectedInstance(), false);
    }

    public void stopNoSync(Properties shutdownCredentials, InternalDistributedSystem sys, boolean forcedDisconnect) throws SQLException {
        boolean stopNetServers = true;
        if (shutdownCredentials == null) {
            shutdownCredentials = new Properties();
        } else {
            stopNetServers = !"false".equalsIgnoreCase(shutdownCredentials.getProperty("stop-netservers"));
        }
        InternalDistributedSystem dsys = sys;
        if (dsys == null) {
            dsys = InternalDistributedSystem.getAnyInstance();
        }
        if (dsys == null || !dsys.isConnected() && !forcedDisconnect) {
            throw Util.newEmbedSQLException("XJ015.M", null, (Throwable)new DistributedSystemDisconnectedException("No connection to the distributed system"));
        }
        SQLException exception = null;
        try {
            GemFireStore store = GemFireStore.getBootedInstance();
            if (store == null || !store.isShutdownAll()) {
                this.authenticateShutdown(shutdownCredentials);
            }
            this.serverstatus = FabricService.State.STOPPING;
            if (GemFireXDUtils.TraceFabricServiceBoot) {
                SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)"Stopping the GemFireXD instance.");
            }
            if (stopNetServers) {
                this.stopAllNetworkServers();
            }
            this.serviceShutdown();
            shutdownCredentials.setProperty("shutdown", Boolean.TRUE.toString());
            DriverManager.getConnection(this.getProtocol(), shutdownCredentials);
        }
        catch (SQLException ex) {
            if (ex.getSQLState().equals("XJ015")) {
                this.userName = null;
                this.password = null;
                theInstance = null;
                return;
            }
            SanityManager.DEBUG_PRINT((String)"warning:FabricServiceAPI", (String)("exception while shutting down " + ex));
            exception = ex;
        }
        if (exception != null) {
            throw exception;
        }
        dsys = InternalDistributedSystem.getConnectedInstance();
        if (dsys != null && dsys.isConnected()) {
            throw new IllegalStateException("ds should be disconnected... ");
        }
        this.monitorlite = null;
        Monitor.clearCachedMonitorLite();
        this.userName = null;
        this.password = null;
        theInstance = null;
    }

    protected void serviceShutdown() throws SQLException {
    }

    @Override
    public boolean isReconnecting() {
        if (this.restarter == null) {
            return false;
        }
        return this.restarter.isReconnecting();
    }

    @Override
    public boolean waitUntilReconnected(long time, TimeUnit units) throws InterruptedException {
        if (this.restarter == null) {
            return false;
        }
        return this.restarter.waitUntilReconnected(time, units);
    }

    @Override
    public void stopReconnecting() {
        if (this.restarter != null) {
            this.restarter.stopReconnecting();
        }
    }

    protected void reconnecting() {
        this.serverstatus = FabricService.State.RECONNECTING;
    }

    protected final void authenticateShutdown(Properties shutdownCredentials) throws SQLException {
        AuthenticationService authService;
        if (shutdownCredentials.getProperty("gemfirexd.__rt.fabricapi") != null) {
            SanityManager.THROWASSERT((String)"boot indicator cannot be user supplied.");
        }
        if ((authService = (AuthenticationService)Monitor.findServiceModule(Misc.getMemStore().getDatabase(), "com.pivotal.gemfirexd.internal.iapi.jdbc.AuthenticationService", "peer.authentication")) == null) {
            return;
        }
        String failure = authService.authenticate(null, shutdownCredentials);
        if (failure != null) {
            throw Util.generateCsSQLException("08004.C.1", MessageService.getTextMessage("A020", failure));
        }
    }

    protected void handleThrowable(Throwable t) throws SQLException {
        if (GemFireXDUtils.TraceFabricServiceBoot) {
            SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)"Handling Throwable during startup", (Throwable)t);
        }
        FabricServiceUtils.clearSystemProperties(this.monitorlite, this.sysProps);
        if (t instanceof SQLException) {
            throw (SQLException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw GemFireXDRuntimeException.newRuntimeException("GemFireXD:FabricServer#start exception ... ", t);
    }

    public void notifyWaiting(String regionPath, Set<PersistentMemberID> membersToWaitFor, Set<Integer> missingBuckets, PersistentMemberID myId, String message) {
        if (GemFireXDUtils.TraceFabricServiceBoot) {
            SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)("Accepting WAITING notification" + (message != null ? ": " + message : "")));
        }
        if (this.serverstatus != FabricService.State.WAITING) {
            this.previousServerStatus = this.serverstatus;
        }
        this.serverstatus = FabricService.State.WAITING;
        FabricServiceImpl.notifyWaitingInLauncher(regionPath, membersToWaitFor, missingBuckets, myId, message);
    }

    public static void notifyWaitingInLauncher(String regionPath, Set<PersistentMemberID> membersToWaitFor, Set<Integer> missingBuckets, PersistentMemberID myId, String message) {
        CacheServerLauncher launcher = CacheServerLauncher.getCurrentInstance();
        if (launcher != null) {
            launcher.setWaitingStatus(regionPath, membersToWaitFor, missingBuckets, myId, message);
        }
    }

    public void endNotifyWaiting() {
        if (GemFireXDUtils.TraceFabricServiceBoot) {
            SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)("Accepting END WAITING notification with previous status " + (Object)((Object)this.previousServerStatus)));
        }
        if (this.previousServerStatus == FabricService.State.RUNNING) {
            this.serverstatus = FabricService.State.RUNNING;
        }
        this.previousServerStatus = FabricService.State.UNINITIALIZED;
    }

    public final synchronized void notifyRunning() {
        if (GemFireXDUtils.TraceFabricServiceBoot) {
            SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)"Accepting RUNNING notification");
        }
        this.serverstatus = FabricService.State.RUNNING;
    }

    public final synchronized void notifyStop(boolean reconnecting) {
        if (GemFireXDUtils.TraceFabricServiceBoot && SanityManager.isFinerEnabled) {
            SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)"Accepting STOPPED notification");
        }
        this.serverstatus = reconnecting ? FabricService.State.RECONNECTING : FabricService.State.STOPPED;
        FabricServiceUtils.clearSystemProperties(this.monitorlite, this.sysProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkInterface startNetworkServerImpl(String bindAddress, int port, Properties networkProperties, boolean thriftServer, String serverType) throws SQLException {
        String user;
        if (this.serverstatus != FabricService.State.RUNNING && GemFireStore.getBootedInstance() == null) {
            throw new IllegalStateException("server not started, cannot start network interface. serverstatus = " + (Object)((Object)this.serverstatus));
        }
        this.networkserverstatus = FabricService.State.STARTING;
        if (networkProperties == null) {
            networkProperties = new Properties();
        }
        FabricServiceImpl fabricServiceImpl = this;
        synchronized (fabricServiceImpl) {
            if (this.monitorlite == null) {
                this.monitorlite = FabricServiceUtils.initCachedMonitorLite(networkProperties, this.sysProps);
            }
        }
        if (bindAddress == null && !thriftServer) {
            bindAddress = (String)networkProperties.remove("gemfirexd.drda.host");
        }
        String string = user = (user = networkProperties.getProperty("user")) == null ? networkProperties.getProperty("UserName") : user;
        if (user != null) {
            FabricServiceImpl fabricServiceImpl2 = this;
            synchronized (fabricServiceImpl2) {
                this.userName = user;
                this.password = networkProperties.getProperty("password");
            }
        }
        if (port <= 0) {
            String portStr;
            port = !thriftServer ? ((portStr = (String)networkProperties.remove("gemfirexd.drda.portNumber")) != null ? Integer.parseInt(portStr) : 1527) : 1527;
        }
        InetAddress listenAddress = this.getListenAddress(bindAddress);
        assert (listenAddress != null);
        if (port <= 1 || port >= 65535) {
            throw new IllegalArgumentException("Allowed port range is between 1 to 65535 (excluding limits)");
        }
        SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)("Starting " + serverType + " on: " + listenAddress + '[' + port + ']'));
        this.clientPort = port;
        this.clientBindAddress = bindAddress;
        this.clientProperties = new Properties();
        this.clientProperties.putAll((Map<?, ?>)networkProperties);
        NetworkInterfaceImpl netImpl = thriftServer ? new ThriftNetworkInterface(listenAddress, port) : new DRDANetworkInterface(listenAddress, port);
        int numtries = 0;
        boolean retry = port == 1527;
        do {
            try {
                ++numtries;
                netImpl.internalStart(networkProperties);
                retry = false;
            }
            catch (GemFireXDRuntimeException e) {
                if (retry && numtries <= 10) {
                    netImpl.setPort(port++);
                    continue;
                }
                throw e;
            }
        } while (retry && numtries <= 10);
        if (netImpl.getServerType().isThrift()) {
            serverType = serverType + " (" + netImpl.getServerType().getProtocolString() + ')';
        }
        SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)("Started " + serverType + " on: " + listenAddress + '[' + port + ']'));
        return netImpl;
    }

    @Override
    public NetworkInterface startNetworkServer(String bindAddress, int port, Properties networkProperties) throws SQLException {
        return ClientSharedUtils.USE_THRIFT_AS_DEFAULT ? this.startThriftServer(bindAddress, port, networkProperties) : this.startDRDAServer(bindAddress, port, networkProperties);
    }

    @Override
    public NetworkInterface startThriftServer(String bindAddress, int port, Properties networkProperties) throws SQLException {
        String serverString = this.isServer() ? "server" : "locator";
        String thriftDisplay = networkProperties != null && "true".equalsIgnoreCase(networkProperties.getProperty("thrift-ssl")) ? "Secure(SSL) Thrift " : "Thrift ";
        return this.startNetworkServerImpl(bindAddress, port, networkProperties, true, thriftDisplay + serverString);
    }

    @Override
    public NetworkInterface startDRDAServer(String bindAddress, int port, Properties networkProperties) throws SQLException {
        return this.startNetworkServerImpl(bindAddress, port, networkProperties, false, "DRDA server");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAllNetworkServers() {
        block14: {
            this.networkserverstatus = FabricService.State.STOPPING;
            if (GemFireXDUtils.TraceFabricServiceBoot) {
                SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)"Stopping all network interfaces ");
            }
            try {
                for (NetworkInterface ni : this.getAllNetworkServers()) {
                    ni.stop();
                }
                DRDAServerStarter server = (DRDAServerStarter)Monitor.getSystemModule(DRDAServerStarter.class.getName());
                if (server == null) break block14;
                boolean stopped = false;
                try {
                    server.ping();
                    server.stop();
                    for (int tries = 1; tries <= 200; ++tries) {
                        try {
                            server.ping();
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        catch (Throwable t) {
                            stopped = true;
                            break;
                        }
                    }
                }
                catch (Throwable t) {
                    stopped = true;
                }
                if (GemFireXDUtils.TraceFabricServiceBoot) {
                    SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)("Stopped " + server + " successfully. status " + (Object)((Object)(stopped ? FabricService.State.STOPPED : FabricService.State.RUNNING))));
                }
            }
            finally {
                this.networkserverstatus = FabricService.State.STOPPED;
            }
        }
        if (GemFireXDUtils.TraceFabricServiceBoot) {
            SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)"All network interfaces stopped successfully ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NetworkInterface> getAllNetworkServers() {
        HashSet<NetworkInterface> hashSet = this.allnetservers;
        synchronized (hashSet) {
            return new ArrayList<NetworkInterface>(this.allnetservers);
        }
    }

    protected InetAddress getListenAddress(String bindAddress) {
        InetAddress listenAddress;
        try {
            listenAddress = FabricServiceUtils.getListenAddress(bindAddress, null);
        }
        catch (UnknownHostException uhe) {
            String msg = MessageService.getTextMessage("J135", bindAddress);
            this.logSevere(msg, uhe);
            GemFireXDRuntimeException rte = new GemFireXDRuntimeException(msg);
            rte.setStackTrace(new StackTraceElement[0]);
            throw rte;
        }
        return listenAddress;
    }

    void logSevere(String msg, Exception ex) {
        SanityManager.DEBUG_PRINT((String)fabapi, (String)msg, (Throwable)ex);
        if (msg != null) {
            System.err.println(msg);
        }
        if (ex != null) {
            ex.printStackTrace(System.err);
        }
    }

    static void registerDrivers() {
        try {
            Class.forName(driver).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            SanityManager.DEBUG_PRINT((String)"warning", (String)("Unable to load the JDBC driver com.pivotal.gemfirexd.jdbc.EmbeddedDriver:" + cnfe.getMessage()));
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
            SanityManager.DEBUG_PRINT((String)"warning", (String)("Unable to instantiate the JDBC driver com.pivotal.gemfirexd.jdbc.EmbeddedDriver:" + ie.getMessage()));
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
            SanityManager.DEBUG_PRINT((String)"warning", (String)("Not allowed to access the JDBC driver com.pivotal.gemfirexd.jdbc.EmbeddedDriver:" + iae.getMessage()));
        }
    }

    private void registerServerRestarter(InternalDistributedSystem sys, Properties bootProperties, boolean ignoreIfStarted, boolean isLocator) {
        if (!sys.getConfig().getDisableAutoReconnect()) {
            this.restarter = new ServerRestarter(sys, bootProperties, ignoreIfStarted, isLocator);
            InternalDistributedSystem.addReconnectListener((InternalDistributedSystem.ReconnectListener)this.restarter);
        }
    }

    private void registerForcedDisconnectListener(InternalDistributedSystem sys, Properties bootProperties) {
        this.forcedDisconnectListener = new ForcedDisconnectListener(sys, bootProperties);
        sys.setGfxdForcedDisconnectListener((InternalDistributedSystem.DisconnectListener)this.forcedDisconnectListener);
    }

    static class ServerRestarter
    implements InternalDistributedSystem.ReconnectListener {
        InternalDistributedSystem sys;
        Properties bootProperties;
        boolean ignoreIfStarted;
        boolean isLocator;

        ServerRestarter(InternalDistributedSystem sys, Properties bootProperties, boolean ignoreIfStarted, boolean isLocator) {
            this.sys = sys;
            this.bootProperties = new Properties();
            for (Map.Entry<Object, Object> en : bootProperties.entrySet()) {
                this.bootProperties.put(en.getKey(), en.getValue());
            }
            this.ignoreIfStarted = ignoreIfStarted;
            this.isLocator = isLocator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reconnecting(InternalDistributedSystem oldsys) {
            FabricServiceImpl impl = (FabricServiceImpl)FabricServiceImpl.getInstance();
            if (impl != null) {
                FabricServiceImpl fabricServiceImpl = impl;
                synchronized (fabricServiceImpl) {
                    impl.reconnecting();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReconnect(InternalDistributedSystem oldSystem, InternalDistributedSystem newSystem) {
            block6: {
                FabricServiceImpl impl = (FabricServiceImpl)FabricServiceImpl.getInstance();
                if (impl != null) {
                    try {
                        FabricServiceImpl fabricServiceImpl = impl;
                        synchronized (fabricServiceImpl) {
                            newSystem.getLogWriter().info("rebooting GemFireXD " + (this.isLocator ? "locator" : "server") + " instance");
                            impl.startImpl(this.bootProperties, false, this.isLocator);
                        }
                        this.sys = InternalDistributedSystem.getConnectedInstance();
                    }
                    catch (SQLException e) {
                        newSystem.getLogWriter().severe("Unable to recreate services due to exception", (Throwable)e);
                        newSystem.disconnect();
                        if (FabricServiceImpl.getInstance() != impl) break block6;
                        FabricServiceImpl.setInstance(null);
                    }
                }
            }
        }

        public boolean isReconnecting() {
            return this.sys.isReconnecting() || this.sys.reconnected();
        }

        public boolean waitUntilReconnected(long time, TimeUnit units) throws InterruptedException {
            return this.sys.reconnected() || this.sys.waitUntilReconnected(time, units);
        }

        public void stopReconnecting() {
            this.sys.stopReconnecting();
        }
    }

    static class ForcedDisconnectListener
    implements InternalDistributedSystem.DisconnectListener {
        InternalDistributedSystem sys;
        Properties bootProperties;

        ForcedDisconnectListener(InternalDistributedSystem sys, Properties bootProperties) {
            this.sys = sys;
            this.bootProperties = bootProperties;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDisconnect(InternalDistributedSystem sys) {
            FabricServiceImpl impl;
            if (sys.forcedDisconnect() && sys.getConfig().getDisableAutoReconnect() && (impl = (FabricServiceImpl)FabricServiceImpl.getInstance()) != null) {
                try {
                    FabricServiceImpl fabricServiceImpl = impl;
                    synchronized (fabricServiceImpl) {
                        sys.getLogWriter().fine("FabricService stopping due to forced-disconnect");
                        impl.stopNoSync(this.bootProperties, sys, true);
                    }
                }
                catch (SQLException e) {
                    SanityManager.DEBUG_PRINT((String)FabricServiceImpl.fabapi, (String)"exception caught while stopping service due to forced disconnect", (Throwable)e);
                }
            }
        }
    }

    private final class DRDANetworkInterface
    extends NetworkInterfaceImpl {
        private final DRDAServerStarter netserver;

        DRDANetworkInterface(InetAddress address, int portNumber) {
            super(address, portNumber, false);
            this.netserver = new DRDAServerStarter();
        }

        DRDANetworkInterface(DRDAServerStarter server) throws Exception {
            super(true);
            int[] outPort = new int[1];
            InetAddress addr = (InetAddress)server.invoke(DRDAServerStarter.NetworkServerControlProps.getHostAddressAndPort, new Object[]{outPort});
            this.initAddress(addr, outPort[0]);
            this.netserver = server;
        }

        @Override
        public ServerType getServerType() {
            return ServerType.DRDA;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void preStart(Properties networkProps) {
            if (!this.isPreStarted) {
                FabricServiceImpl fabricServiceImpl = FabricServiceImpl.this;
                synchronized (fabricServiceImpl) {
                    if (FabricServiceImpl.this.userName != null) {
                        this.netserver.setStartInfo(this.inetAddress, this.port, FabricServiceImpl.this.userName, FabricServiceImpl.this.password, new PrintWriter(System.err));
                    } else {
                        this.netserver.setStartInfo(this.inetAddress, this.port, new PrintWriter(System.err));
                    }
                }
            }
            if (!this.isPreStarted && !this.isAddressAvailable(this.port, this.inetAddress)) {
                String err = MessageService.getTextMessage("J137", this.inetAddress, this.port);
                FabricServiceImpl.this.logSevere(err, null);
                GemFireXDRuntimeException rte = new GemFireXDRuntimeException(err);
                rte.setStackTrace(new StackTraceElement[0]);
                throw rte;
            }
        }

        @Override
        protected void startServer(Properties networkProps) {
            if (!this.isPreStarted) {
                this.netserver.boot(false, null);
            }
            this.netserver.setConnectionListener(this);
        }

        @Override
        protected void stopServer() {
            this.netserver.stop();
        }

        @Override
        public boolean status() {
            try {
                this.netserver.ping();
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }

        @Override
        public void collectStatisticsSample() {
            this.netserver.collectStatisticsSamples();
        }

        @Override
        public void trace(boolean on) {
            this.netserver.invoke(DRDAServerStarter.NetworkServerControlProps.traceBoolean, new Object[]{on});
        }

        @Override
        public void trace(int connNum, boolean on) {
            this.netserver.invoke(DRDAServerStarter.NetworkServerControlProps.traceConnNumBoolean, new Object[]{connNum, on});
        }

        @Override
        public void logConnections(boolean on) {
            this.netserver.invoke(DRDAServerStarter.NetworkServerControlProps.logConnections, new Object[]{on});
        }

        @Override
        public void setTraceDirectory(String traceDirectory) {
            this.netserver.invoke(DRDAServerStarter.NetworkServerControlProps.sendSetTraceDirectory, new Object[]{traceDirectory});
        }

        @Override
        public String getSysinfo() {
            Object ret = this.netserver.invoke(DRDAServerStarter.NetworkServerControlProps.sysinfo, null);
            assert (ret instanceof String) : "getSysinfo expected to return string";
            return (String)ret;
        }

        @Override
        public String getRuntimeInfo() {
            Object ret = this.netserver.invoke(DRDAServerStarter.NetworkServerControlProps.runtimeInfo, null);
            assert (ret instanceof String) : "getRuntimeInfo expected to return string";
            return (String)ret;
        }

        @Override
        public void setMaxThreads(int max) {
            this.netserver.invoke(DRDAServerStarter.NetworkServerControlProps.netSetMaxThreads, new Object[]{max});
        }

        @Override
        public int getMaxThreads() {
            String val = this.getCurrentProperties().getProperty("gemfirexd.drda.maxThreads");
            return Integer.parseInt(val);
        }

        @Override
        public void setTimeSlice(int timeslice) {
            this.netserver.invoke(DRDAServerStarter.NetworkServerControlProps.netSetTimeSlice, new Object[]{timeslice});
        }

        @Override
        public int getTimeSlice() {
            String val = this.getCurrentProperties().getProperty("gemfirexd.drda.timeSlice");
            return Integer.parseInt(val);
        }

        @Override
        public Properties getCurrentProperties() {
            Object props = this.netserver.invoke(DRDAServerStarter.NetworkServerControlProps.getCurrentProperties, null);
            assert (props instanceof Properties) : "getCurrentProperties is expected to have property bag returned.";
            return (Properties)props;
        }

        @Override
        public String toString() {
            return "DRDA Network interface " + this.asString();
        }

        @Override
        public String getName() {
            return "FabricServer.DRDANetworkInterface";
        }

        @Override
        protected void fillServerSessionInfo(SessionsVTI.SessionInfo info) {
            this.netserver.getSessionInfo(info);
        }
    }

    private final class ThriftNetworkInterface
    extends NetworkInterfaceImpl {
        private final GfxdThriftServer thriftService;
        private int maxThreads;
        private final SocketParameters socketParams;

        ThriftNetworkInterface(InetAddress address, int portNumber) {
            super(address, portNumber, false);
            this.maxThreads = Math.max(Runtime.getRuntime().availableProcessors() * 4, Short.MAX_VALUE);
            this.thriftService = new GfxdThriftServer();
            this.socketParams = FabricServiceImpl.this.isServer() ? new SocketParameters(ServerType.THRIFT_GFXD_CP) : new SocketParameters(ServerType.THRIFT_LOCATOR_CP);
        }

        @Override
        public ServerType getServerType() {
            return this.socketParams.getServerType();
        }

        @Override
        protected void preStart(Properties networkProps) {
        }

        @Override
        protected void startServer(Properties networkProps) {
            try {
                boolean useSSL;
                boolean useBinaryProtocol;
                boolean isServer = FabricServiceImpl.this.isServer();
                if (networkProps != null) {
                    useBinaryProtocol = Boolean.parseBoolean((String)networkProps.remove("thrift-binary-protocol"));
                    useSSL = Boolean.parseBoolean((String)networkProps.remove("thrift-ssl"));
                    String propValue = (String)networkProps.remove("thrift-ssl-properties");
                    if (propValue != null) {
                        useSSL = true;
                        ThriftUtils.getSSLParameters((SocketParameters)this.socketParams, (String)propValue);
                    }
                    for (SocketParameters.Param param : SocketParameters.getAllParamsNoSSL()) {
                        propValue = (String)networkProps.remove(param.getPropertyName());
                        if (propValue == null) continue;
                        param.setParameter(this.socketParams, propValue);
                    }
                } else {
                    useBinaryProtocol = false;
                    useSSL = false;
                }
                this.socketParams.setServerType(ServerType.getServerType((boolean)isServer, (boolean)useBinaryProtocol, (boolean)useSSL));
                this.thriftService.start(this.inetAddress, this.port, this.maxThreads, isServer, useBinaryProtocol, useSSL, this.socketParams, this);
            }
            catch (TTransportException te) {
                throw new GemFireXDRuntimeException(te);
            }
            catch (GFXDException gfxde) {
                throw new GemFireXDRuntimeException(ThriftExceptionUtil.newSQLException((GFXDException)gfxde));
            }
        }

        @Override
        public void stopServer() {
            this.thriftService.stop();
            this.socketParams.setServerType(FabricServiceImpl.this.isServer() ? ServerType.THRIFT_GFXD_CP : ServerType.THRIFT_LOCATOR_CP);
        }

        @Override
        public boolean status() {
            return this.thriftService.isServing();
        }

        @Override
        public void collectStatisticsSample() {
        }

        @Override
        public void trace(boolean on) {
        }

        @Override
        public void trace(int connNum, boolean on) {
        }

        @Override
        public void logConnections(boolean on) {
        }

        @Override
        public void setTraceDirectory(String traceDirectory) {
        }

        @Override
        public String getSysinfo() {
            return null;
        }

        @Override
        public String getRuntimeInfo() {
            return null;
        }

        @Override
        public void setMaxThreads(int max) {
            this.maxThreads = max;
        }

        @Override
        public int getMaxThreads() {
            return this.maxThreads;
        }

        @Override
        public void setTimeSlice(int timeslice) {
        }

        @Override
        public int getTimeSlice() {
            return -1;
        }

        @Override
        public Properties getCurrentProperties() {
            return null;
        }

        @Override
        public String toString() {
            return "Thrift Network interface " + this.asString();
        }

        @Override
        public String getName() {
            return "FabricServer.ThriftNetworkInterface";
        }

        @Override
        protected void fillServerSessionInfo(SessionsVTI.SessionInfo info) {
        }
    }

    public abstract class NetworkInterfaceImpl
    implements NetworkInterface,
    DistributionAdvisee,
    NetworkInterface.ConnectionListener,
    ConnectionState,
    ServerMetrics {
        protected InetAddress inetAddress;
        protected volatile String hostName;
        protected int port;
        protected final boolean isPreStarted;
        private int serialNumber;
        private BridgeServerAdvisor advisor;
        private NetworkInterface.ConnectionListener connListener;
        protected volatile ServerLocation location;
        private final ConnectionCountProbe probe = new ConnectionCountProbe();
        private volatile int totalConnections = 0;
        private int connectionDelta = 0;
        private int clientCount = 0;
        private boolean preferIPAddressForClients;
        private String initialLoad;
        private Properties networkProps;

        protected NetworkInterfaceImpl(boolean preStarted) {
            this.isPreStarted = preStarted;
        }

        protected NetworkInterfaceImpl(InetAddress address, int portNumber, boolean preStarted) {
            this(preStarted);
            this.initAddress(address, portNumber);
        }

        protected void initAddress(InetAddress address, int portNumber) {
            this.inetAddress = address;
            this.port = portNumber;
            this.location = new ServerLocation(this.getHostNameForClients(), portNumber);
        }

        protected abstract void preStart(Properties var1);

        protected abstract void startServer(Properties var1);

        protected abstract void stopServer();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void internalStart(Properties networkProps) {
            this.preStart(networkProps);
            if (FabricServiceImpl.this.networkserverstatus.ordinal() >= FabricService.State.STOPPING.ordinal()) {
                throw GemFireXDRuntimeException.newRuntimeException("Cannot start network servers while all network interfaces are shutting down", null);
            }
            if (GemFireXDUtils.TraceFabricServiceBoot) {
                SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)((!this.isPreStarted ? "Starting " : "Wrapping ") + this + " on given address " + this.inetAddress + '[' + this.port + ']'));
            }
            this.networkProps = networkProps;
            this.setHostNameForClients(networkProps);
            if (this.port > 0) {
                this.location = new ServerLocation(this.getHostNameForClients(), this.port);
            }
            this.serialNumber = DistributionAdvisor.createSerialNumber();
            this.advisor = BridgeServerAdvisor.createBridgeServerAdvisor((DistributionAdvisee)this);
            if (FabricServiceImpl.this.isServer()) {
                this.advisor.handshake();
            }
            Object object = FabricServiceImpl.this;
            synchronized (object) {
                block23: {
                    Properties oldProps = null;
                    try {
                        if (networkProps != null) {
                            oldProps = new Properties();
                            Enumeration<?> propNames = networkProps.propertyNames();
                            while (propNames.hasMoreElements()) {
                                String propName = (String)propNames.nextElement();
                                String oldVal = FabricServiceImpl.this.monitorlite.getJVMProperty(propName);
                                String propValue = networkProps.getProperty(propName);
                                if (oldVal != null) {
                                    oldProps.setProperty(propName, oldVal);
                                }
                                if (propValue == null) continue;
                                FabricServiceImpl.this.monitorlite.setJVMProperty(propName, propValue);
                            }
                        }
                        this.startServer(networkProps);
                        while (!this.status()) {
                            Thread.sleep(50L);
                        }
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        this.getCancelCriterion().checkCancelInProgress((Throwable)ie);
                    }
                    finally {
                        if (networkProps == null) break block23;
                        Enumeration<?> propNames = networkProps.propertyNames();
                        while (propNames.hasMoreElements()) {
                            String propName = (String)propNames.nextElement();
                            String oldVal = oldProps.getProperty(propName);
                            if (oldVal == null) {
                                FabricServiceImpl.this.monitorlite.clearJVMProperty(propName);
                                continue;
                            }
                            FabricServiceImpl.this.monitorlite.setJVMProperty(propName, oldVal);
                        }
                    }
                }
            }
            if (GemFireXDUtils.TraceFabricServiceBoot) {
                SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)((!this.isPreStarted ? "Started " : "Wrapped ") + this + " sucessfully (prefer-ipaddress=" + this.preferIPAddressForClients + "). status " + (this.status() ? FabricService.State.RUNNING : " UNKNOWN ")));
            }
            object = FabricServiceImpl.this.allnetservers;
            synchronized (object) {
                if (!FabricServiceImpl.this.allnetservers.add(this)) {
                    this.stop();
                    throw GemFireXDRuntimeException.newRuntimeException("Unexpected existing network server when creating a new one", null);
                }
                FabricServiceImpl.this.networkserverstatus = FabricService.State.RUNNING;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            try {
                if (GemFireXDUtils.TraceFabricServiceBoot) {
                    SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)("Stopping " + this));
                }
                if (this.advisor != null && this.advisor.isInitialized()) {
                    this.advisor.close();
                }
                NetworkInterfaceImpl networkInterfaceImpl = this;
                synchronized (networkInterfaceImpl) {
                    if (this.connListener != null) {
                        this.connListener.close();
                        this.connListener = null;
                    }
                    this.clientCount = 0;
                }
                this.networkProps = null;
                this.stopServer();
                for (int tries = 1; tries <= 200 && this.status(); ++tries) {
                    try {
                        Thread.sleep(50L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)("Stopped " + this + " successfully. status " + (Object)((Object)(FabricServiceImpl.this.isReconnecting() ? FabricService.State.RECONNECTING : (this.status() ? FabricService.State.RUNNING : FabricService.State.STOPPED)))));
            }
            finally {
                HashSet<NetworkInterface> hashSet = FabricServiceImpl.this.allnetservers;
                synchronized (hashSet) {
                    FabricServiceImpl.this.allnetservers.remove(this);
                    if (FabricServiceImpl.this.allnetservers.isEmpty()) {
                        FabricServiceImpl.this.networkserverstatus = FabricService.State.STOPPED;
                    }
                }
            }
        }

        @Override
        public synchronized void setConnectionListener(NetworkInterface.ConnectionListener listener) {
            this.connListener = listener;
        }

        @Override
        public int getTotalConnections() {
            return this.totalConnections;
        }

        @Override
        public final String asString() {
            return this.getHostName() + '[' + this.getPort() + ']';
        }

        @Override
        public final String getHostName() {
            String hostName = this.getHostNameForClients();
            if (hostName != null) {
                return hostName + '/' + this.inetAddress.getHostAddress();
            }
            return "/" + this.inetAddress.getHostAddress();
        }

        @Override
        public final int getPort() {
            return this.port;
        }

        public final void setPort(int port) {
            this.port = port;
        }

        public abstract void collectStatisticsSample();

        protected final String getHostNameForClients() {
            if (this.hostName != null) {
                return this.hostName;
            }
            return this.setHostNameForClients(this.networkProps);
        }

        protected final String setHostNameForClients(Properties networkProps) {
            this.preferIPAddressForClients = PropertyUtil.getBooleanProperty("prefer-netserver-ipaddress", GfxdConstants.GFXD_PREFER_NETSERVER_IP_ADDRESS, networkProps, false, FabricServiceImpl.this.monitorlite);
            if (this.inetAddress.isAnyLocalAddress()) {
                try {
                    InetAddress localHost = SocketCreator.getLocalHost();
                    if (localHost != null && !localHost.isLoopbackAddress()) {
                        this.hostName = this.preferIPAddressForClients ? localHost.getHostAddress() : localHost.getCanonicalHostName();
                        return this.hostName;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            this.hostName = this.preferIPAddressForClients ? this.inetAddress.getHostAddress() : this.inetAddress.getCanonicalHostName();
            return this.hostName;
        }

        public String toString() {
            return "Network interface " + this.asString();
        }

        public int hashCode() {
            return (this.inetAddress.hashCode() ^ this.port) * 3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean isAddressAvailable(int port, InetAddress addr) {
            ServerSocket ss = null;
            boolean isAvailable = false;
            try {
                ss = new ServerSocket(port, 0, addr);
                isAvailable = true;
            }
            catch (IOException iOException) {
            }
            finally {
                if (ss != null) {
                    try {
                        ss.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return isAvailable;
        }

        public DM getDistributionManager() {
            return this.getSystem().getDistributionManager();
        }

        public CancelCriterion getCancelCriterion() {
            return this.getSystem().getCancelCriterion();
        }

        public InternalDistributedSystem getSystem() {
            return Misc.getDistributedSystem();
        }

        public void fillInProfile(DistributionAdvisor.Profile profile) {
            assert (profile instanceof BridgeServerAdvisor.BridgeServerProfile);
            BridgeServerAdvisor.BridgeServerProfile bp = (BridgeServerAdvisor.BridgeServerProfile)profile;
            bp.setHost(this.getHostName());
            bp.setPort(this.getPort());
            String[] groups = ServerGroupUtils.getMyGroupsArray();
            if (groups == null || groups.length == 0) {
                bp.setGroups(new String[]{this.getServerType().getServerGroupName()});
            } else {
                String[] allGroups = new String[groups.length + 1];
                allGroups[0] = this.getServerType().getServerGroupName();
                System.arraycopy(groups, 0, allGroups, 1, groups.length);
                bp.setGroups(allGroups);
            }
            bp.setMaxConnections(this.getMaxConnections());
            bp.setInitialLoad(this.probe.getLoad((ServerMetrics)this));
            bp.setLoadPollInterval(5000L);
            bp.serialNumber = this.getSerialNumber();
            bp.finishInit();
            this.initialLoad = bp.getInitialLoad().toString();
        }

        public DistributionAdvisor getDistributionAdvisor() {
            return this.advisor;
        }

        public DistributionAdvisor.Profile getProfile() {
            return this.getDistributionAdvisor().createProfile();
        }

        public String getName() {
            return "FabricServer.NetworkInterface";
        }

        public String getFullPath() {
            return this.getName();
        }

        public DistributionAdvisee getParentAdvisee() {
            return null;
        }

        public int getSerialNumber() {
            return this.serialNumber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionOpened(Socket clientSocket, int connectionNumber) {
            NetworkInterfaceImpl networkInterfaceImpl = this;
            synchronized (networkInterfaceImpl) {
                ++this.connectionDelta;
                ++this.totalConnections;
                if (this.connListener != null) {
                    this.connListener.connectionOpened(clientSocket, connectionNumber);
                }
            }
            if (this.advisor != null && this.advisor.isInitialized()) {
                ConnectionSignaller.getInstance().add(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionClosed(Socket clientSocket, int connectionNumber) {
            NetworkInterfaceImpl networkInterfaceImpl = this;
            synchronized (networkInterfaceImpl) {
                --this.connectionDelta;
                --this.totalConnections;
                if (this.connListener != null) {
                    this.connListener.connectionClosed(clientSocket, connectionNumber);
                }
            }
            if (this.advisor != null && this.advisor.isInitialized()) {
                ConnectionSignaller.getInstance().add(this);
            }
        }

        @Override
        public void close() {
        }

        @Override
        public boolean accumulate(ConnectionState other) {
            return this == other;
        }

        @Override
        public void distribute() {
            Set<DistributedMember> locators = GemFireXDUtils.getGfxdAdvisor().adviseServerLocators(false);
            if (locators != null && locators.size() > 0) {
                LogWriterI18n logger = this.advisor.getLogWriter();
                ServerLoad load = this.probe.getLoad((ServerMetrics)this);
                if (logger.fineEnabled()) {
                    logger.fine("GemFireXD NetworkServerImpl: transmitting load " + load + " to locators " + locators);
                }
                BridgeServerLoadMessage message = new BridgeServerLoadMessage(load, this.location, null);
                message.setRecipients(locators);
                this.advisor.getDistributionManager().putOutgoing((DistributionMessage)message);
            }
        }

        @Override
        public synchronized int numChanges() {
            int changes = this.connectionDelta;
            return changes < 0 ? -changes : changes;
        }

        @Override
        public int minBatchSize() {
            return 3;
        }

        @Override
        public long waitMillis() {
            return 500L;
        }

        public synchronized int getClientCount() {
            return this.clientCount;
        }

        public synchronized int getConnectionCount() {
            this.connectionDelta = 0;
            return this.totalConnections;
        }

        public int getMaxConnections() {
            return 800;
        }

        public int getSubscriptionConnectionCount() {
            return 0;
        }

        public SessionsVTI.SessionInfo getSessionInfo() {
            SessionsVTI.SessionInfo info = new SessionsVTI.SessionInfo();
            StringBuilder sb = new StringBuilder();
            sb.append("InitialLoad=").append(this.initialLoad).append(SanityManager.lineSeparator);
            sb.append("CurrentLoad=").append(this.probe.getLoad((ServerMetrics)this)).append(SanityManager.lineSeparator);
            info.memberid = this.getSystem().getMemberId();
            info.hostname = this.getHostName();
            info.serverListeningPort = this.getPort();
            info.networkInterfaceInfo = sb.toString();
            this.fillServerSessionInfo(info);
            return info;
        }

        protected void fillServerSessionInfo(SessionsVTI.SessionInfo info) {
        }
    }
}

