/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gnu.trove.TIntArrayList;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ColumnQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DistinctQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.GroupByQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.OrderByQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.TableQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.engine.sql.compile.ParameterizedConstantNode;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultDescription;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.ColumnOrdering;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.GenericColumnDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.GenericResultDescription;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AndNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DistinctNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromVTI;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.IntersectOrExceptNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JoinNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrderByNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ParameterNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ProjectRestrictNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RowCountNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ScrollInsensitiveResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SingleChildResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnionNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ValueRow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class SelectQueryInfo
extends DMLQueryInfo {
    private ColumnQueryInfo[] projQueryInfo = null;
    private ExecRow projRow;
    private ResultDescription resultDescription;
    protected OrderByQueryInfo orderbyQI;
    protected DistinctQueryInfo distinctQI;
    protected GroupByQueryInfo groupbyQI;
    private RowFormatter rowFormatter;
    private int[] projectionFixedColumns;
    private int[] projectionVarColumns;
    private int[] projectionLobColumns;
    private int[] projectionAllColumns;
    private int[] projectionAllColumnsWithLobs;
    private ArrayList<DelayedComputeQIPair<? extends SingleChildResultSetNode>> postSelectQI;
    private long rowcountFetchFirst = -1L;
    private long rowcountOffset = 0L;
    private boolean dynamicOffset;
    private boolean dynamicFetchFirst;
    private boolean canObtainKeyFromProjection;
    private int[] projIndexesForKey;
    private Vector<?> updatableColumns;
    private boolean selectForUpdateCase;
    private boolean routingFromGlobalIndex = true;
    private int[] partitioningColumnsFromProjection;
    private GemFireContainer gfContainerOfTheRegion;

    protected SelectQueryInfo(QueryInfoContext qic, boolean overload) throws StandardException {
        super(qic);
        assert (!overload) : "initialize postSelectQI array otherwise";
    }

    public SelectQueryInfo(QueryInfoContext qic) throws StandardException {
        super(qic);
        this.postSelectQI = new ArrayList(5);
    }

    public SelectQueryInfo(QueryInfoContext qic, Vector updatableColumns) throws StandardException {
        super(qic);
        this.postSelectQI = new ArrayList(5);
        if (updatableColumns != null) {
            this.queryType = GemFireXDUtils.set(this.queryType, 512);
        }
        this.updatableColumns = updatableColumns;
    }

    public void setPrimaryKeyColumnsInformationFromProjection(LanguageConnectionContext lcc, String schemaName, String tableName) throws StandardException {
        this.selectForUpdateCase = true;
        TableDescriptor td = GemFireXDUtils.getTableDescriptor(schemaName, tableName, lcc);
        Map<String, Integer> pkmap = GemFireXDUtils.getPrimaryKeyColumnNamesToIndexMap(td, lcc);
        this.checkIfAllowedUpdatableColumns(this.updatableColumns, pkmap, td);
        if (pkmap != null) {
            Iterator<Map.Entry<String, Integer>> itr = pkmap.entrySet().iterator();
            this.projIndexesForKey = new int[pkmap.size()];
            this.canObtainKeyFromProjection = true;
            int pos = 0;
            block0: while (itr.hasNext()) {
                Map.Entry<String, Integer> anEntry = itr.next();
                String columnName = anEntry.getKey();
                for (int i = 0; i < this.projQueryInfo.length; ++i) {
                    if (columnName.equalsIgnoreCase(this.projQueryInfo[i].getActualColumnName())) {
                        this.projIndexesForKey[pos++] = i;
                        continue block0;
                    }
                    if (i != this.projQueryInfo.length - 1) continue;
                    this.canObtainKeyFromProjection = false;
                    continue block0;
                }
            }
        } else {
            this.canObtainKeyFromProjection = false;
        }
        if (!this.canObtainKeyFromProjection) {
            this.projIndexesForKey = null;
        }
    }

    private void checkIfAllowedUpdatableColumns(Vector updatableColumns, Map<String, Integer> pkmap, TableDescriptor td) throws StandardException {
        Iterator itr = updatableColumns.iterator();
        DistributionDescriptor distdescp = td.getDistributionDescriptor();
        String[] partitioningcolumns = distdescp.getPartitionColumnNames();
        GfxdPartitionResolver resolver = null;
        while (itr.hasNext()) {
            String column = (String)itr.next();
            if (pkmap != null && pkmap.containsKey(column)) {
                throw StandardException.newException("0A000.S", "Update of column which is primary key or is part of the primary key, not supported");
            }
            if (partitioningcolumns == null) continue;
            for (int i = 0; i < partitioningcolumns.length; ++i) {
                if (!partitioningcolumns[i].equals(column)) continue;
                throw StandardException.newException("0A000.S", "Update of partitioning column not supported");
            }
        }
        int policy = distdescp.getPolicy();
        if (partitioningcolumns == null) {
            assert (policy == 1 || policy == 3);
            this.routingFromGlobalIndex = false;
        } else if (policy == 4) {
            this.routingFromGlobalIndex = false;
        } else if (policy != 1 && (resolver = (GfxdPartitionResolver)((PartitionedRegion)this.getRegion()).getPartitionResolver()).isPartitioningKeyThePrimaryKey()) {
            this.routingFromGlobalIndex = false;
        }
        if (this.routingFromGlobalIndex) {
            this.partitioningColumnsFromProjection = this.findPartitoningColumnsFromProjectionIfPossible(partitioningcolumns);
            if (this.partitioningColumnsFromProjection == null) {
                assert (resolver != null);
                assert (resolver.requiresGlobalIndex());
            }
        }
    }

    private int[] findPartitoningColumnsFromProjectionIfPossible(String[] partitioningColStrings) {
        if (partitioningColStrings == null) {
            return null;
        }
        int[] projectionIndexesForPartitoningColumns = new int[partitioningColStrings.length];
        int cnt = 0;
        for (int i = 0; i < partitioningColStrings.length; ++i) {
            String partColtmp = partitioningColStrings[i];
            int colInProjIndex = this.getColumnInProjIndex(partColtmp);
            if (colInProjIndex == -1) {
                projectionIndexesForPartitoningColumns = null;
                break;
            }
            projectionIndexesForPartitoningColumns[cnt++] = colInProjIndex;
        }
        return projectionIndexesForPartitoningColumns;
    }

    private int getColumnInProjIndex(String colName) {
        int ret = -1;
        for (int i = 0; i < this.projQueryInfo.length; ++i) {
            ColumnQueryInfo colInfo = this.projQueryInfo[i];
            if (!colName.equals(colInfo.getActualColumnName())) continue;
            ret = i;
            break;
        }
        return ret;
    }

    public boolean isSelectForUpdateCase() {
        return this.selectForUpdateCase;
    }

    @Override
    public boolean needKeysForSelectForUpdate() {
        return !this.canObtainKeyFromProjection;
    }

    public boolean isRoutingCalculationRequired() {
        return this.routingFromGlobalIndex;
    }

    public int[] getPartitioningColumnFromProjection() {
        return this.partitioningColumnsFromProjection;
    }

    public int[] getProjectionIndexesForKey() {
        return this.projIndexesForKey;
    }

    public GemFireContainer getGFContainer() {
        if (this.gfContainerOfTheRegion == null) {
            this.gfContainerOfTheRegion = (GemFireContainer)this.getRegion().getUserAttribute();
        }
        return this.gfContainerOfTheRegion;
    }

    @Override
    public final boolean isSelect() {
        return true;
    }

    @Override
    public final boolean optimizeForWrite() {
        boolean isOptimizedForWrite = this.qic.optimizeForWrite();
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("returning SelectQueryInfo:optimizeForWrite = " + isOptimizedForWrite));
        }
        return isOptimizedForWrite;
    }

    @Override
    public final boolean withSecondaries() {
        boolean withSecondaries = this.qic.withSecondaries();
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("returning SelectQueryInfo:withSecondaries= " + withSecondaries));
        }
        return withSecondaries;
    }

    @Override
    public boolean skipChildren(Visitable node) throws StandardException {
        return node instanceof ProjectRestrictNode || node instanceof AndNode || node instanceof ResultColumn || node instanceof ScrollInsensitiveResultSetNode || node instanceof GroupByNode || node instanceof OrderByNode || node instanceof DistinctNode || node instanceof SubqueryNode || node instanceof RowCountNode;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        if (node instanceof ScrollInsensitiveResultSetNode) {
            this.handleScrollInsensitiveResultSetNode((ScrollInsensitiveResultSetNode)node);
        } else if (node instanceof ResultColumnList) {
            this.handleResultColumnListNode((ResultColumnList)node);
        } else if (node instanceof ResultColumn) {
            this.handleResultColumnNode((ResultColumn)node);
        } else if (node instanceof OrderByNode) {
            this.handleOrderByNode((OrderByNode)node);
        } else if (node instanceof GroupByNode) {
            if (this.qic.getNestingLevelOfScope() == 0) {
                this.handleGroupByNode((GroupByNode)node);
            } else {
                ResultSetNode rsn = ((GroupByNode)node).getChildResult();
                if (rsn instanceof ProjectRestrictNode) {
                    this.handleProjectRestrictNode((ProjectRestrictNode)rsn);
                }
            }
        } else if (node instanceof DistinctNode) {
            this.handleDistinctNode((DistinctNode)node);
        } else if (node instanceof RowCountNode) {
            this.handleRowCountNode((RowCountNode)node);
        } else if (node instanceof FromVTI) {
            ((FromVTI)node).computeQueryInfo(this.qic);
        } else if (node instanceof UnionNode) {
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"SelectQueryInfo::visit: Case of Union. Set hasUnionNode");
            }
            this.setHasUnionNode();
            super.visit(node);
        } else if (node instanceof IntersectOrExceptNode) {
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("SelectQueryInfo::visit: Case of Intersect or Except. Set name = " + ((IntersectOrExceptNode)node).getOperatorNameWithDistinct()));
            }
            this.setHasIntersectOrExceptNode(((IntersectOrExceptNode)node).getOperatorNameWithDistinct());
            super.visit(node);
        } else if (node instanceof JoinNode) {
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"SelectQueryInfo::visit: Found Join Node. ");
            }
            this.setHasJoinNode();
            super.visit(node);
        } else {
            super.visit(node);
        }
        return node;
    }

    private void handleScrollInsensitiveResultSetNode(ScrollInsensitiveResultSetNode node) throws StandardException {
        node.getChildResult().accept(this);
        this.init();
    }

    @Override
    int processResultColumnListFromProjectRestrictNodeAtLevel() {
        return 0;
    }

    private void handleResultColumnListNode(ResultColumnList rlc) throws StandardException {
        int numCols = rlc.size();
        this.projQueryInfo = new ColumnQueryInfo[numCols];
        this.resultDescription = new GenericResultDescription(new ResultColumnDescriptor[numCols], null);
        this.projRow = new ValueRow(numCols);
    }

    private void handleResultColumnNode(ResultColumn rc) throws StandardException {
        int virtualColPos = rc.getVirtualColumnId();
        ColumnQueryInfo cqi = new ColumnQueryInfo(rc, this.qic);
        ValueNode vn = rc.getExpression();
        if (!GemFireXDUtils.isSet(this.queryType, 32) && vn != null && !vn.isTableColumn()) {
            this.queryType = GemFireXDUtils.set(this.queryType, 32);
        }
        assert (this.projQueryInfo[virtualColPos - 1] == null);
        this.projQueryInfo[virtualColPos - 1] = cqi;
        DataTypeDescriptor dtd = rc.getType();
        this.projRow.setColumn(virtualColPos, dtd.getNull());
        GenericColumnDescriptor rcd = new GenericColumnDescriptor(cqi.getExposedName(), cqi.getSchemaName(), cqi.getTableName(), virtualColPos, dtd, this.updatableColumns != null && this.updatableColumns.contains(cqi.getExposedName()), false);
        ((GenericResultDescription)this.resultDescription).setColumnDescriptor(virtualColPos - 1, rcd);
    }

    private void handleRowCountNode(RowCountNode rcn) throws StandardException {
        this.queryType = GemFireXDUtils.set(this.queryType, 128);
        this.queryType = GemFireXDUtils.set(this.queryType, 8192);
        ValueNode offsetNode = rcn.getRowCountOffSet();
        if (offsetNode instanceof ConstantNode) {
            this.rowcountOffset = ((ConstantNode)offsetNode).getValue().getLong();
            this.dynamicOffset = false;
        } else if (offsetNode instanceof ParameterizedConstantNode) {
            this.rowcountOffset = ((ParameterizedConstantNode)offsetNode).getConstantNumber();
            this.dynamicFetchFirst = true;
        } else if (offsetNode != null) {
            assert (offsetNode instanceof ParameterNode) : offsetNode;
            this.rowcountOffset = ((ParameterNode)offsetNode).getParameterNumber();
            this.dynamicOffset = true;
        }
        ValueNode fetchFirstNode = rcn.getRowCountFetchFirst();
        if (fetchFirstNode instanceof ConstantNode) {
            this.rowcountFetchFirst = ((ConstantNode)fetchFirstNode).getValue().getLong();
            this.dynamicFetchFirst = false;
        } else if (fetchFirstNode instanceof ParameterizedConstantNode) {
            this.rowcountFetchFirst = ((ParameterizedConstantNode)fetchFirstNode).getConstantNumber();
            this.dynamicFetchFirst = true;
        } else if (fetchFirstNode != null) {
            assert (fetchFirstNode instanceof ParameterNode) : fetchFirstNode;
            this.rowcountFetchFirst = ((ParameterNode)fetchFirstNode).getParameterNumber();
            this.dynamicFetchFirst = true;
        } else {
            assert (fetchFirstNode == null);
            this.rowcountFetchFirst = -1L;
            this.dynamicFetchFirst = false;
        }
        this.visit(rcn.getChildResult());
    }

    private void handleOrderByNode(OrderByNode obn) throws StandardException {
        DelayedComputeQIPair orderByPair = new DelayedComputeQIPair(this, (SingleChildResultSetNode)obn, this.qic.getParentPRN());
        this.postSelectQI.add(orderByPair);
        this.queryType = GemFireXDUtils.set(this.queryType, 32);
        this.qic.setParentPRN(null);
        this.visit(obn.getChildResult());
    }

    void handleGroupByNode(GroupByNode gbn) throws StandardException {
        DelayedComputeQIPair groupByPair = new DelayedComputeQIPair(this, (SingleChildResultSetNode)gbn, this.qic.getParentPRN());
        this.postSelectQI.add(groupByPair);
        this.queryType = GemFireXDUtils.set(this.queryType, 32);
        this.qic.setParentPRN(null);
        this.visit(gbn.getChildResult());
    }

    void handleDistinctNode(DistinctNode dnode) throws StandardException {
        DelayedComputeQIPair dnodePair = new DelayedComputeQIPair(this, (SingleChildResultSetNode)dnode, this.qic.getParentPRN());
        this.queryType = GemFireXDUtils.set(this.queryType, 32);
        this.postSelectQI.add(dnodePair);
        this.qic.setParentPRN(null);
        this.visit(dnode.getChildResult());
    }

    @Override
    void handleFromBaseTableNode(FromBaseTable fbtNode, boolean postParentClassHandling) throws StandardException {
        if (fbtNode.isDistinctScan()) {
            this.queryType = GemFireXDUtils.set(this.queryType, 16);
            ProjectRestrictNode parentPRN = this.qic.getParentPRN();
            this.distinctQI = new DistinctQueryInfo(this.qic, parentPRN.getInnerMostPRN().getResultColumns(), parentPRN.getResultColumns(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws StandardException {
        if (this.isDriverTableInitialized()) {
            return;
        }
        try {
            LocalRegion rgn;
            boolean isGFEActivation = false;
            super.init();
            TableQueryInfo driverTable = this.getDriverTableQueryInfo();
            boolean isWhereClauseSatisfactory = false;
            boolean isPrimaryKeyBased = false;
            if (this.numTablesInTableQueryInfoList() == 1) {
                isWhereClauseSatisfactory = this.isWhereClauseSatisfactory(driverTable);
                if (isWhereClauseSatisfactory && (isPrimaryKeyBased = driverTable.isPrimaryKeyBased()) && driverTable.getTableNode() != null) {
                    this.queryType = GemFireXDUtils.set(this.queryType, 4);
                    if (GemFireXDUtils.isSet(this.queryType, 32)) {
                        driverTable.getTableNode().setCreateGFEResultSetTrue(this);
                    }
                    driverTable.setBaseTableNodeAsNull();
                } else if (this.getLocalIndexKey() != null && this.getChosenLocalIndex() != null) {
                    boolean doGetAllOnLocalIndex = false;
                    boolean embedGfeResultSet = GemFireXDUtils.isSet(this.queryType, 32);
                    boolean forceEmbedGfeResultSetRoute = DMLQueryInfo.enableGetAll_LocalIndex_withEmbedGfe();
                    if (embedGfeResultSet) {
                        if (forceEmbedGfeResultSetRoute) {
                            doGetAllOnLocalIndex = true;
                            driverTable.getTableNode().setCreateGFEResultSetTrue(this);
                        } else {
                            doGetAllOnLocalIndex = false;
                        }
                    } else {
                        doGetAllOnLocalIndex = true;
                    }
                    if (doGetAllOnLocalIndex) {
                        this.queryType = GemFireXDUtils.set(this.queryType, 4096);
                        driverTable.setBaseTableNodeAsNull();
                    }
                    if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                        SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("SelectQueryInfo:init Perform GetAll on Local Index=" + doGetAllOnLocalIndex + " ,this.getLocalIndexKey() = " + this.getLocalIndexKey() + " ,this.getChosenLocalIndex() = " + this.getChosenLocalIndex() + " ,embedGfeResultSet=" + embedGfeResultSet + " ,forceEmbedGfeResultSetRoute=" + forceEmbedGfeResultSetRoute));
                    }
                }
            }
            isGFEActivation = this.createGFEActivation();
            if (GemFireXDUtils.TraceQuery) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("SelectQueryInfo:init createGFEActivation= " + isGFEActivation));
            }
            CompilerContext cc = (CompilerContext)ContextService.getContext("CompilerContext");
            for (int i = this.postSelectQI.size() - 1; i >= 0; --i) {
                DelayedComputeQIPair<? extends SingleChildResultSetNode> post = this.postSelectQI.get(i);
                if (!isGFEActivation || !cc.isGlobalScope() && ((DelayedComputeQIPair)post).node instanceof GroupByNode) continue;
                post.process();
            }
            this.postSelectQI.clear();
            this.qic.setOptimizeForWrite(cc.optimizeForWrite());
            this.qic.setWithSecondaries(cc.withSecondaries());
            if (this.qic.optimizeForWrite() && this.isTableVTI() && (rgn = this.getRegion()) != null && !((GemFireContainer)rgn.getUserAttribute()).isApplicationTable()) {
                this.qic.setOptimizeForWrite(false);
            }
            int numTabs = this.containerList.size();
            for (int i = 0; i < numTabs; ++i) {
                if (((GemFireContainer)this.containerList.get(i)).getRegion() == null || !((GemFireContainer)this.containerList.get(i)).getRegion().isHDFSReadWriteRegion()) continue;
                this.qic.setOptimizeForWrite(true);
                break;
            }
            this.initRowFormatter();
        }
        finally {
            for (DelayedComputeQIPair<? extends SingleChildResultSetNode> post : this.postSelectQI) {
                post.clear();
            }
            this.postSelectQI.clear();
            this.wherePredicateList.clear();
        }
    }

    private final void initRowFormatter() {
        if (this.getDriverTableQueryInfo() != null) {
            GemFireContainer container = this.getGFContainer();
            if (this.containerList.size() == 1) {
                boolean projectionRequired;
                boolean bl = projectionRequired = this.projQueryInfo.length != container.numColumns();
                if (!projectionRequired) {
                    for (int pos = 1; pos <= this.projQueryInfo.length; ++pos) {
                        if (this.projQueryInfo[pos - 1].getActualColumnPosition() == pos) continue;
                        projectionRequired = true;
                        break;
                    }
                }
                this.projectionFixedColumns = null;
                this.projectionVarColumns = null;
                this.projectionLobColumns = null;
                this.projectionAllColumns = null;
                this.projectionAllColumnsWithLobs = null;
                if (projectionRequired) {
                    assert (this.projQueryInfo.length > 0) : "no projection columns";
                    this.rowFormatter = container.getRowFormatter(this.projQueryInfo);
                    TIntArrayList fixedCols = new TIntArrayList();
                    TIntArrayList varCols = new TIntArrayList();
                    TIntArrayList lobCols = new TIntArrayList();
                    TIntArrayList allCols = new TIntArrayList();
                    TIntArrayList allColsWithLobs = new TIntArrayList();
                    this.rowFormatter.getColumnPositions(fixedCols, varCols, lobCols, allCols, allColsWithLobs);
                    if (fixedCols.size() > 0) {
                        this.projectionFixedColumns = fixedCols.toNativeArray();
                    }
                    if (varCols.size() > 0) {
                        this.projectionVarColumns = varCols.toNativeArray();
                    }
                    if (lobCols.size() > 0) {
                        this.projectionLobColumns = lobCols.toNativeArray();
                    }
                    if (allCols.size() > 0) {
                        this.projectionAllColumns = allCols.toNativeArray();
                    }
                    assert (allColsWithLobs.size() > 0);
                    this.projectionAllColumnsWithLobs = allColsWithLobs.toNativeArray();
                } else {
                    this.rowFormatter = container.getCurrentRowFormatter();
                }
            } else {
                this.rowFormatter = container.getCurrentRowFormatter();
            }
        }
    }

    public final ExecRow getProjectionExecRow() {
        return this.projRow.getNewNullRow();
    }

    public Map<String, Object> getDriverRegionsForOuterJoins() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.isSpecialCaseOFOuterJoins) {
            Region reg;
            Iterator i$ = this.logicalLeftTableList.iterator();
            while (i$.hasNext() && (reg = (Region)i$.next()).getAttributes().getPartitionAttributes() == null) {
                String regName = (reg.getParentRegion().getName() + "." + reg.getName()).toUpperCase();
                map.put(regName, null);
            }
        } else {
            return null;
        }
        return map;
    }

    @Override
    public ResultDescription getResultDescription() {
        return this.resultDescription;
    }

    public ColumnQueryInfo[] getProjectionColumnQueryInfo() {
        return this.projQueryInfo;
    }

    public OrderByQueryInfo getOrderByQI() {
        assert (this.orderbyQI != null) : "OrderBy info is not expected to null.. see handleOrderByQueryInfo";
        return this.orderbyQI;
    }

    public GroupByQueryInfo getGroupByQI() {
        assert (this.groupbyQI != null) : "GroupBy info is not expected to null.. see handleGroupByQueryInfo";
        return this.groupbyQI;
    }

    public DistinctQueryInfo getDistinctQI() {
        assert (this.distinctQI != null) : "Distinct info is not expected to null.. see handleDistinctQueryInfo";
        return this.distinctQI;
    }

    public ColumnOrdering[] getColumnOrdering() {
        SanityManager.THROWASSERT((String)("getColumnOrdering() not expected to be called for " + this.getClass().getName()));
        return null;
    }

    public final RowFormatter getRowFormatter() {
        return this.rowFormatter;
    }

    public final boolean isProjectionRequired() {
        return this.projectionAllColumnsWithLobs != null;
    }

    public final int[] getProjectionFixedColumns() {
        return this.projectionFixedColumns;
    }

    public final int[] getProjectionVarColumns() {
        return this.projectionVarColumns;
    }

    public final int[] getProjectionLobColumns() {
        return this.projectionLobColumns;
    }

    public final int[] getProjectionAllColumns() {
        return this.projectionAllColumns;
    }

    public final int[] getProjectionAllColumnsWithLobs() {
        return this.projectionAllColumnsWithLobs;
    }

    public long getRowCountOffSet() {
        return this.rowcountOffset;
    }

    public long getRowCountFetchFirst() {
        return this.rowcountFetchFirst;
    }

    public boolean isDynamicOffset() {
        return this.dynamicOffset;
    }

    public boolean isDyanmicFetchFirst() {
        return this.dynamicFetchFirst;
    }

    @Override
    public boolean isTableVTI() {
        return this.qic.virtualTable() != null;
    }

    public boolean isPrimaryKeyComposite() {
        return this.getDriverTableQueryInfo().isPrimaryKeyBased() && this.getDriverTableQueryInfo().getPrimaryKeyColumns().length > 1;
    }

    @Override
    public boolean routeQueryToAllNodes() {
        return this.qic.isVTIDistributable();
    }

    public final void clearPrimaryKeyBasedFlag() {
        this.queryType = GemFireXDUtils.clear(this.queryType, 4);
    }

    private static final class DelayedComputeQIPair<N extends SingleChildResultSetNode> {
        private N node;
        private ProjectRestrictNode parentPRN;
        final /* synthetic */ SelectQueryInfo this$0;

        DelayedComputeQIPair(N node, ProjectRestrictNode parentPRN) {
            this.this$0 = var1_1;
            this.node = node;
            this.parentPRN = parentPRN;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void process() throws StandardException {
            QueryInfo retQi = null;
            QueryInfoContext lqic = this.this$0.qic;
            SelectQueryInfo thisO = this.this$0;
            try {
                lqic.setParentPRN(this.parentPRN);
                retQi = ((QueryTreeNode)this.node).computeQueryInfo(lqic);
                switch (((QueryTreeNode)this.node).getNodeType()) {
                    case 137: {
                        thisO.groupbyQI = (GroupByQueryInfo)retQi;
                        thisO.queryType = GemFireXDUtils.set(thisO.queryType, 2);
                        return;
                    }
                    case 140: {
                        thisO.orderbyQI = (OrderByQueryInfo)retQi;
                        thisO.queryType = GemFireXDUtils.set(thisO.queryType, 1);
                        return;
                    }
                    case 124: {
                        thisO.distinctQI = (DistinctQueryInfo)retQi;
                        thisO.queryType = GemFireXDUtils.set(thisO.queryType, 8);
                        return;
                    }
                    default: {
                        SanityManager.THROWASSERT((String)"No other type expected as of now");
                        return;
                    }
                }
            }
            finally {
                this.clear();
            }
        }

        public final void clear() {
            this.node = null;
            this.parentPRN = null;
            this.this$0.qic.setParentPRN(this.parentPRN);
        }

        public final String toString() {
            return ((FromTable)this.node).toString() + " PRN " + this.parentPRN.toString();
        }
    }
}

