/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.message;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.shared.Version;
import com.gemstone.gnu.trove.THashMap;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.StatementQueryExecutor;
import com.pivotal.gemfirexd.internal.engine.distributed.message.RegionExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.NcjHashMapWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.XPLAINDistPropsDescriptor;
import com.pivotal.gemfirexd.internal.engine.sql.execute.ConstantValueSetImpl;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Set;

public class StatementExecutorMessage<T>
extends RegionExecutorMessage<T> {
    protected String defaultSchema;
    public long connectionId;
    protected long statementId;
    protected int executionId;
    protected long rootId;
    protected int statementLevel;
    protected String source;
    protected ParameterValueSet pvs;
    protected int queryFlags;
    protected short extraFlags;
    protected short HDFSFlags = 0;
    private long timeOutMillis = 0L;
    public transient GfxdConnectionWrapper wrapperForMarkUnused;
    protected static final short SOURCE_STRING_SET = 128;
    protected static final short ISSELECT = 256;
    protected static final short OPTIMIZE_FOR_WRITE = 512;
    protected static final short ISOUTERJOINRR = 1024;
    protected static final short HASAUTHID = 2048;
    protected static final short NEED_GFXD_SUB_ACTIVATION = 4096;
    protected static final short ENABLE_STATS = 8192;
    protected static final short SELECT_FOR_UPDATE_NEED_KEY = 16384;
    protected static final int WITH_SECONDARIES = 32768;
    protected static final int QUERY_FLAGS_MASK = -256;
    protected static final short HAS_ACTIVATION_FLAGS = 17408;
    protected static final byte ENABLE_EXPLAIN_CONNECTION = 1;
    protected static final byte SKIP_LISTENERS = 2;
    protected static final byte INSERT_SUBSELECT = 4;
    protected static final byte HAS_SET_OPERATOR_NODE = 8;
    protected static final byte IGNORE_REPLICATE_IF_SET_OPERATOR = 16;
    protected static final byte NEED_REGION_KEY_FOR_SET_OPERATOR = 32;
    protected static final byte ALL_TABLES_REPLICATED_ON_REMOTE = 64;
    protected static final short DISALLOW_SUBQUERY_FLATTENING = 128;
    private static final short IS_NCJ_QUERY_ON_REMOTE = 256;
    protected static final short QUERY_HDFS = 1;
    protected static final short SKIP_CONSTRAINT_CHECKS = 2;

    public StatementExecutorMessage() {
        super(true);
    }

    public StatementExecutorMessage(ResultCollector<Object, T> collector, String defaultSchema, long connectionId, long statementId, int executionId, long rootId, int statementLevel, String source, boolean isSelect, boolean optimizeForWrite, boolean withSecondaries, boolean isSpecialCaseOuterJoin, boolean needGfxdSubActivation, boolean flattenSubquery, boolean needKeysForSelectForUpdateCase, ParameterValueSet pvs, LocalRegion region, Set<Object> routingObjects, boolean insertAsSubSelect, LanguageConnectionContext lcc, long timeOutMillis, boolean abortOnLowMemory) {
        super(collector, region, routingObjects, StatementExecutorMessage.getCurrentTXState(lcc), StatementExecutorMessage.getTimeStatsSettings(lcc), abortOnLowMemory);
        if (source != null && !"APP".equals(defaultSchema)) {
            this.defaultSchema = defaultSchema;
            this.queryFlags = GemFireXDUtils.set(this.queryFlags, 2048);
        }
        this.connectionId = connectionId;
        this.statementId = statementId;
        this.executionId = executionId;
        this.rootId = rootId;
        this.statementLevel = statementLevel;
        this.source = source;
        this.timeOutMillis = timeOutMillis;
        if (isSelect) {
            this.queryFlags = GemFireXDUtils.set(this.queryFlags, 256);
        }
        if (optimizeForWrite) {
            this.queryFlags = GemFireXDUtils.set(this.queryFlags, 512);
        }
        if (withSecondaries) {
            this.queryFlags = GemFireXDUtils.set(this.queryFlags, 32768);
        }
        if (isSpecialCaseOuterJoin) {
            this.queryFlags = GemFireXDUtils.set(this.queryFlags, 1024);
        }
        if (needGfxdSubActivation) {
            this.queryFlags = GemFireXDUtils.set(this.queryFlags, 4096);
        }
        if (lcc.statsEnabled()) {
            this.queryFlags = GemFireXDUtils.set(this.queryFlags, 8192);
        }
        if (lcc.explainConnection()) {
            this.extraFlags = GemFireXDUtils.set(this.extraFlags, (short)1);
        }
        if (lcc.isSkipListeners()) {
            this.extraFlags = GemFireXDUtils.set(this.extraFlags, (short)2);
        }
        if (insertAsSubSelect) {
            this.extraFlags = GemFireXDUtils.set(this.extraFlags, (short)4);
        }
        if (!flattenSubquery) {
            this.extraFlags = GemFireXDUtils.set(this.extraFlags, (short)128);
        }
        if (needKeysForSelectForUpdateCase) {
            this.queryFlags = GemFireXDUtils.set(this.queryFlags, 16384);
        }
        this.pvs = pvs;
        if (lcc.getQueryHDFS()) {
            this.HDFSFlags = GemFireXDUtils.set(this.HDFSFlags, (short)1);
        }
        if (lcc.isSkipConstraintChecks()) {
            this.HDFSFlags = GemFireXDUtils.set(this.HDFSFlags, (short)2);
        }
    }

    protected StatementExecutorMessage(StatementExecutorMessage<T> other) {
        super(other);
        this.defaultSchema = other.defaultSchema;
        this.connectionId = other.connectionId;
        this.statementId = other.statementId;
        this.executionId = other.executionId;
        this.rootId = other.rootId;
        this.statementLevel = other.statementLevel;
        this.source = other.source;
        this.timeOutMillis = other.timeOutMillis;
        this.queryFlags = other.queryFlags;
        this.pvs = other.pvs;
        this.extraFlags = other.extraFlags;
        this.HDFSFlags = other.HDFSFlags;
    }

    @Override
    protected void execute() throws Exception {
        String argsStr = null;
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            StringBuilder sb = new StringBuilder();
            this.appendFields(sb);
            argsStr = sb.toString();
        }
        this.wrapperForMarkUnused = null;
        StatementQueryExecutor.executeStatement(this.defaultSchema, this.connectionId, this.statementId, this.rootId, this.statementLevel, this.source, this.isSelect(), this.getActivationFlags(), this.needGfxdSubActivation(), this.statsEnabled(), this.timeStatsEnabled(), (FunctionContext)this, argsStr, this.getTXState(), this.pvs, this.allowSubqueryFlattening(), this.isInsertAsSubSelect(), this);
    }

    @Override
    public void endMessage() {
        if (this.wrapperForMarkUnused != null) {
            this.wrapperForMarkUnused.markUnused();
            this.wrapperForMarkUnused = null;
        }
    }

    public long getTimeOutMillis() {
        return this.timeOutMillis;
    }

    protected final int getActivationFlags() {
        int activationFlags = 0;
        if ((this.queryFlags & 0x4400) != 0) {
            if (this.isSpecialCaseOuterJoin()) {
                activationFlags |= 1;
            } else if (this.isSelectForUpdateAndNeedKeys()) {
                activationFlags |= 2;
            }
        } else if (this.needKeysForSetOperatorOnRemote()) {
            activationFlags |= 4;
        }
        return activationFlags;
    }

    @Override
    protected void setArgsForMember(DistributedMember member, Set<DistributedMember> messageAwareMembers) {
    }

    @Override
    public final boolean optimizeForWrite() {
        return GemFireXDUtils.isSet(this.queryFlags, 512);
    }

    @Override
    public boolean withSecondaries() {
        return GemFireXDUtils.isSet(this.queryFlags, 32768);
    }

    @Override
    protected final boolean requiresTXFlushBeforeExecution() {
        return this.needGfxdSubActivation();
    }

    @Override
    protected void doTXFlushBeforeExecution(Set<DistributedMember> members, DistributedMember member, DistributedMember self, TXStateInterface tx) {
        if (this.optimizeForWrite()) {
            if (members != null) {
                if (members.size() > 1 || !members.contains(self)) {
                    tx.flushPendingOps(null);
                }
            } else if (self != member) {
                tx.flushPendingOps(null);
            }
        }
    }

    protected boolean requireFinishTX() {
        return true;
    }

    @Override
    protected StatementExecutorMessage<T> clone() {
        return new StatementExecutorMessage<T>(this);
    }

    @Override
    public final boolean isHA() {
        return true;
    }

    @Override
    public byte getGfxdID() {
        return 28;
    }

    protected final boolean isSelect() {
        return GemFireXDUtils.isSet(this.queryFlags, 256);
    }

    protected final boolean allowSubqueryFlattening() {
        return !GemFireXDUtils.isSet(this.extraFlags, (short)128);
    }

    protected final boolean isSpecialCaseOuterJoin() {
        return GemFireXDUtils.isSet(this.queryFlags, 1024);
    }

    protected final boolean isSelectForUpdateAndNeedKeys() {
        return GemFireXDUtils.isSet(this.queryFlags, 16384);
    }

    protected final boolean hasAuthId() {
        return GemFireXDUtils.isSet(this.queryFlags, 2048);
    }

    protected final boolean needGfxdSubActivation() {
        return GemFireXDUtils.isSet(this.queryFlags, 4096);
    }

    public final boolean statsEnabled() {
        return GemFireXDUtils.isSet(this.queryFlags, 8192);
    }

    public final boolean getQueryHDFS() {
        return GemFireXDUtils.isSet(this.HDFSFlags, (short)1);
    }

    public final boolean isSkipConstraintChecks() {
        return GemFireXDUtils.isSet(this.HDFSFlags, (short)2);
    }

    public final boolean timeStatsEnabled() {
        return this.timeStatsEnabled;
    }

    public final boolean explainConnectionEnabled() {
        return GemFireXDUtils.isSet(this.extraFlags, (short)1);
    }

    public final boolean isSkipListeners() {
        return GemFireXDUtils.isSet(this.extraFlags, (short)2);
    }

    protected final boolean isInsertAsSubSelect() {
        return GemFireXDUtils.isSet(this.extraFlags, (short)4);
    }

    @Override
    public final boolean hasSetOperatorNodeOnRemote() {
        return GemFireXDUtils.isSet(this.extraFlags, (short)8);
    }

    @Override
    public boolean needKeysForSetOperatorOnRemote() {
        return GemFireXDUtils.isSet(this.extraFlags, (short)32);
    }

    @Override
    public final boolean doIgnoreReplicatesIfSetOperatorsOnRemote() {
        return GemFireXDUtils.isSet(this.extraFlags, (short)16);
    }

    @Override
    public boolean allTablesAreReplicatedOnRemote() {
        return GemFireXDUtils.isSet(this.extraFlags, (short)64);
    }

    @Override
    public void setNCJoinOnQN(THashMap ncjMetaInfo, LanguageConnectionContext lcc) {
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)(this.getClass().getSimpleName() + "::setNCJoinOnQN: set ncjMetaData " + "for NonCollocatedJoin: " + ncjMetaInfo + " .Enum info=" + NcjHashMapWrapper.getEnumValues() + " .Given Batch Size: " + (lcc != null ? Integer.valueOf(lcc.getNcjBatchSize()) : "lcc is null") + " and Cache Size: " + (lcc != null ? lcc.getNcjCacheSize() + " MB" : "lcc is null")));
        }
        this.extraFlags = GemFireXDUtils.set(this.extraFlags, (short)256);
        if (lcc != null) {
            if (lcc.getNcjBatchSize() > 0) {
                NcjHashMapWrapper.setBatchSize(ncjMetaInfo, lcc.getNcjBatchSize());
            }
            if (lcc.getNcjCacheSize() > 0) {
                NcjHashMapWrapper.setCacheSize(ncjMetaInfo, lcc.getNcjCacheSize());
            }
        }
        super.setNcjMetaData(ncjMetaInfo);
    }

    @Override
    public void setHasSetOperatorNode(boolean hasSetOp, boolean needKeysFromRemote) {
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.getClass().getSimpleName() + "setHasSetOperatorNode: set extraFlag " + "for union, intersect or except operators: " + this.hasSetOperatorNode + " to " + hasSetOp + " and want keys = " + needKeysFromRemote));
        }
        this.hasSetOperatorNode = hasSetOp;
        if (hasSetOp) {
            this.extraFlags = GemFireXDUtils.set(this.extraFlags, (short)8);
            if (needKeysFromRemote) {
                this.extraFlags = GemFireXDUtils.set(this.extraFlags, (short)32);
            }
        }
    }

    @Override
    protected void setIgnoreReplicateIfSetOperators(boolean ignoreReplicate) {
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.getClass().getSimpleName() + " with set operator = " + this.hasSetOperatorNode + " want to set extraFlag for ignoreReplicatesIfSetOperators - " + ignoreReplicate));
        }
        if (ignoreReplicate && this.hasSetOperatorNode) {
            this.extraFlags = GemFireXDUtils.set(this.extraFlags, (short)16);
        }
    }

    @Override
    public void setAllTablesAreReplicatedOnRemote(boolean allTablesReplicated) {
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.getClass().getSimpleName() + " setAllTablesAreReplicated: set extraFlag ALL_TABLES_REPLICATED_ON_REMOTE" + " to " + allTablesReplicated));
        }
        if (allTablesReplicated) {
            this.extraFlags = GemFireXDUtils.set(this.extraFlags, (short)64);
        }
    }

    @Override
    protected final short computeCompressedShort(short flags) {
        flags = super.computeCompressedShort(flags);
        if (this.source != null) {
            flags = (short)(flags | 0x80);
        }
        flags = (short)(flags | this.queryFlags);
        return flags;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        boolean oldVersion;
        long begintime = this.timeStatsEnabled ? XPLAINUtil.recordTiming(this.ser_deser_time == 0L ? (this.ser_deser_time = -1L) : -2L) : 0L;
        super.toData(out);
        boolean bl = oldVersion = InternalDataSerializer.getVersionForDataStream((DataOutput)out).compareTo(Version.GFXD_10) < 0;
        if (oldVersion) {
            out.writeByte((byte)this.extraFlags);
        } else {
            out.writeShort(this.extraFlags);
        }
        if (oldVersion) {
            out.writeByte((byte)this.HDFSFlags);
        } else {
            out.writeShort(this.HDFSFlags);
        }
        if (this.hasAuthId()) {
            DataSerializer.writeString((String)this.defaultSchema, (DataOutput)out);
        }
        GemFireXDUtils.writeCompressedHighLow(out, this.connectionId);
        GemFireXDUtils.writeCompressedHighLow(out, this.statementId);
        if (this.explainConnectionEnabled()) {
            InternalDataSerializer.writeSignedVL((long)this.executionId, (DataOutput)out);
        }
        if (this.source != null) {
            DataSerializer.writeString((String)this.source, (DataOutput)out);
        }
        GemFireXDUtils.writeCompressedHighLow(out, this.timeOutMillis);
        if (StatementExecutorMessage.class == this.getClass()) {
            ConstantValueSetImpl.writeBytes(out, this.pvs);
        }
        if (GemFireXDUtils.isSet(this.extraFlags, (short)256)) {
            if (!oldVersion) {
                DataSerializer.writeTHashMap((THashMap)this.getNcjMetaData(), (DataOutput)out);
                GemFireXDUtils.writeCompressedHighLow(out, this.rootId);
                out.writeByte((byte)this.statementLevel);
            } else {
                SanityManager.THROWASSERT((String)"Non Collocated Join: May not work in Rolling Upgarde or Mixed Version Scenario");
            }
        }
        if (begintime != 0L) {
            this.ser_deser_time = XPLAINUtil.recordTiming(begintime);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.ser_deser_time = this.timeStatsEnabled ? (long)(this.ser_deser_time == 0L ? -1 : -2) : 0L;
        super.fromData(in);
        this.queryFlags = this.flags & 0xFFFFFF00;
        boolean oldVersion = InternalDataSerializer.getVersionForDataStream((DataInput)in).compareTo(Version.GFXD_10) < 0;
        this.extraFlags = oldVersion ? (short)in.readByte() : in.readShort();
        this.HDFSFlags = oldVersion ? (short)in.readByte() : in.readShort();
        if (this.hasAuthId()) {
            this.defaultSchema = DataSerializer.readString((DataInput)in);
        }
        this.connectionId = GemFireXDUtils.readCompressedHighLow(in);
        this.statementId = GemFireXDUtils.readCompressedHighLow(in);
        if (this.explainConnectionEnabled()) {
            this.executionId = (int)InternalDataSerializer.readSignedVL((DataInput)in);
        }
        if ((this.flags & 0x80) != 0) {
            this.source = DataSerializer.readString((DataInput)in);
        }
        this.timeOutMillis = GemFireXDUtils.readCompressedHighLow(in);
        if (StatementExecutorMessage.class == this.getClass()) {
            this.pvs = ConstantValueSetImpl.readBytes(in);
        }
        if (GemFireXDUtils.isSet(this.extraFlags, (short)256)) {
            this.setNcjMetaData(DataSerializer.readTHashMap((DataInput)in));
            this.rootId = GemFireXDUtils.readCompressedHighLow(in);
            this.statementLevel = in.readByte();
        }
        if (this.timeStatsEnabled && this.ser_deser_time == -1L) {
            this.ser_deser_time = XPLAINUtil.recordStdTiming(this.getTimestamp());
        }
    }

    @Override
    protected void appendFields(StringBuilder sb) {
        super.appendFields(sb);
        sb.append(";connectionId=").append(this.connectionId).append(";statementId=").append(this.statementId).append(";executionId=").append(this.executionId).append(";rootId=").append(this.rootId).append(";statementLevel=").append(this.statementLevel).append(";source=").append(this.source).append(";defaultSchema=").append(this.defaultSchema).append(";optimizeForWrite=").append(this.optimizeForWrite()).append(";queryFlags=0x").append(Integer.toHexString(this.queryFlags)).append(";extraFlags=0x").append(Integer.toHexString(this.extraFlags)).append(";HDFSFlags=0x").append(Integer.toHexString(this.HDFSFlags)).append(";pvs=" + this.pvs).append(";timeOutMillis=" + this.timeOutMillis);
    }

    public final void recBeginProcessTime() {
        this.process_time = XPLAINUtil.recordTiming(-1L);
    }

    public final Timestamp getEndProcessTime() {
        return XPLAINUtil.currentTimeStamp();
    }

    public final String source() {
        return this.source;
    }

    @Override
    public void setDistributionStatistics(XPLAINDistPropsDescriptor distdesc, boolean processReplySend) {
        TXStateInterface tx;
        super.setDistributionStatistics(distdesc, processReplySend);
        StringBuilder sb = new StringBuilder();
        if (this.isSelect()) {
            sb.append("is_select,");
        }
        if (GemFireXDUtils.isSet(this.queryFlags, 512)) {
            sb.append("optimizedForWrite,");
        }
        if (this.allowSubqueryFlattening()) {
            sb.append("disallow_subquery_flattening,");
        }
        if (this.isSpecialCaseOuterJoin()) {
            sb.append("is_outer_join_rr,");
        }
        if (this.isSelectForUpdateAndNeedKeys()) {
            sb.append("select_for_update_need_key,");
        }
        if (this.hasAuthId()) {
            sb.append("has_auth_id:").append(this.defaultSchema).append(",");
        }
        if (this.needGfxdSubActivation()) {
            sb.append("need_gfxd_sub_activation,");
        }
        if (this.statsEnabled()) {
            sb.append("enable_stats,");
        }
        if (this.timeStatsEnabled()) {
            sb.append("enable_timestats,");
        }
        if (this.explainConnectionEnabled()) {
            sb.append("explain_connection_mode,");
        }
        if (this.isSkipListeners()) {
            sb.append("skip_listeners,");
        }
        if ((tx = this.getTXState()) != null) {
            switch (tx.getIsolationLevel().getJdbcIsolationLevel()) {
                case 0: {
                    sb.append("none,");
                    break;
                }
                case 2: {
                    sb.append("RC").append(",");
                    break;
                }
                case 1: {
                    sb.append("RU").append(",");
                    break;
                }
                case 4: {
                    sb.append("RR").append(",");
                    break;
                }
                case 8: {
                    sb.append("SE").append(",");
                }
            }
        }
        distdesc.setMessageFlags(sb.toString());
    }

    public int getExecutionId() {
        return this.executionId;
    }
}

