/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.message;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.offheap.OffHeapHelper;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.access.index.SortedMap2IndexScanController;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdListResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.OffHeapReleaseUtil;
import com.pivotal.gemfirexd.internal.engine.distributed.message.ProjectionRow;
import com.pivotal.gemfirexd.internal.engine.distributed.message.RegionMultiKeyExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.store.access.GenericScanController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class GetAllLocalIndexExecutorMessage
extends RegionMultiKeyExecutorMessage {
    protected long connectionId;
    private String qualifiedIndexName;
    private final Object[] inKeys;

    public GetAllLocalIndexExecutorMessage() {
        super(true);
        this.inKeys = null;
    }

    public GetAllLocalIndexExecutorMessage(String qualifiedName, Object[] keys, LocalRegion region, LanguageConnectionContext lcc, long connectionId, TXStateInterface tx, RowFormatter targetFormat, int[] projectionFixedColumns, int[] projectionVarColumns, int[] projectionLobColumns, int[] projectionAllColumns) {
        super(new GfxdListResultCollector(null, false), region, null, GetAllLocalIndexExecutorMessage.getCurrentTXState(lcc), GetAllLocalIndexExecutorMessage.getTimeStatsSettings(lcc), targetFormat, projectionFixedColumns, projectionVarColumns, projectionLobColumns, projectionAllColumns);
        this.qualifiedIndexName = qualifiedName;
        this.inKeys = keys;
        this.connectionId = connectionId;
        SanityManager.ASSERT((this.qualifiedIndexName != null ? 1 : 0) != 0);
        SanityManager.ASSERT((this.inKeys != null ? 1 : 0) != 0);
        SanityManager.ASSERT((this.membersToKeys != null ? 1 : 0) != 0);
        SanityManager.ASSERT((this.routingObjects == null ? 1 : 0) != 0);
    }

    public GetAllLocalIndexExecutorMessage(GetAllLocalIndexExecutorMessage other) {
        super(other);
        this.inKeys = other.inKeys;
        this.qualifiedIndexName = other.qualifiedIndexName;
        this.connectionId = other.connectionId;
    }

    @Override
    protected GetAllLocalIndexExecutorMessage clone() {
        return new GetAllLocalIndexExecutorMessage(this);
    }

    @Override
    protected void setArgsForMember(DistributedMember member, Set<DistributedMember> messageAwareMembers) {
        this.target = member;
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.getID() + ".setArgsForMember: keys for " + this.regionPath + " :- [" + this.membersToKeys + "] for member= " + member.toString()));
        }
    }

    @Override
    protected void setMembersToBucketIds(PartitionedRegion.RetryTimeKeeper retryTime) throws StandardException {
        super.setMembersToBucketIds(retryTime);
        this.resetKeysPerMember();
        for (Object key : this.inKeys) {
            this.membersToKeys.add(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() throws Exception {
        ArrayList<Object> resultList = new ArrayList<Object>();
        int numKeys = this.membersToKeys.size();
        TXStateInterface tx = this.getTXState(this.region);
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.getID() + ".execute: Got keys " + this.membersToKeys + " of size [" + numKeys + "] " + " for region " + this.region.getFullPath() + " , processorId=" + this.getProcessorId() + " ,tx=" + (tx != null ? tx : "null")));
        }
        GemFireContainer baseContainer = (GemFireContainer)this.region.getUserAttribute();
        GfxdIndexManager idmanager = (GfxdIndexManager)this.region.getIndexUpdater();
        List<GemFireContainer> localIndexContainers = idmanager.getIndexContainers();
        try {
            if (localIndexContainers != null && !localIndexContainers.isEmpty()) {
                boolean foundIndex = false;
                for (GemFireContainer indexContainer : localIndexContainers) {
                    if (!indexContainer.isLocalIndex() || !indexContainer.getQualifiedTableName().equals(this.qualifiedIndexName)) continue;
                    foundIndex = true;
                    GfxdConnectionWrapper wrapper = GfxdConnectionHolder.getOrCreateWrapper(null, this.connectionId, false, null);
                    EmbedConnection conn = wrapper.getConnectionForSynchronization();
                    boolean scanOpened = false;
                    GenericScanController sc = null;
                    Object object = conn.getConnectionSynchronization();
                    synchronized (object) {
                        LanguageConnectionContext lcc = null;
                        GemFireTransaction tc = null;
                        int oldLCCFlags = 0;
                        try {
                            lcc = conn.getLanguageConnectionContext();
                            oldLCCFlags = lcc.getFlags();
                            tc = (GemFireTransaction)lcc.getTransactionExecute();
                            GfxdConnectionWrapper.checkForTransaction(conn, tc, tx);
                            if (lcc.getBucketIdsForLocalExecution() != null) {
                                SanityManager.THROWASSERT((String)("lcc should have no region buckets set, but in lcc we are getting " + lcc.getBucketIdsForLocalExecution()));
                            }
                            lcc.setExecuteLocally(this.bucketBitSet, (Region<?, ?>)this.region, false, null);
                            DataValueDescriptor[] currentDvdKeyArr = new DataValueDescriptor[1];
                            for (int keyIndex = 0; keyIndex < numKeys; ++keyIndex) {
                                DataValueDescriptor[] dvdKeyArr;
                                Object currentKey = this.membersToKeys.get(keyIndex);
                                if (currentKey instanceof DataValueDescriptor[]) {
                                    dvdKeyArr = (DataValueDescriptor[])currentKey;
                                } else if (currentKey instanceof DataValueDescriptor) {
                                    currentDvdKeyArr[0] = (DataValueDescriptor)currentKey;
                                    dvdKeyArr = currentDvdKeyArr;
                                } else {
                                    SanityManager.THROWASSERT((String)("currentkey=" + currentKey + " ,keyIndex=" + keyIndex + " ,type=" + currentKey.getClass().getSimpleName()));
                                    dvdKeyArr = null;
                                }
                                if (sc == null) {
                                    sc = tc.openScan(indexContainer.getId().getContainerId(), true, 0, 6, 0, null, dvdKeyArr, 1, null, dvdKeyArr, -1, null);
                                    assert (sc instanceof SortedMap2IndexScanController);
                                    scanOpened = true;
                                } else {
                                    sc.reopenScan(dvdKeyArr, 1, null, dvdKeyArr, -1, null);
                                }
                                int resultCount = 0;
                                RowLocation rl = null;
                                while (sc.next()) {
                                    Object result;
                                    ++resultCount;
                                    rl = sc.getCurrentRowLocation();
                                    if (rl == null) continue;
                                    Object val = rl.getValueWithoutFaultIn(baseContainer);
                                    ProjectionRow projRow = null;
                                    if (val instanceof BucketRegion.RawValue) {
                                        projRow = (ProjectionRow)val;
                                        val = projRow.getRawValue();
                                    }
                                    if (val == null || Token.isInvalid((Object)val)) continue;
                                    if (this.hasProjection) {
                                        if (this.isLocallyExecuted()) {
                                            try {
                                                result = ProjectionRow.getCompactExecRow(val, baseContainer, this.targetFormat, this.projectionAllColumns, this.projectionLobColumns);
                                            }
                                            finally {
                                                OffHeapHelper.release((Object)val);
                                            }
                                        } else {
                                            if (projRow == null) {
                                                projRow = new ProjectionRow(val);
                                            }
                                            projRow.setProjectionInfo(baseContainer.getRowFormatter(val), this.projectionFixedColumns, this.projectionVarColumns, this.projectionLobColumns, this.targetFormatOffsetBytes);
                                            result = projRow;
                                        }
                                    } else {
                                        result = val;
                                    }
                                    if (GemFireXDUtils.TraceRSIter) {
                                        SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)(this.getID() + ".execute: Got result for key= " + currentKey + " (keyIndex=" + keyIndex + " ) for Index on region " + this.region.getFullPath() + " result=" + " [" + result + "]"));
                                    }
                                    resultList.add(result);
                                }
                                if (!(GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ)) continue;
                                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(this.getID() + ".execute: Got " + resultCount + " no of result for key= " + currentKey + " (keyIndex=" + keyIndex + " ) for Index on region " + this.region.getFullPath()));
                            }
                        }
                        finally {
                            try {
                                if (scanOpened) {
                                    sc.close();
                                }
                            }
                            finally {
                                if (lcc != null) {
                                    lcc.setFlags(oldLCCFlags);
                                    lcc.setExecuteLocally(null, null, false, null);
                                }
                                if (tc != null) {
                                    tc.resetTXState();
                                }
                            }
                        }
                        break;
                    }
                }
                if (!foundIndex) {
                    StringBuilder indexList = new StringBuilder();
                    for (GemFireContainer indexContainer : localIndexContainers) {
                        indexList.append("(");
                        indexList.append(indexContainer.getQualifiedTableName());
                        indexList.append(":");
                        indexList.append(indexContainer.isLocalIndex());
                        indexList.append(")");
                    }
                    throw new IllegalStateException("Did not find chosen index=" + this.qualifiedIndexName + " for region: " + this.region.getFullPath() + " in index-list {" + indexList + "}");
                }
            } else {
                throw new IllegalStateException("expected at least one index for the table using region: " + this.region.getFullPath());
            }
            try {
                this.lastResult(resultList, false, true, true);
            }
            catch (RuntimeException re) {
                if (GemFireXDUtils.isOffHeapEnabled() && this.isLocallyExecuted()) {
                    OffHeapReleaseUtil.freeOffHeapReference(resultList);
                }
                throw re;
            }
        }
        finally {
            if (GemFireXDUtils.isOffHeapEnabled() && !this.isLocallyExecuted()) {
                OffHeapReleaseUtil.freeOffHeapReference(resultList);
            }
        }
    }

    @Override
    public final int getMessageProcessorType() {
        return 78;
    }

    @Override
    public final boolean canStartRemoteTransaction() {
        return this.getLockingPolicy().readCanStartTX();
    }

    @Override
    public boolean useTransactionProxy() {
        return this.getLockingPolicy().readCanStartTX();
    }

    @Override
    protected boolean requiresTXFlushAfterExecution() {
        return this.getLockingPolicy().readCanStartTX();
    }

    @Override
    public byte getGfxdID() {
        return 48;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        long beginTime = this.timeStatsEnabled ? XPLAINUtil.recordTiming(this.ser_deser_time == 0L ? (this.ser_deser_time = -1L) : -2L) : 0L;
        super.toData(out);
        GemFireXDUtils.writeCompressedHighLow(out, this.connectionId);
        DataSerializer.writeString((String)this.qualifiedIndexName, (DataOutput)out);
        if (beginTime != 0L) {
            this.ser_deser_time = XPLAINUtil.recordTiming(beginTime);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.ser_deser_time = this.timeStatsEnabled ? (long)(this.ser_deser_time == 0L ? -1 : -2) : 0L;
        super.fromData(in);
        this.connectionId = GemFireXDUtils.readCompressedHighLow(in);
        this.qualifiedIndexName = DataSerializer.readString((DataInput)in);
        if (this.timeStatsEnabled && this.ser_deser_time == -1L) {
            this.ser_deser_time = XPLAINUtil.recordStdTiming(this.getTimestamp());
        }
    }

    @Override
    protected void appendFields(StringBuilder sb) {
        super.appendFields(sb);
        sb.append(";connectionId=").append(this.connectionId).append(";qualifiedIndexName=").append(this.qualifiedIndexName);
    }

    @Override
    public long estimateMemoryUsage() throws StandardException {
        long memory = 0L;
        try {
            for (Object k : this.membersToKeys) {
                if (k instanceof CompactCompositeKey) {
                    memory += ((CompactCompositeKey)k).estimateMemoryUsage();
                    continue;
                }
                if (k instanceof DataValueDescriptor) {
                    memory += (long)((DataValueDescriptor)k).estimateMemoryUsage();
                    continue;
                }
                if (!(k instanceof Long)) continue;
                memory += 64L;
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return memory;
    }

    @Override
    public void reset() {
        super.reset();
        this.resetKeysPerMember();
    }

    @Override
    public boolean withSecondaries() {
        return false;
    }
}

