/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl.wan.messages;

import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.Token;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.messages.AbstractDBSynchronizerMessage;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.messages.GfxdCBArgForSynchPrms;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class BulkDBSynchronizerMessage
extends AbstractDBSynchronizerMessage {
    private transient GfxdCBArgForSynchPrms cbArg;
    private boolean skipListeners;
    private static final short SKIP_LISTENERS = 64;

    public BulkDBSynchronizerMessage() {
    }

    public BulkDBSynchronizerMessage(LocalRegion rgn, String dmlString, boolean skipListeners, GfxdCBArgForSynchPrms arg) throws StandardException {
        super(rgn);
        this.cbArg = arg;
        this.getEntryEventImpl().setNewValue((Object)Token.INVALID);
        this.getEntryEventImpl().setCallbackArgument((Object)this.cbArg);
        this.getEntryEventImpl().disallowOffHeapValues();
        this.skipListeners = skipListeners;
    }

    @Override
    public byte getGfxdID() {
        return 92;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.skipListeners = (this.flags & 0x40) != 0;
        try {
            EntryEventImpl event = this.getEntryEventImpl();
            if (event != null) {
                this.cbArg = new GfxdCBArgForSynchPrms();
                InternalDataSerializer.invokeFromData((DataSerializableFixedID)this.cbArg, (DataInput)in);
                event.setNewValue((Object)Token.INVALID);
                event.setCallbackArgument((Object)this.cbArg);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        try {
            InternalDataSerializer.invokeToData((DataSerializableFixedID)this.cbArg, (DataOutput)out);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    protected short computeCompressedShort(short flags) {
        flags = super.computeCompressedShort(flags);
        if (this.skipListeners) {
            flags = (short)(flags | 0x40);
        }
        return flags;
    }

    public GfxdCBArgForSynchPrms getGfxdCBArgForSynchPrms() {
        return this.cbArg;
    }

    @Override
    protected void appendFields(StringBuilder sb) {
        super.appendFields(sb);
        sb.append(";GfxdCBArgForSynchPrms=").append(this.cbArg).append(";skipListeners=").append(this.skipListeners);
    }

    @Override
    Operation getOperation() {
        return Operation.BULK_DML_OP;
    }

    @Override
    EnumListenerEvent getListenerEvent() {
        return EnumListenerEvent.AFTER_BULK_DML_OP;
    }

    @Override
    boolean skipListeners() {
        return this.skipListeners;
    }
}

