/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.operations;

import com.gemstone.gemfire.cache.hdfs.HDFSStore;
import com.gemstone.gemfire.cache.hdfs.HDFSStoreMutator;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreImpl;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreMutatorImpl;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemOperation;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.DataDictionaryImpl;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.TabInfoImpl;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.IOException;

public class HDFSStoreAlterOperation
extends MemOperation {
    private final HDFSStoreMutator mutator;
    private final String storeName;
    private HDFSStore oldStoreConfig;

    public HDFSStoreAlterOperation(HDFSStoreMutator hsm, String storeName) {
        super(null);
        this.mutator = hsm;
        this.storeName = storeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        GemFireTransaction tc = (GemFireTransaction)xact;
        LanguageConnectionContext lcc = tc.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        if (this.mutator == null) {
            return;
        }
        HDFSStoreImpl hsi = Misc.getGemFireCache().findHDFSStore(this.storeName);
        if (ServerGroupUtils.isDataStore() && hsi == null) {
            throw StandardException.newException("42Y55", (Object)"HDFSSTORE", (Object)this.storeName);
        }
        if (!ServerGroupUtils.isDataStore()) {
            int mode = dd.startReading(lcc);
            try {
                ExecIndexRow keyRow = dd.getExecutionFactory().getIndexableRow(1);
                keyRow.setColumn(1, new SQLVarchar(this.storeName));
                TabInfoImpl ti = ((DataDictionaryImpl)dd).getNonCoreTI(24);
                ExecRow oldRow = ti.getRow(tc, keyRow, 0);
                if (oldRow == null) {
                    throw StandardException.newException("42Y55", (Object)"HDFSSTORE", (Object)this.storeName);
                }
            }
            finally {
                dd.doneReading(mode, lcc);
            }
        }
        dd.startWriting(lcc);
        try {
            if (ServerGroupUtils.isDataStore()) {
                this.oldStoreConfig = hsi.alter(this.mutator);
                SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("AlterHDFSStoreNode: updated hdfsstore configuration for " + this.storeName));
            }
            ExecIndexRow keyRow = dd.getExecutionFactory().getIndexableRow(1);
            keyRow.setColumn(1, new SQLVarchar(this.storeName));
            TabInfoImpl ti = ((DataDictionaryImpl)dd).getNonCoreTI(24);
            ExecRow curRow = ti.getRow(tc, keyRow, 0);
            if (curRow == null) {
                throw StandardException.newException("42Y55", (Object)"HDFSSTORE", (Object)this.storeName);
            }
            boolean[] bArray = new boolean[1];
            ExecRow mutatedRow = this.mutateRow(curRow);
            ti.updateRow(keyRow, mutatedRow, 0, bArray, null, (TransactionController)tc);
            SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("AlterHDFSStoreNode: updated hdfsstore configuration for " + this.storeName + " in SYS table"));
        }
        catch (Throwable t) {
            throw StandardException.newException("X0Z30.S", t, (Object)t.getMessage());
        }
    }

    public ExecRow mutateRow(ExecRow currRow) {
        HDFSStoreMutator.HDFSCompactionConfigMutator compactionMutator;
        HDFSStoreMutator.HDFSEventQueueAttributesMutator qMutator;
        ExecRow mutableRow = currRow.getClone();
        if (this.mutator.getFileRolloverInterval() >= 0) {
            this.logAttrMutation("fileRolloverInterval", this.mutator.getFileRolloverInterval());
            mutableRow.setColumn(21, new SQLLongint(Integer.valueOf(this.mutator.getFileRolloverInterval()).intValue()));
        }
        if (this.mutator.getMaxFileSize() >= 0) {
            this.logAttrMutation("MaxFileSize", this.mutator.getFileRolloverInterval());
            mutableRow.setColumn(20, new SQLLongint(Integer.valueOf(this.mutator.getMaxFileSize()).intValue()));
        }
        if ((qMutator = this.mutator.getHDFSEventQueueAttributesMutator()).getBatchSizeMB() >= 0) {
            this.logAttrMutation("batchSizeMB", this.mutator.getFileRolloverInterval());
            mutableRow.setColumn(5, new SQLLongint(qMutator.getBatchSizeMB()));
        }
        if (qMutator.getBatchTimeInterval() >= 0) {
            this.logAttrMutation("batchTimeInterval", this.mutator.getFileRolloverInterval());
            mutableRow.setColumn(6, new SQLLongint(qMutator.getBatchTimeInterval()));
        }
        if ((compactionMutator = this.mutator.getCompactionConfigMutator()).getMaxInputFileCount() >= 0) {
            this.logAttrMutation("maxInputFileCount", compactionMutator.getMaxInputFileCount());
            mutableRow.setColumn(14, new SQLLongint(compactionMutator.getMaxInputFileCount()));
        }
        if (compactionMutator.getMaxInputFileSizeMB() >= 0) {
            this.logAttrMutation("MaxInputFileSizeMB", compactionMutator.getMaxInputFileSizeMB());
            mutableRow.setColumn(12, new SQLLongint(compactionMutator.getMaxInputFileSizeMB()));
        }
        if (compactionMutator.getMaxThreads() >= 0) {
            this.logAttrMutation("MaxThreads", compactionMutator.getMaxThreads());
            mutableRow.setColumn(15, new SQLLongint(compactionMutator.getMaxThreads()));
        }
        if (compactionMutator.getMinInputFileCount() >= 0) {
            this.logAttrMutation("MinInputFileCount", compactionMutator.getMinInputFileCount());
            mutableRow.setColumn(13, new SQLLongint(compactionMutator.getMinInputFileCount()));
        }
        if (compactionMutator.getAutoCompaction() != null) {
            this.logAttrMutation("AutoCompaction", compactionMutator.getAutoCompaction());
            mutableRow.setColumn(10, new SQLBoolean(compactionMutator.getAutoCompaction()));
        }
        if (compactionMutator.getMajorCompactionIntervalMins() > -1) {
            this.logAttrMutation("MajorCompactionIntervalMins", compactionMutator.getMajorCompactionIntervalMins());
            mutableRow.setColumn(16, new SQLLongint(compactionMutator.getMajorCompactionIntervalMins()));
        }
        if (compactionMutator.getMajorCompactionMaxThreads() >= 0) {
            this.logAttrMutation("MajorCompactionMaxThreads", compactionMutator.getMajorCompactionMaxThreads());
            mutableRow.setColumn(17, new SQLLongint(compactionMutator.getMajorCompactionMaxThreads()));
        }
        if (compactionMutator.getAutoMajorCompaction() != null) {
            this.logAttrMutation("AutoMajorCompaction", compactionMutator.getAutoMajorCompaction());
            mutableRow.setColumn(11, new SQLBoolean(compactionMutator.getAutoMajorCompaction()));
        }
        if (compactionMutator.getOldFilesCleanupIntervalMins() >= 0) {
            this.logAttrMutation("OldFilesCleanupIntervalMins", compactionMutator.getOldFilesCleanupIntervalMins());
            mutableRow.setColumn(22, new SQLLongint(compactionMutator.getOldFilesCleanupIntervalMins()));
        }
        return mutableRow;
    }

    private void logAttrMutation(String field, Object fileRolloverInterval) {
        SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("HDFSStoreAlterOperation: Mutating fields for " + this.storeName + ". Updated field = " + field + " value: " + fileRolloverInterval));
    }

    @Override
    public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        if (this.oldStoreConfig != null) {
            HDFSStoreMutatorImpl oldConfigBasedMutator = new HDFSStoreMutatorImpl(this.oldStoreConfig);
            return new HDFSStoreAlterOperation((HDFSStoreMutator)oldConfigBasedMutator, this.storeName);
        }
        return new HDFSStoreAlterOperation(null, this.storeName);
    }
}

