/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.operations;

import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.access.operations.GlobalHashIndexDeleteOperation;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemIndexOperation;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import java.io.IOException;

public final class GlobalHashIndexInsertOperation
extends MemIndexOperation {
    public GlobalHashIndexInsertOperation(GemFireContainer container, Object key, RowLocation value) {
        super(container, key, value);
    }

    @Override
    public void doMe(Transaction tran, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        GlobalHashIndexInsertOperation.doMe(null, null, this.memcontainer, this.key, this.row, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doMe(GemFireTransaction tran, TXStateInterface tx, GemFireContainer container, Object key, RowLocation value, boolean isPutDML, boolean wasPutDML) throws StandardException {
        TXManagerImpl txMgr = null;
        TXStateProxy proxy = null;
        try {
            if (tx != null && (proxy = tx.getProxy()) != tx) {
                if (GemFireXDUtils.TraceTran) {
                    SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GlobalHashIndexInsertOperation#doMe:  setting proxy transaction: " + proxy + " in current thread replacing " + tx));
                }
                txMgr = tran.getTransactionManager();
                txMgr.masqueradeAs((TXStateInterface)proxy);
            }
            if (tran != null && tran.needLogging()) {
                GlobalHashIndexInsertOperation op = new GlobalHashIndexInsertOperation(container, key, value);
                tran.logAndDo(op);
                return;
            }
            if (GemFireXDUtils.TraceIndex) {
                GfxdIndexManager.traceIndex("GlobalHashIndexInsertOp: inserting key=(%s) value=(%s) into %s", key, value, container);
            }
            ((KeyWithRegionContext)key).setRegionContext(container.getRegion());
            if (!container.isGlobalIndexForPrimaryKey() && isPutDML) {
                isPutDML = false;
            }
            container.insert(key, value, false, tran, (TXStateInterface)proxy, GemFireTransaction.getLanguageConnectionContext(tran), false, isPutDML, wasPutDML);
            if (GemFireXDUtils.TraceIndex) {
                GfxdIndexManager.traceIndex("GlobalHashIndexInsertOp: successfully inserted key=(%s) value=(%s) into %s", key, value, container);
            }
        }
        finally {
            if (txMgr != null) {
                if (GemFireXDUtils.TraceTran) {
                    SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GlobalHashIndexInsertOperation#doMe:  switching back to: " + tx + " in current thread instead of: " + proxy));
                }
                txMgr.masqueradeAs(tx);
            }
        }
    }

    @Override
    public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        return new GlobalHashIndexDeleteOperation(this.memcontainer, this.key);
    }
}

