/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.operations;

import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemIndexOperation;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import java.io.IOException;

public final class GlobalHashIndexDeleteOperation
extends MemIndexOperation {
    private boolean deleteSuccess;

    public GlobalHashIndexDeleteOperation(GemFireContainer container, Object key) {
        super(container, key, null);
    }

    @Override
    public void doMe(Transaction tran, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        this.deleteSuccess = GlobalHashIndexDeleteOperation.doMe(null, null, this.memcontainer, this.key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doMe(GemFireTransaction tran, TXStateInterface tx, GemFireContainer container, Object key, boolean doEvict) throws StandardException {
        TXManagerImpl txMgr = null;
        TXStateProxy proxy = null;
        try {
            boolean success;
            if (tx != null && (proxy = tx.getProxy()) != tx) {
                if (GemFireXDUtils.TraceTran) {
                    SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GlobalHashIndexDeleteOperation#doMe:  setting proxy transaction: " + proxy + " in current thread replacing " + tx));
                }
                txMgr = tran.getTransactionManager();
                txMgr.masqueradeAs((TXStateInterface)proxy);
            }
            if (tran != null && tran.needLogging()) {
                GlobalHashIndexDeleteOperation op = new GlobalHashIndexDeleteOperation(container, key);
                tran.logAndDo(op);
                boolean bl = op.deleteSuccess;
                return bl;
            }
            if (GemFireXDUtils.TraceIndex) {
                GfxdIndexManager.traceIndex("GlobalHashIndexDeleteOp: deleting key=%s from %s", key, container);
            }
            try {
                container.delete(key, null, false, tran, (TXStateInterface)proxy, GemFireTransaction.getLanguageConnectionContext(tran), doEvict);
                success = true;
            }
            catch (EntryNotFoundException ex) {
                success = false;
            }
            if (GemFireXDUtils.TraceIndex) {
                GfxdIndexManager.traceIndex("GlobalHashIndexDeleteOp: %s deleted key=%s from %s", success ? "successfully" : "unsuccessfully", key, container);
            }
            boolean bl = success;
            return bl;
        }
        finally {
            if (txMgr != null) {
                if (GemFireXDUtils.TraceTran) {
                    SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("GlobalHashIndexDeleteOperation#doMe:  switching back to: " + tx + " in current thread instead of: " + proxy));
                }
                txMgr.masqueradeAs(tx);
            }
        }
    }

    @Override
    public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        throw new UnsupportedOperationException("cannot undo global index delete since PR#destroy does not provide old value");
    }

    @Override
    public final boolean shouldBeConflated() {
        return true;
    }
}

