/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.index;

import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemOperation;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraIndexInfo;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import java.io.IOException;

public final class MemIndexRefresh
extends MemOperation {
    private final GfxdIndexManager indexManager;
    private boolean lockGIIDone;
    private final boolean unlockForIndexGII;
    private int dropColumnPos;

    MemIndexRefresh(GfxdIndexManager indexManager, boolean unlockForIndexGII, boolean forceRefresh) {
        super(indexManager.getContainer());
        this.indexManager = indexManager;
        this.lockGIIDone = false;
        this.unlockForIndexGII = unlockForIndexGII;
    }

    void setDropColumnPosition(int pos) {
        this.dropColumnPos = pos;
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        GemFireTransaction tc = (GemFireTransaction)xact;
        if (Misc.getLanguageConnectionContext() != null) {
            this.indexManager.refreshIndexListAndConstriantDesc(!this.lockGIIDone, false, tc);
            if (this.dropColumnPos > 0) {
                for (GemFireContainer index : this.indexManager.getAllIndexes()) {
                    GemFireXDUtils.dropColumnAdjustColumnPositions(index.getBaseColumnPositions(), this.dropColumnPos);
                    ExtraIndexInfo indexInfo = index.getExtraIndexInfo();
                    if (indexInfo == null) continue;
                    indexInfo.dropColumnForPrimaryKeyFormatter(this.dropColumnPos);
                }
            }
        }
        if (this.lockGIIDone) {
            this.indexManager.unlockForGII(true, tc);
        }
        if (this.unlockForIndexGII) {
            this.indexManager.unlockForIndexGII(true, tc);
        }
    }

    void lockGII(GemFireTransaction tc) {
        if (!this.lockGIIDone) {
            this.lockGIIDone = this.indexManager.lockForGII(true, tc);
        }
    }

    @Override
    public boolean doAtCommitOrAbort() {
        return true;
    }

    @Override
    public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        this.dropColumnPos = 0;
        return null;
    }
}

