/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine;

import com.pivotal.gemfirexd.internal.engine.GfxdVTITemplate;
import com.pivotal.gemfirexd.internal.engine.GfxdVTITemplateNoAllNodesRoute;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.GfxdJarResource;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;

public final class GfxdJarHandler
extends GfxdVTITemplate
implements GfxdVTITemplateNoAllNodesRoute {
    private Iterator<Map.Entry<String, Long>> jarNameMapIterator;
    private Object[] currentEntry;
    public static final String SCHEMA = "SCHEMA";
    public static final String ALIAS = "ALIAS";
    public static final String ID = "ID";
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("SCHEMA", 12, false, 256), EmbedResultSetMetaData.getResultColumnDescriptor("ALIAS", 12, false, 256), EmbedResultSetMetaData.getResultColumnDescriptor("ID", -5, false)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    @Override
    public boolean next() throws SQLException {
        if (this.jarNameMapIterator == null) {
            GfxdJarResource jarResource = Misc.getMemStoreBooting().getJarFileHandler();
            if (jarResource == null) {
                return false;
            }
            this.jarNameMapIterator = jarResource.getNameToIDMap().entrySet().iterator();
        }
        if (this.jarNameMapIterator != null && this.jarNameMapIterator.hasNext()) {
            Map.Entry<String, Long> e = this.jarNameMapIterator.next();
            String schema = "";
            String alias = e.getKey();
            int dotIndex = alias.indexOf(46);
            if (dotIndex != -1) {
                schema = alias.substring(0, dotIndex);
                alias = alias.substring(dotIndex + 1);
            }
            this.currentEntry = new Object[]{schema, alias, e.getValue()};
            return true;
        }
        return false;
    }

    @Override
    protected Object getObjectForColumn(int columnNumber) throws SQLException {
        return this.currentEntry[columnNumber - 1];
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return metadata;
    }

    @Override
    public void close() throws SQLException {
        this.jarNameMapIterator = null;
        this.currentEntry = null;
    }

    public static void dummy() {
    }
}

