/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared.unsafe;

import com.gemstone.gemfire.internal.shared.ChannelBufferFramedInputStream;
import com.gemstone.gemfire.internal.shared.ChannelBufferFramedOutputStream;
import com.gemstone.gemfire.internal.shared.ChannelBufferInputStream;
import com.gemstone.gemfire.internal.shared.ChannelBufferOutputStream;
import com.gemstone.gemfire.internal.shared.InputStreamChannel;
import com.gemstone.gemfire.internal.shared.OutputStreamChannel;
import com.gemstone.gemfire.internal.shared.unsafe.ChannelBufferUnsafeFramedInputStream;
import com.gemstone.gemfire.internal.shared.unsafe.ChannelBufferUnsafeFramedOutputStream;
import com.gemstone.gemfire.internal.shared.unsafe.ChannelBufferUnsafeInputStream;
import com.gemstone.gemfire.internal.shared.unsafe.ChannelBufferUnsafeOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import sun.misc.Unsafe;

public abstract class UnsafeHolder {
    private static final boolean hasUnsafe;
    private static final Method directByteBufferAddressMethod;
    public static final long arrayBaseOffset;
    static final long UNSAFE_COPY_THRESHOLD = 0x100000L;
    static final int ARRAY_COPY_THRESHOLD = 6;

    private UnsafeHolder() {
    }

    public static boolean hasUnsafe() {
        return hasUnsafe;
    }

    public static Method getDirectByteBufferAddressMethod() {
        return directByteBufferAddressMethod;
    }

    public static Unsafe getUnsafe() {
        return Wrapper.unsafe;
    }

    public static InputStreamChannel newChannelBufferInputStream(ReadableByteChannel channel, int bufferSize) throws IOException {
        return directByteBufferAddressMethod != null ? new ChannelBufferUnsafeInputStream(channel, bufferSize) : new ChannelBufferInputStream(channel, bufferSize);
    }

    public static OutputStreamChannel newChannelBufferOutputStream(WritableByteChannel channel, int bufferSize) throws IOException {
        return directByteBufferAddressMethod != null ? new ChannelBufferUnsafeOutputStream(channel, bufferSize) : new ChannelBufferOutputStream(channel, bufferSize);
    }

    public static InputStreamChannel newChannelBufferFramedInputStream(ReadableByteChannel channel, int bufferSize) throws IOException {
        return directByteBufferAddressMethod != null ? new ChannelBufferUnsafeFramedInputStream(channel, bufferSize) : new ChannelBufferFramedInputStream(channel, bufferSize);
    }

    public static OutputStreamChannel newChannelBufferFramedOutputStream(WritableByteChannel channel, int bufferSize) throws IOException {
        return directByteBufferAddressMethod != null ? new ChannelBufferUnsafeFramedOutputStream(channel, bufferSize) : new ChannelBufferFramedOutputStream(channel, bufferSize);
    }

    public static void copyMemory(Object src, long srcOffset, Object dst, long dstOffset, long length, Unsafe unsafe) {
        while (length > 0L) {
            long size = Math.min(length, 0x100000L);
            unsafe.copyMemory(src, srcOffset, dst, dstOffset, size);
            length -= size;
            srcOffset += size;
            dstOffset += size;
        }
    }

    public static boolean checkBounds(int off, int len, int size) {
        return (off | len | off + len | size - (off + len)) >= 0;
    }

    public static void bufferGet(byte[] dst, long address, int offset, int length, Unsafe unsafe) {
        if (length > 6) {
            UnsafeHolder.copyMemory(null, address, dst, arrayBaseOffset + (long)offset, length, unsafe);
        } else {
            int end = offset + length;
            while (offset < end) {
                dst[offset] = unsafe.getByte(address);
                ++address;
                ++offset;
            }
        }
    }

    public static void bufferPut(byte[] src, long address, int offset, int length, Unsafe unsafe) {
        if (length > 6) {
            UnsafeHolder.copyMemory(src, arrayBaseOffset + (long)offset, null, address, length, unsafe);
        } else {
            int end = offset + length;
            while (offset < end) {
                unsafe.putByte(address, src[offset]);
                ++address;
                ++offset;
            }
        }
    }

    static {
        boolean v;
        long arrayOffset = -1L;
        try {
            Wrapper.init();
            arrayOffset = Wrapper.unsafe.arrayBaseOffset(byte[].class);
            v = true;
        }
        catch (LinkageError le) {
            le.printStackTrace();
            v = false;
        }
        hasUnsafe = v;
        arrayBaseOffset = arrayOffset;
        if (hasUnsafe) {
            Method m;
            ByteBuffer testBuf = ByteBuffer.allocateDirect(1);
            try {
                m = testBuf.getClass().getDeclaredMethod("address", new Class[0]);
                m.setAccessible(true);
            }
            catch (Exception e) {
                m = null;
            }
            directByteBufferAddressMethod = m;
        } else {
            directByteBufferAddressMethod = null;
        }
    }

    private static final class Wrapper {
        static final Unsafe unsafe;

        private Wrapper() {
        }

        static void init() {
        }

        static {
            Unsafe v;
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                v = (Unsafe)field.get(null);
            }
            catch (LinkageError le) {
                throw le;
            }
            catch (Throwable t) {
                throw new ExceptionInInitializerError(t);
            }
            if (v == null) {
                throw new ExceptionInInitializerError("theUnsafe not found");
            }
            unsafe = v;
        }
    }
}

