/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared.unsafe;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.OutputStreamChannel;
import com.gemstone.gemfire.internal.shared.unsafe.UnsafeHolder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import sun.misc.Unsafe;

public class ChannelBufferUnsafeOutputStream
extends OutputStreamChannel {
    protected final ByteBuffer buffer;
    protected final long baseAddress;
    protected long addrPosition;
    protected long addrLimit;
    protected static final Unsafe unsafe = UnsafeHolder.getUnsafe();
    protected static final int MIN_BUFFER_SIZE = 10;

    public ChannelBufferUnsafeOutputStream(WritableByteChannel channel) throws IOException {
        this(channel, 32768);
    }

    public ChannelBufferUnsafeOutputStream(WritableByteChannel channel, int bufferSize) throws IOException {
        super(channel);
        if (bufferSize < 10) {
            throw new IllegalArgumentException("ChannelBufferUnsafeDataOutputStream: buffersize=" + bufferSize + " too small (minimum " + 10 + ')');
        }
        this.buffer = this.allocateBuffer(bufferSize);
        try {
            this.baseAddress = (Long)UnsafeHolder.getDirectByteBufferAddressMethod().invoke((Object)this.buffer, new Object[0]);
            this.resetBufferPositions();
        }
        catch (Exception e) {
            throw ClientSharedUtils.newRuntimeException("failed in creating an 'unsafe' buffered channel stream", e);
        }
    }

    protected final void resetBufferPositions() {
        this.addrPosition = this.baseAddress + (long)this.buffer.position();
        this.addrLimit = this.baseAddress + (long)this.buffer.limit();
    }

    protected ByteBuffer allocateBuffer(int bufferSize) {
        return ByteBuffer.allocateDirect(bufferSize);
    }

    @Override
    public final void write(int b) throws IOException {
        long addrPos;
        if ((addrPos = this.addrPosition++) < this.addrLimit) {
            unsafe.putByte(addrPos, (byte)(b & 0xFF));
        } else {
            this.flushBufferBlocking(this.buffer);
            unsafe.putByte(this.addrPosition++, (byte)(b & 0xFF));
        }
    }

    protected final void write_(byte[] b, int off, int len) throws IOException {
        if (len == 1) {
            long addrPos;
            if ((addrPos = this.addrPosition++) < this.addrLimit) {
                unsafe.putByte(addrPos, b[off]);
            } else {
                this.flushBufferBlocking(this.buffer);
                unsafe.putByte(this.addrPosition++, b[off]);
            }
            return;
        }
        while (len > 0) {
            long addrPos = this.addrPosition;
            int remaining = (int)(this.addrLimit - addrPos);
            if (len <= remaining) {
                UnsafeHolder.bufferPut(b, addrPos, off, len, unsafe);
                this.addrPosition += (long)len;
                return;
            }
            if (remaining > 0) {
                UnsafeHolder.bufferPut(b, addrPos, off, remaining, unsafe);
                this.addrPosition += (long)remaining;
                len -= remaining;
                off += remaining;
            }
            this.flushBufferBlocking(this.buffer);
        }
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.write_(b, 0, b.length);
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        if (!UnsafeHolder.checkBounds(off, len, b.length)) {
            throw new IndexOutOfBoundsException("offset=" + off + " length=" + len + " size=" + b.length);
        }
        this.write_(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int write(ByteBuffer src) throws IOException {
        this.buffer.position((int)(this.addrPosition - this.baseAddress));
        try {
            int n = super.writeBuffered(src, this.buffer);
            return n;
        }
        finally {
            this.resetBufferPositions();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.addrPosition > this.baseAddress) {
            this.flushBufferBlocking(this.buffer);
        }
    }

    @Override
    public final boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.flushBufferBlocking(this.buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushBufferBlocking(ByteBuffer buffer) throws IOException {
        buffer.position((int)(this.addrPosition - this.baseAddress));
        buffer.flip();
        try {
            do {
                this.writeBuffer(buffer);
            } while (buffer.hasRemaining());
        }
        finally {
            if (buffer.hasRemaining()) {
                buffer.compact();
            } else {
                buffer.clear();
            }
            this.resetBufferPositions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean flushBufferNonBlocking(ByteBuffer buffer, boolean isChannelBuffer) throws IOException {
        if (isChannelBuffer) {
            try {
                boolean bl = super.flushBufferNonBlocking(buffer, true);
                return bl;
            }
            finally {
                this.resetBufferPositions();
            }
        }
        return super.flushBufferNonBlocking(buffer, false);
    }
}

