/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared.unsafe;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.InputStreamChannel;
import com.gemstone.gemfire.internal.shared.unsafe.UnsafeHolder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import sun.misc.Unsafe;

public class ChannelBufferUnsafeInputStream
extends InputStreamChannel {
    protected final ByteBuffer buffer;
    protected final long baseAddress;
    protected long addrPosition;
    protected long addrLimit;
    protected static final Unsafe unsafe = UnsafeHolder.getUnsafe();

    public ChannelBufferUnsafeInputStream(ReadableByteChannel channel) throws IOException {
        this(channel, 32768);
    }

    public ChannelBufferUnsafeInputStream(ReadableByteChannel channel, int bufferSize) throws IOException {
        super(channel);
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("invalid bufferSize=" + bufferSize);
        }
        this.buffer = this.allocateBuffer(bufferSize);
        this.buffer.flip();
        try {
            this.baseAddress = (Long)UnsafeHolder.getDirectByteBufferAddressMethod().invoke((Object)this.buffer, new Object[0]);
            this.resetBufferPositions();
        }
        catch (Exception e) {
            throw ClientSharedUtils.newRuntimeException("failed in creating an 'unsafe' buffered channel stream", e);
        }
    }

    protected final void resetBufferPositions() {
        this.addrPosition = this.baseAddress + (long)this.buffer.position();
        this.addrLimit = this.baseAddress + (long)this.buffer.limit();
    }

    protected ByteBuffer allocateBuffer(int bufferSize) {
        return ByteBuffer.allocateDirect(bufferSize);
    }

    @Override
    public final int read() throws IOException {
        long addrPos;
        if ((addrPos = this.addrPosition++) < this.addrLimit) {
            return unsafe.getByte(addrPos) & 0xFF;
        }
        if (this.refillBuffer(this.buffer, 1, null) > 0) {
            return unsafe.getByte(this.addrPosition++) & 0xFF;
        }
        return -1;
    }

    private final int read_(byte[] buf, int off, int len) throws IOException {
        int bufBytes;
        if (len == 1) {
            long addrPos;
            if ((addrPos = this.addrPosition++) < this.addrLimit) {
                buf[off] = unsafe.getByte(addrPos);
                return 1;
            }
            if (this.refillBuffer(this.buffer, 1, null) > 0) {
                buf[off] = unsafe.getByte(this.addrPosition++);
                return 1;
            }
            return -1;
        }
        int remaining = (int)(this.addrLimit - this.addrPosition);
        if (len <= remaining) {
            if (len > 0) {
                UnsafeHolder.bufferGet(buf, this.addrPosition, off, len, unsafe);
                this.addrPosition += (long)len;
                return len;
            }
            return 0;
        }
        int readBytes = 0;
        if (remaining > 0) {
            UnsafeHolder.bufferGet(buf, this.addrPosition, off, remaining, unsafe);
            this.addrPosition += (long)remaining;
            off += remaining;
            len -= remaining;
            readBytes += remaining;
        }
        if ((bufBytes = this.refillBuffer(this.buffer, 1, null)) > 0) {
            if (len > bufBytes) {
                len = bufBytes;
            }
            UnsafeHolder.bufferGet(buf, this.addrPosition, off, len, unsafe);
            this.addrPosition += (long)len;
            return readBytes + len;
        }
        return readBytes > 0 ? readBytes : bufBytes;
    }

    @Override
    public final int read(byte[] buf) throws IOException {
        return this.read_(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int read(ByteBuffer dst) throws IOException {
        this.buffer.position((int)(this.addrPosition - this.baseAddress));
        try {
            int n = super.readBuffered(dst, this.buffer);
            return n;
        }
        finally {
            this.resetBufferPositions();
        }
    }

    @Override
    public final int read(byte[] buf, int off, int len) throws IOException {
        if (UnsafeHolder.checkBounds(off, len, buf.length)) {
            return this.read_(buf, off, len);
        }
        throw new IndexOutOfBoundsException("offset=" + off + " length=" + len + " size=" + buf.length);
    }

    @Override
    public final int readInt() throws IOException {
        long addrPos = this.addrPosition;
        if (this.addrLimit - addrPos >= 4L) {
            return this.getInt(addrPos);
        }
        this.refillBuffer(this.buffer, 4, "readInt: premature end of stream");
        return this.getInt(this.addrPosition);
    }

    protected final int getInt(long addrPos) {
        Unsafe unsafe = ChannelBufferUnsafeInputStream.unsafe;
        int result = unsafe.getByte(addrPos++) & 0xFF;
        result = result << 8 | unsafe.getByte(addrPos++) & 0xFF;
        result = result << 8 | unsafe.getByte(addrPos++) & 0xFF;
        result = result << 8 | unsafe.getByte(addrPos++) & 0xFF;
        this.addrPosition = addrPos;
        return result;
    }

    @Override
    public final int available() throws IOException {
        return (int)(this.addrLimit - this.addrPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int refillBuffer(ByteBuffer channelBuffer, int tryReadBytes, String eofMessage) throws IOException {
        channelBuffer.position((int)(this.addrPosition - this.baseAddress));
        try {
            int n = super.refillBuffer(channelBuffer, tryReadBytes, eofMessage);
            return n;
        }
        finally {
            this.resetBufferPositions();
        }
    }

    @Override
    public final boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.buffer.clear();
        this.resetBufferPositions();
    }
}

