/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared.unsafe;

import com.gemstone.gemfire.internal.shared.unsafe.ChannelBufferUnsafeDataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public final class ChannelBufferUnsafeFramedOutputStream
extends ChannelBufferUnsafeDataOutputStream {
    protected boolean doWriteFrameSize;

    public ChannelBufferUnsafeFramedOutputStream(WritableByteChannel channel) throws IOException {
        super(channel);
        this.addrPosition += 4L;
        this.doWriteFrameSize = true;
    }

    public ChannelBufferUnsafeFramedOutputStream(WritableByteChannel channel, int bufferSize) throws IOException {
        super(channel, bufferSize);
        this.addrPosition += 4L;
        this.doWriteFrameSize = true;
    }

    @Override
    public void flush() throws IOException {
        if (this.doWriteFrameSize) {
            long baseAddr = this.baseAddress;
            ChannelBufferUnsafeFramedOutputStream.putInt(baseAddr, (int)(this.addrPosition - baseAddr - 4L));
            super.flushBufferBlocking(this.buffer);
        } else {
            if (this.addrPosition > this.baseAddress) {
                super.flushBufferBlocking(this.buffer);
            }
            this.doWriteFrameSize = true;
        }
        this.addrPosition += 4L;
    }

    @Override
    protected void flushBufferBlocking(ByteBuffer buffer) throws IOException {
        if (this.doWriteFrameSize) {
            long baseAddr = this.baseAddress;
            ChannelBufferUnsafeFramedOutputStream.putInt(baseAddr, (int)(this.addrPosition - baseAddr - 4L));
            this.doWriteFrameSize = false;
        }
        super.flushBufferBlocking(buffer);
    }
}

