/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared.unsafe;

import com.gemstone.gemfire.internal.shared.unsafe.ChannelBufferUnsafeOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.channels.WritableByteChannel;
import sun.misc.Unsafe;

public class ChannelBufferUnsafeDataOutputStream
extends ChannelBufferUnsafeOutputStream
implements DataOutput {
    public ChannelBufferUnsafeDataOutputStream(WritableByteChannel channel) throws IOException {
        super(channel);
    }

    public ChannelBufferUnsafeDataOutputStream(WritableByteChannel channel, int bufferSize) throws IOException {
        super(channel, bufferSize);
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        super.write(v ? 1 : 0);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        super.write(v);
    }

    @Override
    public final void writeShort(int v) throws IOException {
        long addrPos = this.addrPosition;
        if (this.addrLimit - addrPos >= 2L) {
            this.addrPosition = ChannelBufferUnsafeDataOutputStream.putShort(addrPos, v);
        } else {
            this.flushBufferBlocking(this.buffer);
            this.addrPosition = ChannelBufferUnsafeDataOutputStream.putShort(this.addrPosition, v);
        }
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.writeShort(v);
    }

    @Override
    public final void writeInt(int v) throws IOException {
        long addrPos = this.addrPosition;
        if (this.addrLimit - addrPos >= 4L) {
            this.addrPosition = ChannelBufferUnsafeDataOutputStream.putInt(addrPos, v);
        } else {
            this.flushBufferBlocking(this.buffer);
            this.addrPosition = ChannelBufferUnsafeDataOutputStream.putInt(this.addrPosition, v);
        }
    }

    @Override
    public final void writeLong(long v) throws IOException {
        long addrPos = this.addrPosition;
        if (this.addrLimit - addrPos >= 8L) {
            this.addrPosition += 8L;
            this.buffer.putLong((int)(addrPos - this.baseAddress), v);
        } else {
            this.flushBufferBlocking(this.buffer);
            addrPos = this.addrPosition;
            this.addrPosition += 8L;
            this.buffer.putLong((int)(addrPos - this.baseAddress), v);
        }
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public final void writeBytes(String s) throws IOException {
        int remaining;
        Unsafe unsafe = ChannelBufferUnsafeOutputStream.unsafe;
        int off = 0;
        for (int len = s.length(); len > 0; len -= remaining) {
            int end;
            long addrPos = this.addrPosition;
            remaining = (int)(this.addrLimit - addrPos);
            if (len <= remaining) {
                end = off + len;
                while (off < end) {
                    unsafe.putByte(addrPos, (byte)(s.charAt(off) & 0xFF));
                    ++addrPos;
                    ++off;
                }
                this.addrPosition = addrPos;
                return;
            }
            end = off + remaining;
            while (off < end) {
                unsafe.putByte(addrPos, (byte)(s.charAt(off) & 0xFF));
                ++addrPos;
                ++off;
            }
            this.addrPosition = addrPos;
            this.flushBufferBlocking(this.buffer);
        }
    }

    @Override
    public final void writeChars(String s) throws IOException {
        int remchars;
        Unsafe unsafe = ChannelBufferUnsafeOutputStream.unsafe;
        int off = 0;
        for (int len = s.length(); len > 0; len -= remchars) {
            long addrPos = this.addrPosition;
            int remaining = (int)(this.addrLimit - addrPos);
            if (len << 1 <= remaining) {
                int end = off + len;
                while (off < end) {
                    char c = s.charAt(off++);
                    unsafe.putByte(addrPos++, (byte)(c >>> 8 & 0xFF));
                    unsafe.putByte(addrPos++, (byte)(c & 0xFF));
                }
                this.addrPosition = addrPos;
                return;
            }
            remchars = remaining >>> 1;
            int end = off + remchars;
            while (off < end) {
                char c = s.charAt(off++);
                unsafe.putByte(addrPos++, (byte)(c >>> 8 & 0xFF));
                unsafe.putByte(addrPos++, (byte)(c & 0xFF));
            }
            this.addrPosition = addrPos;
            this.flushBufferBlocking(this.buffer);
        }
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        Unsafe unsafe = ChannelBufferUnsafeOutputStream.unsafe;
        int strlen = str.length();
        if (strlen > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + strlen);
        }
        long addrPos = this.addrPosition;
        long remaining = this.addrLimit - addrPos;
        if (remaining >= (long)(strlen * 3 + 2)) {
            long utflen;
            long finalAddrPos = ChannelBufferUnsafeDataOutputStream.writeUTFSegmentNoOverflow(str, 0, strlen, addrPos += 2L, unsafe);
            if ((utflen = finalAddrPos - addrPos) <= 65535L) {
                addrPos -= 2L;
            } else {
                throw new UTFDataFormatException("encoded string too long: " + utflen + " bytes");
            }
            unsafe.putByte(addrPos++, (byte)(utflen >>> 8 & 0xFFL));
            unsafe.putByte(addrPos++, (byte)(utflen & 0xFFL));
            this.addrPosition = finalAddrPos;
            return;
        }
        int utflen = 0;
        for (int index = 0; index < strlen; ++index) {
            char c = str.charAt(index);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + utflen + " bytes");
        }
        if (remaining > 2L) {
            addrPos = ChannelBufferUnsafeDataOutputStream.putShort(addrPos, utflen);
            remaining -= 2L;
        } else {
            this.flushBufferBlocking(this.buffer);
            addrPos = ChannelBufferUnsafeDataOutputStream.putShort(this.addrPosition, utflen);
            remaining = this.addrLimit - addrPos;
        }
        int offset = 0;
        while (strlen > 0) {
            int writeLen = (int)(remaining / 3L);
            if (writeLen >= 3) {
                long newAddrPos = ChannelBufferUnsafeDataOutputStream.writeUTFSegmentNoOverflow(str, offset, writeLen, addrPos, unsafe);
                strlen -= writeLen;
                offset += writeLen;
                remaining -= newAddrPos - addrPos;
                addrPos = newAddrPos;
                continue;
            }
            this.addrPosition = addrPos;
            this.flushBufferBlocking(this.buffer);
            addrPos = this.addrPosition;
            remaining = this.addrLimit - addrPos;
        }
    }

    private static final long writeUTFSegmentNoOverflow(String str, int offset, int length, long addrPos, Unsafe unsafe) throws IOException {
        int end = offset + length;
        while (offset < end) {
            char c = str.charAt(offset);
            if (c >= '\u0001' && c <= '\u007f') {
                unsafe.putByte(addrPos++, (byte)c);
            } else if (c > '\u07ff') {
                unsafe.putByte(addrPos++, (byte)(0xE0 | c >> 12 & 0xF));
                unsafe.putByte(addrPos++, (byte)(0x80 | c >> 6 & 0x3F));
                unsafe.putByte(addrPos++, (byte)(0x80 | c >> 0 & 0x3F));
            } else {
                unsafe.putByte(addrPos++, (byte)(0xC0 | c >> 6 & 0x1F));
                unsafe.putByte(addrPos++, (byte)(0x80 | c >> 0 & 0x3F));
            }
            ++offset;
        }
        return addrPos;
    }

    protected static final long putShort(long addrPos, int v) {
        Unsafe unsafe = ChannelBufferUnsafeOutputStream.unsafe;
        unsafe.putByte(addrPos++, (byte)(v >>> 8 & 0xFF));
        unsafe.putByte(addrPos++, (byte)(v & 0xFF));
        return addrPos;
    }

    protected static final long putInt(long addrPos, int v) {
        Unsafe unsafe = ChannelBufferUnsafeOutputStream.unsafe;
        unsafe.putByte(addrPos++, (byte)(v >>> 24 & 0xFF));
        unsafe.putByte(addrPos++, (byte)(v >>> 16 & 0xFF));
        unsafe.putByte(addrPos++, (byte)(v >>> 8 & 0xFF));
        unsafe.putByte(addrPos++, (byte)(v & 0xFF));
        return addrPos;
    }
}

