/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.locks.LockSupport;

public abstract class OutputStreamChannel
extends OutputStream
implements WritableByteChannel,
Closeable {
    protected final WritableByteChannel channel;
    protected volatile Thread parkedThread;
    protected static final long PARK_NANOS = 200L;
    protected static final long PARK_NANOS_MAX = 15000000000L;

    protected OutputStreamChannel(WritableByteChannel channel) {
        this.channel = channel;
    }

    public final WritableByteChannel getUnderlyingChannel() {
        return this.channel;
    }

    @Override
    public abstract int write(ByteBuffer var1) throws IOException;

    protected final int writeBuffered(ByteBuffer src, ByteBuffer channelBuffer) throws IOException {
        int srcLen = src.remaining();
        int numWritten = 0;
        do {
            int remaining;
            if (srcLen <= (remaining = channelBuffer.remaining())) {
                channelBuffer.put(src);
                return numWritten + srcLen;
            }
            if (remaining > 0) {
                int srcPos = src.position();
                src.limit(srcPos + remaining);
                channelBuffer.put(src);
                src.limit(srcPos + srcLen);
                numWritten += remaining;
                assert ((srcLen -= remaining) == src.remaining()) : "srcLen=" + srcLen + " srcRemaining=" + src.remaining();
            }
            if (this.flushBufferNonBlocking(channelBuffer, true)) continue;
            return numWritten;
        } while (srcLen <= channelBuffer.limit() || !src.isDirect());
        return numWritten + this.writeBufferNonBlocking(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean flushBufferNonBlocking(ByteBuffer buffer, boolean isChannelBuffer) throws IOException {
        boolean flushed;
        buffer.flip();
        try {
            this.writeBufferNonBlocking(buffer);
        }
        finally {
            if (buffer.hasRemaining()) {
                buffer.compact();
                flushed = false;
            } else {
                buffer.clear();
                flushed = true;
            }
        }
        return flushed;
    }

    protected int writeBuffer(ByteBuffer buffer) throws IOException {
        int writtenBytes;
        long parkNanos = 0L;
        while ((writtenBytes = this.channel.write(buffer)) == 0 && buffer.hasRemaining()) {
            this.parkedThread = Thread.currentThread();
            LockSupport.parkNanos(200L);
            this.parkedThread = null;
            if ((parkNanos += 200L) <= 15000000000L) continue;
            throw new SocketTimeoutException("Connection write timed out.");
        }
        return writtenBytes;
    }

    protected int writeBufferNonBlocking(ByteBuffer buffer) throws IOException {
        return this.channel.write(buffer);
    }

    public final Thread getParkedThread() {
        return this.parkedThread;
    }
}

