/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.JdkHelper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.concurrent.ConcurrentHashMap;

public class Jdk5Helper
implements JdkHelper {
    private static final Constructor<?> stringInternalConstructor;
    private static final int stringInternalConsVersion;
    private static final int STRING_CONS_VER1 = 1;
    private static final int STRING_CONS_VER2 = 2;
    private static final int STRING_CONS_VER3 = 3;

    @Override
    public final ConcurrentHashMap<?, ?> newConcurrentMap(int initialCapacity, int concurrencyLevel) {
        return new ConcurrentHashMap(initialCapacity, 0.75f, concurrencyLevel);
    }

    @Override
    public final long getThreadId(Thread currentThread) {
        return currentThread.getId();
    }

    @Override
    public final Byte newByte(byte value) {
        return value;
    }

    @Override
    public final Short newShort(short value) {
        return value;
    }

    @Override
    public final Integer newInteger(int value) {
        return value;
    }

    @Override
    public final Long newLong(long value) {
        return value;
    }

    @Override
    public final Character newCharacter(char value) {
        return Character.valueOf(value);
    }

    @Override
    public String readChars(InputStream in, boolean noecho) {
        StringBuilder sb = new StringBuilder();
        try {
            char c;
            int value = in.read();
            if (value != -1 && (c = (char)value) != '\n' && c != '\r') {
                sb.append(c);
            }
            while (in.available() > 0 && (value = in.read()) != -1 && (c = (char)value) != '\n' && c != '\r') {
                sb.append(c);
            }
        }
        catch (IOException ioe) {
            throw ClientSharedUtils.newRuntimeException(ioe.getMessage(), ioe);
        }
        return sb.toString();
    }

    @Override
    public String newWrappedString(char[] chars, int offset, int size) {
        if (size >= 0) {
            try {
                switch (stringInternalConsVersion) {
                    case 1: {
                        return (String)stringInternalConstructor.newInstance(offset, size, chars);
                    }
                    case 2: {
                        if (offset == 0 && size == chars.length) {
                            return (String)stringInternalConstructor.newInstance(chars, true);
                        }
                        return new String(chars, offset, size);
                    }
                    case 3: {
                        return (String)stringInternalConstructor.newInstance(chars, offset, size, true);
                    }
                }
                return new String(chars, offset, size);
            }
            catch (Exception ex) {
                throw ClientSharedUtils.newRuntimeException("unexpected exception", ex);
            }
        }
        throw new AssertionError((Object)("unexpected size=" + size));
    }

    @Override
    public boolean isInterfaceUp(NetworkInterface iface) throws SocketException {
        return true;
    }

    static {
        Constructor constructor = null;
        int version = 0;
        try {
            constructor = String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);
            constructor.setAccessible(true);
            version = 2;
        }
        catch (Exception e1) {
            try {
                constructor = String.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, char[].class);
                constructor.setAccessible(true);
                version = 1;
            }
            catch (Exception e2) {
                try {
                    constructor = String.class.getDeclaredConstructor(char[].class, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                    constructor.setAccessible(true);
                    version = 3;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        stringInternalConstructor = constructor;
        stringInternalConsVersion = version;
    }
}

