/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import java.io.Serializable;
import java.net.UnknownHostException;

public abstract class HostLocationBase<T extends HostLocationBase<T>>
implements Comparable<T>,
Serializable {
    private static final long serialVersionUID = 299867375891198580L;
    protected String hostName;
    protected int port;

    protected HostLocationBase() {
    }

    public HostLocationBase(String hostName, int port) {
        this.hostName = hostName;
        this.port = port;
    }

    public final String getHostName() {
        return this.hostName;
    }

    public final int getPort() {
        return this.port;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.port;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HostLocationBase) {
            return this.equals((HostLocationBase)obj);
        }
        return false;
    }

    public boolean equals(HostLocationBase<?> other) {
        if (this == other) {
            return true;
        }
        if (other != null) {
            if (this.port != other.port) {
                return false;
            }
            return this.equalsHostName(other);
        }
        return false;
    }

    protected final boolean equalsHostName(HostLocationBase<?> other) {
        if (this.hostName == null) {
            if (other.hostName != null) {
                return false;
            }
        } else {
            if (other.hostName == null) {
                return false;
            }
            if (!HostLocationBase.hostNamesEqual(this.hostName, other.hostName)) {
                String canonicalHostName;
                try {
                    canonicalHostName = ClientSharedUtils.getLocalHost().getCanonicalHostName();
                }
                catch (UnknownHostException e) {
                    throw new IllegalStateException("getLocalHost failed with " + e);
                }
                if ("localhost".equals(this.hostName)) {
                    if (!canonicalHostName.equals(other.hostName)) {
                        return false;
                    }
                } else if ("localhost".equals(other.hostName)) {
                    if (!canonicalHostName.equals(this.hostName)) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean hostNamesEqual(String hostName1, String hostName2) {
        int addrStart = hostName1.indexOf(47);
        if (addrStart == -1) {
            addrStart = hostName2.indexOf(47);
            if (addrStart != -1) {
                hostName2 = hostName2.substring(0, addrStart);
            }
        } else if (hostName2.indexOf(47) == -1) {
            hostName1 = hostName1.substring(0, addrStart);
        }
        return hostName1.equals(hostName2);
    }

    @Override
    public int compareTo(T other) {
        int difference = this.hostName.compareTo(((HostLocationBase)other).hostName);
        if (difference != 0) {
            return difference;
        }
        return this.port - ((HostLocationBase)other).getPort();
    }

    public String toString() {
        return this.hostName + '[' + this.port + ']';
    }
}

