/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

public abstract class ClientResolverUtils {
    protected static final int[] sbox = new int[]{-180479945, 1595197547, -1629252020, -92705453, 841105347, 1300413592, -1597506974, 1675807106, 614025819, 516848622, 690698479, -707965354, 1364148995, 2078354307, 1905455509, -2099481856, 138641588, 1208702419, 1598227569, 334977425, 1067250220, 803246202, -41017751, 2065522152, -713709476, -1392392950, 2128611127, 1021936104, 239369978, 587767254, -1247865697, 325062343, -402470682, 1728651748, 1913122800, -414752336, 1761825332, -1079767271, -164212320, 702958630, 530107559, -648609666, -417473419, 1047696789, 1971369932, -671418869, -1840757981, -1539238933, -456401400, 879241161, 1022569210, 187284721, 1848244191, -1340182069, 1006354641, 1659749816, -1210156902, -1535865143, -512078769, 1743109379, -206357222, -1747397655, 152181696, 880487724, 2040631612, 1346466526, 2132771971, 330054902, 2048955611, -948372974, -1376303457, 561539963, 1906591184, -1467388901, 1701798651, -2086643277, -1758593426, 1092747276, -1747330535, 399873147, -1313866484, 1861761943, -1350600693, 1175655306, 2084467622, -820649923, 1096246050, 1731064466, -1235724147, 871100329, -1819492602, 112620417, 133272262, 735729749, 881778920, 433829603, 841095243, -1231200838, 2121665416, -1353875116, 8016301, 890316032, -909300355, 1330624353, 1766290147, 1766622033, 1249786613, 1742101729, -1836589422, 622385980, -1934300154, -782969969, -509991237, 694084665, -989196028, 559138471, -2110364074, 118733871, 1684152666, 567918542, -1165054746, -1372719935, 713907840, 1065243345, 691377049, -22949476, 411538195, 1163590273, -85989320, 1650497592, -788363207, 121039151, 1003102883, 344305802, 765956107, -2060708499, -386775037, 492658, 334549810, 718262479, 1601470300, -2017780177, -1477457053, 603206384, -422675364, 529878774, -1240872677, 994406847, -288260672, -447296096, -1484494195, -15704172, 1387777246, 238282753, 1715754474, -221838316, 1944564870, -1887238559, -1957042138, -1148523062, -204010823, -684068167, 1241826122, -1999572855, -534670942, -660759432, 422324041, -62675057, 179079371, -1808214995, -1641541766, 906377218, 954781720, 474130891, -1834287252, -1572331323, 0x7F077F, -832846525, 1768328536, 282525556, -1107233247, 556796862, 782143302, 1523492393, -98597177, 1391593144, 1054808693, 1839781955, -814638808, 1944291615, -1262920234, -1297863385, -308147265, 442031071, -1538675453, 1843327531, -1878707738, 1027342133, 1529129890, 1194016332, 947858805, 1301133878, 1909151297, -481870017, -154317953, -1082321880, 877356240, -976356170, -30539390, 741844595, -565266525, 1677576499, 31211619, 1629435249, -781729873, 1150703983, 1039009417, -663729904, 1884463380, 109878981, 1976624998, 1297402912, -1269903902, 1253860670, 743770657, 441630939, -806550576, 295415778, -2023071437, -1138548600, 1130078642, -1365656582, -1152448284, -1507106999, 497333909, 862684382, -595509967, 12662011, 964335846, 354356836, -638894487, -741875872, -755842250, 769459835, -1122883531, -1330397894, -1328198074, -2042498588, -1598845034, 1372819865, 933670261, -544936383, 1006849210, -1394973956, 294796171, 1173296906};

    protected ClientResolverUtils() {
    }

    public static final int addBytesToHash(byte[] bytes, int hash) {
        return ClientResolverUtils.addBytesToHash(bytes, 0, bytes.length, hash);
    }

    public static final int addBytesToHash(byte[] bytes, int offset, int length, int hash) {
        int endPos = offset + length;
        while (offset < endPos) {
            hash ^= sbox[bytes[offset] & 0xFF];
            hash *= 3;
            ++offset;
        }
        return hash;
    }

    public static final int addStringToHash(String s, int offset, int length, int hash) {
        int endPos = offset + length;
        while (offset < endPos) {
            char c = s.charAt(offset);
            int b1 = c & 0xFF;
            int b2 = c >>> 8 & 0xFF;
            hash ^= sbox[b1];
            hash *= 3;
            hash ^= sbox[b2];
            hash *= 3;
            ++offset;
        }
        return hash;
    }

    public static final int addCharsToHash(char[] chars, int offset, int length, int hash) {
        int endPos = offset + length;
        while (offset < endPos) {
            char c = chars[offset];
            int b1 = c & 0xFF;
            int b2 = c >>> 8 & 0xFF;
            hash ^= sbox[b1];
            hash *= 3;
            hash ^= sbox[b2];
            hash *= 3;
            ++offset;
        }
        return hash;
    }

    public static final int addByteToHash(byte b, int hash) {
        hash ^= sbox[b & 0xFF];
        return hash *= 3;
    }

    public static final int addIntToHash(int val, int hash) {
        hash = ClientResolverUtils.addByteToHash((byte)(val >>> 24), hash);
        hash = ClientResolverUtils.addByteToHash((byte)(val >>> 16), hash);
        hash = ClientResolverUtils.addByteToHash((byte)(val >>> 8), hash);
        return ClientResolverUtils.addByteToHash((byte)val, hash);
    }

    public static final int addLongToHash(long val, int hash) {
        hash = ClientResolverUtils.addByteToHash((byte)(val >>> 56), hash);
        hash = ClientResolverUtils.addByteToHash((byte)(val >>> 48), hash);
        hash = ClientResolverUtils.addByteToHash((byte)(val >>> 40), hash);
        hash = ClientResolverUtils.addByteToHash((byte)(val >>> 32), hash);
        hash = ClientResolverUtils.addByteToHash((byte)(val >>> 24), hash);
        hash = ClientResolverUtils.addByteToHash((byte)(val >>> 16), hash);
        hash = ClientResolverUtils.addByteToHash((byte)(val >>> 8), hash);
        return ClientResolverUtils.addByteToHash((byte)val, hash);
    }
}

