/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared;

import com.gemstone.gemfire.internal.shared.InputStreamChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class ChannelBufferInputStream
extends InputStreamChannel {
    protected final ByteBuffer buffer;
    public static final int DEFAULT_BUFFER_SIZE = 32768;

    public ChannelBufferInputStream(ReadableByteChannel channel) throws IOException {
        this(channel, 32768);
    }

    public ChannelBufferInputStream(ReadableByteChannel channel, int bufferSize) throws IOException {
        super(channel);
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("invalid bufferSize=" + bufferSize);
        }
        this.buffer = this.allocateBuffer(bufferSize);
        this.buffer.flip();
    }

    protected ByteBuffer allocateBuffer(int bufferSize) {
        return ByteBuffer.allocateDirect(bufferSize);
    }

    @Override
    public final int read() throws IOException {
        if (this.buffer.hasRemaining()) {
            return this.buffer.get() & 0xFF;
        }
        if (this.refillBuffer(this.buffer, 1, null) > 0) {
            return this.buffer.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public final int read(byte[] buf, int off, int len) throws IOException {
        int bufBytes;
        if (len == 1) {
            if (this.buffer.hasRemaining()) {
                buf[off] = this.buffer.get();
                return 1;
            }
            if (this.refillBuffer(this.buffer, 1, null) > 0) {
                buf[off] = this.buffer.get();
                return 1;
            }
            return -1;
        }
        int remaining = this.buffer.remaining();
        if (len <= remaining) {
            if (len > 0) {
                this.buffer.get(buf, off, len);
                return len;
            }
            return 0;
        }
        int readBytes = 0;
        if (remaining > 0) {
            this.buffer.get(buf, off, remaining);
            off += remaining;
            len -= remaining;
            readBytes += remaining;
        }
        if ((bufBytes = this.refillBuffer(this.buffer, 1, null)) > 0) {
            if (len > bufBytes) {
                len = bufBytes;
            }
            this.buffer.get(buf, off, len);
            return readBytes + len;
        }
        return readBytes > 0 ? readBytes : bufBytes;
    }

    @Override
    public final int read(ByteBuffer dst) throws IOException {
        return super.readBuffered(dst, this.buffer);
    }

    @Override
    public final int readInt() throws IOException {
        ByteBuffer buffer = this.buffer;
        if (buffer.remaining() >= 4) {
            return buffer.getInt();
        }
        this.refillBuffer(buffer, 4, "readInt: premature end of stream");
        return buffer.getInt();
    }

    @Override
    public final int available() throws IOException {
        return this.buffer.remaining();
    }

    @Override
    public final boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.buffer.clear();
    }
}

