/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.log4j;

import com.gemstone.gemfire.internal.shared.unsafe.UnsafeHolder;
import java.lang.reflect.Field;
import org.apache.log4j.spi.LoggingEvent;
import sun.misc.Unsafe;

public class PatternLayout
extends org.apache.log4j.PatternLayout {
    private static final long threadNameOffset;

    public PatternLayout() {
    }

    public PatternLayout(String pattern) {
        super(pattern);
    }

    public String format(LoggingEvent event) {
        return super.format(PatternLayout.addThreadIdToEvent(event));
    }

    static LoggingEvent addThreadIdToEvent(LoggingEvent event) {
        Unsafe unsafe = UnsafeHolder.getUnsafe();
        String currentName = (String)unsafe.getObject(event, threadNameOffset);
        if (currentName == null || currentName.charAt(currentName.length() - 1) != '>' || !currentName.contains("<tid=0x")) {
            Thread currentThread = Thread.currentThread();
            String threadNameAndId = currentThread.getName() + "<tid=0x" + Long.toHexString(currentThread.getId()) + '>';
            unsafe.putObject(event, threadNameOffset, threadNameAndId);
        }
        return event;
    }

    static {
        try {
            Field f = LoggingEvent.class.getDeclaredField("threadName");
            f.setAccessible(true);
            threadNameOffset = UnsafeHolder.getUnsafe().objectFieldOffset(f);
        }
        catch (NoSuchFieldException nse) {
            throw new ExceptionInInitializerError(nse);
        }
    }
}

