/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared.unsafe;

import com.gemstone.gemfire.internal.shared.ChannelBufferFramedInputStream;
import com.gemstone.gemfire.internal.shared.ChannelBufferFramedOutputStream;
import com.gemstone.gemfire.internal.shared.ChannelBufferInputStream;
import com.gemstone.gemfire.internal.shared.ChannelBufferOutputStream;
import com.gemstone.gemfire.internal.shared.InputStreamChannel;
import com.gemstone.gemfire.internal.shared.OutputStreamChannel;
import com.gemstone.gemfire.internal.shared.unsafe.ChannelBufferUnsafeFramedInputStream;
import com.gemstone.gemfire.internal.shared.unsafe.ChannelBufferUnsafeFramedOutputStream;
import com.gemstone.gemfire.internal.shared.unsafe.ChannelBufferUnsafeInputStream;
import com.gemstone.gemfire.internal.shared.unsafe.ChannelBufferUnsafeOutputStream;
import com.gemstone.gemfire.internal.shared.unsafe.FreeMemory;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiConsumer;
import org.apache.spark.unsafe.Platform;
import sun.misc.Cleaner;
import sun.misc.SharedSecrets;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public abstract class UnsafeHolder {
    private static final boolean hasUnsafe;
    public static final boolean littleEndian;

    private UnsafeHolder() {
    }

    public static boolean hasUnsafe() {
        return hasUnsafe;
    }

    public static int getAllocationSize(int size) {
        if ((size = size + 7 >>> 3 << 3) > 0) {
            return size;
        }
        throw new BufferOverflowException();
    }

    public static ByteBuffer allocateDirectBuffer(int size, FreeMemory.Factory factory) {
        int allocSize = UnsafeHolder.getAllocationSize(size);
        ByteBuffer buffer = UnsafeHolder.allocateDirectBuffer(UnsafeHolder.getUnsafe().allocateMemory(allocSize), allocSize, factory);
        buffer.limit(size);
        return buffer;
    }

    public static ByteBuffer allocateDirectBuffer(long address, int size, FreeMemory.Factory factory) {
        try {
            ByteBuffer buffer = (ByteBuffer)Wrapper.directBufferConstructor.newInstance(address, size);
            if (factory != null) {
                Cleaner cleaner = Cleaner.create((Object)buffer, (Runnable)factory.newFreeMemory(address, size));
                Wrapper.cleanerField.set(buffer, cleaner);
            }
            return buffer;
        }
        catch (Exception e) {
            UnsafeHolder.getUnsafe().throwException(e);
            throw new IllegalStateException("unreachable");
        }
    }

    public static long getDirectBufferAddress(ByteBuffer buffer) {
        return ((DirectBuffer)((Object)buffer)).address();
    }

    public static ByteBuffer reallocateDirectBuffer(ByteBuffer buffer, int newSize, Class<?> expectedClass, FreeMemory.Factory factory) {
        DirectBuffer directBuffer = (DirectBuffer)((Object)buffer);
        long address = directBuffer.address();
        long newAddress = 0L;
        newSize = UnsafeHolder.getAllocationSize(newSize);
        Cleaner cleaner = directBuffer.cleaner();
        if (cleaner != null) {
            try {
                Object freeMemory = Wrapper.cleanerRunnableField.get(cleaner);
                if (!(expectedClass == null || freeMemory != null && expectedClass.isInstance(freeMemory))) {
                    throw new IllegalStateException("Expected class to be " + expectedClass.getName() + " in reallocate but was " + (freeMemory != null ? freeMemory.getClass().getName() : "null"));
                }
                if (freeMemory instanceof FreeMemory && ((FreeMemory)freeMemory).tryFree() != 0L) {
                    newAddress = Wrapper.unsafe.reallocateMemory(address, newSize);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (newAddress == 0L) {
            if (expectedClass != null) {
                throw new IllegalStateException("Expected class to be " + expectedClass.getName() + " in reallocate but was non-runnable");
            }
            newAddress = UnsafeHolder.getUnsafe().allocateMemory(newSize);
            Platform.copyMemory(null, (long)address, null, (long)newAddress, (long)Math.min(newSize, buffer.limit()));
        }
        if (cleaner != null) {
            cleaner.clean();
            cleaner.clear();
        }
        return UnsafeHolder.allocateDirectBuffer(newAddress, newSize, factory).order(buffer.order());
    }

    public static void changeDirectBufferCleaner(ByteBuffer buffer, int size, Class<? extends FreeMemory> from, Class<? extends FreeMemory> to, FreeMemory.Factory factory, BiConsumer<String, Object> changeOwner) throws IllegalAccessException {
        DirectBuffer directBuffer = (DirectBuffer)((Object)buffer);
        Cleaner cleaner = directBuffer.cleaner();
        if (cleaner != null) {
            Field runnableField = Wrapper.cleanerRunnableField;
            Object runnable = runnableField.get(cleaner);
            if (!to.isInstance(runnable)) {
                if (changeOwner != null) {
                    if (from.isInstance(runnable)) {
                        changeOwner.accept(((FreeMemory)runnable).objectName(), runnable);
                    } else {
                        changeOwner.accept(null, runnable);
                    }
                }
                FreeMemory newFree = factory.newFreeMemory(directBuffer.address(), size);
                runnableField.set(cleaner, newFree);
            }
        } else {
            throw new IllegalAccessException("ByteBuffer without a Cleaner cannot be marked for storage");
        }
    }

    public static void releaseDirectBuffer(ByteBuffer buffer) {
        Cleaner cleaner = ((DirectBuffer)((Object)buffer)).cleaner();
        if (cleaner != null) {
            cleaner.clean();
            cleaner.clear();
        }
        buffer.rewind().limit(0);
    }

    public static void releasePendingReferences() {
        Method handlePendingRefs = Wrapper.handlePendingRefs;
        if (handlePendingRefs != null) {
            try {
                while (((Boolean)handlePendingRefs.invoke(Wrapper.javaLangRefAccess, new Object[0])).booleanValue()) {
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Unsafe getUnsafe() {
        return Wrapper.unsafe;
    }

    public static boolean tryMonitorEnter(Object obj, boolean checkSelf) {
        if (checkSelf && Thread.holdsLock(obj)) {
            return false;
        }
        if (!UnsafeHolder.getUnsafe().tryMonitorEnter(obj)) {
            LockSupport.parkNanos(100L);
            if (!UnsafeHolder.getUnsafe().tryMonitorEnter(obj)) {
                return false;
            }
        }
        return true;
    }

    public static void monitorEnter(Object obj) {
        UnsafeHolder.getUnsafe().monitorEnter(obj);
    }

    public static void monitorExit(Object obj) {
        UnsafeHolder.getUnsafe().monitorExit(obj);
    }

    public static InputStreamChannel newChannelBufferInputStream(ReadableByteChannel channel, int bufferSize) throws IOException {
        return hasUnsafe ? new ChannelBufferUnsafeInputStream(channel, bufferSize) : new ChannelBufferInputStream(channel, bufferSize);
    }

    public static OutputStreamChannel newChannelBufferOutputStream(WritableByteChannel channel, int bufferSize) throws IOException {
        return hasUnsafe ? new ChannelBufferUnsafeOutputStream(channel, bufferSize) : new ChannelBufferOutputStream(channel, bufferSize);
    }

    public static InputStreamChannel newChannelBufferFramedInputStream(ReadableByteChannel channel, int bufferSize) throws IOException {
        return hasUnsafe ? new ChannelBufferUnsafeFramedInputStream(channel, bufferSize) : new ChannelBufferFramedInputStream(channel, bufferSize);
    }

    public static OutputStreamChannel newChannelBufferFramedOutputStream(WritableByteChannel channel, int bufferSize) throws IOException {
        return hasUnsafe ? new ChannelBufferUnsafeFramedOutputStream(channel, bufferSize) : new ChannelBufferFramedOutputStream(channel, bufferSize);
    }

    public static void checkBounds(int arrayLength, int offset, int len) {
        if ((offset | len) < 0 || offset > arrayLength || arrayLength - offset < len) {
            throw new ArrayIndexOutOfBoundsException("Array index out of range: length=" + arrayLength + " offset=" + offset + " length=" + len);
        }
    }

    static {
        boolean v;
        littleEndian = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
        try {
            Wrapper.init();
            v = true;
        }
        catch (LinkageError le) {
            le.printStackTrace();
            v = false;
        }
        hasUnsafe = v;
    }

    private static final class Wrapper {
        static final Unsafe unsafe;
        static final boolean unaligned;
        static final Constructor<?> directBufferConstructor;
        static final Field cleanerField;
        static final Field cleanerRunnableField;
        static final Object javaLangRefAccess;
        static final Method handlePendingRefs;

        private Wrapper() {
        }

        static void init() {
        }

        static {
            Object langRefAccess;
            Method m;
            Field cleaner;
            Constructor<?> dbConstructor;
            Unsafe v;
            Field runnableField = null;
            try {
                Field[] fields;
                ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                v = (Unsafe)field.get(null);
                Class<?> cls = Class.forName("java.nio.DirectByteBuffer", false, systemLoader);
                dbConstructor = cls.getDeclaredConstructor(Long.TYPE, Integer.TYPE);
                dbConstructor.setAccessible(true);
                cleaner = cls.getDeclaredField("cleaner");
                cleaner.setAccessible(true);
                Class<Runnable> runnableClass = Runnable.class;
                for (Field f : fields = Cleaner.class.getDeclaredFields()) {
                    if (!runnableClass.isAssignableFrom(f.getType()) || runnableField != null && !f.getName().contains("thunk")) continue;
                    f.setAccessible(true);
                    runnableField = f;
                }
                Class<?> bitsClass = Class.forName("java.nio.Bits", false, systemLoader);
                Method m2 = bitsClass.getDeclaredMethod("unaligned", new Class[0]);
                m2.setAccessible(true);
                unaligned = Boolean.TRUE.equals(m2.invoke(null, new Object[0]));
            }
            catch (LinkageError le) {
                throw le;
            }
            catch (Throwable t) {
                throw new ExceptionInInitializerError(t);
            }
            if (v == null) {
                throw new ExceptionInInitializerError("theUnsafe not found");
            }
            if (runnableField == null) {
                throw new ExceptionInInitializerError("DirectByteBuffer cleaner thunk runnable field not found");
            }
            unsafe = v;
            directBufferConstructor = dbConstructor;
            cleanerField = cleaner;
            cleanerRunnableField = runnableField;
            try {
                m = SharedSecrets.class.getMethod("getJavaLangRefAccess", new Class[0]);
                m.setAccessible(true);
                langRefAccess = m.invoke(null, new Object[0]);
                m = langRefAccess.getClass().getMethod("tryHandlePendingReference", new Class[0]);
                m.setAccessible(true);
                m.invoke(langRefAccess, new Object[0]);
            }
            catch (Throwable ignored) {
                langRefAccess = null;
                m = null;
            }
            javaLangRefAccess = langRefAccess;
            handlePendingRefs = m;
        }
    }
}

