/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared.unsafe;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.OutputStreamChannel;
import com.gemstone.gemfire.internal.shared.unsafe.DirectBufferAllocator;
import com.gemstone.gemfire.internal.shared.unsafe.UnsafeHolder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nonnull;
import org.apache.spark.unsafe.Platform;

public class ChannelBufferUnsafeOutputStream
extends OutputStreamChannel {
    protected ByteBuffer buffer;
    protected final long baseAddress;
    protected long addrPosition;
    protected long addrLimit;
    protected static final int MIN_BUFFER_SIZE = 32;

    public ChannelBufferUnsafeOutputStream(WritableByteChannel channel) {
        this(channel, 32768);
    }

    public ChannelBufferUnsafeOutputStream(WritableByteChannel channel, int bufferSize) {
        super(channel);
        this.baseAddress = this.allocateBuffer(bufferSize);
        this.resetBufferPositions();
    }

    public ByteBuffer getInternalBuffer() {
        this.buffer.position(this.position());
        return this.buffer;
    }

    protected final void resetBufferPositions() {
        this.addrPosition = this.baseAddress + (long)this.buffer.position();
        this.addrLimit = this.baseAddress + (long)this.buffer.limit();
    }

    protected long allocateBuffer(int bufferSize) {
        if (bufferSize < 32) {
            throw new IllegalArgumentException("ChannelBufferUnsafeDataOutputStream: buffersize=" + bufferSize + " too small (minimum " + 32 + ')');
        }
        ByteBuffer buffer = DirectBufferAllocator.instance().allocateWithFallback(bufferSize, "CHANNELOUTPUT");
        buffer.order(ByteOrder.nativeOrder());
        this.buffer = buffer;
        try {
            return UnsafeHolder.getDirectBufferAddress(buffer);
        }
        catch (Exception e) {
            this.releaseBuffer();
            throw ClientSharedUtils.newRuntimeException("failed in creating an 'unsafe' buffered channel stream", e);
        }
    }

    @Override
    public final void write(int b) throws IOException {
        this.putByte((byte)(b & 0xFF));
    }

    protected final void write_(byte[] b, int off, int len) throws IOException {
        if (len == 1) {
            this.putByte(b[off]);
            return;
        }
        while (len > 0) {
            long addrPos = this.addrPosition;
            int remaining = (int)(this.addrLimit - addrPos);
            if (len <= remaining) {
                Platform.copyMemory((Object)b, (long)(Platform.BYTE_ARRAY_OFFSET + off), null, (long)addrPos, (long)len);
                this.addrPosition += (long)len;
                return;
            }
            if (remaining > 0) {
                Platform.copyMemory((Object)b, (long)(Platform.BYTE_ARRAY_OFFSET + off), null, (long)addrPos, (long)remaining);
                this.addrPosition += (long)remaining;
                len -= remaining;
                off += remaining;
            }
            this.flushBufferBlocking(this.buffer);
        }
    }

    @Override
    public final void write(@Nonnull byte[] b) throws IOException {
        this.write_(b, 0, b.length);
    }

    protected final void putByte(byte b) throws IOException {
        if (this.addrPosition >= this.addrLimit) {
            this.flushBufferBlocking(this.buffer);
        }
        Platform.putByte(null, (long)this.addrPosition++, (byte)b);
    }

    @Override
    public final void write(@Nonnull byte[] b, int off, int len) throws IOException {
        UnsafeHolder.checkBounds(b.length, off, len);
        this.write_(b, off, len);
    }

    @Override
    public final int write(ByteBuffer src) throws IOException {
        this.buffer.position((int)(this.addrPosition - this.baseAddress));
        try {
            int n = super.writeBuffered(src, this.buffer);
            return n;
        }
        finally {
            this.resetBufferPositions();
        }
    }

    @Override
    public final void writeInt(int v) throws IOException {
        long addrPos = this.addrPosition;
        if (this.addrLimit - addrPos < 4L) {
            this.flushBufferBlocking(this.buffer);
            addrPos = this.addrPosition;
        }
        this.addrPosition = ChannelBufferUnsafeOutputStream.putInt(addrPos, v);
    }

    public final int position() {
        return (int)(this.addrPosition - this.baseAddress);
    }

    @Override
    public void flush() throws IOException {
        ByteBuffer buffer;
        if (this.addrPosition > this.baseAddress && (buffer = this.buffer) != null) {
            this.flushBufferBlocking(buffer);
        }
    }

    @Override
    public final boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.addrLimit = 0L;
        this.addrPosition = 0L;
        this.releaseBuffer();
    }

    protected final void releaseBuffer() {
        ByteBuffer buffer = this.buffer;
        if (buffer != null) {
            this.buffer = null;
            DirectBufferAllocator.instance().release(buffer);
        }
    }

    public void closeChannel() throws IOException {
        this.flush();
        this.addrLimit = 0L;
        this.addrPosition = 0L;
        this.channel.close();
        this.releaseBuffer();
    }

    protected void flushBufferBlocking(ByteBuffer buffer) throws IOException {
        buffer.position(this.position());
        buffer.flip();
        try {
            do {
                this.writeBuffer(buffer, this.channel);
            } while (buffer.hasRemaining());
        }
        finally {
            if (buffer.hasRemaining()) {
                buffer.compact();
            } else {
                buffer.clear();
            }
            this.resetBufferPositions();
        }
    }

    protected static long putInt(long addrPos, int v) {
        if (UnsafeHolder.littleEndian) {
            Platform.putInt(null, (long)addrPos, (int)Integer.reverseBytes(v));
        } else {
            Platform.putInt(null, (long)addrPos, (int)v);
        }
        return addrPos + 4L;
    }
}

