/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared.unsafe;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.InputStreamChannel;
import com.gemstone.gemfire.internal.shared.unsafe.DirectBufferAllocator;
import com.gemstone.gemfire.internal.shared.unsafe.UnsafeHolder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import javax.annotation.Nonnull;
import org.apache.spark.unsafe.Platform;

public class ChannelBufferUnsafeInputStream
extends InputStreamChannel {
    protected ByteBuffer buffer;
    protected final long baseAddress;
    protected long addrPosition;
    protected long addrLimit;

    public ChannelBufferUnsafeInputStream(ReadableByteChannel channel) {
        this(channel, 32768);
    }

    public ChannelBufferUnsafeInputStream(ReadableByteChannel channel, int bufferSize) {
        super(channel);
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("invalid bufferSize=" + bufferSize);
        }
        this.buffer = this.allocateBuffer(bufferSize);
        this.buffer.position(bufferSize);
        try {
            this.baseAddress = UnsafeHolder.getDirectBufferAddress(this.buffer);
            this.resetBufferPositions();
        }
        catch (Exception e) {
            throw ClientSharedUtils.newRuntimeException("failed in creating an 'unsafe' buffered channel stream", e);
        }
    }

    protected final void resetBufferPositions() {
        this.addrPosition = this.baseAddress + (long)this.buffer.position();
        this.addrLimit = this.baseAddress + (long)this.buffer.limit();
    }

    protected ByteBuffer allocateBuffer(int bufferSize) {
        ByteBuffer buffer = DirectBufferAllocator.instance().allocateWithFallback(bufferSize, "CHANNELINPUT");
        buffer.order(ByteOrder.nativeOrder());
        return buffer;
    }

    @Override
    public final int read() throws IOException {
        if (this.addrPosition >= this.addrLimit && this.refillBuffer(this.buffer, 1, null) <= 0) {
            return -1;
        }
        return Platform.getByte(null, (long)this.addrPosition++) & 0xFF;
    }

    private int read_(byte[] buf, int off, int len) throws IOException {
        if (len == 1) {
            int b = this.read();
            if (b != -1) {
                buf[off] = (byte)b;
                return 1;
            }
            return -1;
        }
        int remaining = (int)(this.addrLimit - this.addrPosition);
        if (len <= remaining) {
            if (len > 0) {
                Platform.copyMemory(null, (long)this.addrPosition, (Object)buf, (long)(Platform.BYTE_ARRAY_OFFSET + off), (long)len);
                this.addrPosition += (long)len;
                return len;
            }
            return 0;
        }
        if (remaining > 0) {
            Platform.copyMemory(null, (long)this.addrPosition, (Object)buf, (long)(Platform.BYTE_ARRAY_OFFSET + off), (long)remaining);
            this.addrPosition += (long)remaining;
            return remaining;
        }
        int bufBytes = this.refillBuffer(this.buffer, 1, null);
        if (bufBytes > 0) {
            if (len > bufBytes) {
                len = bufBytes;
            }
            Platform.copyMemory(null, (long)this.addrPosition, (Object)buf, (long)(Platform.BYTE_ARRAY_OFFSET + off), (long)len);
            this.addrPosition += (long)len;
            return len;
        }
        return bufBytes;
    }

    @Override
    public final int read(@Nonnull byte[] buf) throws IOException {
        return this.read_(buf, 0, buf.length);
    }

    @Override
    public final int read(@Nonnull byte[] buf, int off, int len) throws IOException {
        UnsafeHolder.checkBounds(buf.length, off, len);
        return this.read_(buf, off, len);
    }

    @Override
    public final int read(ByteBuffer dst) throws IOException {
        this.buffer.position((int)(this.addrPosition - this.baseAddress));
        try {
            int n = super.readBuffered(dst, this.buffer);
            return n;
        }
        finally {
            this.resetBufferPositions();
        }
    }

    @Override
    public final int readInt() throws IOException {
        long addrPos = this.addrPosition;
        if (this.addrLimit - addrPos < 4L) {
            this.refillBuffer(this.buffer, 4, "readInt: premature end of stream");
            addrPos = this.addrPosition;
        }
        this.addrPosition += 4L;
        if (UnsafeHolder.littleEndian) {
            return Integer.reverseBytes(Platform.getInt(null, (long)addrPos));
        }
        return Platform.getInt(null, (long)addrPos);
    }

    @Override
    public final int available() {
        return (int)(this.addrLimit - this.addrPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int refillBuffer(ByteBuffer channelBuffer, int tryReadBytes, String eofMessage) throws IOException {
        channelBuffer.position((int)(this.addrPosition - this.baseAddress));
        try {
            int n = super.refillBuffer(channelBuffer, tryReadBytes, eofMessage);
            return n;
        }
        finally {
            this.resetBufferPositions();
        }
    }

    @Override
    public final boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() {
        ByteBuffer buffer = this.buffer;
        if (buffer != null) {
            this.addrLimit = 0L;
            this.addrPosition = 0L;
            this.buffer = null;
            DirectBufferAllocator.instance().release(buffer);
        }
    }
}

