/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.shared.unsafe;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.unsafe.ChannelBufferUnsafeOutputStream;
import com.gemstone.gemfire.internal.shared.unsafe.UnsafeHolder;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import org.apache.spark.unsafe.Platform;

public class ChannelBufferUnsafeDataOutputStream
extends ChannelBufferUnsafeOutputStream
implements DataOutput {
    public ChannelBufferUnsafeDataOutputStream(WritableByteChannel channel) {
        super(channel);
    }

    public ChannelBufferUnsafeDataOutputStream(WritableByteChannel channel, int bufferSize) {
        super(channel, bufferSize);
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.putByte(v ? (byte)1 : 0);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.putByte((byte)(v & 0xFF));
    }

    @Override
    public final void writeShort(int v) throws IOException {
        long addrPos = this.addrPosition;
        if (this.addrLimit - addrPos < 2L) {
            this.flushBufferBlocking(this.buffer);
            addrPos = this.addrPosition;
        }
        this.addrPosition = ChannelBufferUnsafeDataOutputStream.putShort(addrPos, v);
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.writeShort(v);
    }

    @Override
    public final void writeLong(long v) throws IOException {
        long addrPos = this.addrPosition;
        if (this.addrLimit - addrPos < 8L) {
            this.flushBufferBlocking(this.buffer);
            addrPos = this.addrPosition;
        }
        this.addrPosition = ChannelBufferUnsafeDataOutputStream.putLong(addrPos, v);
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public final void writeBytes(@Nonnull String s) throws IOException {
        if (s.length() > 0) {
            this.write(s.getBytes(StandardCharsets.US_ASCII));
        }
    }

    @Override
    public final void writeChars(@Nonnull String s) throws IOException {
        int remchars;
        int off = 0;
        for (int len = s.length(); len > 0; len -= remchars) {
            long addrPos = this.addrPosition;
            int remaining = (int)(this.addrLimit - addrPos);
            if (len << 1 <= remaining) {
                int end = off + len;
                while (off < end) {
                    addrPos = ChannelBufferUnsafeDataOutputStream.putShort(addrPos, s.charAt(off++));
                }
                this.addrPosition = addrPos;
                return;
            }
            remchars = remaining >>> 1;
            int end = off + remchars;
            while (off < end) {
                addrPos = ChannelBufferUnsafeDataOutputStream.putShort(addrPos, s.charAt(off++));
            }
            this.addrPosition = addrPos;
            this.flushBufferBlocking(this.buffer);
        }
    }

    @Override
    public final void writeUTF(@Nonnull String str) throws IOException {
        int strLen = str.length();
        if (strLen > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + strLen);
        }
        long addrPos = this.addrPosition;
        long remaining = this.addrLimit - addrPos;
        if (remaining >= (long)(strLen * 3 + 2)) {
            long utflen;
            long finalAddrPos = ChannelBufferUnsafeDataOutputStream.writeUTFSegmentNoOverflow(str, 0, strLen, -1, null, addrPos += 2L);
            if ((utflen = finalAddrPos - addrPos) > 65535L) {
                throw new UTFDataFormatException("encoded string too long: " + utflen + " bytes");
            }
            ChannelBufferUnsafeDataOutputStream.putShort(addrPos - 2L, (int)utflen);
            this.addrPosition = finalAddrPos;
            return;
        }
        int utfLen = ClientSharedUtils.getUTFLength(str, strLen);
        if (utfLen > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + utfLen + " bytes");
        }
        if (remaining > 2L) {
            addrPos = ChannelBufferUnsafeDataOutputStream.putShort(addrPos, utfLen);
            remaining -= 2L;
        } else {
            this.flushBufferBlocking(this.buffer);
            addrPos = ChannelBufferUnsafeDataOutputStream.putShort(this.addrPosition, utfLen);
            remaining = this.addrLimit - addrPos;
        }
        int offset = 0;
        while (strLen > 0) {
            int writeLen = Math.min(strLen, (int)(remaining / 3L));
            if (writeLen >= 3) {
                long newAddrPos = ChannelBufferUnsafeDataOutputStream.writeUTFSegmentNoOverflow(str, offset, writeLen, -1, null, addrPos);
                strLen -= writeLen;
                offset += writeLen;
                remaining -= newAddrPos - addrPos;
                addrPos = newAddrPos;
                continue;
            }
            this.addrPosition = addrPos;
            this.flushBufferBlocking(this.buffer);
            addrPos = this.addrPosition;
            remaining = this.addrLimit - addrPos;
        }
        this.addrPosition = addrPos;
    }

    public static long writeUTFSegmentNoOverflow(String str, int offset, int length, int utfLen, Object target, long addrPos) {
        int end = offset + length;
        if (length == utfLen) {
            while (offset < end) {
                char c = str.charAt(offset++);
                Platform.putByte((Object)target, (long)addrPos++, (byte)((byte)c));
            }
            return addrPos;
        }
        while (offset < end) {
            char c;
            if ((c = str.charAt(offset++)) >= '\u0001' && c <= '\u007f') {
                Platform.putByte((Object)target, (long)addrPos++, (byte)((byte)c));
                continue;
            }
            if (c > '\u07ff') {
                Platform.putByte((Object)target, (long)addrPos++, (byte)((byte)(0xE0 | c >> 12 & 0xF)));
                Platform.putByte((Object)target, (long)addrPos++, (byte)((byte)(0x80 | c >> 6 & 0x3F)));
                Platform.putByte((Object)target, (long)addrPos++, (byte)((byte)(0x80 | c & 0x3F)));
                continue;
            }
            Platform.putByte((Object)target, (long)addrPos++, (byte)((byte)(0xC0 | c >> 6 & 0x1F)));
            Platform.putByte((Object)target, (long)addrPos++, (byte)((byte)(0x80 | c & 0x3F)));
        }
        return addrPos;
    }

    protected static long putShort(long addrPos, int v) {
        if (UnsafeHolder.littleEndian) {
            Platform.putShort(null, (long)addrPos, (short)Short.reverseBytes((short)v));
        } else {
            Platform.putShort(null, (long)addrPos, (short)((short)v));
        }
        return addrPos + 2L;
    }

    protected static long putLong(long addrPos, long v) {
        if (UnsafeHolder.littleEndian) {
            Platform.putLong(null, (long)addrPos, (long)Long.reverseBytes(v));
        } else {
            Platform.putLong(null, (long)addrPos, (long)v);
        }
        return addrPos + 8L;
    }
}

